/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.api.gax.grpc.GrpcStatusCode;
import com.google.api.gax.rpc.BidiStreamObserver;
import com.google.api.gax.rpc.BidiStreamingCallable;
import com.google.api.gax.rpc.ClientStream;
import com.google.api.gax.rpc.InternalException;
import com.google.api.gax.rpc.StatusCode;
import com.google.cloud.firestore.DocumentChange;
import com.google.cloud.firestore.DocumentSnapshot;
import com.google.cloud.firestore.FirestoreException;
import com.google.cloud.firestore.FirestoreImpl;
import com.google.cloud.firestore.FirestoreOptions;
import com.google.cloud.firestore.ListenerRegistration;
import com.google.cloud.firestore.LocalFirestoreHelper;
import com.google.cloud.firestore.Query;
import com.google.cloud.firestore.QueryDocumentSnapshot;
import com.google.cloud.firestore.QuerySnapshot;
import com.google.cloud.firestore.spi.v1.FirestoreRpc;
import com.google.firestore.v1.Document;
import com.google.firestore.v1.DocumentChange;
import com.google.firestore.v1.DocumentDelete;
import com.google.firestore.v1.DocumentRemove;
import com.google.firestore.v1.ExistenceFilter;
import com.google.firestore.v1.ListenRequest;
import com.google.firestore.v1.ListenResponse;
import com.google.firestore.v1.TargetChange;
import com.google.firestore.v1.Value;
import com.google.protobuf.ByteString;
import com.google.protobuf.Timestamp;
import io.grpc.Status;
import io.grpc.StatusException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;

@RunWith(value=MockitoJUnitRunner.class)
public class WatchTest {
    @Rule
    public Timeout timeout = new Timeout(1L, TimeUnit.SECONDS);
    private static final int TARGET_ID = 1;
    private static final ByteString RESUME_TOKEN = ByteString.copyFromUtf8((String)"token");
    private static int documentCount;
    @Spy
    private final FirestoreRpc firestoreRpc = (FirestoreRpc)Mockito.mock(FirestoreRpc.class);
    @Spy
    private final FirestoreImpl firestoreMock = new FirestoreImpl(((FirestoreOptions.Builder)((FirestoreOptions.Builder)FirestoreOptions.newBuilder().setProjectId("test-project")).setRetrySettings(LocalFirestoreHelper.IMMEDIATE_RETRY_SETTINGS)).build(), this.firestoreRpc);
    @Captor
    private ArgumentCaptor<BidiStreamObserver<ListenRequest, ListenResponse>> streamObserverCapture;
    private final ScheduledExecutorService immediateExecutor = new ScheduledThreadPoolExecutor(1){

        @Override
        @Nonnull
        public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
            return super.schedule(command, 0L, TimeUnit.MILLISECONDS);
        }
    };
    private final BlockingQueue<ListenRequest> requests = new LinkedBlockingDeque<ListenRequest>();
    private final BlockingQueue<FirestoreException> exceptions = new LinkedBlockingDeque<FirestoreException>();
    private final BlockingQueue<DocumentSnapshot> documentSnapshots = new LinkedBlockingDeque<DocumentSnapshot>();
    private final BlockingQueue<QuerySnapshot> querySnapshots = new LinkedBlockingDeque<QuerySnapshot>();
    private final Semaphore closes = new Semaphore(0);
    private QuerySnapshot lastSnapshot = null;
    private ListenerRegistration listenerRegistration;

    @Before
    public void before() {
        this.requests.clear();
        this.documentSnapshots.clear();
        this.exceptions.clear();
        this.querySnapshots.clear();
        this.closes.drainPermits();
        this.lastSnapshot = null;
        ((FirestoreRpc)Mockito.lenient().doReturn((Object)this.immediateExecutor).when((Object)this.firestoreRpc)).getExecutor();
        ((FirestoreImpl)Mockito.doAnswer(this.newRequestObserver()).when((Object)this.firestoreMock)).streamRequest((BidiStreamObserver)this.streamObserverCapture.capture(), (BidiStreamingCallable)ArgumentMatchers.any());
    }

    @After
    public void after() {
        Object[] emptyArray = new Object[]{};
        Assert.assertArrayEquals((Object[])this.exceptions.toArray(), (Object[])emptyArray);
        Assert.assertArrayEquals((Object[])this.requests.toArray(), (Object[])emptyArray);
        Assert.assertArrayEquals((Object[])this.documentSnapshots.toArray(), (Object[])emptyArray);
        Assert.assertArrayEquals((Object[])this.querySnapshots.toArray(), (Object[])emptyArray);
        this.listenerRegistration.remove();
    }

    private void addDocumentListener() {
        this.listenerRegistration = this.firestoreMock.document("coll/doc").addSnapshotListener((value, error) -> {
            if (value != null) {
                this.documentSnapshots.add((DocumentSnapshot)value);
            } else {
                this.exceptions.add(error);
            }
        });
    }

    private void addQueryListener() {
        this.listenerRegistration = this.firestoreMock.collection("coll").addSnapshotListener((value, error) -> {
            if (value != null) {
                this.querySnapshots.add((QuerySnapshot)value);
            } else {
                this.exceptions.add(error);
            }
        });
    }

    @Test
    public void documentWatchChange() throws InterruptedException {
        this.addDocumentListener();
        this.awaitAddTarget();
        this.send(this.addTarget());
        this.send(this.current());
        this.send(this.snapshot());
        this.awaitDocumentSnapshot();
        this.send(this.doc("coll/doc", LocalFirestoreHelper.SINGLE_FIELD_PROTO));
        this.send(this.snapshot());
        this.awaitDocumentSnapshot("coll/doc", LocalFirestoreHelper.SINGLE_FIELD_MAP);
        this.send(this.doc("coll/doc", LocalFirestoreHelper.UPDATED_FIELD_PROTO));
        this.send(this.snapshot());
        this.awaitDocumentSnapshot("coll/doc", LocalFirestoreHelper.UPDATED_FIELD_MAP);
        this.send(this.docDelete("coll/doc"));
        this.send(this.snapshot());
        this.awaitDocumentSnapshot();
    }

    @Test
    public void documentWatchIgnoresNonMatchingDocument() throws InterruptedException {
        this.addDocumentListener();
        this.awaitAddTarget();
        this.send(this.addTarget());
        this.send(this.current());
        this.send(this.doc("coll/nondoc", LocalFirestoreHelper.SINGLE_FIELD_PROTO));
        this.send(this.snapshot());
        this.awaitDocumentSnapshot();
    }

    @Test
    public void documentWatchCombinesEventsForDocument() throws InterruptedException {
        this.addDocumentListener();
        this.awaitAddTarget();
        this.send(this.addTarget());
        this.send(this.current());
        this.send(this.doc("coll/doc", LocalFirestoreHelper.SINGLE_FIELD_PROTO));
        this.send(this.doc("coll/doc", LocalFirestoreHelper.UPDATED_FIELD_PROTO));
        this.send(this.snapshot());
        this.awaitDocumentSnapshot("coll/doc", LocalFirestoreHelper.UPDATED_FIELD_MAP);
    }

    @Test
    public void queryWatchRemoveTarget() throws InterruptedException {
        this.addQueryListener();
        this.awaitAddTarget();
        this.send(this.removeTarget(null));
        this.awaitException(null);
    }

    @Test
    public void queryWatchRemoveTargetWithStatus() throws InterruptedException {
        this.addQueryListener();
        this.awaitAddTarget();
        this.send(this.removeTarget(Status.Code.ABORTED));
        this.awaitException(Status.Code.ABORTED);
    }

    @Test
    public void queryWatchShutsDownStreamOnPermissionDenied() throws InterruptedException {
        this.addQueryListener();
        this.awaitAddTarget();
        this.send(this.removeTarget(Status.Code.PERMISSION_DENIED));
        this.awaitClose();
        this.awaitException(Status.Code.PERMISSION_DENIED);
    }

    @Test
    public void queryWatchReopensOnUnexceptedStreamEnd() throws InterruptedException {
        this.addQueryListener();
        this.awaitAddTarget();
        this.send(this.addTarget());
        this.send(this.current());
        this.send(this.snapshot());
        this.awaitQuerySnapshot(new SnapshotDocument[0]);
        this.close();
        this.awaitClose();
        this.awaitAddTarget();
        this.send(this.addTarget());
        this.send(this.current());
        this.send(this.doc("coll/doc", LocalFirestoreHelper.SINGLE_FIELD_PROTO));
        this.send(this.snapshot());
        this.awaitQuerySnapshot(new SnapshotDocument(SnapshotDocument.ChangeType.ADDED, "coll/doc", LocalFirestoreHelper.SINGLE_FIELD_MAP));
    }

    @Test
    public void queryWatchDoesntSendRaiseSnapshotOnReset() throws InterruptedException {
        this.addQueryListener();
        this.awaitAddTarget();
        this.send(this.addTarget());
        this.send(this.current());
        this.send(this.snapshot());
        this.awaitQuerySnapshot(new SnapshotDocument[0]);
        this.close();
        this.awaitClose();
        this.awaitAddTarget();
        this.send(this.addTarget());
        this.send(this.current());
        this.send(this.snapshot());
        this.send(this.doc("coll/doc", LocalFirestoreHelper.SINGLE_FIELD_PROTO));
        this.send(this.snapshot());
        this.awaitQuerySnapshot(new SnapshotDocument(SnapshotDocument.ChangeType.ADDED, "coll/doc", LocalFirestoreHelper.SINGLE_FIELD_MAP));
    }

    @Test
    public void queryWatchDoesntReopenInactiveStream() throws InterruptedException {
        this.addQueryListener();
        this.awaitAddTarget();
        this.send(this.addTarget());
        this.send(this.current());
        this.send(this.snapshot());
        this.awaitQuerySnapshot(new SnapshotDocument[0]);
        this.close();
        this.listenerRegistration.remove();
    }

    @Test
    public void queryWatchRetriesBasedOnErrorCode() throws InterruptedException {
        HashMap<Status.Code, Boolean> expectRetry = new HashMap<Status.Code, Boolean>();
        expectRetry.put(Status.Code.CANCELLED, true);
        expectRetry.put(Status.Code.UNKNOWN, true);
        expectRetry.put(Status.Code.INVALID_ARGUMENT, false);
        expectRetry.put(Status.Code.DEADLINE_EXCEEDED, true);
        expectRetry.put(Status.Code.NOT_FOUND, false);
        expectRetry.put(Status.Code.ALREADY_EXISTS, false);
        expectRetry.put(Status.Code.PERMISSION_DENIED, false);
        expectRetry.put(Status.Code.RESOURCE_EXHAUSTED, true);
        expectRetry.put(Status.Code.FAILED_PRECONDITION, false);
        expectRetry.put(Status.Code.ABORTED, false);
        expectRetry.put(Status.Code.OUT_OF_RANGE, false);
        expectRetry.put(Status.Code.UNIMPLEMENTED, false);
        expectRetry.put(Status.Code.INTERNAL, true);
        expectRetry.put(Status.Code.UNAVAILABLE, true);
        expectRetry.put(Status.Code.DATA_LOSS, false);
        expectRetry.put(Status.Code.UNAUTHENTICATED, true);
        for (Map.Entry entry : expectRetry.entrySet()) {
            this.addQueryListener();
            this.awaitAddTarget();
            this.send(this.addTarget());
            this.send(this.current());
            this.destroy((Status.Code)entry.getKey());
            if (((Boolean)entry.getValue()).booleanValue()) {
                this.awaitAddTarget();
                this.send(this.addTarget());
                this.send(this.current());
                this.send(this.snapshot());
                this.awaitQuerySnapshot(new SnapshotDocument[0]);
                this.listenerRegistration.remove();
                continue;
            }
            this.awaitException(null);
        }
    }

    @Test
    public void queryWatchRetriesOnInternalException() throws InterruptedException {
        this.addQueryListener();
        this.awaitAddTarget();
        this.send(this.addTarget());
        this.destroy((Exception)new InternalException(null, (StatusCode)GrpcStatusCode.of((Status.Code)Status.Code.INTERNAL), true));
        this.awaitAddTarget();
        this.send(this.addTarget());
        this.send(this.current());
        this.send(this.snapshot());
        this.awaitQuerySnapshot(new SnapshotDocument[0]);
    }

    @Test
    public void queryWatchHandlesDocumentChange() throws InterruptedException {
        this.addQueryListener();
        this.awaitAddTarget();
        this.send(this.addTarget());
        this.send(this.current());
        this.send(this.doc("coll/doc1", LocalFirestoreHelper.SINGLE_FIELD_PROTO));
        this.send(this.doc("coll/doc2", LocalFirestoreHelper.SINGLE_FIELD_PROTO));
        this.send(this.snapshot());
        this.awaitQuerySnapshot(new SnapshotDocument(SnapshotDocument.ChangeType.ADDED, "coll/doc1", LocalFirestoreHelper.SINGLE_FIELD_MAP), new SnapshotDocument(SnapshotDocument.ChangeType.ADDED, "coll/doc2", LocalFirestoreHelper.SINGLE_FIELD_MAP));
        this.send(this.doc("coll/doc1", LocalFirestoreHelper.UPDATED_FIELD_PROTO));
        this.send(this.doc("coll/doc3", LocalFirestoreHelper.SINGLE_FIELD_PROTO));
        this.send(this.snapshot());
        this.awaitQuerySnapshot(new SnapshotDocument(SnapshotDocument.ChangeType.MODIFIED, "coll/doc1", LocalFirestoreHelper.UPDATED_FIELD_MAP), new SnapshotDocument(SnapshotDocument.ChangeType.UNCHANGED, "coll/doc2", LocalFirestoreHelper.SINGLE_FIELD_MAP), new SnapshotDocument(SnapshotDocument.ChangeType.ADDED, "coll/doc3", LocalFirestoreHelper.SINGLE_FIELD_MAP));
        this.send(this.docDelete("coll/doc1"));
        this.send(this.docRemove("coll/doc3"));
        this.send(this.snapshot());
        this.awaitQuerySnapshot(new SnapshotDocument(SnapshotDocument.ChangeType.REMOVED, "coll/doc1", null), new SnapshotDocument(SnapshotDocument.ChangeType.UNCHANGED, "coll/doc2", LocalFirestoreHelper.SINGLE_FIELD_MAP), new SnapshotDocument(SnapshotDocument.ChangeType.REMOVED, "coll/doc3", null));
    }

    @Test
    public void queryWatchReconnectsWithResumeToken() throws InterruptedException {
        this.addQueryListener();
        this.awaitAddTarget();
        this.send(this.addTarget());
        this.send(this.current());
        this.send(this.doc("coll/doc1", LocalFirestoreHelper.SINGLE_FIELD_PROTO));
        this.send(this.snapshot());
        this.awaitQuerySnapshot(new SnapshotDocument(SnapshotDocument.ChangeType.ADDED, "coll/doc1", LocalFirestoreHelper.SINGLE_FIELD_MAP));
        this.send(this.doc("coll/doc1", LocalFirestoreHelper.UPDATED_FIELD_PROTO));
        this.close();
        this.awaitResumeToken();
        this.send(this.addTarget());
        this.send(this.current());
        this.send(this.doc("coll/doc2", LocalFirestoreHelper.SINGLE_FIELD_PROTO));
        this.send(this.snapshot());
        this.awaitQuerySnapshot(new SnapshotDocument(SnapshotDocument.ChangeType.UNCHANGED, "coll/doc1", LocalFirestoreHelper.SINGLE_FIELD_MAP), new SnapshotDocument(SnapshotDocument.ChangeType.ADDED, "coll/doc2", LocalFirestoreHelper.SINGLE_FIELD_MAP));
    }

    @Test
    public void queryWatchSortsDocuments() throws InterruptedException {
        this.listenerRegistration = this.firestoreMock.collection("coll").orderBy("foo").orderBy("bar", Query.Direction.DESCENDING).addSnapshotListener((value, error) -> this.querySnapshots.add((QuerySnapshot)value));
        ListenResponse[] documents = new ListenResponse[]{this.doc("coll/doc1", LocalFirestoreHelper.map("foo", LocalFirestoreHelper.string("a"), "bar", LocalFirestoreHelper.string("b"))), this.doc("coll/doc2", LocalFirestoreHelper.map("foo", LocalFirestoreHelper.string("a"), "bar", LocalFirestoreHelper.string("a"))), this.doc("coll/doc3", LocalFirestoreHelper.map("foo", LocalFirestoreHelper.string("b"), "bar", LocalFirestoreHelper.string("b"))), this.doc("coll/doc5", LocalFirestoreHelper.map("foo", LocalFirestoreHelper.string("b"), "bar", LocalFirestoreHelper.string("a"))), this.doc("coll/doc4", LocalFirestoreHelper.map("foo", LocalFirestoreHelper.string("b"), "bar", LocalFirestoreHelper.string("a")))};
        this.awaitAddTarget();
        this.send(this.addTarget());
        this.send(this.current());
        this.send(documents[4]);
        this.send(documents[3]);
        this.send(documents[2]);
        this.send(documents[0]);
        this.send(documents[1]);
        this.send(this.snapshot());
        QuerySnapshot querySnapshot = this.querySnapshots.take();
        this.verifyOrder(Arrays.asList("coll/doc1", "coll/doc2", "coll/doc3", "coll/doc5", "coll/doc4"), querySnapshot.getDocuments());
    }

    @Test
    public void queryWatchCombinesChangesForSameDocument() throws InterruptedException {
        this.addQueryListener();
        this.awaitAddTarget();
        this.send(this.addTarget());
        this.send(this.current());
        this.send(this.doc("coll/doc1", LocalFirestoreHelper.SINGLE_FIELD_PROTO));
        this.send(this.doc("coll/doc1", LocalFirestoreHelper.UPDATED_FIELD_PROTO));
        this.send(this.snapshot());
        this.awaitQuerySnapshot(new SnapshotDocument(SnapshotDocument.ChangeType.ADDED, "coll/doc1", LocalFirestoreHelper.UPDATED_FIELD_MAP));
        this.send(this.doc("coll/doc1", LocalFirestoreHelper.UPDATED_FIELD_PROTO));
        this.send(this.doc("coll/doc1", LocalFirestoreHelper.SINGLE_FIELD_PROTO));
        this.send(this.snapshot());
        this.awaitQuerySnapshot(new SnapshotDocument(SnapshotDocument.ChangeType.MODIFIED, "coll/doc1", LocalFirestoreHelper.SINGLE_FIELD_MAP));
    }

    @Test
    public void queryWatchHandlesDeletingNonExistingDocument() throws InterruptedException {
        this.addQueryListener();
        this.awaitAddTarget();
        this.send(this.addTarget());
        this.send(this.current());
        this.send(this.doc("coll/doc1", LocalFirestoreHelper.SINGLE_FIELD_PROTO));
        this.send(this.snapshot());
        this.awaitQuerySnapshot(new SnapshotDocument(SnapshotDocument.ChangeType.ADDED, "coll/doc1", LocalFirestoreHelper.SINGLE_FIELD_MAP));
        this.send(this.docDelete("coll/doc2"));
        this.send(this.doc("coll/doc1", LocalFirestoreHelper.UPDATED_FIELD_PROTO));
        this.send(this.snapshot());
        this.awaitQuerySnapshot(new SnapshotDocument(SnapshotDocument.ChangeType.MODIFIED, "coll/doc1", LocalFirestoreHelper.UPDATED_FIELD_MAP));
    }

    @Test
    public void queryWatchHandlesDeletesAndAddInSingleSnapshot() throws InterruptedException {
        ListenResponse document = this.doc("coll/doc1", LocalFirestoreHelper.SINGLE_FIELD_PROTO);
        this.addQueryListener();
        this.awaitAddTarget();
        this.send(this.addTarget());
        this.send(this.current());
        this.send(document);
        this.send(this.snapshot());
        this.awaitQuerySnapshot(new SnapshotDocument(SnapshotDocument.ChangeType.ADDED, "coll/doc1", LocalFirestoreHelper.SINGLE_FIELD_MAP));
        this.send(this.docDelete("coll/doc1"));
        this.send(this.doc("coll/doc2", LocalFirestoreHelper.SINGLE_FIELD_PROTO));
        this.send(document);
        this.send(this.snapshot());
        this.awaitQuerySnapshot(new SnapshotDocument(SnapshotDocument.ChangeType.UNCHANGED, "coll/doc1", LocalFirestoreHelper.SINGLE_FIELD_MAP), new SnapshotDocument(SnapshotDocument.ChangeType.ADDED, "coll/doc2", LocalFirestoreHelper.SINGLE_FIELD_MAP));
    }

    @Test
    public void queryWatchHandlesAddAndDeleteInSingleSnapshot() throws InterruptedException {
        this.addQueryListener();
        this.awaitAddTarget();
        this.send(this.addTarget());
        this.send(this.current());
        this.send(this.snapshot());
        this.awaitQuerySnapshot(new SnapshotDocument[0]);
        this.send(this.doc("coll/doc1", LocalFirestoreHelper.SINGLE_FIELD_PROTO));
        this.send(this.doc("coll/doc2", LocalFirestoreHelper.SINGLE_FIELD_PROTO));
        this.send(this.docDelete("coll/doc1"));
        this.send(this.snapshot());
        this.awaitQuerySnapshot(new SnapshotDocument(SnapshotDocument.ChangeType.ADDED, "coll/doc2", LocalFirestoreHelper.SINGLE_FIELD_MAP));
    }

    @Test
    public void queryWatchHandlesReset() throws InterruptedException {
        this.addQueryListener();
        this.awaitAddTarget();
        this.send(this.addTarget());
        this.send(this.current());
        this.send(this.doc("coll/doc1", LocalFirestoreHelper.SINGLE_FIELD_PROTO));
        this.send(this.snapshot());
        this.awaitQuerySnapshot(new SnapshotDocument(SnapshotDocument.ChangeType.ADDED, "coll/doc1", LocalFirestoreHelper.SINGLE_FIELD_MAP));
        this.send(this.reset());
        this.send(this.current());
        this.send(this.doc("coll/doc2", LocalFirestoreHelper.SINGLE_FIELD_PROTO));
        this.send(this.snapshot());
        this.awaitQuerySnapshot(new SnapshotDocument(SnapshotDocument.ChangeType.REMOVED, "coll/doc1", null), new SnapshotDocument(SnapshotDocument.ChangeType.ADDED, "coll/doc2", LocalFirestoreHelper.SINGLE_FIELD_MAP));
    }

    @Test
    public void queryWatchHandlesFilterMatch() throws InterruptedException {
        this.addQueryListener();
        this.awaitAddTarget();
        this.send(this.addTarget());
        this.send(this.current());
        this.send(this.doc("coll/doc1", LocalFirestoreHelper.SINGLE_FIELD_PROTO));
        this.send(this.snapshot());
        this.awaitQuerySnapshot(new SnapshotDocument(SnapshotDocument.ChangeType.ADDED, "coll/doc1", LocalFirestoreHelper.SINGLE_FIELD_MAP));
        this.send(this.filter(1));
        this.send(this.doc("coll/doc2", LocalFirestoreHelper.SINGLE_FIELD_PROTO));
        this.send(this.snapshot());
        this.awaitQuerySnapshot(new SnapshotDocument(SnapshotDocument.ChangeType.UNCHANGED, "coll/doc1", LocalFirestoreHelper.SINGLE_FIELD_MAP), new SnapshotDocument(SnapshotDocument.ChangeType.ADDED, "coll/doc2", LocalFirestoreHelper.SINGLE_FIELD_MAP));
    }

    @Test
    public void queryWatchHandlesFilterMismatch() throws InterruptedException {
        this.addQueryListener();
        this.awaitAddTarget();
        this.send(this.addTarget());
        this.send(this.current());
        this.send(this.doc("coll/doc1", LocalFirestoreHelper.SINGLE_FIELD_PROTO));
        this.send(this.snapshot());
        this.awaitQuerySnapshot(new SnapshotDocument(SnapshotDocument.ChangeType.ADDED, "coll/doc1", LocalFirestoreHelper.SINGLE_FIELD_MAP));
        this.send(this.filter(2));
        this.awaitClose();
        this.awaitAddTarget();
        this.send(this.doc("coll/doc2", LocalFirestoreHelper.SINGLE_FIELD_PROTO));
        this.send(this.current());
        this.send(this.snapshot());
        this.awaitQuerySnapshot(new SnapshotDocument(SnapshotDocument.ChangeType.REMOVED, "coll/doc1", null), new SnapshotDocument(SnapshotDocument.ChangeType.ADDED, "coll/doc2", LocalFirestoreHelper.SINGLE_FIELD_MAP));
    }

    @Test
    public void queryWatchHandlesTargetRemoval() throws InterruptedException {
        this.addQueryListener();
        this.awaitAddTarget();
        this.send(this.addTarget());
        this.send(this.current());
        this.send(this.doc("coll/doc1", LocalFirestoreHelper.SINGLE_FIELD_PROTO));
        this.send(this.snapshot());
        this.awaitQuerySnapshot(new SnapshotDocument(SnapshotDocument.ChangeType.ADDED, "coll/doc1", LocalFirestoreHelper.SINGLE_FIELD_MAP));
        ListenResponse.Builder request = this.doc("coll/doc1", LocalFirestoreHelper.SINGLE_FIELD_PROTO).toBuilder();
        request.getDocumentChangeBuilder().clearTargetIds();
        request.getDocumentChangeBuilder().addRemovedTargetIds(1);
        this.send(request.build());
        this.send(this.snapshot());
        this.awaitQuerySnapshot(new SnapshotDocument(SnapshotDocument.ChangeType.REMOVED, "coll/doc1", null));
    }

    @Test
    public void queryWatchHandlesIgnoresDifferentTarget() throws InterruptedException {
        this.addQueryListener();
        this.awaitAddTarget();
        this.send(this.addTarget());
        this.send(this.current());
        ListenResponse.Builder request = this.doc("coll/doc1", LocalFirestoreHelper.SINGLE_FIELD_PROTO).toBuilder();
        request.getDocumentChangeBuilder().clearTargetIds();
        request.getDocumentChangeBuilder().addTargetIds(2);
        this.send(request.build());
        this.send(this.snapshot());
        this.awaitQuerySnapshot(new SnapshotDocument[0]);
    }

    @Test
    public void emptySnapshotEquals() throws InterruptedException {
        this.addQueryListener();
        this.awaitAddTarget();
        this.send(this.addTarget());
        this.send(this.current());
        this.send(this.snapshot());
        QuerySnapshot firstSnapshot = this.awaitQuerySnapshot(new SnapshotDocument[0]);
        this.restartWatch();
        this.addQueryListener();
        this.awaitAddTarget();
        this.send(this.addTarget());
        this.send(this.current());
        this.send(this.snapshot());
        QuerySnapshot secondSnapshot = this.awaitQuerySnapshot(new SnapshotDocument[0]);
        Assert.assertEquals((Object)firstSnapshot, (Object)firstSnapshot);
        Assert.assertEquals((Object)firstSnapshot, (Object)secondSnapshot);
    }

    @Test
    public void snapshotWithChangesEquals() throws InterruptedException {
        ListenResponse doc1 = this.doc("coll/doc1", LocalFirestoreHelper.SINGLE_FIELD_PROTO);
        ListenResponse doc2 = this.doc("coll/doc2", LocalFirestoreHelper.SINGLE_FIELD_PROTO);
        ListenResponse doc3 = this.doc("coll/doc3", LocalFirestoreHelper.SINGLE_FIELD_PROTO);
        this.addQueryListener();
        this.awaitAddTarget();
        this.send(this.addTarget());
        this.send(doc1);
        this.send(this.current());
        this.send(this.snapshot());
        QuerySnapshot firstSnapshot = this.awaitQuerySnapshot(new SnapshotDocument(SnapshotDocument.ChangeType.ADDED, "coll/doc1", LocalFirestoreHelper.SINGLE_FIELD_MAP));
        this.send(doc2);
        this.send(doc3);
        this.send(this.snapshot());
        QuerySnapshot secondSnapshot = this.awaitQuerySnapshot(new SnapshotDocument(SnapshotDocument.ChangeType.UNCHANGED, "coll/doc1", LocalFirestoreHelper.SINGLE_FIELD_MAP), new SnapshotDocument(SnapshotDocument.ChangeType.ADDED, "coll/doc2", LocalFirestoreHelper.SINGLE_FIELD_MAP), new SnapshotDocument(SnapshotDocument.ChangeType.ADDED, "coll/doc3", LocalFirestoreHelper.SINGLE_FIELD_MAP));
        Assert.assertNotEquals((Object)secondSnapshot, (Object)firstSnapshot);
        this.send(this.docDelete("coll/doc3"));
        this.send(this.snapshot());
        QuerySnapshot thirdSnapshot = this.awaitQuerySnapshot(new SnapshotDocument(SnapshotDocument.ChangeType.UNCHANGED, "coll/doc1", LocalFirestoreHelper.SINGLE_FIELD_MAP), new SnapshotDocument(SnapshotDocument.ChangeType.UNCHANGED, "coll/doc2", LocalFirestoreHelper.SINGLE_FIELD_MAP), new SnapshotDocument(SnapshotDocument.ChangeType.REMOVED, "coll/doc3", null));
        Assert.assertNotEquals((Object)thirdSnapshot, (Object)firstSnapshot);
        Assert.assertNotEquals((Object)thirdSnapshot, (Object)secondSnapshot);
        this.restartWatch();
        this.addQueryListener();
        this.awaitAddTarget();
        this.send(this.addTarget());
        this.send(doc2);
        this.send(this.current());
        this.send(this.snapshot());
        QuerySnapshot currentSnapshot = this.awaitQuerySnapshot(new SnapshotDocument(SnapshotDocument.ChangeType.ADDED, "coll/doc2", LocalFirestoreHelper.SINGLE_FIELD_MAP));
        Assert.assertNotEquals((Object)currentSnapshot, (Object)firstSnapshot);
        this.send(doc3);
        this.send(doc1);
        this.send(this.snapshot());
        currentSnapshot = this.awaitQuerySnapshot(new SnapshotDocument(SnapshotDocument.ChangeType.ADDED, "coll/doc1", LocalFirestoreHelper.SINGLE_FIELD_MAP), new SnapshotDocument(SnapshotDocument.ChangeType.UNCHANGED, "coll/doc2", LocalFirestoreHelper.SINGLE_FIELD_MAP), new SnapshotDocument(SnapshotDocument.ChangeType.ADDED, "coll/doc3", LocalFirestoreHelper.SINGLE_FIELD_MAP));
        Assert.assertNotEquals((Object)currentSnapshot, (Object)secondSnapshot);
        this.send(this.docDelete("coll/doc3"));
        this.send(this.snapshot());
        currentSnapshot = this.awaitQuerySnapshot(new SnapshotDocument(SnapshotDocument.ChangeType.UNCHANGED, "coll/doc1", LocalFirestoreHelper.SINGLE_FIELD_MAP), new SnapshotDocument(SnapshotDocument.ChangeType.UNCHANGED, "coll/doc2", LocalFirestoreHelper.SINGLE_FIELD_MAP), new SnapshotDocument(SnapshotDocument.ChangeType.REMOVED, "coll/doc3", null));
        Assert.assertEquals((Object)currentSnapshot, (Object)thirdSnapshot);
    }

    private void restartWatch() {
        this.after();
        this.before();
    }

    private void awaitException(Status.Code expectedCode) throws InterruptedException {
        FirestoreException exception = this.exceptions.take();
        if (expectedCode != null) {
            Assert.assertEquals((Object)expectedCode, (Object)exception.getStatus().getCode());
        }
    }

    private void awaitDocumentSnapshot(String docPath, Map<String, Object> data) throws InterruptedException {
        DocumentSnapshot documentSnapshot = this.documentSnapshots.take();
        Assert.assertEquals((Object)docPath, (Object)documentSnapshot.getReference().getPath());
        Assert.assertEquals(data, (Object)documentSnapshot.getData());
    }

    private QuerySnapshot awaitQuerySnapshot(SnapshotDocument ... documents) throws InterruptedException {
        QuerySnapshot querySnapshot = this.querySnapshots.take();
        ArrayList<QueryDocumentSnapshot> updatedDocuments = new ArrayList<QueryDocumentSnapshot>();
        if (this.lastSnapshot != null) {
            updatedDocuments.addAll(this.lastSnapshot.getDocuments());
        }
        ArrayList<String> expectedOrder = new ArrayList<String>();
        Iterator snapshotIterator = querySnapshot.getDocuments().iterator();
        for (SnapshotDocument expected : documents) {
            if (expected.type != SnapshotDocument.ChangeType.REMOVED) {
                DocumentSnapshot actual = (DocumentSnapshot)snapshotIterator.next();
                Assert.assertEquals((Object)expected.name, (Object)actual.getReference().getPath());
                Assert.assertEquals(expected.data, (Object)actual.getData());
                Assert.assertNotNull((Object)actual.getReadTime());
                expectedOrder.add(expected.name);
            }
            boolean found = false;
            for (DocumentChange change : querySnapshot.getDocumentChanges()) {
                if (!change.getDocument().getReference().getPath().equals(expected.name)) continue;
                if (change.getOldIndex() != -1) {
                    updatedDocuments.remove(change.getOldIndex());
                }
                if (change.getNewIndex() != -1) {
                    updatedDocuments.add(change.getNewIndex(), change.getDocument());
                }
                Assert.assertEquals((Object)expected.type.name(), (Object)change.getType().name());
                found = true;
                break;
            }
            if (found) continue;
            Assert.assertEquals((Object)((Object)SnapshotDocument.ChangeType.UNCHANGED), (Object)((Object)expected.type));
        }
        Assert.assertFalse((boolean)snapshotIterator.hasNext());
        this.lastSnapshot = querySnapshot;
        this.verifyOrder(expectedOrder, updatedDocuments);
        return querySnapshot;
    }

    private void verifyOrder(List<String> expectedOrder, List<QueryDocumentSnapshot> updatedDocuments) {
        Assert.assertEquals((long)expectedOrder.size(), (long)updatedDocuments.size());
        for (int i = 0; i < expectedOrder.size(); ++i) {
            Assert.assertEquals((Object)expectedOrder.get(i), (Object)updatedDocuments.get(i).getReference().getPath());
        }
    }

    private void awaitDocumentSnapshot() throws InterruptedException {
        DocumentSnapshot documentSnapshot = this.documentSnapshots.take();
        Assert.assertFalse((boolean)documentSnapshot.exists());
    }

    private void awaitClose() throws InterruptedException {
        this.closes.acquire();
    }

    private void awaitAddTarget() throws InterruptedException {
        ListenRequest listenRequest = this.requests.take();
        Assert.assertEquals((Object)LocalFirestoreHelper.DATABASE_NAME, (Object)listenRequest.getDatabase());
        Assert.assertEquals((long)1L, (long)listenRequest.getAddTarget().getTargetId());
    }

    private void awaitResumeToken() throws InterruptedException {
        ListenRequest listenRequest = this.requests.take();
        Assert.assertEquals((Object)LocalFirestoreHelper.DATABASE_NAME, (Object)listenRequest.getDatabase());
        Assert.assertEquals((long)1L, (long)listenRequest.getAddTarget().getTargetId());
        Assert.assertEquals((Object)RESUME_TOKEN, (Object)listenRequest.getAddTarget().getResumeToken());
    }

    private ListenResponse removeTarget(@Nullable Status.Code code) {
        TargetChange.Builder targetChange = TargetChange.newBuilder().setTargetChangeType(TargetChange.TargetChangeType.REMOVE).addTargetIds(1);
        if (code != null) {
            targetChange.setCause(com.google.rpc.Status.newBuilder().setCode(code.value()));
        }
        ListenResponse.Builder response = ListenResponse.newBuilder();
        response.setTargetChange(targetChange);
        return response.build();
    }

    private ListenResponse addTarget() {
        ListenResponse.Builder response = ListenResponse.newBuilder();
        response.setTargetChange(TargetChange.newBuilder().setTargetChangeType(TargetChange.TargetChangeType.ADD).addTargetIds(1));
        return response.build();
    }

    private ListenResponse current() {
        ListenResponse.Builder response = ListenResponse.newBuilder();
        response.setTargetChange(TargetChange.newBuilder().setTargetChangeType(TargetChange.TargetChangeType.CURRENT).addTargetIds(1));
        return response.build();
    }

    private ListenResponse reset() {
        ListenResponse.Builder response = ListenResponse.newBuilder();
        response.setTargetChange(TargetChange.newBuilder().setTargetChangeType(TargetChange.TargetChangeType.RESET).addTargetIds(1));
        return response.build();
    }

    private ListenResponse filter(int documentCount) {
        ListenResponse.Builder response = ListenResponse.newBuilder();
        response.setFilter(ExistenceFilter.newBuilder().setCount(documentCount).build());
        return response.build();
    }

    private ListenResponse snapshot() {
        ListenResponse.Builder response = ListenResponse.newBuilder();
        response.setTargetChange(TargetChange.newBuilder().setTargetChangeType(TargetChange.TargetChangeType.NO_CHANGE).setReadTime(Timestamp.getDefaultInstance()).setResumeToken(RESUME_TOKEN));
        return response.build();
    }

    private ListenResponse doc(String docPath, Map<String, Value> singleFieldProto) {
        DocumentChange.Builder documentChange = com.google.firestore.v1.DocumentChange.newBuilder();
        documentChange.addTargetIds(1);
        documentChange.setDocument(Document.newBuilder().setName(String.format("%s/documents/%s", LocalFirestoreHelper.DATABASE_NAME, docPath)).putAllFields(singleFieldProto).setUpdateTime(this.updateTime()));
        ListenResponse.Builder response = ListenResponse.newBuilder();
        response.setDocumentChange(documentChange);
        return response.build();
    }

    private Timestamp updateTime() {
        return Timestamp.newBuilder().setSeconds((long)(++documentCount)).build();
    }

    private ListenResponse docDelete(String docPath) {
        ListenResponse.Builder response = ListenResponse.newBuilder();
        response.setDocumentDelete(DocumentDelete.newBuilder().addRemovedTargetIds(1).setDocument(String.format("%s/documents/%s", LocalFirestoreHelper.DATABASE_NAME, docPath)));
        return response.build();
    }

    private ListenResponse docRemove(String docPath) {
        ListenResponse.Builder response = ListenResponse.newBuilder();
        response.setDocumentRemove(DocumentRemove.newBuilder().addRemovedTargetIds(1).setDocument(String.format("%s/documents/%s", LocalFirestoreHelper.DATABASE_NAME, docPath)));
        return response.build();
    }

    private void send(ListenResponse response) {
        ((BidiStreamObserver)this.streamObserverCapture.getValue()).onResponse((Object)response);
    }

    private void destroy(Status.Code code) {
        this.destroy((Exception)new StatusException(Status.fromCode((Status.Code)code)));
    }

    private void destroy(Exception e) {
        ((BidiStreamObserver)this.streamObserverCapture.getValue()).onError((Throwable)e);
    }

    private void close() {
        ((BidiStreamObserver)this.streamObserverCapture.getValue()).onComplete();
    }

    private Answer<ClientStream<ListenRequest>> newRequestObserver() {
        return invocationOnMock -> new ClientStream<ListenRequest>(){

            public void send(ListenRequest listenRequest) {
                WatchTest.this.requests.add(listenRequest);
            }

            public void closeSendWithError(Throwable throwable) {
            }

            public void closeSend() {
                WatchTest.this.closes.release();
            }

            public boolean isSendReady() {
                return true;
            }
        };
    }

    static class SnapshotDocument {
        ChangeType type;
        String name;
        Map<String, Object> data;

        SnapshotDocument(ChangeType type, String name, Map<String, Object> data) {
            this.type = type;
            this.name = name;
            this.data = data;
        }

        static enum ChangeType {
            UNCHANGED,
            ADDED,
            REMOVED,
            MODIFIED;

        }
    }
}

