/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.Timestamp;
import com.google.cloud.firestore.DocumentReference;
import com.google.cloud.firestore.FieldValue;
import com.google.cloud.firestore.FirestoreImpl;
import com.google.cloud.firestore.FirestoreOptions;
import com.google.cloud.firestore.LocalFirestoreHelper;
import com.google.cloud.firestore.Precondition;
import com.google.cloud.firestore.SetOptions;
import com.google.cloud.firestore.WriteBatch;
import com.google.cloud.firestore.WriteResult;
import com.google.cloud.firestore.spi.v1.FirestoreRpc;
import com.google.firestore.v1.BatchWriteRequest;
import com.google.firestore.v1.CommitRequest;
import com.google.firestore.v1.Precondition;
import com.google.firestore.v1.Write;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class WriteBatchTest {
    @Spy
    private final FirestoreImpl firestoreMock = new FirestoreImpl(((FirestoreOptions.Builder)FirestoreOptions.newBuilder().setProjectId("test-project")).build(), (FirestoreRpc)Mockito.mock(FirestoreRpc.class));
    @Captor
    private ArgumentCaptor<CommitRequest> commitCapture;
    @Captor
    private ArgumentCaptor<BatchWriteRequest> batchWriteCapture;
    private WriteBatch batch;
    private DocumentReference documentReference;

    @Before
    public void before() {
        this.batch = this.firestoreMock.batch();
        this.documentReference = this.firestoreMock.document("coll/doc");
    }

    @Test
    public void updateDocument() throws Exception {
        ((FirestoreImpl)Mockito.doReturn(LocalFirestoreHelper.commitResponse(4, 0)).when((Object)this.firestoreMock)).sendRequest((Object)((CommitRequest)this.commitCapture.capture()), (UnaryCallable)ArgumentMatchers.any());
        List<com.google.firestore.v1.Precondition> preconditions = Arrays.asList(com.google.firestore.v1.Precondition.newBuilder().setExists(true).build(), com.google.firestore.v1.Precondition.newBuilder().setExists(true).build(), com.google.firestore.v1.Precondition.newBuilder().setUpdateTime(com.google.protobuf.Timestamp.getDefaultInstance()).build(), com.google.firestore.v1.Precondition.newBuilder().setUpdateTime(com.google.protobuf.Timestamp.getDefaultInstance()).build());
        Precondition updateTime = Precondition.updatedAt((Timestamp)Timestamp.ofTimeSecondsAndNanos((long)0L, (int)0));
        this.batch.update(this.documentReference, LocalFirestoreHelper.SINGLE_FIELD_MAP);
        this.batch.update(this.documentReference, "foo", (Object)"bar", new Object[0]);
        this.batch.update(this.documentReference, updateTime, "foo", (Object)"bar", new Object[0]);
        this.batch.update(this.documentReference, LocalFirestoreHelper.SINGLE_FIELD_MAP, updateTime);
        Assert.assertEquals((long)4L, (long)this.batch.getMutationsSize());
        List writeResults = (List)this.batch.commit().get();
        ArrayList<Write> writes = new ArrayList<Write>();
        for (int i = 0; i < writeResults.size(); ++i) {
            Assert.assertEquals((Object)Timestamp.ofTimeSecondsAndNanos((long)i, (int)i), (Object)((WriteResult)writeResults.get(i)).getUpdateTime());
            writes.add(LocalFirestoreHelper.update(LocalFirestoreHelper.SINGLE_FIELD_PROTO, Collections.singletonList("foo"), preconditions.get(i)));
        }
        CommitRequest commitRequest = (CommitRequest)this.commitCapture.getValue();
        Assert.assertEquals((Object)LocalFirestoreHelper.commit(writes.toArray(new Write[0])), (Object)commitRequest);
    }

    @Test
    public void updateDocumentWithPOJO() throws Exception {
        ((FirestoreImpl)Mockito.doReturn(LocalFirestoreHelper.commitResponse(1, 0)).when((Object)this.firestoreMock)).sendRequest((Object)((CommitRequest)this.commitCapture.capture()), (UnaryCallable)ArgumentMatchers.any());
        this.batch.update(this.documentReference, "foo", (Object)LocalFirestoreHelper.UPDATE_SINGLE_FIELD_OBJECT, new Object[0]);
        Assert.assertEquals((long)1L, (long)this.batch.getMutationsSize());
        List writeResults = (List)this.batch.commit().get();
        Assert.assertEquals((long)1L, (long)writeResults.size());
        CommitRequest actual = (CommitRequest)this.commitCapture.getValue();
        CommitRequest expected = LocalFirestoreHelper.commit(LocalFirestoreHelper.update(LocalFirestoreHelper.UPDATED_SINGLE_FIELD_PROTO, Collections.singletonList("foo")));
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void setDocument() throws Exception {
        ((FirestoreImpl)Mockito.doReturn(LocalFirestoreHelper.commitResponse(4, 0)).when((Object)this.firestoreMock)).sendRequest((Object)((CommitRequest)this.commitCapture.capture()), (UnaryCallable)ArgumentMatchers.any());
        ((WriteBatch)((WriteBatch)((WriteBatch)this.batch.set(this.documentReference, LocalFirestoreHelper.SINGLE_FIELD_MAP)).set(this.documentReference, (Object)LocalFirestoreHelper.SINGLE_FIELD_OBJECT)).set(this.documentReference, LocalFirestoreHelper.SINGLE_FIELD_MAP, SetOptions.merge())).set(this.documentReference, (Object)LocalFirestoreHelper.SINGLE_FIELD_OBJECT, SetOptions.merge());
        ArrayList<Write> writes = new ArrayList<Write>();
        writes.add(LocalFirestoreHelper.set(LocalFirestoreHelper.SINGLE_FIELD_PROTO));
        writes.add(LocalFirestoreHelper.set(LocalFirestoreHelper.SINGLE_FIELD_PROTO));
        writes.add(LocalFirestoreHelper.set(LocalFirestoreHelper.SINGLE_FIELD_PROTO, Arrays.asList("foo")));
        writes.add(LocalFirestoreHelper.set(LocalFirestoreHelper.SINGLE_FIELD_PROTO, Arrays.asList("foo")));
        Assert.assertEquals((long)4L, (long)this.batch.getMutationsSize());
        List writeResults = (List)this.batch.commit().get();
        for (int i = 0; i < writeResults.size(); ++i) {
            Assert.assertEquals((Object)Timestamp.ofTimeSecondsAndNanos((long)i, (int)i), (Object)((WriteResult)writeResults.get(i)).getUpdateTime());
        }
        CommitRequest commitRequest = (CommitRequest)this.commitCapture.getValue();
        Assert.assertEquals((Object)LocalFirestoreHelper.commit(writes.toArray(new Write[0])), (Object)commitRequest);
    }

    @Test
    public void setDocumentWithValue() throws Exception {
        ((FirestoreImpl)Mockito.doReturn(LocalFirestoreHelper.commitResponse(4, 0)).when((Object)this.firestoreMock)).sendRequest((Object)((CommitRequest)this.commitCapture.capture()), (UnaryCallable)ArgumentMatchers.any());
        ((WriteBatch)((WriteBatch)((WriteBatch)this.batch.set(this.documentReference, LocalFirestoreHelper.SINGLE_FIELD_PROTO)).set(this.documentReference, (Object)LocalFirestoreHelper.SINGLE_FIELD_OBJECT)).set(this.documentReference, LocalFirestoreHelper.SINGLE_FIELD_PROTO, SetOptions.merge())).set(this.documentReference, (Object)LocalFirestoreHelper.SINGLE_FIELD_OBJECT, SetOptions.merge());
        ArrayList<Write> writes = new ArrayList<Write>();
        writes.add(LocalFirestoreHelper.set(LocalFirestoreHelper.SINGLE_FIELD_PROTO));
        writes.add(LocalFirestoreHelper.set(LocalFirestoreHelper.SINGLE_FIELD_PROTO));
        writes.add(LocalFirestoreHelper.set(LocalFirestoreHelper.SINGLE_FIELD_PROTO, Arrays.asList("foo")));
        writes.add(LocalFirestoreHelper.set(LocalFirestoreHelper.SINGLE_FIELD_PROTO, Arrays.asList("foo")));
        Assert.assertEquals((long)4L, (long)this.batch.getMutationsSize());
        List writeResults = (List)this.batch.commit().get();
        for (int i = 0; i < writeResults.size(); ++i) {
            Assert.assertEquals((Object)Timestamp.ofTimeSecondsAndNanos((long)i, (int)i), (Object)((WriteResult)writeResults.get(i)).getUpdateTime());
        }
        CommitRequest commitRequest = (CommitRequest)this.commitCapture.getValue();
        Assert.assertEquals((Object)LocalFirestoreHelper.commit(writes.toArray(new Write[0])), (Object)commitRequest);
    }

    @Test
    public void setDocumentWithFloat() throws Exception {
        ((FirestoreImpl)Mockito.doReturn(LocalFirestoreHelper.commitResponse(1, 0)).when((Object)this.firestoreMock)).sendRequest((Object)((CommitRequest)this.commitCapture.capture()), (UnaryCallable)ArgumentMatchers.any());
        this.batch.set(this.documentReference, LocalFirestoreHelper.SINGLE_FLOAT_MAP);
        ArrayList<Write> writes = new ArrayList<Write>();
        writes.add(LocalFirestoreHelper.set(LocalFirestoreHelper.SINGLE_FLOAT_PROTO));
        Assert.assertEquals((long)1L, (long)this.batch.getMutationsSize());
        List writeResults = (List)this.batch.commit().get();
        for (int i = 0; i < writeResults.size(); ++i) {
            Assert.assertEquals((Object)Timestamp.ofTimeSecondsAndNanos((long)i, (int)i), (Object)((WriteResult)writeResults.get(i)).getUpdateTime());
        }
        CommitRequest commitRequest = (CommitRequest)this.commitCapture.getValue();
        Assert.assertEquals((Object)LocalFirestoreHelper.commit(writes.toArray(new Write[0])), (Object)commitRequest);
    }

    @Test
    public void omitWriteResultForDocumentTransforms() throws Exception {
        ((FirestoreImpl)Mockito.doReturn(LocalFirestoreHelper.commitResponse(1, 0)).when((Object)this.firestoreMock)).sendRequest((Object)((CommitRequest)this.commitCapture.capture()), (UnaryCallable)ArgumentMatchers.any());
        this.batch.set(this.documentReference, LocalFirestoreHelper.map("time", FieldValue.serverTimestamp(), new Object[0]));
        Assert.assertEquals((long)1L, (long)this.batch.getMutationsSize());
        List writeResults = (List)this.batch.commit().get();
        Assert.assertEquals((long)1L, (long)writeResults.size());
    }

    @Test
    public void createDocument() throws Exception {
        ((FirestoreImpl)Mockito.doReturn(LocalFirestoreHelper.commitResponse(2, 0)).when((Object)this.firestoreMock)).sendRequest((Object)((CommitRequest)this.commitCapture.capture()), (UnaryCallable)ArgumentMatchers.any());
        ((WriteBatch)this.batch.create(this.documentReference, LocalFirestoreHelper.SINGLE_FIELD_MAP)).create(this.documentReference, (Object)LocalFirestoreHelper.SINGLE_FIELD_OBJECT);
        Assert.assertEquals((long)2L, (long)this.batch.getMutationsSize());
        List writeResults = (List)this.batch.commit().get();
        ArrayList<Write> writes = new ArrayList<Write>();
        for (int i = 0; i < writeResults.size(); ++i) {
            Assert.assertEquals((Object)Timestamp.ofTimeSecondsAndNanos((long)i, (int)i), (Object)((WriteResult)writeResults.get(i)).getUpdateTime());
            writes.add(LocalFirestoreHelper.create(LocalFirestoreHelper.SINGLE_FIELD_PROTO));
        }
        CommitRequest commitRequest = (CommitRequest)this.commitCapture.getValue();
        Assert.assertEquals((Object)LocalFirestoreHelper.commit(writes.toArray(new Write[0])), (Object)commitRequest);
    }

    @Test
    public void createDocumentWithValue() throws Exception {
        ((FirestoreImpl)Mockito.doReturn(LocalFirestoreHelper.commitResponse(2, 0)).when((Object)this.firestoreMock)).sendRequest((Object)((CommitRequest)this.commitCapture.capture()), (UnaryCallable)ArgumentMatchers.any());
        ((WriteBatch)this.batch.create(this.documentReference, LocalFirestoreHelper.SINGLE_FIELD_PROTO)).create(this.documentReference, (Object)LocalFirestoreHelper.SINGLE_FIELD_OBJECT);
        Assert.assertEquals((long)2L, (long)this.batch.getMutationsSize());
        List writeResults = (List)this.batch.commit().get();
        ArrayList<Write> writes = new ArrayList<Write>();
        for (int i = 0; i < writeResults.size(); ++i) {
            Assert.assertEquals((Object)Timestamp.ofTimeSecondsAndNanos((long)i, (int)i), (Object)((WriteResult)writeResults.get(i)).getUpdateTime());
            writes.add(LocalFirestoreHelper.create(LocalFirestoreHelper.SINGLE_FIELD_PROTO));
        }
        CommitRequest commitRequest = (CommitRequest)this.commitCapture.getValue();
        Assert.assertEquals((Object)LocalFirestoreHelper.commit(writes.toArray(new Write[0])), (Object)commitRequest);
    }

    @Test
    public void createDocumentWithFloat() throws Exception {
        ((FirestoreImpl)Mockito.doReturn(LocalFirestoreHelper.commitResponse(1, 0)).when((Object)this.firestoreMock)).sendRequest((Object)((CommitRequest)this.commitCapture.capture()), (UnaryCallable)ArgumentMatchers.any());
        this.batch.create(this.documentReference, LocalFirestoreHelper.SINGLE_FLOAT_MAP);
        Assert.assertEquals((long)1L, (long)this.batch.getMutationsSize());
        List writeResults = (List)this.batch.commit().get();
        ArrayList<Write> writes = new ArrayList<Write>();
        for (int i = 0; i < writeResults.size(); ++i) {
            Assert.assertEquals((Object)Timestamp.ofTimeSecondsAndNanos((long)i, (int)i), (Object)((WriteResult)writeResults.get(i)).getUpdateTime());
            writes.add(LocalFirestoreHelper.create(LocalFirestoreHelper.SINGLE_FLOAT_PROTO));
        }
        CommitRequest commitRequest = (CommitRequest)this.commitCapture.getValue();
        Assert.assertEquals((Object)LocalFirestoreHelper.commit(writes.toArray(new Write[0])), (Object)commitRequest);
    }

    @Test
    public void deleteDocument() throws Exception {
        ((FirestoreImpl)Mockito.doReturn(LocalFirestoreHelper.commitResponse(2, 0)).when((Object)this.firestoreMock)).sendRequest((Object)((CommitRequest)this.commitCapture.capture()), (UnaryCallable)ArgumentMatchers.any());
        ArrayList<Write> writes = new ArrayList<Write>();
        this.batch.delete(this.documentReference);
        writes.add(LocalFirestoreHelper.delete());
        this.batch.delete(this.documentReference, Precondition.updatedAt((Timestamp)Timestamp.ofTimeSecondsAndNanos((long)1L, (int)2)));
        Precondition.Builder precondition = com.google.firestore.v1.Precondition.newBuilder();
        precondition.getUpdateTimeBuilder().setSeconds(1L).setNanos(2);
        writes.add(LocalFirestoreHelper.delete(precondition.build()));
        Assert.assertEquals((long)2L, (long)this.batch.getMutationsSize());
        List writeResults = (List)this.batch.commit().get();
        for (int i = 0; i < writeResults.size(); ++i) {
            Assert.assertEquals((Object)Timestamp.ofTimeSecondsAndNanos((long)i, (int)i), (Object)((WriteResult)writeResults.get(i)).getUpdateTime());
        }
        CommitRequest commitRequest = (CommitRequest)this.commitCapture.getValue();
        Assert.assertEquals((Object)LocalFirestoreHelper.commit(writes.toArray(new Write[0])), (Object)commitRequest);
    }

    @Test
    public void throwsWhenModifyingACommittedWriteBatch() throws Exception {
        ((FirestoreImpl)Mockito.doReturn(LocalFirestoreHelper.commitResponse(0, 0)).when((Object)this.firestoreMock)).sendRequest((Object)((CommitRequest)this.commitCapture.capture()), (UnaryCallable)ArgumentMatchers.any());
        String expectedErrorMessage = "Cannot modify a WriteBatch that has already been committed.";
        DocumentReference docRef = this.firestoreMock.collection("foo").document("bar");
        WriteBatch batch = this.firestoreMock.batch();
        batch.commit().get();
        LocalFirestoreHelper.assertException(() -> batch.set(docRef, LocalFirestoreHelper.map("foo", "bar", new Object[0])), expectedErrorMessage);
        LocalFirestoreHelper.assertException(() -> batch.update(docRef, LocalFirestoreHelper.map("foo", "bar", new Object[0])), expectedErrorMessage);
        LocalFirestoreHelper.assertException(() -> batch.create(docRef, LocalFirestoreHelper.map("foo", "bar", new Object[0])), expectedErrorMessage);
        LocalFirestoreHelper.assertException(() -> batch.delete(docRef), expectedErrorMessage);
    }
}

