/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore.it;

import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.firestore.DocumentReference;
import com.google.cloud.firestore.Firestore;
import com.google.cloud.firestore.FirestoreOptions;
import com.google.cloud.firestore.FirestoreSpy;
import com.google.cloud.firestore.ListenerRegistration;
import com.google.cloud.firestore.LocalFirestoreHelper;
import com.google.cloud.firestore.it.ITQueryTest;
import com.google.common.base.Preconditions;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.After;
import org.junit.Before;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public abstract class ITBaseTest {
    private static final long PRIMING_TIMEOUT_MS = 45000L;
    private static final Logger logger = Logger.getLogger(ITBaseTest.class.getName());
    protected Firestore firestore;
    protected FirestoreSpy firestoreSpy;
    private FirestoreOptions firestoreOptions;
    private boolean backendPrimed = false;

    @Before
    public void before() throws Exception {
        FirestoreOptions.Builder optionsBuilder = FirestoreOptions.newBuilder();
        String dbPropertyName = "FIRESTORE_NAMED_DATABASE";
        String namedDb = System.getProperty(dbPropertyName);
        if (namedDb == null) {
            namedDb = System.getenv(dbPropertyName);
        }
        if (namedDb != null) {
            logger.log(Level.INFO, "Integration test using named database " + namedDb);
            optionsBuilder = optionsBuilder.setDatabaseId(namedDb);
        } else {
            logger.log(Level.INFO, "Integration test using default database.");
        }
        String targetPropertyName = "FIRESTORE_TARGET_BACKEND";
        String targetBackend = System.getProperty(targetPropertyName);
        if (targetBackend == null) {
            targetBackend = System.getenv(targetPropertyName);
        }
        TransportChannelProvider defaultProvider = optionsBuilder.build().getTransportChannelProvider();
        if (targetBackend != null && !targetBackend.equals("PROD")) {
            if (targetBackend.equals("QA")) {
                optionsBuilder.setChannelProvider(defaultProvider.withEndpoint("staging-firestore.sandbox.googleapis.com:443"));
            } else if (targetBackend.equals("NIGHTLY")) {
                optionsBuilder.setChannelProvider(defaultProvider.withEndpoint("test-firestore.sandbox.googleapis.com:443"));
            } else {
                throw new IllegalArgumentException("Illegal target backend: " + targetBackend);
            }
        }
        this.firestoreOptions = optionsBuilder.build();
        logger.log(Level.INFO, "Integration test against " + this.firestoreOptions.getTransportChannelProvider().getEndpoint());
        this.firestore = (Firestore)this.firestoreOptions.getService();
        this.primeBackend();
    }

    public void primeBackend() throws Exception {
        if (this.backendPrimed) {
            return;
        }
        this.backendPrimed = true;
        CompletableFuture watchInitialized = new CompletableFuture();
        CompletableFuture watchUpdateReceived = new CompletableFuture();
        DocumentReference docRef = this.firestore.collection(LocalFirestoreHelper.autoId()).document();
        ListenerRegistration listenerRegistration = docRef.addSnapshotListener((snapshot, error) -> {
            if (error != null) {
                logger.log(Level.SEVERE, "Prime backend received error in snapshot listener.", error);
                if (!watchInitialized.isDone()) {
                    watchInitialized.completeExceptionally(error);
                } else if (!watchUpdateReceived.isDone()) {
                    watchUpdateReceived.completeExceptionally(error);
                }
            }
            if (snapshot != null) {
                if ("done".equals(snapshot.get("value"))) {
                    watchUpdateReceived.complete(null);
                } else {
                    watchInitialized.complete(null);
                }
            }
        });
        watchInitialized.get(45000L, TimeUnit.MILLISECONDS);
        docRef.getFirestore().runTransaction(transaction -> {
            transaction.set(docRef, ITQueryTest.map("value", "done"));
            return null;
        });
        watchUpdateReceived.get(45000L, TimeUnit.MILLISECONDS);
        listenerRegistration.remove();
    }

    @After
    public void after() throws Exception {
        Preconditions.checkNotNull((Object)this.firestore, (Object)"Error instantiating Firestore. Check that the service account credentials were properly set.");
        this.firestore.close();
        this.firestore = null;
        this.firestoreOptions = null;
        this.firestoreSpy = null;
    }

    public FirestoreSpy useFirestoreSpy() {
        if (this.firestoreSpy == null) {
            this.firestoreSpy = new FirestoreSpy(this.firestoreOptions);
            this.firestore = this.firestoreSpy.spy;
        }
        return this.firestoreSpy;
    }
}

