/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore.it;

import com.google.api.core.ApiFuture;
import com.google.cloud.Timestamp;
import com.google.cloud.firestore.BulkWriter;
import com.google.cloud.firestore.CollectionReference;
import com.google.cloud.firestore.DocumentReference;
import com.google.cloud.firestore.DocumentSnapshot;
import com.google.cloud.firestore.LocalFirestoreHelper;
import com.google.cloud.firestore.WriteResult;
import com.google.cloud.firestore.it.ITBaseTest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class ITBulkWriterTest
extends ITBaseTest {
    private CollectionReference randomColl;
    private DocumentReference randomDoc;
    @Rule
    public TestName testName = new TestName();

    @Override
    @Before
    public void before() throws Exception {
        super.before();
        this.randomColl = this.firestore.collection(String.format("java-%s-%s", this.testName.getMethodName(), LocalFirestoreHelper.autoId()));
        this.randomDoc = this.randomColl.document();
    }

    @Test
    public void bulkWriterCreate() throws Exception {
        DocumentReference docRef = this.randomColl.document();
        this.firestore.bulkWriter();
        BulkWriter writer = this.firestore.bulkWriter();
        ApiFuture result = writer.create(docRef, Collections.singletonMap("foo", "bar"));
        writer.close();
        Assert.assertNotNull((Object)((WriteResult)result.get()).getUpdateTime());
        DocumentSnapshot snapshot = (DocumentSnapshot)docRef.get().get();
        Assert.assertEquals((Object)"bar", (Object)snapshot.get("foo"));
    }

    @Test
    public void bulkWriterCreateAddsPrecondition() throws Exception {
        DocumentReference docRef = this.randomColl.document();
        docRef.set(Collections.singletonMap("foo", "bar")).get();
        BulkWriter writer = this.firestore.bulkWriter();
        ApiFuture result = writer.create(docRef, Collections.singletonMap("foo", "bar"));
        writer.close();
        try {
            result.get();
            Assert.fail((String)"Create operation should have thrown exception");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Document already exists"));
        }
    }

    @Test
    public void bulkWriterSet() throws Exception {
        DocumentReference docRef = this.randomColl.document();
        BulkWriter writer = this.firestore.bulkWriter();
        ApiFuture result = writer.set(docRef, Collections.singletonMap("foo", "bar"));
        writer.close();
        Assert.assertNotNull((Object)((WriteResult)result.get()).getUpdateTime());
        DocumentSnapshot snapshot = (DocumentSnapshot)docRef.get().get();
        Assert.assertEquals((Object)"bar", (Object)snapshot.get("foo"));
    }

    @Test
    public void bulkWriterUpdate() throws Exception {
        DocumentReference docRef = this.randomColl.document();
        docRef.set(Collections.singletonMap("foo", "oldValue")).get();
        BulkWriter writer = this.firestore.bulkWriter();
        ApiFuture result = writer.update(docRef, "foo", (Object)"newValue", new Object[0]);
        writer.close();
        Assert.assertNotNull((Object)((WriteResult)result.get()).getUpdateTime());
        DocumentSnapshot snapshot = (DocumentSnapshot)docRef.get().get();
        Assert.assertEquals((Object)"newValue", (Object)snapshot.get("foo"));
    }

    @Test
    public void bulkWriterUpdateAddsPrecondition() throws Exception {
        DocumentReference docRef = this.randomColl.document();
        BulkWriter writer = this.firestore.bulkWriter();
        ApiFuture result = writer.update(docRef, "foo", (Object)"newValue", new Object[0]);
        writer.close();
        try {
            result.get();
            Assert.fail((String)"Update operation should have thrown exception");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().matches(".* No (document|entity) to update.*"));
        }
    }

    @Test
    public void bulkWriterDelete() throws Exception {
        DocumentReference docRef = this.randomColl.document();
        docRef.set(Collections.singletonMap("foo", "oldValue")).get();
        BulkWriter writer = this.firestore.bulkWriter();
        ApiFuture result = writer.delete(docRef);
        writer.close();
        Assert.assertNotNull((Object)((WriteResult)result.get()).getUpdateTime());
        Assert.assertEquals((Object)Timestamp.ofTimeSecondsAndNanos((long)0L, (int)0), (Object)((WriteResult)result.get()).getUpdateTime());
        DocumentSnapshot snapshot = (DocumentSnapshot)docRef.get().get();
        Assert.assertNull((Object)snapshot.get("foo"));
    }

    @Test
    public void bulkWriterOnResult() throws Exception {
        class NamedThreadFactory
        implements ThreadFactory {
            NamedThreadFactory() {
            }

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "bulkWriterSuccess");
            }
        }
        ExecutorService executor = Executors.newSingleThreadExecutor(new NamedThreadFactory());
        ArrayList operations = new ArrayList();
        BulkWriter writer = this.firestore.bulkWriter();
        writer.addWriteResultListener((Executor)executor, (documentReference, result) -> {
            operations.add("operation");
            Assert.assertTrue((boolean)Thread.currentThread().getName().contains("bulkWriterSuccess"));
        });
        writer.set(this.randomDoc, Collections.singletonMap("foo", "bar"));
        writer.flush().get();
        Assert.assertEquals((Object)"operation", operations.get(0));
    }

    @Test
    public void bulkWriterOnError() throws Exception {
        class NamedThreadFactory
        implements ThreadFactory {
            NamedThreadFactory() {
            }

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "bulkWriterException");
            }
        }
        ExecutorService executor = Executors.newSingleThreadExecutor(new NamedThreadFactory());
        ArrayList operations = new ArrayList();
        BulkWriter writer = this.firestore.bulkWriter();
        writer.addWriteErrorListener((Executor)executor, error -> {
            operations.add("operation-error");
            Assert.assertTrue((boolean)Thread.currentThread().getName().contains("bulkWriterException"));
            return false;
        });
        writer.addWriteResultListener((Executor)executor, (documentReference, result) -> Assert.fail((String)"The success listener shouldn't be called"));
        writer.update(this.randomDoc, "foo", (Object)"bar", new Object[0]);
        writer.flush().get();
        Assert.assertEquals((Object)"operation-error", operations.get(0));
    }
}

