/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore.it;

import com.google.api.gax.rpc.NotFoundException;
import com.google.cloud.firestore.BulkWriter;
import com.google.cloud.firestore.BulkWriterOptions;
import com.google.cloud.firestore.CollectionGroup;
import com.google.cloud.firestore.DocumentReference;
import com.google.cloud.firestore.FieldMask;
import com.google.cloud.firestore.FieldPath;
import com.google.cloud.firestore.Firestore;
import com.google.cloud.firestore.FirestoreOpenTelemetryOptions;
import com.google.cloud.firestore.FirestoreOptions;
import com.google.cloud.firestore.Precondition;
import com.google.cloud.firestore.Query;
import com.google.cloud.firestore.SetOptions;
import com.google.cloud.firestore.WriteBatch;
import com.google.cloud.firestore.it.ITBaseTest;
import com.google.cloud.firestore.it.ITTracingTest;
import com.google.cloud.opentelemetry.trace.TraceConfiguration;
import com.google.cloud.opentelemetry.trace.TraceExporter;
import com.google.cloud.trace.v1.TraceServiceClient;
import com.google.common.base.Preconditions;
import com.google.devtools.cloudtrace.v1.Trace;
import com.google.devtools.cloudtrace.v1.TraceSpan;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.TraceFlags;
import io.opentelemetry.api.trace.TraceState;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.context.Scope;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.export.BatchSpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import io.opentelemetry.semconv.resource.attributes.ResourceAttributes;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public abstract class ITE2ETracingTest
extends ITBaseTest {
    private static final Logger logger = Logger.getLogger(ITE2ETracingTest.class.getName());
    private static final String SERVICE = "google.firestore.v1.Firestore/";
    private static final String BATCH_GET_DOCUMENTS_RPC_NAME = "BatchGetDocuments";
    private static final String BATCH_WRITE_RPC_NAME = "BatchWrite";
    private static final String BEGIN_TRANSACTION_RPC_NAME = "BeginTransaction";
    private static final String COMMIT_RPC_NAME = "Commit";
    private static final String LIST_COLLECTIONS_RPC_NAME = "ListCollectionIds";
    private static final String LIST_DOCUMENTS_RPC_NAME = "ListDocuments";
    private static final String ROLLBACK_RPC_NAME = "Rollback";
    private static final String RUN_AGGREGATION_QUERY_RPC_NAME = "RunAggregationQuery";
    private static final String RUN_QUERY_RPC_NAME = "RunQuery";
    private static final int NUM_TRACE_ID_BYTES = 32;
    private static final int NUM_SPAN_ID_BYTES = 16;
    private static final int GET_TRACE_RETRY_COUNT = 60;
    private static final int GET_TRACE_RETRY_BACKOFF_MILLIS = 1000;
    private static final int TRACE_FORCE_FLUSH_MILLIS = 3000;
    private static final int TRACE_PROVIDER_SHUTDOWN_MILLIS = 1000;
    private static Random random;
    private static SpanExporter traceExporter;
    private static TraceServiceClient traceClient_v1;
    private static SpanContext customSpanContext;
    private static Trace retrievedTrace;
    private static String rootSpanName;
    private static Tracer tracer;
    private static OpenTelemetrySdk openTelemetrySdk;
    private static boolean isNightlyTesting;
    private static String projectId;
    private static Firestore firestore;

    protected abstract boolean isUsingGlobalOpenTelemetrySDK();

    @BeforeClass
    public static void setup() throws IOException {
        String jobType = System.getenv("GITHUB_ENV_VAR_KOKORO_JOB_TYPE");
        isNightlyTesting = jobType != null && jobType.equalsIgnoreCase("nightly");
        projectId = FirestoreOptions.getDefaultProjectId();
        logger.info("projectId:" + projectId);
        traceExporter = TraceExporter.createWithConfiguration((TraceConfiguration)TraceConfiguration.builder().setProjectId(projectId).build());
        traceClient_v1 = TraceServiceClient.create();
        random = new Random();
    }

    @Override
    @Before
    public void before() throws Exception {
        String namedDb;
        Resource resource = Resource.getDefault().merge(Resource.builder().put(ResourceAttributes.SERVICE_NAME, (Object)"Sparky").build());
        if (this.isUsingGlobalOpenTelemetrySDK()) {
            GlobalOpenTelemetry.resetForTest();
            openTelemetrySdk = OpenTelemetrySdk.builder().setTracerProvider(SdkTracerProvider.builder().setResource(resource).addSpanProcessor((SpanProcessor)BatchSpanProcessor.builder((SpanExporter)traceExporter).build()).setSampler(Sampler.alwaysOn()).build()).buildAndRegisterGlobal();
        } else {
            openTelemetrySdk = OpenTelemetrySdk.builder().setTracerProvider(SdkTracerProvider.builder().setResource(resource).addSpanProcessor((SpanProcessor)BatchSpanProcessor.builder((SpanExporter)traceExporter).build()).setSampler(Sampler.alwaysOn()).build()).build();
        }
        FirestoreOptions.Builder optionsBuilder = FirestoreOptions.newBuilder();
        if (!this.isUsingGlobalOpenTelemetrySDK()) {
            optionsBuilder = optionsBuilder.setOpenTelemetryOptions(FirestoreOpenTelemetryOptions.newBuilder().setOpenTelemetry((OpenTelemetry)openTelemetrySdk).build());
        }
        if ((namedDb = System.getProperty("FIRESTORE_NAMED_DATABASE")) != null) {
            logger.log(Level.INFO, "Integration test using named database " + namedDb);
            optionsBuilder = optionsBuilder.setDatabaseId(namedDb);
        } else {
            logger.log(Level.INFO, "Integration test using default database.");
        }
        firestore = (Firestore)optionsBuilder.build().getService();
        Preconditions.checkNotNull((Object)firestore, (Object)"Error instantiating Firestore. Check that the service account credentials were properly set.");
        rootSpanName = String.format("%s%d", this.getClass().getSimpleName(), System.currentTimeMillis());
        tracer = this.isUsingGlobalOpenTelemetrySDK() ? GlobalOpenTelemetry.getTracer((String)rootSpanName) : ((FirestoreOptions)firestore.getOptions()).getOpenTelemetryOptions().getOpenTelemetry().getTracer(rootSpanName);
        customSpanContext = this.getNewSpanContext();
        Assert.assertNotNull((Object)customSpanContext);
        Assert.assertNull((Object)retrievedTrace);
        Assume.assumeTrue((boolean)isNightlyTesting);
    }

    @Override
    @After
    public void after() throws Exception {
        firestore.shutdown();
        rootSpanName = null;
        tracer = null;
        retrievedTrace = null;
        customSpanContext = null;
    }

    @AfterClass
    public static void teardown() throws Exception {
        traceClient_v1.close();
        CompletableResultCode completableResultCode = openTelemetrySdk.getSdkTracerProvider().shutdown();
        completableResultCode.join(1000L, TimeUnit.MILLISECONDS);
    }

    private String generateRandomHexString(int numBytes) {
        StringBuffer newTraceId = new StringBuffer();
        while (newTraceId.length() < numBytes) {
            newTraceId.append(Integer.toHexString(random.nextInt()));
        }
        return newTraceId.substring(0, numBytes);
    }

    protected String generateNewTraceId() {
        return this.generateRandomHexString(32);
    }

    protected String generateNewSpanId() {
        return this.generateRandomHexString(16);
    }

    protected SpanContext getNewSpanContext() {
        String traceId = this.generateNewTraceId();
        String spanId = this.generateNewSpanId();
        logger.info("traceId=" + traceId + ", spanId=" + spanId);
        return SpanContext.create((String)traceId, (String)spanId, (TraceFlags)TraceFlags.getSampled(), (TraceState)TraceState.getDefault());
    }

    protected Span getNewRootSpanWithContext() {
        return tracer.spanBuilder(rootSpanName).setParent(Context.root().with((ImplicitContextKeyed)Span.wrap((SpanContext)customSpanContext))).startSpan();
    }

    protected String grpcSpanName(String rpcName) {
        return "Sent.google.firestore.v1.Firestore/" + rpcName;
    }

    protected void waitForTracesToComplete() throws Exception {
        logger.info("Flushing traces...");
        CompletableResultCode completableResultCode = openTelemetrySdk.getSdkTracerProvider().forceFlush();
        completableResultCode.join(3000L, TimeUnit.MILLISECONDS);
    }

    protected void fetchAndValidateTrace(String traceId, int numExpectedSpans, List<List<String>> callStackList) throws InterruptedException {
        int numRetries = 60;
        ++numExpectedSpans;
        do {
            try {
                retrievedTrace = traceClient_v1.getTrace(projectId, traceId);
                Assert.assertEquals((Object)traceId, (Object)retrievedTrace.getTraceId());
                logger.info("expectedSpanCount=" + numExpectedSpans + ", retrievedSpanCount=" + retrievedTrace.getSpansCount());
            }
            catch (NotFoundException notFound) {
                logger.info("Trace not found, retrying in 1000 ms");
            }
            catch (IndexOutOfBoundsException outOfBoundsException) {
                logger.info("Call stack not found in trace. Retrying.");
            }
            if (retrievedTrace != null && numExpectedSpans == retrievedTrace.getSpansCount()) continue;
            Thread.sleep(1000L);
        } while (numRetries-- > 0 && (retrievedTrace == null || numExpectedSpans != retrievedTrace.getSpansCount()));
        if (retrievedTrace == null || numExpectedSpans != retrievedTrace.getSpansCount()) {
            throw new RuntimeException("Expected number of spans: " + numExpectedSpans + ", Actual number of spans: " + (retrievedTrace != null ? retrievedTrace.getSpansList().toString() : "Trace NOT_FOUND"));
        }
        TraceContainer traceContainer = new TraceContainer(rootSpanName, retrievedTrace);
        for (List<String> callStack : callStackList) {
            ArrayList<String> expectedCallStack = new ArrayList<String>(callStack);
            expectedCallStack.add(0, rootSpanName);
            logger.info("Checking if TraceContainer contains the callStack");
            String[] expectedCallList = new String[expectedCallStack.size()];
            if (!traceContainer.containsCallStack(expectedCallStack.toArray(expectedCallList))) {
                throw new RuntimeException("Expected spans: " + expectedCallList.toString() + ", Actual spans: " + (retrievedTrace != null ? retrievedTrace.getSpansList().toString() : "Trace NOT_FOUND"));
            }
            logger.severe("CallStack not found in TraceContainer.");
        }
    }

    protected void fetchAndValidateTrace(String traceId, String ... spanNames) throws InterruptedException {
        this.fetchAndValidateTrace(traceId, spanNames.length, Arrays.asList(Arrays.asList(spanNames)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void traceContainerTest() throws Exception {
        Assert.assertNotNull((Object)customSpanContext);
        Span rootSpan = this.getNewRootSpanWithContext();
        try (Scope ignored = rootSpan.makeCurrent();){
            firestore.collection("col").whereEqualTo("foo", (Object)"my_non_existent_value").get().get();
        }
        finally {
            rootSpan.end();
        }
        this.waitForTracesToComplete();
        Trace traceResp = null;
        int expectedSpanCount = 3;
        int numRetries = 60;
        do {
            try {
                traceResp = traceClient_v1.getTrace(projectId, customSpanContext.getTraceId());
                if (traceResp.getSpansCount() == expectedSpanCount) {
                    logger.info("Success: Got " + expectedSpanCount + " spans.");
                    break;
                }
            }
            catch (NotFoundException notFoundException) {
                Thread.sleep(1000L);
                logger.info("Trace not found, retrying in 1000 ms");
            }
            logger.info("Trace Found. The trace did not contain " + expectedSpanCount + " spans. Going to retry.");
        } while (--numRetries > 0);
        Assert.assertNotNull((Object)traceResp);
        Assert.assertEquals((long)expectedSpanCount, (long)traceResp.getSpansCount());
        TraceContainer traceCont = new TraceContainer(rootSpanName, traceResp);
        Assert.assertTrue((boolean)traceCont.containsCallStack(rootSpanName, "Query.Get", this.grpcSpanName(RUN_QUERY_RPC_NAME)));
        Assert.assertFalse((boolean)traceCont.containsCallStack("Query.Get", RUN_QUERY_RPC_NAME));
        Assert.assertFalse((boolean)traceCont.containsCallStack(rootSpanName, "Query.Get"));
        Assert.assertFalse((boolean)traceCont.containsCallStack(rootSpanName, "Query.Get", RUN_AGGREGATION_QUERY_RPC_NAME));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void aggregateQueryGetTraceTest() throws Exception {
        Assert.assertNotNull((Object)customSpanContext);
        Span rootSpan = this.getNewRootSpanWithContext();
        try (Scope ignored = rootSpan.makeCurrent();){
            firestore.collection("col").count().get().get();
        }
        finally {
            rootSpan.end();
        }
        this.waitForTracesToComplete();
        this.fetchAndValidateTrace(customSpanContext.getTraceId(), "AggregationQuery.Get", this.grpcSpanName(RUN_AGGREGATION_QUERY_RPC_NAME));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void bulkWriterCommitTraceTest() throws Exception {
        Assert.assertNotNull((Object)customSpanContext);
        Span rootSpan = this.getNewRootSpanWithContext();
        try (Scope ignored = rootSpan.makeCurrent();){
            ScheduledExecutorService bulkWriterExecutor = Executors.newSingleThreadScheduledExecutor();
            BulkWriter bulkWriter = firestore.bulkWriter(BulkWriterOptions.builder().setExecutor(bulkWriterExecutor).build());
            bulkWriter.set(firestore.collection("col").document("foo"), Collections.singletonMap("bulk-foo", "bulk-bar"));
            bulkWriter.close();
            bulkWriterExecutor.awaitTermination(100L, TimeUnit.MILLISECONDS);
        }
        finally {
            rootSpan.end();
        }
        this.waitForTracesToComplete();
        this.fetchAndValidateTrace(customSpanContext.getTraceId(), "BulkWriter.Commit", this.grpcSpanName(BATCH_WRITE_RPC_NAME));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void partitionQueryTraceTest() throws Exception {
        Assert.assertNotNull((Object)customSpanContext);
        Span rootSpan = this.getNewRootSpanWithContext();
        try (Scope ignored = rootSpan.makeCurrent();){
            CollectionGroup collectionGroup = firestore.collectionGroup("col");
            collectionGroup.getPartitions(3L).get();
        }
        finally {
            rootSpan.end();
        }
        this.waitForTracesToComplete();
        this.fetchAndValidateTrace(customSpanContext.getTraceId(), "PartitionQuery", this.grpcSpanName("PartitionQuery"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void collectionListDocumentsTraceTest() throws Exception {
        Assert.assertNotNull((Object)customSpanContext);
        Span rootSpan = this.getNewRootSpanWithContext();
        try (Scope ignored = rootSpan.makeCurrent();){
            firestore.collection("col").listDocuments();
        }
        finally {
            rootSpan.end();
        }
        this.waitForTracesToComplete();
        this.fetchAndValidateTrace(customSpanContext.getTraceId(), "CollectionReference.ListDocuments", this.grpcSpanName(LIST_DOCUMENTS_RPC_NAME));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void docRefCreateTraceTest() throws Exception {
        Assert.assertNotNull((Object)customSpanContext);
        Span rootSpan = this.getNewRootSpanWithContext();
        try (Scope ignored = rootSpan.makeCurrent();){
            firestore.collection("col").document().create(Collections.singletonMap("foo", "bar")).get();
        }
        finally {
            rootSpan.end();
        }
        this.waitForTracesToComplete();
        this.fetchAndValidateTrace(customSpanContext.getTraceId(), "DocumentReference.Create", "Batch.Commit", this.grpcSpanName(COMMIT_RPC_NAME));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void docRefCreate2TraceTest() throws Exception {
        Assert.assertNotNull((Object)customSpanContext);
        Span rootSpan = this.getNewRootSpanWithContext();
        try (Scope ignored = rootSpan.makeCurrent();){
            firestore.collection("col").document().create((Object)new ITTracingTest.Pojo(1)).get();
        }
        finally {
            rootSpan.end();
        }
        this.waitForTracesToComplete();
        this.fetchAndValidateTrace(customSpanContext.getTraceId(), "DocumentReference.Create", "Batch.Commit", this.grpcSpanName(COMMIT_RPC_NAME));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void docRefSetTraceTest() throws Exception {
        Assert.assertNotNull((Object)customSpanContext);
        Span rootSpan = this.getNewRootSpanWithContext();
        try (Scope ignored = rootSpan.makeCurrent();){
            firestore.collection("col").document("foo").set(Collections.singletonMap("foo", "bar")).get();
        }
        finally {
            rootSpan.end();
        }
        this.waitForTracesToComplete();
        this.fetchAndValidateTrace(customSpanContext.getTraceId(), "DocumentReference.Set", "Batch.Commit", this.grpcSpanName(COMMIT_RPC_NAME));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void docRefSet2TraceTest() throws Exception {
        Assert.assertNotNull((Object)customSpanContext);
        Span rootSpan = this.getNewRootSpanWithContext();
        try (Scope ignored = rootSpan.makeCurrent();){
            firestore.collection("col").document("foo").set(Collections.singletonMap("foo", "bar"), SetOptions.merge()).get();
        }
        finally {
            rootSpan.end();
        }
        this.waitForTracesToComplete();
        this.fetchAndValidateTrace(customSpanContext.getTraceId(), "DocumentReference.Set", "Batch.Commit", this.grpcSpanName(COMMIT_RPC_NAME));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void docRefSet3TraceTest() throws Exception {
        Assert.assertNotNull((Object)customSpanContext);
        Span rootSpan = this.getNewRootSpanWithContext();
        try (Scope ignored = rootSpan.makeCurrent();){
            firestore.collection("col").document("foo").set((Object)new ITTracingTest.Pojo(1)).get();
        }
        finally {
            rootSpan.end();
        }
        this.waitForTracesToComplete();
        this.fetchAndValidateTrace(customSpanContext.getTraceId(), "DocumentReference.Set", "Batch.Commit", this.grpcSpanName(COMMIT_RPC_NAME));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void docRefSet4TraceTest() throws Exception {
        Assert.assertNotNull((Object)customSpanContext);
        Span rootSpan = this.getNewRootSpanWithContext();
        try (Scope ignored = rootSpan.makeCurrent();){
            firestore.collection("col").document("foo").set((Object)new ITTracingTest.Pojo(1), SetOptions.merge()).get();
        }
        finally {
            rootSpan.end();
        }
        this.waitForTracesToComplete();
        this.fetchAndValidateTrace(customSpanContext.getTraceId(), "DocumentReference.Set", "Batch.Commit", this.grpcSpanName(COMMIT_RPC_NAME));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void docRefUpdateTraceTest() throws Exception {
        Assert.assertNotNull((Object)customSpanContext);
        Span rootSpan = this.getNewRootSpanWithContext();
        try (Scope ignored = rootSpan.makeCurrent();){
            firestore.collection("col").document("foo").update(Collections.singletonMap("foo", "bar")).get();
        }
        finally {
            rootSpan.end();
        }
        this.waitForTracesToComplete();
        this.fetchAndValidateTrace(customSpanContext.getTraceId(), "DocumentReference.Update", "Batch.Commit", this.grpcSpanName(COMMIT_RPC_NAME));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void docRefUpdate2TraceTest() throws Exception {
        Assert.assertNotNull((Object)customSpanContext);
        Span rootSpan = this.getNewRootSpanWithContext();
        try (Scope ignored = rootSpan.makeCurrent();){
            firestore.collection("col").document("foo").update(Collections.singletonMap("foo", "bar"), Precondition.NONE).get();
        }
        finally {
            rootSpan.end();
        }
        this.waitForTracesToComplete();
        this.fetchAndValidateTrace(customSpanContext.getTraceId(), "DocumentReference.Update", "Batch.Commit", this.grpcSpanName(COMMIT_RPC_NAME));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void docRefUpdate3TraceTest() throws Exception {
        Assert.assertNotNull((Object)customSpanContext);
        Span rootSpan = this.getNewRootSpanWithContext();
        try (Scope ignored = rootSpan.makeCurrent();){
            firestore.collection("col").document("foo").update("key", (Object)"value", new Object[]{"key2", "value2"}).get();
        }
        finally {
            rootSpan.end();
        }
        this.waitForTracesToComplete();
        this.fetchAndValidateTrace(customSpanContext.getTraceId(), "DocumentReference.Update", "Batch.Commit", this.grpcSpanName(COMMIT_RPC_NAME));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void docRefUpdate4TraceTest() throws Exception {
        Assert.assertNotNull((Object)customSpanContext);
        Span rootSpan = this.getNewRootSpanWithContext();
        try (Scope ignored = rootSpan.makeCurrent();){
            firestore.collection("col").document("foo").update(FieldPath.of((String[])new String[]{"key"}), (Object)"value", new Object[]{FieldPath.of((String[])new String[]{"key2"}), "value2"}).get();
        }
        finally {
            rootSpan.end();
        }
        this.waitForTracesToComplete();
        this.fetchAndValidateTrace(customSpanContext.getTraceId(), "DocumentReference.Update", "Batch.Commit", this.grpcSpanName(COMMIT_RPC_NAME));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void docRefUpdate5TraceTest() throws Exception {
        Assert.assertNotNull((Object)customSpanContext);
        Span rootSpan = this.getNewRootSpanWithContext();
        try (Scope ignored = rootSpan.makeCurrent();){
            firestore.collection("col").document("foo").update(Precondition.NONE, "key", (Object)"value", new Object[]{"key2", "value2"}).get();
        }
        finally {
            rootSpan.end();
        }
        this.waitForTracesToComplete();
        this.fetchAndValidateTrace(customSpanContext.getTraceId(), "DocumentReference.Update", "Batch.Commit", this.grpcSpanName(COMMIT_RPC_NAME));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void docRefUpdate6TraceTest() throws Exception {
        Assert.assertNotNull((Object)customSpanContext);
        Span rootSpan = this.getNewRootSpanWithContext();
        try (Scope ignored = rootSpan.makeCurrent();){
            firestore.collection("col").document("foo").update(Precondition.NONE, FieldPath.of((String[])new String[]{"key"}), (Object)"value", new Object[]{FieldPath.of((String[])new String[]{"key2"}), "value2"}).get();
        }
        finally {
            rootSpan.end();
        }
        this.waitForTracesToComplete();
        this.fetchAndValidateTrace(customSpanContext.getTraceId(), "DocumentReference.Update", "Batch.Commit", this.grpcSpanName(COMMIT_RPC_NAME));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void docRefDeleteTraceTest() throws Exception {
        Assert.assertNotNull((Object)customSpanContext);
        Span rootSpan = this.getNewRootSpanWithContext();
        try (Scope ignored = rootSpan.makeCurrent();){
            firestore.collection("col").document("doc0").delete().get();
        }
        finally {
            rootSpan.end();
        }
        this.waitForTracesToComplete();
        this.fetchAndValidateTrace(customSpanContext.getTraceId(), "DocumentReference.Delete", "Batch.Commit", this.grpcSpanName(COMMIT_RPC_NAME));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void docRefDelete2TraceTest() throws Exception {
        Assert.assertNotNull((Object)customSpanContext);
        Span rootSpan = this.getNewRootSpanWithContext();
        try (Scope ignored = rootSpan.makeCurrent();){
            firestore.collection("col").document("doc0").delete(Precondition.NONE).get();
        }
        finally {
            rootSpan.end();
        }
        this.waitForTracesToComplete();
        this.fetchAndValidateTrace(customSpanContext.getTraceId(), "DocumentReference.Delete", "Batch.Commit", this.grpcSpanName(COMMIT_RPC_NAME));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void docRefGetTraceTest() throws Exception {
        Assert.assertNotNull((Object)customSpanContext);
        Span rootSpan = this.getNewRootSpanWithContext();
        try (Scope ignored = rootSpan.makeCurrent();){
            firestore.collection("col").document("doc0").get().get();
        }
        finally {
            rootSpan.end();
        }
        this.waitForTracesToComplete();
        this.fetchAndValidateTrace(customSpanContext.getTraceId(), "DocumentReference.Get", this.grpcSpanName(BATCH_GET_DOCUMENTS_RPC_NAME));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void docRefGet2TraceTest() throws Exception {
        Assert.assertNotNull((Object)customSpanContext);
        Span rootSpan = this.getNewRootSpanWithContext();
        try (Scope ignored = rootSpan.makeCurrent();){
            firestore.collection("col").document("doc0").get(FieldMask.of((String[])new String[]{"foo"})).get();
        }
        finally {
            rootSpan.end();
        }
        this.waitForTracesToComplete();
        this.fetchAndValidateTrace(customSpanContext.getTraceId(), "DocumentReference.Get", this.grpcSpanName(BATCH_GET_DOCUMENTS_RPC_NAME));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void docListCollectionsTraceTest() throws Exception {
        Assert.assertNotNull((Object)customSpanContext);
        Span rootSpan = this.getNewRootSpanWithContext();
        try (Scope ignored = rootSpan.makeCurrent();){
            firestore.collection("col").document("doc0").listCollections();
        }
        finally {
            rootSpan.end();
        }
        this.waitForTracesToComplete();
        this.fetchAndValidateTrace(customSpanContext.getTraceId(), "DocumentReference.ListCollections", this.grpcSpanName(LIST_COLLECTIONS_RPC_NAME));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void getAllTraceTest() throws Exception {
        Assert.assertNotNull((Object)customSpanContext);
        Span rootSpan = this.getNewRootSpanWithContext();
        try (Scope ignored = rootSpan.makeCurrent();){
            DocumentReference docRef0 = firestore.collection("col").document();
            DocumentReference docRef1 = firestore.collection("col").document();
            DocumentReference[] docs = new DocumentReference[]{docRef0, docRef1};
            firestore.getAll(docs).get();
        }
        finally {
            rootSpan.end();
        }
        this.waitForTracesToComplete();
        this.fetchAndValidateTrace(customSpanContext.getTraceId(), this.grpcSpanName(BATCH_GET_DOCUMENTS_RPC_NAME));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void queryGetTraceTest() throws Exception {
        Assert.assertNotNull((Object)customSpanContext);
        Span rootSpan = this.getNewRootSpanWithContext();
        try (Scope ignored = rootSpan.makeCurrent();){
            firestore.collection("col").whereEqualTo("foo", (Object)"my_non_existent_value").get().get();
        }
        finally {
            rootSpan.end();
        }
        this.waitForTracesToComplete();
        this.fetchAndValidateTrace(customSpanContext.getTraceId(), "Query.Get", this.grpcSpanName(RUN_QUERY_RPC_NAME));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void transactionTraceTest() throws Exception {
        Assert.assertNotNull((Object)customSpanContext);
        Span rootSpan = this.getNewRootSpanWithContext();
        try (Scope ignored = rootSpan.makeCurrent();){
            firestore.runTransaction(transaction -> {
                Query q = firestore.collection("col").whereGreaterThan("bla", (Object)"");
                DocumentReference d = firestore.collection("col").document("foo");
                transaction.get(q).get();
                transaction.get(q.count());
                transaction.getAll(new DocumentReference[]{d, d}).get();
                transaction.set(firestore.collection("foo").document("bar"), Collections.singletonMap("foo", "bar"));
                transaction.set(firestore.collection("foo").document("bar2"), Collections.singletonMap("foo2", "bar2"));
                return 0;
            }).get();
        }
        finally {
            rootSpan.end();
        }
        this.waitForTracesToComplete();
        this.fetchAndValidateTrace(customSpanContext.getTraceId(), 11, Arrays.asList(Arrays.asList("Transaction.Run", "Transaction.Begin", this.grpcSpanName(BEGIN_TRANSACTION_RPC_NAME)), Arrays.asList("Transaction.Run", "Transaction.Begin", this.grpcSpanName(BEGIN_TRANSACTION_RPC_NAME)), Arrays.asList("Transaction.Run", "Transaction.Get.Query", this.grpcSpanName(RUN_QUERY_RPC_NAME)), Arrays.asList("Transaction.Run", "Transaction.Get.AggregationQuery", this.grpcSpanName(RUN_AGGREGATION_QUERY_RPC_NAME)), Arrays.asList("Transaction.Run", "Transaction.Get.Documents", this.grpcSpanName(BATCH_GET_DOCUMENTS_RPC_NAME)), Arrays.asList("Transaction.Run", "Transaction.Commit", this.grpcSpanName(COMMIT_RPC_NAME))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void transactionRollbackTraceTest() throws Exception {
        String myErrorMessage = "My error message.";
        Assert.assertNotNull((Object)customSpanContext);
        Span rootSpan = this.getNewRootSpanWithContext();
        try (Scope ignored = rootSpan.makeCurrent();){
            firestore.runTransaction(transaction -> {
                throw new Exception(myErrorMessage);
            }).get();
        }
        catch (Exception exception) {
        }
        finally {
            rootSpan.end();
        }
        this.waitForTracesToComplete();
        this.fetchAndValidateTrace(customSpanContext.getTraceId(), 5, Arrays.asList(Arrays.asList("Transaction.Run", "Transaction.Begin", this.grpcSpanName(BEGIN_TRANSACTION_RPC_NAME)), Arrays.asList("Transaction.Run", "Transaction.Rollback", this.grpcSpanName(ROLLBACK_RPC_NAME))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void writeBatchTraceTest() throws Exception {
        Assert.assertNotNull((Object)customSpanContext);
        Span rootSpan = this.getNewRootSpanWithContext();
        try (Scope ignored = rootSpan.makeCurrent();){
            WriteBatch batch = firestore.batch();
            DocumentReference docRef = firestore.collection("foo").document();
            batch.create(docRef, Collections.singletonMap("foo", "bar"));
            batch.update(docRef, Collections.singletonMap("foo", "bar"));
            batch.delete(docRef);
            batch.commit().get();
        }
        finally {
            rootSpan.end();
        }
        this.waitForTracesToComplete();
        this.fetchAndValidateTrace(customSpanContext.getTraceId(), "Batch.Commit", this.grpcSpanName(COMMIT_RPC_NAME));
    }

    protected static class TraceContainer {
        private final Map<Long, TraceSpan> idSpanMap = new TreeMap<Long, TraceSpan>();
        private final Map<Long, List<Long>> parentChildIdMap = new TreeMap<Long, List<Long>>();
        private long rootId;

        public TraceContainer(String rootSpanName, Trace trace) {
            for (TraceSpan span : trace.getSpansList()) {
                long spanId = span.getSpanId();
                this.idSpanMap.put(spanId, span);
                if (rootSpanName.equals(span.getName())) {
                    this.rootId = span.getSpanId();
                }
                if (!this.parentChildIdMap.containsKey(span.getParentSpanId())) {
                    this.parentChildIdMap.put(span.getParentSpanId(), new ArrayList());
                }
                this.parentChildIdMap.get(span.getParentSpanId()).add(spanId);
            }
        }

        String spanName(long spanId) {
            return this.idSpanMap.get(spanId).getName();
        }

        List<Long> childSpans(long spanId) {
            return this.parentChildIdMap.get(spanId);
        }

        boolean containsCallStack(String ... callStack) throws RuntimeException {
            List<String> expectedCallStack = Arrays.asList(callStack);
            if (expectedCallStack.isEmpty()) {
                throw new RuntimeException("Input callStack is empty");
            }
            return this.dfsContainsCallStack(this.rootId, expectedCallStack);
        }

        private boolean dfsContainsCallStack(long spanId, List<String> expectedCallStack) {
            logger.info("span=" + this.spanName(spanId) + ", expectedCallStack[0]=" + (expectedCallStack.isEmpty() ? "null" : expectedCallStack.get(0)));
            if (expectedCallStack.isEmpty()) {
                return false;
            }
            if (this.spanName(spanId).equals(expectedCallStack.get(0))) {
                if (this.childSpans(spanId) == null) {
                    logger.info("No more children for " + this.spanName(spanId));
                    return true;
                }
                for (Long childSpan : this.childSpans(spanId)) {
                    int callStackListSize = expectedCallStack.size();
                    logger.info("childSpan=" + this.spanName(childSpan) + ", expectedCallStackSize=" + callStackListSize);
                    if (!this.dfsContainsCallStack(childSpan, expectedCallStack.subList(1, callStackListSize))) continue;
                    return true;
                }
            } else {
                logger.info(this.spanName(spanId) + " didn't match " + expectedCallStack.get(0));
            }
            return false;
        }
    }
}

