/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore.it;

import com.google.api.core.ApiFuture;
import com.google.cloud.firestore.AggregateField;
import com.google.cloud.firestore.AggregateQuery;
import com.google.cloud.firestore.AggregateQuerySnapshot;
import com.google.cloud.firestore.CollectionGroup;
import com.google.cloud.firestore.CollectionReference;
import com.google.cloud.firestore.DocumentSnapshot;
import com.google.cloud.firestore.FieldPath;
import com.google.cloud.firestore.FirestoreOptions;
import com.google.cloud.firestore.LocalFirestoreHelper;
import com.google.cloud.firestore.Query;
import com.google.cloud.firestore.it.ITBaseTest;
import com.google.cloud.firestore.it.TestHelper;
import com.google.common.truth.Truth;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ITQueryAggregationsTest
extends ITBaseTest {
    private static Map<String, Map<String, Object>> testDocs1 = LocalFirestoreHelper.map("a", LocalFirestoreHelper.map("author", "authorA", "title", "titleA", "pages", 100, "foo", 1, "bar", 2, "baz", 3), "b", LocalFirestoreHelper.map("author", "authorB", "title", "titleB", "pages", 50, "foo", 1, "bar", 2, "baz", 3));

    private CollectionReference testCollection() {
        String collectionPath = "java-" + LocalFirestoreHelper.autoId();
        return this.firestore.collection(collectionPath);
    }

    private CollectionReference testCollection(String name) {
        return this.firestore.collection("java-" + name + "-" + LocalFirestoreHelper.autoId());
    }

    private CollectionReference testCollectionWithDocs(Map<String, Map<String, Object>> docs) throws InterruptedException {
        CollectionReference collection = this.testCollection();
        CollectionReference writer = this.firestore.collection(collection.getId());
        ITQueryAggregationsTest.writeAllDocs(writer, docs);
        return collection;
    }

    public static void writeAllDocs(CollectionReference collection, Map<String, Map<String, Object>> docs) throws InterruptedException {
        for (Map.Entry<String, Map<String, Object>> doc : docs.entrySet()) {
            TestHelper.await(collection.document(doc.getKey()).set(doc.getValue()));
        }
    }

    @Test
    public void canRunCountUsingAggregationMethod() throws Exception {
        CollectionReference collection = this.testCollectionWithDocs(testDocs1);
        AggregateQuerySnapshot snapshot = (AggregateQuerySnapshot)collection.aggregate((AggregateField)AggregateField.count(), new AggregateField[0]).get().get();
        Truth.assertThat((Long)snapshot.getCount()).isEqualTo((Object)2);
    }

    @Test
    public void allowsAliasesForLongestFieldNames() throws Exception {
        StringBuilder builder = new StringBuilder(1500);
        for (int i = 0; i < 1499; ++i) {
            builder.append("k");
        }
        String longestField = builder.toString();
        Map<String, Map<String, Object>> testDocs = LocalFirestoreHelper.map("a", LocalFirestoreHelper.map(longestField, 2, new Object[0]), "b", LocalFirestoreHelper.map(longestField, 4, new Object[0]));
        CollectionReference collection = this.testCollectionWithDocs(testDocs);
        AggregateQuerySnapshot snapshot = (AggregateQuerySnapshot)collection.aggregate((AggregateField)AggregateField.sum((String)longestField), new AggregateField[0]).get().get();
        Truth.assertThat((Object)snapshot.get((AggregateField)AggregateField.sum((String)longestField))).isEqualTo((Object)6);
        AggregateQuerySnapshot snapshot2 = (AggregateQuerySnapshot)collection.aggregate((AggregateField)AggregateField.average((String)longestField), new AggregateField[0]).get().get();
        Truth.assertThat((Double)snapshot2.get(AggregateField.average((String)longestField))).isEqualTo((Object)3.0);
    }

    @Test
    public void canGetDuplicateAggregations() throws Exception {
        CollectionReference collection = this.testCollectionWithDocs(testDocs1);
        AggregateQuerySnapshot snapshot = (AggregateQuerySnapshot)collection.aggregate((AggregateField)AggregateField.count(), new AggregateField[]{AggregateField.count(), AggregateField.sum((String)"pages"), AggregateField.sum((String)"pages")}).get().get();
        Truth.assertThat((Long)snapshot.getCount()).isEqualTo((Object)2);
        Truth.assertThat((Object)snapshot.get((AggregateField)AggregateField.sum((String)"pages"))).isEqualTo((Object)150);
    }

    @Test
    public void aggregateErrorMessageIfIndexIsMissing() throws Exception {
        Assume.assumeFalse((String)"Skip this test when running against the emulator because it does not require composite index creation.", (boolean)TestHelper.isRunningAgainstFirestoreEmulator(this.firestore));
        CollectionReference collection = this.testCollectionWithDocs(testDocs1);
        AggregateQuery aggregateQuery = collection.whereEqualTo("key1", (Object)42).whereLessThan("key2", (Object)42).aggregate((AggregateField)AggregateField.count(), new AggregateField[0]);
        ExecutionException executionException = (ExecutionException)Assert.assertThrows(ExecutionException.class, () -> aggregateQuery.get().get());
        Truth.assertThat((Throwable)executionException).hasCauseThat().hasMessageThat().containsMatch("FAILED_PRECONDITION:.*index.*");
    }

    @Test
    public void canRunSumQuery() throws Exception {
        CollectionReference collection = this.testCollectionWithDocs(testDocs1);
        AggregateQuerySnapshot snapshot = (AggregateQuerySnapshot)collection.aggregate((AggregateField)AggregateField.sum((String)"pages"), new AggregateField[0]).get().get();
        Truth.assertThat((Object)snapshot.get((AggregateField)AggregateField.sum((String)"pages"))).isEqualTo((Object)150);
    }

    @Test
    public void canRunAverageQuery() throws Exception {
        CollectionReference collection = this.testCollectionWithDocs(testDocs1);
        AggregateQuerySnapshot snapshot = (AggregateQuerySnapshot)collection.aggregate((AggregateField)AggregateField.average((String)"pages"), new AggregateField[0]).get().get();
        Truth.assertThat((Double)snapshot.get(AggregateField.average((String)"pages"))).isEqualTo((Object)75.0);
    }

    @Test
    public void canGetMultipleAggregationsInTheSameQuery() throws Exception {
        CollectionReference collection = this.testCollectionWithDocs(testDocs1);
        AggregateQuerySnapshot snapshot = (AggregateQuerySnapshot)collection.aggregate((AggregateField)AggregateField.sum((String)"pages"), new AggregateField[]{AggregateField.average((String)"pages"), AggregateField.count()}).get().get();
        Truth.assertThat((Object)snapshot.get((AggregateField)AggregateField.sum((String)"pages"))).isEqualTo((Object)150);
        Truth.assertThat((Double)snapshot.get(AggregateField.average((String)"pages"))).isEqualTo((Object)75.0);
        Truth.assertThat((Long)snapshot.get(AggregateField.count())).isEqualTo((Object)2);
    }

    @Test
    public void getCorrectTypeForSumLong() throws Exception {
        Map<String, Map<String, Object>> testDocs = LocalFirestoreHelper.map("a", LocalFirestoreHelper.map("foo", 100, new Object[0]), "b", LocalFirestoreHelper.map("foo", 100, new Object[0]));
        CollectionReference collection = this.testCollectionWithDocs(testDocs);
        AggregateQuerySnapshot snapshot = (AggregateQuerySnapshot)collection.aggregate((AggregateField)AggregateField.sum((String)"foo"), new AggregateField[0]).get().get();
        Object sum = snapshot.get((AggregateField)AggregateField.sum((String)"foo"));
        Truth.assertThat((Boolean)(sum instanceof Long)).isTrue();
    }

    @Test
    public void getCorrectTypeForSumDouble() throws Exception {
        Map<String, Map<String, Object>> testDocs = LocalFirestoreHelper.map("a", LocalFirestoreHelper.map("foo", 100.5, new Object[0]), "b", LocalFirestoreHelper.map("foo", 100, new Object[0]));
        CollectionReference collection = this.testCollectionWithDocs(testDocs);
        AggregateQuerySnapshot snapshot = (AggregateQuerySnapshot)collection.aggregate((AggregateField)AggregateField.sum((String)"foo"), new AggregateField[0]).get().get();
        Object sum = snapshot.get((AggregateField)AggregateField.sum((String)"foo"));
        Truth.assertThat((Boolean)(sum instanceof Double)).isTrue();
    }

    @Test
    public void getCorrectTypeForSumNaN() throws Exception {
        Map<String, Map<String, Object>> testDocs = LocalFirestoreHelper.map("a", LocalFirestoreHelper.map("foo", 100.5, new Object[0]), "b", LocalFirestoreHelper.map("foo", Double.NaN, new Object[0]));
        CollectionReference collection = this.testCollectionWithDocs(testDocs);
        AggregateQuerySnapshot snapshot = (AggregateQuerySnapshot)collection.aggregate((AggregateField)AggregateField.sum((String)"foo"), new AggregateField[0]).get().get();
        Object sum = snapshot.get((AggregateField)AggregateField.sum((String)"foo"));
        Truth.assertThat((Boolean)(sum instanceof Double)).isTrue();
        Truth.assertThat((Boolean)sum.equals(Double.NaN));
    }

    @Test
    public void getCorrectTypeForAverageDouble() throws Exception {
        CollectionReference collection = this.testCollectionWithDocs(testDocs1);
        AggregateQuerySnapshot snapshot = (AggregateQuerySnapshot)collection.aggregate((AggregateField)AggregateField.average((String)"pages"), new AggregateField[0]).get().get();
        Object average = snapshot.get((AggregateField)AggregateField.average((String)"pages"));
        Truth.assertThat((Boolean)(average instanceof Double)).isTrue();
    }

    @Test
    public void getCorrectTypeForAverageNaN() throws Exception {
        Map<String, Map<String, Object>> testDocs = LocalFirestoreHelper.map("a", LocalFirestoreHelper.map("foo", 100.5, new Object[0]), "b", LocalFirestoreHelper.map("foo", Double.NaN, new Object[0]));
        CollectionReference collection = this.testCollectionWithDocs(testDocs);
        AggregateQuerySnapshot snapshot = (AggregateQuerySnapshot)collection.aggregate((AggregateField)AggregateField.average((String)"foo"), new AggregateField[0]).get().get();
        Double sum = snapshot.get(AggregateField.average((String)"foo"));
        Truth.assertThat((Boolean)(sum instanceof Double)).isTrue();
        Truth.assertThat((Boolean)((Object)sum).equals(Double.NaN));
    }

    @Test
    public void getCorrectTypeForAverageNull() throws Exception {
        CollectionReference collection = this.testCollection();
        AggregateQuerySnapshot snapshot = (AggregateQuerySnapshot)collection.aggregate((AggregateField)AggregateField.average((String)"bar"), new AggregateField[0]).get().get();
        Double sum = snapshot.get(AggregateField.average((String)"bar"));
        Truth.assertThat((Boolean)(sum == null ? 1 : 0)).isTrue();
    }

    @Test
    public void canPerformMaxAggregations() throws Exception {
        Assume.assumeTrue((String)"Skip this test when running against prod because it requires composite index creation.", (boolean)TestHelper.isRunningAgainstFirestoreEmulator(this.firestore));
        CollectionReference collection = this.testCollectionWithDocs(testDocs1);
        AggregateField.SumAggregateField f1 = AggregateField.sum((String)"pages");
        AggregateField.AverageAggregateField f2 = AggregateField.average((String)"pages");
        AggregateField.CountAggregateField f3 = AggregateField.count();
        AggregateField.SumAggregateField f4 = AggregateField.sum((String)"foo");
        AggregateField.SumAggregateField f5 = AggregateField.sum((String)"bar");
        AggregateQuerySnapshot snapshot = (AggregateQuerySnapshot)collection.aggregate((AggregateField)f1, new AggregateField[]{f2, f3, f4, f5}).get().get();
        Truth.assertThat((Object)snapshot.get((AggregateField)f1)).isEqualTo((Object)150);
        Truth.assertThat((Object)snapshot.get((AggregateField)f2)).isEqualTo((Object)75.0);
        Truth.assertThat((Object)snapshot.get((AggregateField)f3)).isEqualTo((Object)2);
        Truth.assertThat((Object)snapshot.get((AggregateField)f4)).isEqualTo((Object)2);
        Truth.assertThat((Object)snapshot.get((AggregateField)f5)).isEqualTo((Object)4);
    }

    @Test
    public void cannotPerformMoreThanMaxAggregations() throws Exception {
        CollectionReference collection = this.testCollectionWithDocs(testDocs1);
        AggregateField.SumAggregateField f1 = AggregateField.sum((String)"pages");
        AggregateField.AverageAggregateField f2 = AggregateField.average((String)"pages");
        AggregateField.CountAggregateField f3 = AggregateField.count();
        AggregateField.SumAggregateField f4 = AggregateField.sum((String)"foo");
        AggregateField.SumAggregateField f5 = AggregateField.sum((String)"bar");
        AggregateField.SumAggregateField f6 = AggregateField.sum((String)"baz");
        Exception exception = null;
        try {
            collection.aggregate((AggregateField)f1, new AggregateField[]{f2, f3, f4, f5, f6}).get().get();
        }
        catch (Exception e) {
            exception = e;
        }
        Truth.assertThat((Throwable)exception).isNotNull();
        Truth.assertThat((String)exception.getMessage()).contains((CharSequence)"maximum number of aggregations");
    }

    @Test
    public void aggregateQueriesSupportCollectionGroups() throws Exception {
        Assume.assumeTrue((String)"Skip this test when running against prod because it requires composite index creation.", (boolean)TestHelper.isRunningAgainstFirestoreEmulator(this.firestore));
        String collectionGroupId = "myColGroupId" + LocalFirestoreHelper.autoId();
        Map<String, Integer> data = LocalFirestoreHelper.map("x", 2, new Object[0]);
        TestHelper.await(this.firestore.collection(collectionGroupId).document("cg-doc1").set(data));
        TestHelper.await(this.firestore.collection("abc").document("123").collection(collectionGroupId).document("cg-doc2").set(data));
        TestHelper.await(this.firestore.collection("zzz" + collectionGroupId).document("cg-doc3").set(data));
        TestHelper.await(this.firestore.collection("abc").document("123").collection("zzz" + collectionGroupId).document("cg-doc4").set(data));
        TestHelper.await(this.firestore.collection("abc").document("123").collection("zzz").document(collectionGroupId).set(data));
        CollectionGroup collectionGroup = this.firestore.collectionGroup(collectionGroupId);
        AggregateQuerySnapshot snapshot = (AggregateQuerySnapshot)collectionGroup.aggregate((AggregateField)AggregateField.count(), new AggregateField[]{AggregateField.sum((String)"x"), AggregateField.average((String)"x")}).get().get();
        Truth.assertThat((Long)snapshot.get(AggregateField.count())).isEqualTo((Object)2);
        Truth.assertThat((Object)snapshot.get((AggregateField)AggregateField.sum((String)"x"))).isEqualTo((Object)4);
        Truth.assertThat((Double)snapshot.get(AggregateField.average((String)"x"))).isEqualTo((Object)2);
    }

    @Test
    public void performsAggregationsOnDocumentsWithAllAggregatedFields() throws Exception {
        Assume.assumeTrue((String)"Skip this test when running against prod because it requires composite index creation.", (boolean)TestHelper.isRunningAgainstFirestoreEmulator(this.firestore));
        Map<String, Map<String, Object>> testDocs = LocalFirestoreHelper.map("a", LocalFirestoreHelper.map("author", "authorA", "title", "titleA", "pages", 100, "year", 1980), "b", LocalFirestoreHelper.map("author", "authorB", "title", "titleB", "pages", 50, "year", 2020), "c", LocalFirestoreHelper.map("author", "authorC", "title", "titleC", "pages", 150, "year", 2021), "d", LocalFirestoreHelper.map("author", "authorD", "title", "titleD", "pages", 50));
        CollectionReference collection = this.testCollectionWithDocs(testDocs);
        AggregateQuerySnapshot snapshot = (AggregateQuerySnapshot)collection.aggregate((AggregateField)AggregateField.sum((String)"pages"), new AggregateField[]{AggregateField.average((String)"pages"), AggregateField.average((String)"year"), AggregateField.count()}).get().get();
        Truth.assertThat((Object)snapshot.get((AggregateField)AggregateField.sum((String)"pages"))).isEqualTo((Object)300);
        Truth.assertThat((Double)snapshot.get(AggregateField.average((String)"pages"))).isEqualTo((Object)100);
        Truth.assertThat((Double)snapshot.get(AggregateField.average((String)"year"))).isEqualTo((Object)2007);
        Truth.assertThat((Long)snapshot.get(AggregateField.count())).isEqualTo((Object)3);
    }

    @Test
    public void performsAggregationsWhenNaNExistsForSomeFieldValues() throws Exception {
        Assume.assumeTrue((String)"Skip this test when running against prod because it requires composite index creation.", (boolean)TestHelper.isRunningAgainstFirestoreEmulator(this.firestore));
        Map<String, Map<String, Object>> testDocs = LocalFirestoreHelper.map("a", LocalFirestoreHelper.map("author", "authorA", "title", "titleA", "pages", 100, "year", 1980, "rating", 5), "b", LocalFirestoreHelper.map("author", "authorB", "title", "titleB", "pages", 50, "year", 2020, "rating", 4), "c", LocalFirestoreHelper.map("author", "authorC", "title", "titleC", "pages", 100, "year", 1980, "rating", Double.NaN), "d", LocalFirestoreHelper.map("author", "authorD", "title", "titleD", "pages", 50, "year", 2020, "rating", 0));
        CollectionReference collection = this.testCollectionWithDocs(testDocs);
        AggregateQuerySnapshot snapshot = (AggregateQuerySnapshot)collection.aggregate((AggregateField)AggregateField.sum((String)"rating"), new AggregateField[]{AggregateField.sum((String)"pages"), AggregateField.average((String)"year")}).get().get();
        Truth.assertThat((Object)snapshot.get((AggregateField)AggregateField.sum((String)"rating"))).isEqualTo((Object)Double.NaN);
        Truth.assertThat((Object)snapshot.get((AggregateField)AggregateField.sum((String)"pages"))).isEqualTo((Object)300);
        Truth.assertThat((Double)snapshot.get(AggregateField.average((String)"year"))).isEqualTo((Object)2000);
    }

    @Test
    public void throwsAnErrorWhenGettingTheResultOfAnUnrequestedAggregation() throws Exception {
        CollectionReference collection = this.testCollectionWithDocs(testDocs1);
        AggregateQuerySnapshot snapshot = (AggregateQuerySnapshot)collection.aggregate((AggregateField)AggregateField.sum((String)"pages"), new AggregateField[0]).get().get();
        Exception exception = null;
        try {
            snapshot.get(AggregateField.average((String)"pages"));
        }
        catch (Exception e) {
            exception = e;
        }
        Truth.assertThat((Throwable)exception).isNotNull();
        Truth.assertThat((String)exception.getMessage()).isEqualTo((Object)"'average(pages)' was not requested in the aggregation query.");
        exception = null;
        try {
            snapshot.get((AggregateField)AggregateField.sum((String)"foo"));
        }
        catch (RuntimeException e) {
            exception = e;
        }
        Truth.assertThat((Throwable)exception).isNotNull();
        Truth.assertThat((String)exception.getMessage()).isEqualTo((Object)"'sum(foo)' was not requested in the aggregation query.");
    }

    @Test
    public void performsAggregationWhenUsingInOperator() throws Exception {
        Assume.assumeTrue((String)"Skip this test when running against prod because it requires composite index creation.", (boolean)TestHelper.isRunningAgainstFirestoreEmulator(this.firestore));
        Map<String, Map<String, Object>> testDocs = LocalFirestoreHelper.map("a", LocalFirestoreHelper.map("author", "authorA", "title", "titleA", "pages", 100, "year", 1980, "rating", 5), "b", LocalFirestoreHelper.map("author", "authorB", "title", "titleB", "pages", 50, "year", 2020, "rating", 4), "c", LocalFirestoreHelper.map("author", "authorC", "title", "titleC", "pages", 100, "year", 1980, "rating", 3), "d", LocalFirestoreHelper.map("author", "authorD", "title", "titleD", "pages", 50, "year", 2020, "rating", 0));
        CollectionReference collection = this.testCollectionWithDocs(testDocs);
        AggregateQuerySnapshot snapshot = (AggregateQuerySnapshot)collection.whereIn("rating", Arrays.asList(5, 3)).aggregate((AggregateField)AggregateField.sum((String)"rating"), new AggregateField[]{AggregateField.average((String)"rating"), AggregateField.sum((String)"pages"), AggregateField.average((String)"pages"), AggregateField.count()}).get().get();
        Truth.assertThat((Object)snapshot.get((AggregateField)AggregateField.sum((String)"rating"))).isEqualTo((Object)8);
        Truth.assertThat((Double)snapshot.get(AggregateField.average((String)"rating"))).isEqualTo((Object)4);
        Truth.assertThat((Object)snapshot.get((AggregateField)AggregateField.sum((String)"pages"))).isEqualTo((Object)200);
        Truth.assertThat((Double)snapshot.get(AggregateField.average((String)"pages"))).isEqualTo((Object)100);
        Truth.assertThat((Long)snapshot.get(AggregateField.count())).isEqualTo((Object)2);
    }

    @Test
    public void performsAggregationWhenUsingArrayContainsAnyOperator() throws Exception {
        Assume.assumeTrue((String)"Skip this test when running against prod because it requires composite index creation.", (boolean)TestHelper.isRunningAgainstFirestoreEmulator(this.firestore));
        Map<String, Map<String, Object>> testDocs = LocalFirestoreHelper.map("a", LocalFirestoreHelper.map("author", "authorA", "title", "titleA", "pages", 100, "year", 1980, "rating", Arrays.asList(5, 1000)), "b", LocalFirestoreHelper.map("author", "authorB", "title", "titleB", "pages", 50, "year", 2020, "rating", Arrays.asList(4)), "c", LocalFirestoreHelper.map("author", "authorC", "title", "titleC", "pages", 100, "year", 1980, "rating", Arrays.asList(2222, 3)), "d", LocalFirestoreHelper.map("author", "authorD", "title", "titleD", "pages", 50, "year", 2020, "rating", Arrays.asList(0)));
        CollectionReference collection = this.testCollectionWithDocs(testDocs);
        AggregateQuerySnapshot snapshot = (AggregateQuerySnapshot)collection.whereArrayContainsAny("rating", Arrays.asList(5, 3)).aggregate((AggregateField)AggregateField.sum((String)"rating"), new AggregateField[]{AggregateField.average((String)"rating"), AggregateField.sum((String)"pages"), AggregateField.average((String)"pages"), AggregateField.count()}).get().get();
        Truth.assertThat((Object)snapshot.get((AggregateField)AggregateField.sum((String)"rating"))).isEqualTo((Object)0);
        Truth.assertThat((Double)snapshot.get(AggregateField.average((String)"rating"))).isEqualTo(null);
        Truth.assertThat((Object)snapshot.get((AggregateField)AggregateField.sum((String)"pages"))).isEqualTo((Object)200);
        Truth.assertThat((Double)snapshot.get(AggregateField.average((String)"pages"))).isEqualTo((Object)100);
        Truth.assertThat((Long)snapshot.get(AggregateField.count())).isEqualTo((Object)2);
    }

    @Test
    public void performsAggregationsOnNestedMapValues() throws Exception {
        Map<String, Map<String, Object>> testDocs = LocalFirestoreHelper.map("a", LocalFirestoreHelper.map("author", "authorA", "title", "titleA", "metadata", LocalFirestoreHelper.map("pages", 100, "rating", LocalFirestoreHelper.map("critic", 2, "user", 5))), "b", LocalFirestoreHelper.map("author", "authorB", "title", "titleB", "metadata", LocalFirestoreHelper.map("pages", 50, "rating", LocalFirestoreHelper.map("critic", 4, "user", 4))));
        CollectionReference collection = this.testCollectionWithDocs(testDocs);
        AggregateQuerySnapshot snapshot = (AggregateQuerySnapshot)collection.aggregate((AggregateField)AggregateField.sum((String)"metadata.pages"), new AggregateField[]{AggregateField.average((String)"metadata.pages"), AggregateField.count()}).get().get();
        Truth.assertThat((Object)snapshot.get((AggregateField)AggregateField.sum((String)"metadata.pages"))).isEqualTo((Object)150);
        Truth.assertThat((Double)snapshot.get(AggregateField.average((String)"metadata.pages"))).isEqualTo((Object)75);
        Truth.assertThat((Long)snapshot.get(AggregateField.count())).isEqualTo((Object)2);
    }

    @Test
    public void performsSumThatResultsInFloat() throws Exception {
        Map<String, Map<String, Object>> testDocs = LocalFirestoreHelper.map("a", LocalFirestoreHelper.map("author", "authorA", "title", "titleA", "rating", 5), "b", LocalFirestoreHelper.map("author", "authorB", "title", "titleB", "rating", 4.5), "c", LocalFirestoreHelper.map("author", "authorC", "title", "titleC", "rating", 3));
        CollectionReference collection = this.testCollectionWithDocs(testDocs);
        AggregateQuerySnapshot snapshot = (AggregateQuerySnapshot)collection.aggregate((AggregateField)AggregateField.sum((String)"rating"), new AggregateField[0]).get().get();
        Object sum = snapshot.get((AggregateField)AggregateField.sum((String)"rating"));
        Truth.assertThat((Boolean)(sum instanceof Double)).isTrue();
        Truth.assertThat((Object)sum).isEqualTo((Object)12.5);
    }

    @Test
    public void performsSumOfIntsAndFloatsThatResultsInInt() throws Exception {
        Map<String, Map<String, Object>> testDocs = LocalFirestoreHelper.map("a", LocalFirestoreHelper.map("author", "authorA", "title", "titleA", "rating", 5), "b", LocalFirestoreHelper.map("author", "authorB", "title", "titleB", "rating", 4.5), "c", LocalFirestoreHelper.map("author", "authorC", "title", "titleC", "rating", 3.5));
        CollectionReference collection = this.testCollectionWithDocs(testDocs);
        AggregateQuerySnapshot snapshot = (AggregateQuerySnapshot)collection.aggregate((AggregateField)AggregateField.sum((String)"rating"), new AggregateField[0]).get().get();
        Object sum = snapshot.get((AggregateField)AggregateField.sum((String)"rating"));
        Truth.assertThat((Boolean)(sum instanceof Double)).isTrue();
        Truth.assertThat((Object)sum).isEqualTo((Object)13.0);
    }

    @Test
    public void performsSumThatOverflowsMaxLong() throws Exception {
        Map<String, Map<String, Object>> testDocs = LocalFirestoreHelper.map("a", LocalFirestoreHelper.map("author", "authorA", "title", "titleA", "rating", Long.MAX_VALUE), "b", LocalFirestoreHelper.map("author", "authorB", "title", "titleB", "rating", Long.MAX_VALUE));
        CollectionReference collection = this.testCollectionWithDocs(testDocs);
        AggregateQuerySnapshot snapshot = (AggregateQuerySnapshot)collection.aggregate((AggregateField)AggregateField.sum((String)"rating"), new AggregateField[0]).get().get();
        Object sum = snapshot.get((AggregateField)AggregateField.sum((String)"rating"));
        Truth.assertThat((Boolean)(sum instanceof Double)).isTrue();
        Truth.assertThat((Object)sum).isEqualTo((Object)1.8446744073709552E19);
    }

    @Test
    public void performsSumThatCanOverflowIntegerValuesDuringAccumulation() throws Exception {
        Map<String, Map<String, Object>> testDocs = LocalFirestoreHelper.map("a", LocalFirestoreHelper.map("author", "authorA", "title", "titleA", "rating", Long.MAX_VALUE), "b", LocalFirestoreHelper.map("author", "authorB", "title", "titleB", "rating", 1), "c", LocalFirestoreHelper.map("author", "authorC", "title", "titleC", "rating", -101));
        CollectionReference collection = this.testCollectionWithDocs(testDocs);
        AggregateQuerySnapshot snapshot = (AggregateQuerySnapshot)collection.aggregate((AggregateField)AggregateField.sum((String)"rating"), new AggregateField[0]).get().get();
        Object sum = snapshot.get((AggregateField)AggregateField.sum((String)"rating"));
        Truth.assertThat((Boolean)(sum instanceof Long)).isTrue();
        Truth.assertThat((Object)sum).isEqualTo((Object)9223372036854775707L);
    }

    @Test
    public void performsSumThatIsNegative() throws Exception {
        Map<String, Map<String, Object>> testDocs = LocalFirestoreHelper.map("a", LocalFirestoreHelper.map("author", "authorA", "title", "titleA", "rating", Long.MAX_VALUE), "b", LocalFirestoreHelper.map("author", "authorB", "title", "titleB", "rating", -9223372036854775807L), "c", LocalFirestoreHelper.map("author", "authorC", "title", "titleC", "rating", -101), "d", LocalFirestoreHelper.map("author", "authorD", "title", "titleD", "rating", -10000));
        CollectionReference collection = this.testCollectionWithDocs(testDocs);
        AggregateQuerySnapshot snapshot = (AggregateQuerySnapshot)collection.aggregate((AggregateField)AggregateField.sum((String)"rating"), new AggregateField[0]).get().get();
        Truth.assertThat((Object)snapshot.get((AggregateField)AggregateField.sum((String)"rating"))).isEqualTo((Object)-10101);
    }

    @Test
    public void performsSumThatIsPositiveInfinity() throws Exception {
        Map<String, Map<String, Object>> testDocs = LocalFirestoreHelper.map("a", LocalFirestoreHelper.map("author", "authorA", "title", "titleA", "rating", Double.MAX_VALUE), "b", LocalFirestoreHelper.map("author", "authorB", "title", "titleB", "rating", Double.MAX_VALUE));
        CollectionReference collection = this.testCollectionWithDocs(testDocs);
        AggregateQuerySnapshot snapshot = (AggregateQuerySnapshot)collection.aggregate((AggregateField)AggregateField.sum((String)"rating"), new AggregateField[0]).get().get();
        Object sum = snapshot.get((AggregateField)AggregateField.sum((String)"rating"));
        Truth.assertThat((Boolean)(sum instanceof Double)).isTrue();
        Truth.assertThat((Object)sum).isEqualTo((Object)Double.POSITIVE_INFINITY);
        Truth.assertThat((Double)snapshot.getDouble((AggregateField)AggregateField.sum((String)"rating"))).isEqualTo((Object)Double.POSITIVE_INFINITY);
        Truth.assertThat((Long)snapshot.getLong((AggregateField)AggregateField.sum((String)"rating"))).isEqualTo((Object)Long.MAX_VALUE);
    }

    @Test
    public void performsSumThatIsNegativeInfinity() throws Exception {
        Map<String, Map<String, Object>> testDocs = LocalFirestoreHelper.map("a", LocalFirestoreHelper.map("author", "authorA", "title", "titleA", "rating", -1.7976931348623157E308), "b", LocalFirestoreHelper.map("author", "authorB", "title", "titleB", "rating", -1.7976931348623157E308));
        CollectionReference collection = this.testCollectionWithDocs(testDocs);
        AggregateQuerySnapshot snapshot = (AggregateQuerySnapshot)collection.aggregate((AggregateField)AggregateField.sum((String)"rating"), new AggregateField[0]).get().get();
        Object sum = snapshot.get((AggregateField)AggregateField.sum((String)"rating"));
        Truth.assertThat((Boolean)(sum instanceof Double)).isTrue();
        Truth.assertThat((Object)sum).isEqualTo((Object)Double.NEGATIVE_INFINITY);
        Truth.assertThat((Double)snapshot.getDouble((AggregateField)AggregateField.sum((String)"rating"))).isEqualTo((Object)Double.NEGATIVE_INFINITY);
        Truth.assertThat((Long)snapshot.getLong((AggregateField)AggregateField.sum((String)"rating"))).isEqualTo((Object)Long.MIN_VALUE);
    }

    @Test
    public void performsSumThatIsValidButCouldOverflowDuringAggregation() throws Exception {
        Map<String, Map<String, Object>> testDocs = LocalFirestoreHelper.map("a", LocalFirestoreHelper.map("author", "authorA", "title", "titleA", "rating", Double.MAX_VALUE), "b", LocalFirestoreHelper.map("author", "authorB", "title", "titleB", "rating", Double.MAX_VALUE), "c", LocalFirestoreHelper.map("author", "authorC", "title", "titleC", "rating", -1.7976931348623157E308), "d", LocalFirestoreHelper.map("author", "authorD", "title", "titleD", "rating", -1.7976931348623157E308), "e", LocalFirestoreHelper.map("author", "authorE", "title", "titleE", "rating", Double.MAX_VALUE), "f", LocalFirestoreHelper.map("author", "authorF", "title", "titleF", "rating", -1.7976931348623157E308), "g", LocalFirestoreHelper.map("author", "authorG", "title", "titleG", "rating", -1.7976931348623157E308), "h", LocalFirestoreHelper.map("author", "authorH", "title", "titleH", "rating", Double.MAX_VALUE));
        CollectionReference collection = this.testCollectionWithDocs(testDocs);
        AggregateQuerySnapshot snapshot = (AggregateQuerySnapshot)collection.aggregate((AggregateField)AggregateField.sum((String)"rating"), new AggregateField[0]).get().get();
        Object sum = snapshot.get((AggregateField)AggregateField.sum((String)"rating"));
        Truth.assertThat((Boolean)(sum instanceof Double)).isTrue();
        Truth.assertThat((Object)sum).isAnyOf((Object)0, (Object)Double.NEGATIVE_INFINITY, new Object[]{Double.POSITIVE_INFINITY});
    }

    @Test
    public void performsSumThatIncludesNaN() throws Exception {
        Map<String, Map<String, Object>> testDocs = LocalFirestoreHelper.map("a", LocalFirestoreHelper.map("author", "authorA", "title", "titleA", "rating", 5), "b", LocalFirestoreHelper.map("author", "authorB", "title", "titleB", "rating", 4), "c", LocalFirestoreHelper.map("author", "authorC", "title", "titleC", "rating", Double.NaN), "d", LocalFirestoreHelper.map("author", "authorD", "title", "titleD", "rating", 0));
        CollectionReference collection = this.testCollectionWithDocs(testDocs);
        AggregateQuerySnapshot snapshot = (AggregateQuerySnapshot)collection.aggregate((AggregateField)AggregateField.sum((String)"rating"), new AggregateField[0]).get().get();
        Truth.assertThat((Object)snapshot.get((AggregateField)AggregateField.sum((String)"rating"))).isEqualTo((Object)Double.NaN);
    }

    @Test
    public void performsSumOverResultSetOfZeroDocuments() throws Exception {
        CollectionReference collection = this.testCollectionWithDocs(testDocs1);
        AggregateQuerySnapshot snapshot = (AggregateQuerySnapshot)collection.whereGreaterThan("pages", (Object)200).aggregate((AggregateField)AggregateField.sum((String)"pages"), new AggregateField[0]).get().get();
        Truth.assertThat((Object)snapshot.get((AggregateField)AggregateField.sum((String)"pages"))).isEqualTo((Object)0);
    }

    @Test
    public void performsSumOnlyOnNumericFields() throws Exception {
        Map<String, Map<String, Object>> testDocs = LocalFirestoreHelper.map("a", LocalFirestoreHelper.map("author", "authorA", "title", "titleA", "rating", 5), "b", LocalFirestoreHelper.map("author", "authorB", "title", "titleB", "rating", 4), "c", LocalFirestoreHelper.map("author", "authorC", "title", "titleC", "rating", "3"), "d", LocalFirestoreHelper.map("author", "authorD", "title", "titleD", "rating", 1));
        CollectionReference collection = this.testCollectionWithDocs(testDocs);
        AggregateQuerySnapshot snapshot = (AggregateQuerySnapshot)collection.aggregate((AggregateField)AggregateField.sum((String)"rating"), new AggregateField[]{AggregateField.count()}).get().get();
        Truth.assertThat((Object)snapshot.get((AggregateField)AggregateField.sum((String)"rating"))).isEqualTo((Object)10);
        Truth.assertThat((Long)snapshot.get(AggregateField.count())).isEqualTo((Object)4);
    }

    @Test
    public void performsSumOfMinIEEE754() throws Exception {
        Map<String, Map<String, Object>> testDocs = LocalFirestoreHelper.map("a", LocalFirestoreHelper.map("author", "authorA", "title", "titleA", "rating", Double.MIN_VALUE), new Object[0]);
        CollectionReference collection = this.testCollectionWithDocs(testDocs);
        AggregateQuerySnapshot snapshot = (AggregateQuerySnapshot)collection.aggregate((AggregateField)AggregateField.sum((String)"rating"), new AggregateField[0]).get().get();
        Truth.assertThat((Object)snapshot.get((AggregateField)AggregateField.sum((String)"rating"))).isEqualTo((Object)Double.MIN_VALUE);
    }

    @Test
    public void performsAverageOfIntsThatResultsInAnInt() throws Exception {
        Map<String, Map<String, Object>> testDocs = LocalFirestoreHelper.map("a", LocalFirestoreHelper.map("author", "authorA", "title", "titleA", "rating", 10), "b", LocalFirestoreHelper.map("author", "authorB", "title", "titleB", "rating", 5), "c", LocalFirestoreHelper.map("author", "authorC", "title", "titleC", "rating", 0));
        CollectionReference collection = this.testCollectionWithDocs(testDocs);
        AggregateQuerySnapshot snapshot = (AggregateQuerySnapshot)collection.aggregate((AggregateField)AggregateField.average((String)"rating"), new AggregateField[0]).get().get();
        Truth.assertThat((Double)snapshot.get(AggregateField.average((String)"rating"))).isEqualTo((Object)5);
        Truth.assertThat((Long)snapshot.getLong((AggregateField)AggregateField.average((String)"rating"))).isEqualTo((Object)5L);
        Truth.assertThat((Double)snapshot.getDouble((AggregateField)AggregateField.average((String)"rating"))).isEqualTo((Object)5.0);
    }

    @Test
    public void performsAverageOfFloatsThatResultsInAnInt() throws Exception {
        Map<String, Map<String, Object>> testDocs = LocalFirestoreHelper.map("a", LocalFirestoreHelper.map("author", "authorA", "title", "titleA", "rating", 10.5), "b", LocalFirestoreHelper.map("author", "authorB", "title", "titleB", "rating", 9.5));
        CollectionReference collection = this.testCollectionWithDocs(testDocs);
        AggregateQuerySnapshot snapshot = (AggregateQuerySnapshot)collection.aggregate((AggregateField)AggregateField.average((String)"rating"), new AggregateField[0]).get().get();
        Truth.assertThat((Boolean)(snapshot.get(AggregateField.average((String)"rating")) instanceof Double)).isTrue();
        Truth.assertThat((Double)snapshot.get(AggregateField.average((String)"rating"))).isEqualTo((Object)10);
        Truth.assertThat((Long)snapshot.getLong((AggregateField)AggregateField.average((String)"rating"))).isEqualTo((Object)10L);
        Truth.assertThat((Double)snapshot.getDouble((AggregateField)AggregateField.average((String)"rating"))).isEqualTo((Object)10.0);
    }

    @Test
    public void performsAverageOfFloatsAndIntsThatResultsInAnInt() throws Exception {
        Map<String, Map<String, Object>> testDocs = LocalFirestoreHelper.map("a", LocalFirestoreHelper.map("author", "authorA", "title", "titleA", "rating", 10), "b", LocalFirestoreHelper.map("author", "authorB", "title", "titleB", "rating", 9.5), "c", LocalFirestoreHelper.map("author", "authorC", "title", "titleC", "rating", 10.5));
        CollectionReference collection = this.testCollectionWithDocs(testDocs);
        AggregateQuerySnapshot snapshot = (AggregateQuerySnapshot)collection.aggregate((AggregateField)AggregateField.average((String)"rating"), new AggregateField[0]).get().get();
        Truth.assertThat((Double)snapshot.get(AggregateField.average((String)"rating"))).isEqualTo((Object)10);
        Truth.assertThat((Long)snapshot.getLong((AggregateField)AggregateField.average((String)"rating"))).isEqualTo((Object)10L);
        Truth.assertThat((Double)snapshot.getDouble((AggregateField)AggregateField.average((String)"rating"))).isEqualTo((Object)10.0);
    }

    @Test
    public void performsAverageOfFloatsThatResultsInAFloat() throws Exception {
        Map<String, Map<String, Object>> testDocs = LocalFirestoreHelper.map("a", LocalFirestoreHelper.map("author", "authorA", "title", "titleA", "rating", 5.5), "b", LocalFirestoreHelper.map("author", "authorB", "title", "titleB", "rating", 4.5), "c", LocalFirestoreHelper.map("author", "authorC", "title", "titleC", "rating", 3.5));
        CollectionReference collection = this.testCollectionWithDocs(testDocs);
        AggregateQuerySnapshot snapshot = (AggregateQuerySnapshot)collection.aggregate((AggregateField)AggregateField.average((String)"rating"), new AggregateField[0]).get().get();
        Truth.assertThat((Double)snapshot.get(AggregateField.average((String)"rating"))).isEqualTo((Object)4.5);
        Truth.assertThat((Double)snapshot.getDouble((AggregateField)AggregateField.average((String)"rating"))).isEqualTo((Object)4.5);
        Truth.assertThat((Long)snapshot.getLong((AggregateField)AggregateField.average((String)"rating"))).isEqualTo((Object)4L);
    }

    @Test
    public void performsAverageOfFloatsAndIntsThatResultsInAFloat() throws Exception {
        Map<String, Map<String, Object>> testDocs = LocalFirestoreHelper.map("a", LocalFirestoreHelper.map("author", "authorA", "title", "titleA", "rating", 8.6), "b", LocalFirestoreHelper.map("author", "authorB", "title", "titleB", "rating", 9), "c", LocalFirestoreHelper.map("author", "authorC", "title", "titleC", "rating", 10));
        CollectionReference collection = this.testCollectionWithDocs(testDocs);
        AggregateQuerySnapshot snapshot = (AggregateQuerySnapshot)collection.aggregate((AggregateField)AggregateField.average((String)"rating"), new AggregateField[0]).get().get();
        Truth.assertThat((Double)snapshot.get(AggregateField.average((String)"rating"))).isEqualTo((Object)9.200000000000001);
        Truth.assertThat((Double)snapshot.getDouble((AggregateField)AggregateField.average((String)"rating"))).isEqualTo((Object)9.200000000000001);
        Truth.assertThat((Long)snapshot.getLong((AggregateField)AggregateField.average((String)"rating"))).isEqualTo((Object)9L);
    }

    @Test
    public void performsAverageOfIntsThatResultsInAFloat() throws Exception {
        Map<String, Map<String, Object>> testDocs = LocalFirestoreHelper.map("a", LocalFirestoreHelper.map("author", "authorA", "title", "titleA", "rating", 10), "b", LocalFirestoreHelper.map("author", "authorB", "title", "titleB", "rating", 9));
        CollectionReference collection = this.testCollectionWithDocs(testDocs);
        AggregateQuerySnapshot snapshot = (AggregateQuerySnapshot)collection.aggregate((AggregateField)AggregateField.average((String)"rating"), new AggregateField[0]).get().get();
        Truth.assertThat((Double)snapshot.get(AggregateField.average((String)"rating"))).isEqualTo((Object)9.5);
        Truth.assertThat((Double)snapshot.getDouble((AggregateField)AggregateField.average((String)"rating"))).isEqualTo((Object)9.5);
        Truth.assertThat((Long)snapshot.getLong((AggregateField)AggregateField.average((String)"rating"))).isEqualTo((Object)9L);
    }

    @Test
    public void performsAverageCausingUnderflow() throws Exception {
        Map<String, Map<String, Object>> testDocs = LocalFirestoreHelper.map("a", LocalFirestoreHelper.map("author", "authorA", "title", "titleA", "rating", Double.MIN_VALUE), "b", LocalFirestoreHelper.map("author", "authorB", "title", "titleB", "rating", 0));
        CollectionReference collection = this.testCollectionWithDocs(testDocs);
        AggregateQuerySnapshot snapshot = (AggregateQuerySnapshot)collection.aggregate((AggregateField)AggregateField.average((String)"rating"), new AggregateField[0]).get().get();
        Truth.assertThat((Double)snapshot.get(AggregateField.average((String)"rating"))).isEqualTo((Object)0);
        Truth.assertThat((Double)snapshot.getDouble((AggregateField)AggregateField.average((String)"rating"))).isEqualTo((Object)0.0);
        Truth.assertThat((Long)snapshot.getLong((AggregateField)AggregateField.average((String)"rating"))).isEqualTo((Object)0L);
    }

    @Test
    public void performsAverageOfMinIEEE754() throws Exception {
        Map<String, Map<String, Object>> testDocs = LocalFirestoreHelper.map("a", LocalFirestoreHelper.map("author", "authorA", "title", "titleA", "rating", Double.MIN_VALUE), new Object[0]);
        CollectionReference collection = this.testCollectionWithDocs(testDocs);
        AggregateQuerySnapshot snapshot = (AggregateQuerySnapshot)collection.aggregate((AggregateField)AggregateField.average((String)"rating"), new AggregateField[0]).get().get();
        Truth.assertThat((Double)snapshot.get(AggregateField.average((String)"rating"))).isEqualTo((Object)Double.MIN_VALUE);
        Truth.assertThat((Double)snapshot.getDouble((AggregateField)AggregateField.average((String)"rating"))).isEqualTo((Object)Double.MIN_VALUE);
        Truth.assertThat((Long)snapshot.getLong((AggregateField)AggregateField.average((String)"rating"))).isEqualTo((Object)0);
    }

    @Test
    public void performsAverageThatCouldOverflowIEEE754DuringAccumulation() throws Exception {
        Map<String, Map<String, Object>> testDocs = LocalFirestoreHelper.map("a", LocalFirestoreHelper.map("author", "authorA", "title", "titleA", "rating", Double.MAX_VALUE), "b", LocalFirestoreHelper.map("author", "authorB", "title", "titleB", "rating", Double.MAX_VALUE));
        CollectionReference collection = this.testCollectionWithDocs(testDocs);
        AggregateQuerySnapshot snapshot = (AggregateQuerySnapshot)collection.aggregate((AggregateField)AggregateField.average((String)"rating"), new AggregateField[0]).get().get();
        Truth.assertThat((Double)snapshot.get(AggregateField.average((String)"rating"))).isEqualTo((Object)Double.POSITIVE_INFINITY);
        Truth.assertThat((Double)snapshot.getDouble((AggregateField)AggregateField.average((String)"rating"))).isEqualTo((Object)Double.POSITIVE_INFINITY);
        Truth.assertThat((Long)snapshot.getLong((AggregateField)AggregateField.average((String)"rating"))).isEqualTo((Object)Long.MAX_VALUE);
    }

    @Test
    public void performsAverageThatIncludesNaN() throws Exception {
        Map<String, Map<String, Object>> testDocs = LocalFirestoreHelper.map("a", LocalFirestoreHelper.map("author", "authorA", "title", "titleA", "rating", 5), "b", LocalFirestoreHelper.map("author", "authorB", "title", "titleB", "rating", 4), "c", LocalFirestoreHelper.map("author", "authorC", "title", "titleC", "rating", Double.NaN), "d", LocalFirestoreHelper.map("author", "authorD", "title", "titleD", "rating", 0));
        CollectionReference collection = this.testCollectionWithDocs(testDocs);
        AggregateQuerySnapshot snapshot = (AggregateQuerySnapshot)collection.aggregate((AggregateField)AggregateField.average((String)"rating"), new AggregateField[0]).get().get();
        Truth.assertThat((Double)snapshot.get(AggregateField.average((String)"rating"))).isEqualTo((Object)Double.NaN);
        Truth.assertThat((Double)snapshot.getDouble((AggregateField)AggregateField.average((String)"rating"))).isEqualTo((Object)Double.NaN);
        Truth.assertThat((Long)snapshot.getLong((AggregateField)AggregateField.average((String)"rating"))).isEqualTo((Object)0L);
    }

    @Test
    public void performsAverageOverResultSetOfZeroDocuments() throws Exception {
        CollectionReference collection = this.testCollectionWithDocs(testDocs1);
        AggregateQuerySnapshot snapshot = (AggregateQuerySnapshot)collection.whereGreaterThan("pages", (Object)200).aggregate((AggregateField)AggregateField.average((String)"pages"), new AggregateField[0]).get().get();
        Truth.assertThat((Double)snapshot.get(AggregateField.average((String)"pages"))).isEqualTo(null);
        Truth.assertThat((Double)snapshot.getDouble((AggregateField)AggregateField.average((String)"pages"))).isEqualTo(null);
        Truth.assertThat((Long)snapshot.getLong((AggregateField)AggregateField.average((String)"pages"))).isEqualTo(null);
    }

    @Test
    public void performsAverageOnlyOnNumericFields() throws Exception {
        Map<String, Map<String, Object>> testDocs = LocalFirestoreHelper.map("a", LocalFirestoreHelper.map("author", "authorA", "title", "titleA", "rating", 5), "b", LocalFirestoreHelper.map("author", "authorB", "title", "titleB", "rating", 4), "c", LocalFirestoreHelper.map("author", "authorC", "title", "titleC", "rating", "3"), "d", LocalFirestoreHelper.map("author", "authorD", "title", "titleD", "rating", 6));
        CollectionReference collection = this.testCollectionWithDocs(testDocs);
        AggregateQuerySnapshot snapshot = (AggregateQuerySnapshot)collection.aggregate((AggregateField)AggregateField.average((String)"rating"), new AggregateField[]{AggregateField.count()}).get().get();
        Truth.assertThat((Double)snapshot.get(AggregateField.average((String)"rating"))).isEqualTo((Object)5);
        Truth.assertThat((Long)snapshot.get(AggregateField.count())).isEqualTo((Object)4);
    }

    @Ignore
    @Test
    public void aggregatesWithDocumentReferenceCursors() throws Exception {
        Map<String, Map<String, Object>> testDocs = LocalFirestoreHelper.map("a", LocalFirestoreHelper.map("num", 1, new Object[0]), "b", LocalFirestoreHelper.map("num", 2, new Object[0]), "c", LocalFirestoreHelper.map("num", 3, new Object[0]), "d", LocalFirestoreHelper.map("num", 4, new Object[0]), "e", LocalFirestoreHelper.map("num", 5, new Object[0]));
        CollectionReference collection = this.testCollectionWithDocs(testDocs);
        AggregateQuerySnapshot snapshot = (AggregateQuerySnapshot)collection.orderBy(FieldPath.documentId()).startAfter(new Object[]{collection.document("c")}).aggregate((AggregateField)AggregateField.sum((String)"num"), new AggregateField[0]).get().get();
        Truth.assertThat((Object)snapshot.get((AggregateField)AggregateField.sum((String)"num"))).isEqualTo((Object)9);
        snapshot = (AggregateQuerySnapshot)collection.orderBy(FieldPath.documentId()).startAt(new Object[]{collection.document("c")}).aggregate((AggregateField)AggregateField.sum((String)"num"), new AggregateField[0]).get().get();
        Truth.assertThat((Object)snapshot.get((AggregateField)AggregateField.sum((String)"num"))).isEqualTo((Object)12);
        snapshot = (AggregateQuerySnapshot)collection.orderBy(FieldPath.documentId()).endBefore(new Object[]{collection.document("c")}).aggregate((AggregateField)AggregateField.sum((String)"num"), new AggregateField[0]).get().get();
        Truth.assertThat((Object)snapshot.get((AggregateField)AggregateField.sum((String)"num"))).isEqualTo((Object)3);
        snapshot = (AggregateQuerySnapshot)collection.orderBy(FieldPath.documentId()).endAt(new Object[]{collection.document("c")}).aggregate((AggregateField)AggregateField.sum((String)"num"), new AggregateField[0]).get().get();
        Truth.assertThat((Object)snapshot.get((AggregateField)AggregateField.sum((String)"num"))).isEqualTo((Object)6);
    }

    CollectionReference addTwoDocsForCursorTesting() throws InterruptedException {
        Map<String, Map<String, Object>> testDocs = LocalFirestoreHelper.map("a", LocalFirestoreHelper.map("num", 5, "foo", 1), "b", LocalFirestoreHelper.map("num", 7, "foo", 2));
        return this.testCollectionWithDocs(testDocs);
    }

    @Test
    public void aggregateWithNoFilterNoOrderByNoCursor() throws Exception {
        CollectionReference collection = this.addTwoDocsForCursorTesting();
        AggregateQuery query = collection.aggregate((AggregateField)AggregateField.sum((String)"num"), new AggregateField[0]);
        AggregateQuerySnapshot snapshot = (AggregateQuerySnapshot)query.get().get();
        Truth.assertThat((Object)snapshot.get((AggregateField)AggregateField.sum((String)"num"))).isEqualTo((Object)12);
    }

    @Test
    public void aggregateWithEqualityFilterNoOrderByNoCursor() throws Exception {
        CollectionReference collection = this.addTwoDocsForCursorTesting();
        AggregateQuery query = collection.whereEqualTo("num", (Object)5).aggregate((AggregateField)AggregateField.sum((String)"num"), new AggregateField[0]);
        AggregateQuerySnapshot snapshot = (AggregateQuerySnapshot)query.get().get();
        Truth.assertThat((Object)snapshot.get((AggregateField)AggregateField.sum((String)"num"))).isEqualTo((Object)5);
    }

    @Test
    public void aggregateWithInequalityFilterNoOrderByNoCursor() throws Exception {
        CollectionReference collection = this.addTwoDocsForCursorTesting();
        AggregateQuery query = collection.whereGreaterThan("num", (Object)5).aggregate((AggregateField)AggregateField.sum((String)"num"), new AggregateField[0]);
        AggregateQuerySnapshot snapshot = (AggregateQuerySnapshot)query.get().get();
        Truth.assertThat((Object)snapshot.get((AggregateField)AggregateField.sum((String)"num"))).isEqualTo((Object)7);
    }

    @Test
    public void aggregateWithNoFilterExplicitOrderByNoCursor() throws Exception {
        CollectionReference collection = this.addTwoDocsForCursorTesting();
        AggregateQuery query = collection.orderBy("num").aggregate((AggregateField)AggregateField.sum((String)"num"), new AggregateField[0]);
        AggregateQuerySnapshot snapshot = (AggregateQuerySnapshot)query.get().get();
        Truth.assertThat((Object)snapshot.get((AggregateField)AggregateField.sum((String)"num"))).isEqualTo((Object)12);
    }

    @Test
    public void aggregateWithEqualityFilterExplicitOrderByNoCursor() throws Exception {
        CollectionReference collection = this.addTwoDocsForCursorTesting();
        AggregateQuery query = collection.whereEqualTo("num", (Object)5).orderBy("num").aggregate((AggregateField)AggregateField.sum((String)"num"), new AggregateField[0]);
        AggregateQuerySnapshot snapshot = (AggregateQuerySnapshot)query.get().get();
        Truth.assertThat((Object)snapshot.get((AggregateField)AggregateField.sum((String)"num"))).isEqualTo((Object)5);
    }

    @Test
    public void aggregateWithInequalityFilterExplicitOrderByNoCursor() throws Exception {
        CollectionReference collection = this.addTwoDocsForCursorTesting();
        AggregateQuery query = collection.whereGreaterThan("num", (Object)5).orderBy("num").aggregate((AggregateField)AggregateField.sum((String)"num"), new AggregateField[0]);
        AggregateQuerySnapshot snapshot = (AggregateQuerySnapshot)query.get().get();
        Truth.assertThat((Object)snapshot.get((AggregateField)AggregateField.sum((String)"num"))).isEqualTo((Object)7);
    }

    @Test
    public void aggregateNoFilterExplicitOrderByFieldValueCursor() throws Exception {
        CollectionReference collection = this.addTwoDocsForCursorTesting();
        AggregateQuery query = collection.orderBy("num").startAfter(new Object[]{5}).aggregate((AggregateField)AggregateField.sum((String)"num"), new AggregateField[0]);
        AggregateQuerySnapshot snapshot = (AggregateQuerySnapshot)query.get().get();
        Truth.assertThat((Object)snapshot.get((AggregateField)AggregateField.sum((String)"num"))).isEqualTo((Object)7);
    }

    @Ignore
    @Test
    public void aggregateNoFilterExplicitOrderByDocumentReferenceCursor() throws Exception {
        CollectionReference collection = this.addTwoDocsForCursorTesting();
        AggregateQuery query = collection.orderBy(FieldPath.documentId()).startAfter(new Object[]{collection.document("a")}).aggregate((AggregateField)AggregateField.sum((String)"num"), new AggregateField[0]);
        AggregateQuerySnapshot snapshot = (AggregateQuerySnapshot)query.get().get();
        Truth.assertThat((Object)snapshot.get((AggregateField)AggregateField.sum((String)"num"))).isEqualTo((Object)7);
    }

    @Ignore
    @Test
    public void aggregateNoFilterNoOrderByDocumentReferenceCursor() throws Exception {
        CollectionReference collection = this.addTwoDocsForCursorTesting();
        AggregateQuery query = collection.startAfter(new Object[]{collection.document("a")}).aggregate((AggregateField)AggregateField.sum((String)"num"), new AggregateField[0]);
        AggregateQuerySnapshot snapshot = (AggregateQuerySnapshot)query.get().get();
        Truth.assertThat((Object)snapshot.get((AggregateField)AggregateField.sum((String)"num"))).isEqualTo((Object)7);
    }

    @Ignore
    @Test
    public void aggregateNoFilterExplicitOrderByDocumentSnapshotCursor() throws Exception {
        CollectionReference collection = this.addTwoDocsForCursorTesting();
        DocumentSnapshot docSnapshot = (DocumentSnapshot)collection.document("a").get().get();
        AggregateQuery query = collection.orderBy("foo").startAfter(docSnapshot).aggregate((AggregateField)AggregateField.sum((String)"num"), new AggregateField[0]);
        AggregateQuerySnapshot snapshot = (AggregateQuerySnapshot)query.get().get();
        Truth.assertThat((Object)snapshot.get((AggregateField)AggregateField.sum((String)"num"))).isEqualTo((Object)7);
    }

    @Test
    public void aggregateNoFilterExplicitOrderByDocumentSnapshotCursor2() throws Exception {
        CollectionReference collection = this.addTwoDocsForCursorTesting();
        DocumentSnapshot docSnapshot = (DocumentSnapshot)collection.document("a").get().get();
        AggregateQuery query = collection.orderBy("num").startAfter(docSnapshot).aggregate((AggregateField)AggregateField.sum((String)"num"), new AggregateField[0]);
        AggregateQuerySnapshot snapshot = (AggregateQuerySnapshot)query.get().get();
        Truth.assertThat((Object)snapshot.get((AggregateField)AggregateField.sum((String)"num"))).isEqualTo((Object)7);
    }

    @Test
    public void aggregateEqualityFilterExplicitOrderByFieldValueCursor() throws Exception {
        CollectionReference collection = this.addTwoDocsForCursorTesting();
        AggregateQuery query = collection.whereEqualTo("num", (Object)5).orderBy("num").startAt(new Object[]{5}).aggregate((AggregateField)AggregateField.sum((String)"num"), new AggregateField[0]);
        AggregateQuerySnapshot snapshot = (AggregateQuerySnapshot)query.get().get();
        Truth.assertThat((Object)snapshot.get((AggregateField)AggregateField.sum((String)"num"))).isEqualTo((Object)5);
    }

    @Test
    public void aggregateInequalityFilterExplicitOrderByFieldValueCursor() throws Exception {
        CollectionReference collection = this.addTwoDocsForCursorTesting();
        AggregateQuery query = collection.whereGreaterThan("num", (Object)5).orderBy("num").startAt(new Object[]{6}).aggregate((AggregateField)AggregateField.sum((String)"num"), new AggregateField[0]);
        AggregateQuerySnapshot snapshot = (AggregateQuerySnapshot)query.get().get();
        Truth.assertThat((Object)snapshot.get((AggregateField)AggregateField.sum((String)"num"))).isEqualTo((Object)7);
    }

    @Ignore
    @Test
    public void aggregateEqualityFilterExplicitOrderByDocumentReferenceCursor() throws Exception {
        CollectionReference collection = this.addTwoDocsForCursorTesting();
        AggregateQuery query = collection.whereEqualTo("num", (Object)7).orderBy(FieldPath.documentId()).startAfter(new Object[]{collection.document("a")}).aggregate((AggregateField)AggregateField.sum((String)"num"), new AggregateField[0]);
        AggregateQuerySnapshot snapshot = (AggregateQuerySnapshot)query.get().get();
        Truth.assertThat((Object)snapshot.get((AggregateField)AggregateField.sum((String)"num"))).isEqualTo((Object)7);
    }

    @Test
    public void aggregateInequalityFilterExplicitOrderByDocumentReferenceCursor() throws Exception {
        CollectionReference collection = this.addTwoDocsForCursorTesting();
        AggregateQuery query = collection.whereGreaterThan("num", (Object)0).orderBy("num").orderBy(FieldPath.documentId()).startAfter(new Object[]{5, collection.document("a")}).aggregate((AggregateField)AggregateField.sum((String)"num"), new AggregateField[0]);
        AggregateQuerySnapshot snapshot = (AggregateQuerySnapshot)query.get().get();
        Truth.assertThat((Object)snapshot.get((AggregateField)AggregateField.sum((String)"num"))).isEqualTo((Object)7);
    }

    @Ignore
    @Test
    public void aggregateEqualityFilterNoOrderByDocumentSnapshotReference() throws Exception {
        CollectionReference collection = this.addTwoDocsForCursorTesting();
        DocumentSnapshot docSnapshot = (DocumentSnapshot)collection.document("a").get().get();
        AggregateQuery query = collection.whereEqualTo("num", (Object)7).startAfter(docSnapshot).aggregate((AggregateField)AggregateField.sum((String)"num"), new AggregateField[0]);
        AggregateQuerySnapshot snapshot = (AggregateQuerySnapshot)query.get().get();
        Truth.assertThat((Object)snapshot.get((AggregateField)AggregateField.sum((String)"num"))).isEqualTo((Object)7);
    }

    @Test
    public void aggregateInequalityFilterNoOrderByDocumentSnapshotReference() throws Exception {
        CollectionReference collection = this.addTwoDocsForCursorTesting();
        DocumentSnapshot docSnapshot = (DocumentSnapshot)collection.document("a").get().get();
        AggregateQuery query = collection.whereGreaterThan("num", (Object)0).startAfter(docSnapshot).aggregate((AggregateField)AggregateField.sum((String)"num"), new AggregateField[0]);
        AggregateQuerySnapshot snapshot = (AggregateQuerySnapshot)query.get().get();
        Truth.assertThat((Object)snapshot.get((AggregateField)AggregateField.sum((String)"num"))).isEqualTo((Object)7);
    }

    @Ignore
    @Test
    public void aggregateInequalityFilterNoOrderByDocumentSnapshotReference2() throws Exception {
        CollectionReference collection = this.addTwoDocsForCursorTesting();
        DocumentSnapshot docSnapshot = (DocumentSnapshot)collection.document("a").get().get();
        AggregateQuery query = collection.whereGreaterThan("foo", (Object)0).startAfter(docSnapshot).aggregate((AggregateField)AggregateField.sum((String)"num"), new AggregateField[0]);
        AggregateQuerySnapshot snapshot = (AggregateQuerySnapshot)query.get().get();
        Truth.assertThat((Object)snapshot.get((AggregateField)AggregateField.sum((String)"num"))).isEqualTo((Object)7);
    }

    @Test
    public void aggregateQueryShouldFailWithMessageWithConsoleLinkIfMissingIndex() {
        Assume.assumeFalse((String)"Skip this test when running against the Firestore emulator because the Firestore emulator does not use indexes and never fails with a 'missing index' error", (boolean)TestHelper.isRunningAgainstFirestoreEmulator(this.firestore));
        CollectionReference collection = this.testCollection();
        Query compositeIndexQuery = collection.whereEqualTo("field1", (Object)42).whereLessThan("field2", (Object)99);
        AggregateQuery compositeIndexAggregateQuery = compositeIndexQuery.aggregate((AggregateField)AggregateField.count(), new AggregateField[]{AggregateField.sum((String)"pages"), AggregateField.average((String)"pages")});
        ApiFuture future = compositeIndexAggregateQuery.get();
        ExecutionException executionException = (ExecutionException)Assert.assertThrows(ExecutionException.class, () -> future.get());
        Throwable throwable = executionException.getCause();
        Truth.assertThat((Throwable)throwable).hasMessageThat().ignoringCase().contains((CharSequence)"index");
        if (((FirestoreOptions)collection.getFirestore().getOptions()).getDatabaseId().equals("(default)")) {
            Truth.assertThat((Throwable)throwable).hasMessageThat().contains((CharSequence)"https://console.firebase.google.com");
        }
    }
}

