/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore.it;

import com.google.api.core.ApiFuture;
import com.google.auto.value.AutoValue;
import com.google.cloud.Timestamp;
import com.google.cloud.firestore.AggregateField;
import com.google.cloud.firestore.AggregateQuery;
import com.google.cloud.firestore.AggregateQuerySnapshot;
import com.google.cloud.firestore.CollectionGroup;
import com.google.cloud.firestore.CollectionReference;
import com.google.cloud.firestore.DocumentReference;
import com.google.cloud.firestore.DocumentSnapshot;
import com.google.cloud.firestore.FieldPath;
import com.google.cloud.firestore.FirestoreOptions;
import com.google.cloud.firestore.LocalFirestoreHelper;
import com.google.cloud.firestore.Query;
import com.google.cloud.firestore.QueryDocumentSnapshot;
import com.google.cloud.firestore.QuerySnapshot;
import com.google.cloud.firestore.TransactionOptions;
import com.google.cloud.firestore.WriteBatch;
import com.google.cloud.firestore.it.AutoValue_ITQueryCountTest_CreatedCollectionInfo;
import com.google.cloud.firestore.it.ITBaseTest;
import com.google.cloud.firestore.it.TestHelper;
import com.google.common.truth.Truth;
import com.google.protobuf.TimestampOrBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ITQueryCountTest
extends ITBaseTest {
    @Rule
    public TestName testName = new TestName();

    @Test
    public void countShouldReturnZeroForEmptyCollection() throws Exception {
        CollectionReference collection = this.createEmptyCollection();
        AggregateQuerySnapshot snapshot = (AggregateQuerySnapshot)collection.count().get().get();
        Truth.assertThat((Long)snapshot.getCount()).isEqualTo((Object)0);
    }

    @Test
    public void countShouldReturnNumDocumentsInNonEmptyCollection() throws Exception {
        CollectionReference collection = this.createCollectionWithDocuments(5).collection();
        AggregateQuerySnapshot snapshot = (AggregateQuerySnapshot)collection.count().get().get();
        Truth.assertThat((Long)snapshot.getCount()).isEqualTo((Object)5);
    }

    @Test
    public void countShouldReturnNumMatchingDocuments() throws Exception {
        CollectionReference collection = this.createEmptyCollection();
        this.createDocumentsWithKeyValuePair(collection, 3, "key", 42);
        this.createDocumentsWithKeyValuePair(collection, 5, "key", 24);
        AggregateQuerySnapshot snapshot = (AggregateQuerySnapshot)collection.whereEqualTo("key", (Object)42).count().get().get();
        Truth.assertThat((Long)snapshot.getCount()).isEqualTo((Object)3);
    }

    @Test
    public void countShouldRespectLimit() throws Exception {
        CollectionReference collection = this.createCollectionWithDocuments(5).collection();
        AggregateQuerySnapshot snapshot = (AggregateQuerySnapshot)collection.limit(2).count().get().get();
        Truth.assertThat((Long)snapshot.getCount()).isEqualTo((Object)2);
    }

    @Test
    public void countShouldRespectOffset() throws Exception {
        CollectionReference collection = this.createCollectionWithDocuments(5).collection();
        AggregateQuerySnapshot snapshot = (AggregateQuerySnapshot)collection.offset(2).count().get().get();
        Truth.assertThat((Long)snapshot.getCount()).isEqualTo((Object)3);
    }

    @Test
    public void countShouldRespectOrderBy() throws Exception {
        CollectionReference collection = this.createEmptyCollection();
        this.createDocumentsWithKeyValuePair(collection, 3, "key1", 42);
        this.createDocumentsWithKeyValuePair(collection, 5, "key2", 24);
        this.createDocumentsWithKeyValuePair(collection, 4, "key1", 99);
        AggregateQuerySnapshot snapshot = (AggregateQuerySnapshot)collection.orderBy("key1").count().get().get();
        Truth.assertThat((Long)snapshot.getCount()).isEqualTo((Object)7);
    }

    @Test
    public void countShouldRespectStartAtAndEndAtWithDocumentSnapshotCursor() throws Exception {
        CollectionReference collection = this.createCollectionWithDocuments(10).collection();
        List documentSnapshots = ((QuerySnapshot)collection.get().get()).getDocuments();
        AggregateQuerySnapshot snapshot = (AggregateQuerySnapshot)collection.startAt((DocumentSnapshot)documentSnapshots.get(2)).endAt((DocumentSnapshot)documentSnapshots.get(7)).count().get().get();
        Truth.assertThat((Long)snapshot.getCount()).isEqualTo((Object)6);
    }

    @Test
    public void countShouldRespectStartAtAndEndAtWithDocumentReferenceCursor() throws Exception {
        CollectionReference collection = this.createCollectionWithDocuments(10).collection();
        List documentSnapshots = ((QuerySnapshot)collection.get().get()).getDocuments();
        AggregateQuerySnapshot snapshot = (AggregateQuerySnapshot)collection.orderBy(FieldPath.documentId()).startAt(new Object[]{((QueryDocumentSnapshot)documentSnapshots.get(2)).getReference()}).endAt(new Object[]{((QueryDocumentSnapshot)documentSnapshots.get(7)).getReference()}).count().get().get();
        Truth.assertThat((Long)snapshot.getCount()).isEqualTo((Object)6);
    }

    @Test
    public void countShouldRespectStartAfterAndEndBeforeWithDocumentSnapshotCursor() throws Exception {
        CollectionReference collection = this.createCollectionWithDocuments(10).collection();
        List documentSnapshots = ((QuerySnapshot)collection.get().get()).getDocuments();
        AggregateQuerySnapshot snapshot = (AggregateQuerySnapshot)collection.startAfter((DocumentSnapshot)documentSnapshots.get(2)).endBefore((DocumentSnapshot)documentSnapshots.get(7)).count().get().get();
        Truth.assertThat((Long)snapshot.getCount()).isEqualTo((Object)4);
    }

    @Test
    public void countShouldRespectStartAfterAndEndBeforeWithDocumentReferenceCursor() throws Exception {
        CollectionReference collection = this.createCollectionWithDocuments(10).collection();
        List documentSnapshots = ((QuerySnapshot)collection.get().get()).getDocuments();
        AggregateQuerySnapshot snapshot = (AggregateQuerySnapshot)collection.orderBy(FieldPath.documentId()).startAfter(new Object[]{((QueryDocumentSnapshot)documentSnapshots.get(2)).getReference()}).endBefore(new Object[]{((QueryDocumentSnapshot)documentSnapshots.get(7)).getReference()}).count().get().get();
        Truth.assertThat((Long)snapshot.getCount()).isEqualTo((Object)4);
    }

    @Test
    public void countQueriesShouldFailIfCollectionNameIsInvalid() {
        CollectionReference collection = this.createEmptyCollection().document().collection("__invalid__");
        ApiFuture future = collection.count().get();
        ExecutionException executionException = (ExecutionException)Assert.assertThrows(ExecutionException.class, () -> future.get());
        Truth.assertThat((Throwable)executionException).hasCauseThat().hasMessageThat().contains((CharSequence)"__invalid__");
        Truth.assertThat((Throwable)executionException).hasCauseThat().hasMessageThat().contains((CharSequence)"INVALID_ARGUMENT");
    }

    @Test
    public void countShouldReturnNumberOfDocumentsForCollectionGroups() throws Exception {
        CollectionGroup collectionGroup = this.createCollectionGroupWithDocuments(13);
        AggregateQuerySnapshot snapshot = (AggregateQuerySnapshot)collectionGroup.count().get().get();
        Truth.assertThat((Long)snapshot.getCount()).isEqualTo((Object)13);
    }

    @Test
    public void aggregateQuerySupportsCollectionGroups() throws Exception {
        CollectionGroup collectionGroup = this.createCollectionGroupWithDocuments(13);
        AggregateQuerySnapshot snapshot = (AggregateQuerySnapshot)collectionGroup.aggregate((AggregateField)AggregateField.count(), new AggregateField[0]).get().get();
        Truth.assertThat((Long)snapshot.getCount()).isEqualTo((Object)13);
    }

    @Test
    public void countShouldReturnNumberOfDocumentsForPartitionQuery() throws Exception {
        CollectionReference collection = this.createCollectionWithDocuments(3).collection();
        Query query = collection.select(new String[]{"abc"});
        AggregateQuerySnapshot snapshot = (AggregateQuerySnapshot)query.count().get().get();
        Truth.assertThat((Long)snapshot.getCount()).isEqualTo((Object)3);
    }

    @Test
    public void inFlightCountQueriesShouldCompleteSuccessfullyWhenFirestoreIsClosed() throws Exception {
        CollectionReference collection = this.createCollectionWithDocuments(20).collection();
        ApiFuture task = collection.count().get();
        collection.getFirestore().close();
        Truth.assertThat((Long)((AggregateQuerySnapshot)task.get()).getCount()).isEqualTo((Object)20);
    }

    @Test
    public void inFlightAggregateQueriesShouldCompleteSuccessfullyWhenFirestoreIsClosed() throws Exception {
        CollectionReference collection = this.createCollectionWithDocuments(20).collection();
        ApiFuture task = collection.aggregate((AggregateField)AggregateField.count(), new AggregateField[0]).get();
        collection.getFirestore().close();
        Truth.assertThat((Long)((AggregateQuerySnapshot)task.get()).getCount()).isEqualTo((Object)20);
    }

    @Test
    public void inFlightCountQueriesShouldCompleteSuccessfullyWhenFirestoreIsShutDownGracefully() throws Exception {
        CollectionReference collection = this.createCollectionWithDocuments(20).collection();
        ApiFuture task = collection.count().get();
        collection.getFirestore().shutdown();
        Truth.assertThat((Long)((AggregateQuerySnapshot)task.get()).getCount()).isEqualTo((Object)20);
    }

    @Test
    public void inFlightAggregationQueriesShouldCompleteSuccessfullyWhenFirestoreIsShutDownGracefully() throws Exception {
        CollectionReference collection = this.createCollectionWithDocuments(20).collection();
        ApiFuture task = collection.aggregate((AggregateField)AggregateField.count(), new AggregateField[0]).get();
        collection.getFirestore().shutdown();
        Truth.assertThat((Long)((AggregateQuerySnapshot)task.get()).getCount()).isEqualTo((Object)20);
    }

    @Test
    public void inFlightAggregateQueriesShouldRunToCompletionWhenFirestoreIsShutDownForcefully() throws Exception {
        CollectionReference collection = this.createCollectionWithDocuments(20).collection();
        ApiFuture task = collection.aggregate((AggregateField)AggregateField.count(), new AggregateField[0]).get();
        collection.getFirestore().shutdownNow();
        TestHelper.await(task);
    }

    @Test
    public void countQueriesShouldFailIfStartedOnAClosedFirestoreInstance() throws Exception {
        CollectionReference collection = this.createEmptyCollection();
        AggregateQuery aggregateQuery = collection.count();
        collection.getFirestore().close();
        Assert.assertThrows(IllegalStateException.class, () -> ((AggregateQuery)aggregateQuery).get());
    }

    @Test
    public void aggregateQueriesShouldFailIfStartedOnAClosedFirestoreInstance() throws Exception {
        CollectionReference collection = this.createEmptyCollection();
        AggregateQuery aggregateQuery = collection.aggregate((AggregateField)AggregateField.count(), new AggregateField[0]);
        collection.getFirestore().close();
        Assert.assertThrows(IllegalStateException.class, () -> ((AggregateQuery)aggregateQuery).get());
    }

    @Test
    public void countQueriesShouldFailIfStartedOnAShutDownFirestoreInstance() throws Exception {
        CollectionReference collection = this.createEmptyCollection();
        AggregateQuery aggregateQuery = collection.count();
        collection.getFirestore().shutdown();
        Assert.assertThrows(IllegalStateException.class, () -> ((AggregateQuery)aggregateQuery).get());
    }

    @Test
    public void aggregateSnapshotShouldHaveReasonableReadTime() throws Exception {
        CollectionReference collection = this.createCollectionWithDocuments(5).collection();
        AggregateQuerySnapshot snapshot1 = (AggregateQuerySnapshot)collection.count().get().get();
        AggregateQuerySnapshot snapshot2 = (AggregateQuerySnapshot)collection.count().get().get();
        long readTimeMs1 = ITQueryCountTest.msFromTimestamp(snapshot1.getReadTime());
        long readTimeMs2 = ITQueryCountTest.msFromTimestamp(snapshot2.getReadTime());
        Truth.assertThat((Long)readTimeMs1).isLessThan((Comparable)Long.valueOf(readTimeMs2));
    }

    @Test
    public void aggregateSnapshotShouldHaveCorrectQuery() throws Exception {
        CollectionReference collection = this.createCollectionWithDocuments(5).collection();
        AggregateQuery aggregateQuery = collection.count();
        AggregateQuerySnapshot snapshot1 = (AggregateQuerySnapshot)aggregateQuery.get().get();
        AggregateQuerySnapshot snapshot2 = (AggregateQuerySnapshot)aggregateQuery.get().get();
        Truth.assertThat((Object)snapshot1.getQuery()).isSameInstanceAs((Object)aggregateQuery);
        Truth.assertThat((Object)snapshot2.getQuery()).isSameInstanceAs((Object)aggregateQuery);
    }

    @Test
    public void aggregateQueryShouldHaveCorrectQuery() {
        CollectionReference collection = this.firestore.collection("abc");
        AggregateQuery aggregateQuery = collection.count();
        Truth.assertThat((Object)aggregateQuery.getQuery()).isSameInstanceAs((Object)collection);
    }

    @Test
    public void aggregateQueryShouldWorkInATransaction() throws Exception {
        CollectionReference collection = this.createCollectionWithDocuments(7).collection();
        ApiFuture transactionFuture = collection.getFirestore().runTransaction(t -> (AggregateQuerySnapshot)t.get(collection.count()).get());
        AggregateQuerySnapshot snapshot = (AggregateQuerySnapshot)transactionFuture.get();
        Truth.assertThat((Long)snapshot.getCount()).isEqualTo((Object)7);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void aggregateQueryInATransactionShouldLockTheCountedDocuments() throws Exception {
        ExecutionException executionException;
        Assume.assumeTrue((String)"Skip this test when running against production because it appears that production is failing to lock the counted documents b/248152832", (boolean)TestHelper.isRunningAgainstFirestoreEmulator(this.firestore));
        CollectionReference collection = this.createEmptyCollection();
        DocumentReference document = this.createDocumentInCollection(collection);
        CountDownLatch aggregateQueryExecutedSignal = new CountDownLatch(1);
        CountDownLatch transactionContinueSignal = new CountDownLatch(1);
        ApiFuture transactionFuture = collection.getFirestore().runTransaction(t -> {
            t.get(collection.count()).get();
            aggregateQueryExecutedSignal.countDown();
            transactionContinueSignal.await();
            return null;
        });
        try {
            aggregateQueryExecutedSignal.await();
            ApiFuture documentSetTask = document.set(Collections.singletonMap("abc", "def"));
            executionException = (ExecutionException)Assert.assertThrows(ExecutionException.class, () -> documentSetTask.get());
        }
        finally {
            transactionContinueSignal.countDown();
        }
        Truth.assertThat((Throwable)executionException).hasCauseThat().hasMessageThat().ignoringCase().contains((CharSequence)"transaction lock timeout");
        transactionFuture.get();
    }

    @Test
    public void aggregateQueryInATransactionShouldRespectReadTime() throws Exception {
        CreatedCollectionInfo createdCollectionInfo = this.createCollectionWithDocuments(5);
        CollectionReference collection = createdCollectionInfo.collection();
        List<DocumentReference> documents = createdCollectionInfo.documents();
        AggregateQuerySnapshot snapshot = (AggregateQuerySnapshot)collection.count().get().get();
        Truth.assertThat((Long)snapshot.getCount()).isEqualTo((Object)5);
        documents.get(0).delete().get();
        ApiFuture transactionFuture = collection.getFirestore().runTransaction(t -> ((AggregateQuerySnapshot)t.get(collection.count()).get()).getCount(), TransactionOptions.createReadOnlyOptionsBuilder().setReadTime((TimestampOrBuilder)snapshot.getReadTime().toProto()).build());
        Long transactionCount = (Long)transactionFuture.get();
        Truth.assertThat((Long)transactionCount).isEqualTo((Object)5);
    }

    @Test
    public void countQueryShouldFailWithMessageWithConsoleLinkIfMissingIndex() {
        Assume.assumeFalse((String)"Skip this test when running against the Firestore emulator because the Firestore emulator does not use indexes and never fails with a 'missing index' error", (boolean)TestHelper.isRunningAgainstFirestoreEmulator(this.firestore));
        CollectionReference collection = this.createEmptyCollection();
        Query compositeIndexQuery = collection.whereEqualTo("field1", (Object)42).whereLessThan("field2", (Object)99);
        AggregateQuery compositeIndexCountQuery = compositeIndexQuery.count();
        ApiFuture future = compositeIndexCountQuery.get();
        ExecutionException executionException = (ExecutionException)Assert.assertThrows(ExecutionException.class, () -> future.get());
        Throwable throwable = executionException.getCause();
        Truth.assertThat((Throwable)throwable).hasMessageThat().ignoringCase().contains((CharSequence)"index");
        if (((FirestoreOptions)collection.getFirestore().getOptions()).getDatabaseId().equals("(default)")) {
            Truth.assertThat((Throwable)throwable).hasMessageThat().contains((CharSequence)"https://console.firebase.google.com");
        }
    }

    private CollectionReference createEmptyCollection() {
        String collectionPath = "java-" + this.testName.getMethodName() + "-" + LocalFirestoreHelper.autoId();
        return this.firestore.collection(collectionPath);
    }

    private CreatedCollectionInfo createCollectionWithDocuments(int numDocuments) throws ExecutionException, InterruptedException {
        CollectionReference collection = this.createEmptyCollection();
        List<DocumentReference> createdDocuments = this.createDocumentsWithKeyValuePair(collection, numDocuments, "key", 42);
        return CreatedCollectionInfo.create(collection, createdDocuments);
    }

    private List<DocumentReference> createDocumentsWithKeyValuePair(CollectionReference collection, int numDocumentsToCreate, String key, int value) throws ExecutionException, InterruptedException {
        WriteBatch writeBatch = this.firestore.batch();
        ArrayList<DocumentReference> createdDocuments = new ArrayList<DocumentReference>();
        for (int i = 0; i < numDocumentsToCreate; ++i) {
            DocumentReference doc = collection.document();
            createdDocuments.add(doc);
            writeBatch.create(doc, Collections.singletonMap(key, value));
        }
        writeBatch.commit().get();
        return createdDocuments;
    }

    private List<DocumentReference> createDocumentsInCollection(CollectionReference collection, int numDocumentsToCreate) throws ExecutionException, InterruptedException {
        return this.createDocumentsWithKeyValuePair(collection, numDocumentsToCreate, "meaning", 42);
    }

    private DocumentReference createDocumentInCollection(CollectionReference collection) throws ExecutionException, InterruptedException {
        WriteBatch writeBatch = collection.getFirestore().batch();
        DocumentReference createdDocument = this.createDocumentInCollection(writeBatch, collection, "age", 42);
        writeBatch.commit();
        return createdDocument;
    }

    private void createDocumentInCollection(WriteBatch writeBatch, CollectionReference collection) throws ExecutionException, InterruptedException {
        this.createDocumentInCollection(writeBatch, collection, "age", 42);
    }

    private DocumentReference createDocumentInCollection(WriteBatch writeBatch, CollectionReference collection, String key, int value) throws ExecutionException, InterruptedException {
        DocumentReference doc = collection.document();
        writeBatch.create(doc, Collections.singletonMap(key, value));
        return doc;
    }

    private CollectionGroup createCollectionGroupWithDocuments(int numDocumentsToCreate) throws ExecutionException, InterruptedException {
        String collectionId = LocalFirestoreHelper.autoId();
        ArrayList<CollectionReference> collections = new ArrayList<CollectionReference>();
        for (int i = 0; i <= numDocumentsToCreate / 3; ++i) {
            collections.add(this.createEmptyCollection().document().collection(collectionId));
        }
        WriteBatch writeBatch = this.firestore.batch();
        for (int i = 0; i < numDocumentsToCreate; ++i) {
            CollectionReference collection = (CollectionReference)collections.get(i % collections.size());
            this.createDocumentInCollection(writeBatch, collection);
        }
        writeBatch.commit().get();
        return this.firestore.collectionGroup(collectionId);
    }

    private static long msFromTimestamp(Timestamp timestamp) {
        return timestamp.getSeconds() * 1000L + (long)(timestamp.getNanos() / 1000000);
    }

    @AutoValue
    static abstract class CreatedCollectionInfo {
        CreatedCollectionInfo() {
        }

        abstract CollectionReference collection();

        abstract List<DocumentReference> documents();

        static CreatedCollectionInfo create(CollectionReference collection, List<DocumentReference> documents) {
            return new AutoValue_ITQueryCountTest_CreatedCollectionInfo(collection, documents);
        }
    }
}

