/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore.it;

import com.google.cloud.firestore.CollectionReference;
import com.google.cloud.firestore.ExecutionStats;
import com.google.cloud.firestore.ExplainMetrics;
import com.google.cloud.firestore.ExplainOptions;
import com.google.cloud.firestore.ExplainResults;
import com.google.cloud.firestore.FieldPath;
import com.google.cloud.firestore.FieldValue;
import com.google.cloud.firestore.LocalFirestoreHelper;
import com.google.cloud.firestore.PlanSummary;
import com.google.cloud.firestore.QueryDocumentSnapshot;
import com.google.cloud.firestore.VectorQuery;
import com.google.cloud.firestore.VectorQueryOptions;
import com.google.cloud.firestore.VectorQuerySnapshot;
import com.google.cloud.firestore.VectorValue;
import com.google.cloud.firestore.it.ITBaseTest;
import com.google.cloud.firestore.it.TestHelper;
import com.google.common.truth.Truth;
import java.time.Duration;
import java.util.Arrays;
import java.util.Map;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ITQueryFindNearestTest
extends ITBaseTest {
    static String testId = LocalFirestoreHelper.autoId();
    @Rule
    public TestName testName = new TestName();

    private String getUniqueTestId() {
        return testId + "-" + this.testName.getMethodName();
    }

    private CollectionReference testCollection() {
        String collectionPath = "index-test-collection";
        return this.firestore.collection(collectionPath);
    }

    private CollectionReference testCollectionWithDocs(Map<String, Map<String, Object>> docs) throws InterruptedException {
        CollectionReference collection = this.testCollection();
        CollectionReference writer = this.firestore.collection(collection.getId());
        this.writeAllDocs(writer, docs);
        return collection;
    }

    private String getUniqueDocId(String docId) {
        return testId + docId;
    }

    public void writeAllDocs(CollectionReference collection, Map<String, Map<String, Object>> docs) throws InterruptedException {
        for (Map.Entry<String, Map<String, Object>> doc : docs.entrySet()) {
            Map<String, Object> data = doc.getValue();
            data.put("testId", this.getUniqueTestId());
            data.put("docId", this.getUniqueDocId(doc.getKey()));
            TestHelper.await(collection.add(data));
        }
    }

    @Test
    public void findNearestWithEuclideanDistance() throws Exception {
        CollectionReference collection = this.testCollectionWithDocs(LocalFirestoreHelper.map("a", LocalFirestoreHelper.map("foo", "bar", new Object[0]), "b", LocalFirestoreHelper.map("foo", "xxx", "embedding", FieldValue.vector((double[])new double[]{10.0, 10.0})), "c", LocalFirestoreHelper.map("foo", "bar", "embedding", FieldValue.vector((double[])new double[]{1.0, 1.0})), "d", LocalFirestoreHelper.map("foo", "bar", "embedding", FieldValue.vector((double[])new double[]{10.0, 0.0})), "e", LocalFirestoreHelper.map("foo", "bar", "embedding", FieldValue.vector((double[])new double[]{20.0, 0.0})), "f", LocalFirestoreHelper.map("foo", "bar", "embedding", FieldValue.vector((double[])new double[]{100.0, 100.0}))));
        VectorQuery vectorQuery = collection.whereEqualTo("foo", (Object)"bar").whereEqualTo("testId", (Object)this.getUniqueTestId()).findNearest("embedding", new double[]{10.0, 10.0}, 3, VectorQuery.DistanceMeasure.EUCLIDEAN);
        VectorQuerySnapshot snapshot = (VectorQuerySnapshot)vectorQuery.get().get();
        Truth.assertThat((Integer)snapshot.size()).isEqualTo((Object)3);
        Truth.assertThat((Object)((QueryDocumentSnapshot)snapshot.getDocuments().get(0)).get("docId")).isEqualTo((Object)this.getUniqueDocId("d"));
        Truth.assertThat((Object)((QueryDocumentSnapshot)snapshot.getDocuments().get(1)).get("docId")).isEqualTo((Object)this.getUniqueDocId("c"));
        Truth.assertThat((Object)((QueryDocumentSnapshot)snapshot.getDocuments().get(2)).get("docId")).isEqualTo((Object)this.getUniqueDocId("e"));
    }

    @Test
    public void findNearestWithEuclideanDistanceFirestoreTypeOverride() throws Exception {
        CollectionReference collection = this.testCollectionWithDocs(LocalFirestoreHelper.map("a", LocalFirestoreHelper.map("foo", "bar", new Object[0]), "b", LocalFirestoreHelper.map("foo", "xxx", "embedding", FieldValue.vector((double[])new double[]{10.0, 10.0})), "c", LocalFirestoreHelper.map("foo", "bar", "embedding", FieldValue.vector((double[])new double[]{1.0, 1.0})), "d", LocalFirestoreHelper.map("foo", "bar", "embedding", FieldValue.vector((double[])new double[]{10.0, 0.0})), "e", LocalFirestoreHelper.map("foo", "bar", "embedding", FieldValue.vector((double[])new double[]{20.0, 0.0})), "f", LocalFirestoreHelper.map("foo", "bar", "embedding", FieldValue.vector((double[])new double[]{100.0, 100.0}))));
        VectorQuery vectorQuery = collection.whereEqualTo("foo", (Object)"bar").whereEqualTo("testId", (Object)this.getUniqueTestId()).findNearest(FieldPath.of((String[])new String[]{"embedding"}), FieldValue.vector((double[])new double[]{10.0, 10.0}), 3, VectorQuery.DistanceMeasure.EUCLIDEAN);
        VectorQuerySnapshot snapshot = (VectorQuerySnapshot)vectorQuery.get().get();
        Truth.assertThat((Integer)snapshot.size()).isEqualTo((Object)3);
        Truth.assertThat((Object)((QueryDocumentSnapshot)snapshot.getDocuments().get(0)).get("docId")).isEqualTo((Object)this.getUniqueDocId("d"));
        Truth.assertThat((Object)((QueryDocumentSnapshot)snapshot.getDocuments().get(1)).get("docId")).isEqualTo((Object)this.getUniqueDocId("c"));
        Truth.assertThat((Object)((QueryDocumentSnapshot)snapshot.getDocuments().get(2)).get("docId")).isEqualTo((Object)this.getUniqueDocId("e"));
    }

    @Test
    public void findNearestWithCosineDistance() throws Exception {
        CollectionReference collection = this.testCollectionWithDocs(LocalFirestoreHelper.map("a", LocalFirestoreHelper.map("foo", "bar", new Object[0]), "b", LocalFirestoreHelper.map("foo", "xxx", "embedding", FieldValue.vector((double[])new double[]{10.0, 10.0})), "c", LocalFirestoreHelper.map("foo", "bar", "embedding", FieldValue.vector((double[])new double[]{1.0, 1.0})), "d", LocalFirestoreHelper.map("foo", "bar", "embedding", FieldValue.vector((double[])new double[]{20.0, 0.0})), "e", LocalFirestoreHelper.map("foo", "bar", "embedding", FieldValue.vector((double[])new double[]{10.0, 0.0})), "f", LocalFirestoreHelper.map("foo", "bar", "embedding", FieldValue.vector((double[])new double[]{100.0, 100.0}))));
        VectorQuery vectorQuery = collection.whereEqualTo("foo", (Object)"bar").whereEqualTo("testId", (Object)this.getUniqueTestId()).findNearest("embedding", new double[]{10.0, 10.0}, 3, VectorQuery.DistanceMeasure.COSINE);
        VectorQuerySnapshot snapshot = (VectorQuerySnapshot)vectorQuery.get().get();
        Truth.assertThat((Integer)snapshot.size()).isEqualTo((Object)3);
        Assert.assertTrue((boolean)Arrays.asList(this.getUniqueDocId("f"), this.getUniqueDocId("c")).contains(((QueryDocumentSnapshot)snapshot.getDocuments().get(0)).get("docId")));
        Assert.assertTrue((boolean)Arrays.asList(this.getUniqueDocId("f"), this.getUniqueDocId("c")).contains(((QueryDocumentSnapshot)snapshot.getDocuments().get(1)).get("docId")));
        Assert.assertTrue((boolean)Arrays.asList(this.getUniqueDocId("d"), this.getUniqueDocId("e")).contains(((QueryDocumentSnapshot)snapshot.getDocuments().get(2)).get("docId")));
    }

    @Test
    public void findNearestWithDotProductDistance() throws Exception {
        CollectionReference collection = this.testCollectionWithDocs(LocalFirestoreHelper.map("a", LocalFirestoreHelper.map("foo", "bar", new Object[0]), "b", LocalFirestoreHelper.map("foo", "xxx", "embedding", FieldValue.vector((double[])new double[]{10.0, 10.0})), "c", LocalFirestoreHelper.map("foo", "bar", "embedding", FieldValue.vector((double[])new double[]{1.0, 1.0})), "d", LocalFirestoreHelper.map("foo", "bar", "embedding", FieldValue.vector((double[])new double[]{10.0, 0.0})), "e", LocalFirestoreHelper.map("foo", "bar", "embedding", FieldValue.vector((double[])new double[]{20.0, 0.0})), "f", LocalFirestoreHelper.map("foo", "bar", "embedding", FieldValue.vector((double[])new double[]{100.0, 100.0}))));
        VectorQuery vectorQuery = collection.whereEqualTo("foo", (Object)"bar").whereEqualTo("testId", (Object)this.getUniqueTestId()).findNearest("embedding", new double[]{10.0, 10.0}, 3, VectorQuery.DistanceMeasure.DOT_PRODUCT);
        VectorQuerySnapshot snapshot = (VectorQuerySnapshot)vectorQuery.get().get();
        Truth.assertThat((Integer)snapshot.size()).isEqualTo((Object)3);
        Truth.assertThat((Object)((QueryDocumentSnapshot)snapshot.getDocuments().get(0)).get("docId")).isEqualTo((Object)this.getUniqueDocId("f"));
        Truth.assertThat((Object)((QueryDocumentSnapshot)snapshot.getDocuments().get(1)).get("docId")).isEqualTo((Object)this.getUniqueDocId("e"));
        Truth.assertThat((Object)((QueryDocumentSnapshot)snapshot.getDocuments().get(2)).get("docId")).isEqualTo((Object)this.getUniqueDocId("d"));
    }

    @Test
    public void findNearestSkipsFieldsOfWrongTypes() throws Exception {
        CollectionReference collection = this.testCollectionWithDocs(LocalFirestoreHelper.map("a", LocalFirestoreHelper.map("foo", "bar", new Object[0]), "b", LocalFirestoreHelper.map("foo", "bar", "embedding", Arrays.asList(10.0, 10.0)), "c", LocalFirestoreHelper.map("foo", "bar", "embedding", "not actually a vector"), "d", LocalFirestoreHelper.map("foo", "bar", "embedding", null), "e", LocalFirestoreHelper.map("foo", "bar", "embedding", FieldValue.vector((double[])new double[]{9.0, 9.0})), "f", LocalFirestoreHelper.map("foo", "bar", "embedding", FieldValue.vector((double[])new double[]{50.0, 50.0})), "g", LocalFirestoreHelper.map("foo", "bar", "embedding", FieldValue.vector((double[])new double[]{100.0, 100.0}))));
        VectorQuery vectorQuery = collection.whereEqualTo("foo", (Object)"bar").whereEqualTo("testId", (Object)this.getUniqueTestId()).findNearest("embedding", new double[]{10.0, 10.0}, 100, VectorQuery.DistanceMeasure.EUCLIDEAN);
        VectorQuerySnapshot snapshot = (VectorQuerySnapshot)vectorQuery.get().get();
        Truth.assertThat((Integer)snapshot.size()).isEqualTo((Object)3);
        Truth.assertThat((Object)((QueryDocumentSnapshot)snapshot.getDocuments().get(0)).get("docId")).isEqualTo((Object)this.getUniqueDocId("e"));
        Truth.assertThat((Object)((QueryDocumentSnapshot)snapshot.getDocuments().get(1)).get("docId")).isEqualTo((Object)this.getUniqueDocId("f"));
        Truth.assertThat((Object)((QueryDocumentSnapshot)snapshot.getDocuments().get(2)).get("docId")).isEqualTo((Object)this.getUniqueDocId("g"));
    }

    @Test
    public void findNearestIgnoresMismatchingDimensions() throws Exception {
        CollectionReference collection = this.testCollectionWithDocs(LocalFirestoreHelper.map("a", LocalFirestoreHelper.map("foo", "bar", new Object[0]), "b", LocalFirestoreHelper.map("foo", "bar", "embedding", FieldValue.vector((double[])new double[]{10.0})), "c", LocalFirestoreHelper.map("foo", "bar", "embedding", FieldValue.vector((double[])new double[]{9.0, 9.0})), "d", LocalFirestoreHelper.map("foo", "bar", "embedding", FieldValue.vector((double[])new double[]{50.0, 50.0}))));
        VectorQuery vectorQuery = collection.whereEqualTo("foo", (Object)"bar").whereEqualTo("testId", (Object)this.getUniqueTestId()).findNearest("embedding", new double[]{10.0, 10.0}, 3, VectorQuery.DistanceMeasure.EUCLIDEAN);
        VectorQuerySnapshot snapshot = (VectorQuerySnapshot)vectorQuery.get().get();
        Truth.assertThat((Integer)snapshot.size()).isEqualTo((Object)2);
        Truth.assertThat((Object)((QueryDocumentSnapshot)snapshot.getDocuments().get(0)).get("docId")).isEqualTo((Object)this.getUniqueDocId("c"));
        Truth.assertThat((Object)((QueryDocumentSnapshot)snapshot.getDocuments().get(1)).get("docId")).isEqualTo((Object)this.getUniqueDocId("d"));
    }

    @Test
    public void findNearestOnNonExistentField() throws Exception {
        CollectionReference collection = this.testCollectionWithDocs(LocalFirestoreHelper.map("a", LocalFirestoreHelper.map("foo", "bar", new Object[0]), "b", LocalFirestoreHelper.map("foo", "bar", "otherField", Arrays.asList(10.0, 10.0)), "c", LocalFirestoreHelper.map("foo", "bar", "otherField", "not actually a vector"), "d", LocalFirestoreHelper.map("foo", "bar", "otherField", null)));
        VectorQuery vectorQuery = collection.whereEqualTo("foo", (Object)"bar").whereEqualTo("testId", (Object)this.getUniqueTestId()).findNearest("embedding", new double[]{10.0, 10.0}, 3, VectorQuery.DistanceMeasure.EUCLIDEAN);
        VectorQuerySnapshot snapshot = (VectorQuerySnapshot)vectorQuery.get().get();
        Truth.assertThat((Integer)snapshot.size()).isEqualTo((Object)0);
    }

    @Test
    public void findNearestOnVectorNestedInAMap() throws Exception {
        CollectionReference collection = this.testCollectionWithDocs(LocalFirestoreHelper.map("a", LocalFirestoreHelper.map("nested", LocalFirestoreHelper.map("foo", "bar", new Object[0]), new Object[0]), "b", LocalFirestoreHelper.map("nested", LocalFirestoreHelper.map("foo", "xxx", "embedding", FieldValue.vector((double[])new double[]{10.0, 10.0})), new Object[0]), "c", LocalFirestoreHelper.map("nested", LocalFirestoreHelper.map("foo", "bar", "embedding", FieldValue.vector((double[])new double[]{1.0, 1.0})), new Object[0]), "d", LocalFirestoreHelper.map("nested", LocalFirestoreHelper.map("foo", "bar", "embedding", FieldValue.vector((double[])new double[]{10.0, 0.0})), new Object[0]), "e", LocalFirestoreHelper.map("nested", LocalFirestoreHelper.map("foo", "bar", "embedding", FieldValue.vector((double[])new double[]{20.0, 0.0})), new Object[0]), "f", LocalFirestoreHelper.map("nested", LocalFirestoreHelper.map("foo", "bar", "embedding", FieldValue.vector((double[])new double[]{100.0, 100.0})), new Object[0])));
        VectorQuery vectorQuery = collection.whereEqualTo("testId", (Object)this.getUniqueTestId()).findNearest("nested.embedding", new double[]{10.0, 10.0}, 3, VectorQuery.DistanceMeasure.EUCLIDEAN);
        VectorQuerySnapshot snapshot = (VectorQuerySnapshot)vectorQuery.get().get();
        Truth.assertThat((Integer)snapshot.size()).isEqualTo((Object)3);
        Truth.assertThat((Object)((QueryDocumentSnapshot)snapshot.getDocuments().get(0)).get("docId")).isEqualTo((Object)this.getUniqueDocId("b"));
        Truth.assertThat((Object)((QueryDocumentSnapshot)snapshot.getDocuments().get(1)).get("docId")).isEqualTo((Object)this.getUniqueDocId("d"));
        Truth.assertThat((Object)((QueryDocumentSnapshot)snapshot.getDocuments().get(2)).get("docId")).isEqualTo((Object)this.getUniqueDocId("c"));
    }

    @Test
    public void findNearestWithSelectToExcludeVectorDataInResponse() throws Exception {
        CollectionReference collection = this.testCollectionWithDocs(LocalFirestoreHelper.map("a", LocalFirestoreHelper.map("foo", 1, new Object[0]), "b", LocalFirestoreHelper.map("foo", 2, "embedding", FieldValue.vector((double[])new double[]{10.0, 10.0})), "c", LocalFirestoreHelper.map("foo", 3, "embedding", FieldValue.vector((double[])new double[]{1.0, 1.0})), "d", LocalFirestoreHelper.map("foo", 4, "embedding", FieldValue.vector((double[])new double[]{10.0, 0.0})), "e", LocalFirestoreHelper.map("foo", 5, "embedding", FieldValue.vector((double[])new double[]{20.0, 0.0})), "f", LocalFirestoreHelper.map("foo", 6, "embedding", FieldValue.vector((double[])new double[]{100.0, 100.0}))));
        VectorQuery vectorQuery = collection.whereIn("foo", Arrays.asList(1, 2, 3, 4, 5, 6)).whereEqualTo("testId", (Object)this.getUniqueTestId()).select(new String[]{"foo", "docId"}).findNearest("embedding", new double[]{10.0, 10.0}, 10, VectorQuery.DistanceMeasure.EUCLIDEAN);
        VectorQuerySnapshot snapshot = (VectorQuerySnapshot)vectorQuery.get().get();
        Truth.assertThat((Integer)snapshot.size()).isEqualTo((Object)5);
        Truth.assertThat((Object)((QueryDocumentSnapshot)snapshot.getDocuments().get(0)).get("docId")).isEqualTo((Object)this.getUniqueDocId("b"));
        Truth.assertThat((Object)((QueryDocumentSnapshot)snapshot.getDocuments().get(1)).get("docId")).isEqualTo((Object)this.getUniqueDocId("d"));
        Truth.assertThat((Object)((QueryDocumentSnapshot)snapshot.getDocuments().get(2)).get("docId")).isEqualTo((Object)this.getUniqueDocId("c"));
        Truth.assertThat((Object)((QueryDocumentSnapshot)snapshot.getDocuments().get(3)).get("docId")).isEqualTo((Object)this.getUniqueDocId("e"));
        Truth.assertThat((Object)((QueryDocumentSnapshot)snapshot.getDocuments().get(4)).get("docId")).isEqualTo((Object)this.getUniqueDocId("f"));
        for (QueryDocumentSnapshot doc : snapshot.getDocuments()) {
            Truth.assertThat((Object)doc.get("embedding")).isNull();
        }
    }

    @Test
    public void findNearestLimits() throws Exception {
        double[] embeddingVector = new double[2048];
        double[] queryVector = new double[2048];
        for (int i = 0; i < 2048; ++i) {
            embeddingVector[i] = i + 1;
            queryVector[i] = i - 1;
        }
        CollectionReference collection = this.testCollectionWithDocs(LocalFirestoreHelper.map("a", LocalFirestoreHelper.map("embedding", FieldValue.vector((double[])embeddingVector), new Object[0]), new Object[0]));
        VectorQuery vectorQuery = collection.whereEqualTo("testId", (Object)this.getUniqueTestId()).findNearest("embedding", queryVector, 1000, VectorQuery.DistanceMeasure.EUCLIDEAN);
        VectorQuerySnapshot snapshot = (VectorQuerySnapshot)vectorQuery.get().get();
        Truth.assertThat((Integer)snapshot.size()).isEqualTo((Object)1);
        Truth.assertThat((double[])((VectorValue)((QueryDocumentSnapshot)snapshot.getDocuments().get(0)).get("embedding")).toArray()).isEqualTo((Object)embeddingVector);
    }

    @Test
    public void requestingComputedCosineDistance() throws Exception {
        CollectionReference collection = this.testCollectionWithDocs(LocalFirestoreHelper.map("1", LocalFirestoreHelper.map("foo", "bar", new Object[0]), "2", LocalFirestoreHelper.map("foo", "bar", "embedding", FieldValue.vector((double[])new double[]{1.0, 0.0})), "3", LocalFirestoreHelper.map("foo", "bar", "embedding", FieldValue.vector((double[])new double[]{0.0, 1.0})), "4", LocalFirestoreHelper.map("foo", "bar", "embedding", FieldValue.vector((double[])new double[]{0.0, -0.1})), "5", LocalFirestoreHelper.map("foo", "bar", "embedding", FieldValue.vector((double[])new double[]{-1.0, 0.0}))));
        VectorQuery vectorQuery = collection.whereEqualTo("testId", (Object)this.getUniqueTestId()).findNearest("embedding", new double[]{1.0, 0.0}, 5, VectorQuery.DistanceMeasure.COSINE, VectorQueryOptions.newBuilder().setDistanceResultField("distance").build());
        VectorQuerySnapshot snapshot = (VectorQuerySnapshot)vectorQuery.get().get();
        Truth.assertThat((Integer)snapshot.size()).isEqualTo((Object)4);
        Truth.assertThat((Object)((QueryDocumentSnapshot)snapshot.getDocuments().get(0)).get("docId")).isEqualTo((Object)this.getUniqueDocId("2"));
        Truth.assertThat((Double)((QueryDocumentSnapshot)snapshot.getDocuments().get(0)).getDouble("distance")).isEqualTo((Object)0);
        Truth.assertThat((Double)((QueryDocumentSnapshot)snapshot.getDocuments().get(1)).getDouble("distance")).isEqualTo((Object)1);
        Truth.assertThat((Double)((QueryDocumentSnapshot)snapshot.getDocuments().get(2)).getDouble("distance")).isEqualTo((Object)1);
        Truth.assertThat((Object)((QueryDocumentSnapshot)snapshot.getDocuments().get(3)).get("docId")).isEqualTo((Object)this.getUniqueDocId("5"));
        Truth.assertThat((Double)((QueryDocumentSnapshot)snapshot.getDocuments().get(3)).getDouble("distance")).isEqualTo((Object)2);
    }

    @Test
    public void requestingComputedEuclideanDistance() throws Exception {
        CollectionReference collection = this.testCollectionWithDocs(LocalFirestoreHelper.map("1", LocalFirestoreHelper.map("foo", "bar", new Object[0]), "2", LocalFirestoreHelper.map("foo", "bar", "embedding", FieldValue.vector((double[])new double[]{2.0, 0.0})), "3", LocalFirestoreHelper.map("foo", "bar", "embedding", FieldValue.vector((double[])new double[]{1.0, 100.0})), "4", LocalFirestoreHelper.map("foo", "bar", "embedding", FieldValue.vector((double[])new double[]{1.0, -0.1})), "5", LocalFirestoreHelper.map("foo", "bar", "embedding", FieldValue.vector((double[])new double[]{4.0, 4.0}))));
        VectorQuery vectorQuery = collection.whereEqualTo("testId", (Object)this.getUniqueTestId()).findNearest("embedding", new double[]{1.0, 0.0}, 5, VectorQuery.DistanceMeasure.EUCLIDEAN, VectorQueryOptions.newBuilder().setDistanceResultField("distance").build());
        VectorQuerySnapshot snapshot = (VectorQuerySnapshot)vectorQuery.get().get();
        Truth.assertThat((Integer)snapshot.size()).isEqualTo((Object)4);
        Truth.assertThat((Object)((QueryDocumentSnapshot)snapshot.getDocuments().get(0)).get("docId")).isEqualTo((Object)this.getUniqueDocId("4"));
        Truth.assertThat((Double)((QueryDocumentSnapshot)snapshot.getDocuments().get(0)).getDouble("distance")).isEqualTo((Object)0.1);
        Truth.assertThat((Object)((QueryDocumentSnapshot)snapshot.getDocuments().get(1)).get("docId")).isEqualTo((Object)this.getUniqueDocId("2"));
        Truth.assertThat((Double)((QueryDocumentSnapshot)snapshot.getDocuments().get(1)).getDouble("distance")).isEqualTo((Object)1);
        Truth.assertThat((Object)((QueryDocumentSnapshot)snapshot.getDocuments().get(2)).get("docId")).isEqualTo((Object)this.getUniqueDocId("5"));
        Truth.assertThat((Double)((QueryDocumentSnapshot)snapshot.getDocuments().get(2)).getDouble("distance")).isEqualTo((Object)5);
        Truth.assertThat((Object)((QueryDocumentSnapshot)snapshot.getDocuments().get(3)).get("docId")).isEqualTo((Object)this.getUniqueDocId("3"));
        Truth.assertThat((Double)((QueryDocumentSnapshot)snapshot.getDocuments().get(3)).getDouble("distance")).isEqualTo((Object)100);
    }

    @Test
    public void requestingComputedDotProductDistance() throws Exception {
        CollectionReference collection = this.testCollectionWithDocs(LocalFirestoreHelper.map("1", LocalFirestoreHelper.map("foo", "bar", new Object[0]), "2", LocalFirestoreHelper.map("foo", "bar", "embedding", FieldValue.vector((double[])new double[]{2.0, 0.0})), "3", LocalFirestoreHelper.map("foo", "bar", "embedding", FieldValue.vector((double[])new double[]{1.0, 100.0})), "4", LocalFirestoreHelper.map("foo", "bar", "embedding", FieldValue.vector((double[])new double[]{-20.0, 0.0})), "5", LocalFirestoreHelper.map("foo", "bar", "embedding", FieldValue.vector((double[])new double[]{0.1, 4.0}))));
        VectorQuery vectorQuery = collection.whereEqualTo("testId", (Object)this.getUniqueTestId()).findNearest("embedding", new double[]{1.0, 0.0}, 5, VectorQuery.DistanceMeasure.DOT_PRODUCT, VectorQueryOptions.newBuilder().setDistanceResultField("distance").build());
        VectorQuerySnapshot snapshot = (VectorQuerySnapshot)vectorQuery.get().get();
        Truth.assertThat((Integer)snapshot.size()).isEqualTo((Object)4);
        Truth.assertThat((Object)((QueryDocumentSnapshot)snapshot.getDocuments().get(0)).get("docId")).isEqualTo((Object)this.getUniqueDocId("2"));
        Truth.assertThat((Double)((QueryDocumentSnapshot)snapshot.getDocuments().get(0)).getDouble("distance")).isEqualTo((Object)2);
        Truth.assertThat((Object)((QueryDocumentSnapshot)snapshot.getDocuments().get(1)).get("docId")).isEqualTo((Object)this.getUniqueDocId("3"));
        Truth.assertThat((Double)((QueryDocumentSnapshot)snapshot.getDocuments().get(1)).getDouble("distance")).isEqualTo((Object)1);
        Truth.assertThat((Object)((QueryDocumentSnapshot)snapshot.getDocuments().get(2)).get("docId")).isEqualTo((Object)this.getUniqueDocId("5"));
        Truth.assertThat((Double)((QueryDocumentSnapshot)snapshot.getDocuments().get(2)).getDouble("distance")).isEqualTo((Object)0.1);
        Truth.assertThat((Object)((QueryDocumentSnapshot)snapshot.getDocuments().get(3)).get("docId")).isEqualTo((Object)this.getUniqueDocId("4"));
        Truth.assertThat((Double)((QueryDocumentSnapshot)snapshot.getDocuments().get(3)).getDouble("distance")).isEqualTo((Object)-20);
    }

    @Test
    public void overwritesDistanceResultFieldOnConflict() throws Exception {
        CollectionReference collection = this.testCollectionWithDocs(LocalFirestoreHelper.map("1", LocalFirestoreHelper.map("foo", "bar", "embedding", FieldValue.vector((double[])new double[]{0.0, 1.0}), "distance", "100 miles"), new Object[0]));
        VectorQuery vectorQuery = collection.whereEqualTo("testId", (Object)this.getUniqueTestId()).findNearest("embedding", new double[]{1.0, 0.0}, 5, VectorQuery.DistanceMeasure.COSINE, VectorQueryOptions.newBuilder().setDistanceResultField("distance").build());
        VectorQuerySnapshot snapshot = (VectorQuerySnapshot)vectorQuery.get().get();
        Truth.assertThat((Integer)snapshot.size()).isEqualTo((Object)1);
        Truth.assertThat((Object)((QueryDocumentSnapshot)snapshot.getDocuments().get(0)).get("docId")).isEqualTo((Object)this.getUniqueDocId("1"));
        Truth.assertThat((Double)((QueryDocumentSnapshot)snapshot.getDocuments().get(0)).getDouble("distance")).isEqualTo((Object)1);
    }

    @Test
    public void requestingComputedDistanceInSelectQueries() throws Exception {
        CollectionReference collection = this.testCollectionWithDocs(LocalFirestoreHelper.map("1", LocalFirestoreHelper.map("foo", "bar", new Object[0]), "2", LocalFirestoreHelper.map("foo", "bar", "embedding", FieldValue.vector((double[])new double[]{1.0, 0.0})), "3", LocalFirestoreHelper.map("foo", "bar", "embedding", FieldValue.vector((double[])new double[]{0.0, 1.0})), "4", LocalFirestoreHelper.map("foo", "bar", "embedding", FieldValue.vector((double[])new double[]{0.0, -0.1})), "5", LocalFirestoreHelper.map("foo", "bar", "embedding", FieldValue.vector((double[])new double[]{-1.0, 0.0}))));
        VectorQuery vectorQuery = collection.whereEqualTo("testId", (Object)this.getUniqueTestId()).select(new String[]{"embedding", "distance", "docId"}).findNearest("embedding", new double[]{1.0, 0.0}, 5, VectorQuery.DistanceMeasure.COSINE, VectorQueryOptions.newBuilder().setDistanceResultField("distance").build());
        VectorQuerySnapshot snapshot = (VectorQuerySnapshot)vectorQuery.get().get();
        Truth.assertThat((Integer)snapshot.size()).isEqualTo((Object)4);
        Truth.assertThat((Object)((QueryDocumentSnapshot)snapshot.getDocuments().get(0)).get("docId")).isEqualTo((Object)this.getUniqueDocId("2"));
        Truth.assertThat((Double)((QueryDocumentSnapshot)snapshot.getDocuments().get(0)).getDouble("distance")).isEqualTo((Object)0);
        Truth.assertThat((Double)((QueryDocumentSnapshot)snapshot.getDocuments().get(1)).getDouble("distance")).isEqualTo((Object)1);
        Truth.assertThat((Double)((QueryDocumentSnapshot)snapshot.getDocuments().get(2)).getDouble("distance")).isEqualTo((Object)1);
        Truth.assertThat((Object)((QueryDocumentSnapshot)snapshot.getDocuments().get(3)).get("docId")).isEqualTo((Object)this.getUniqueDocId("5"));
        Truth.assertThat((Double)((QueryDocumentSnapshot)snapshot.getDocuments().get(3)).getDouble("distance")).isEqualTo((Object)2);
    }

    @Test
    public void queryingWithDistanceThresholdUsingCosineDistance() throws Exception {
        CollectionReference collection = this.testCollectionWithDocs(LocalFirestoreHelper.map("1", LocalFirestoreHelper.map("foo", "bar", new Object[0]), "2", LocalFirestoreHelper.map("foo", "bar", "embedding", FieldValue.vector((double[])new double[]{1.0, 0.0})), "3", LocalFirestoreHelper.map("foo", "bar", "embedding", FieldValue.vector((double[])new double[]{1.0, 1.0})), "4", LocalFirestoreHelper.map("foo", "bar", "embedding", FieldValue.vector((double[])new double[]{0.0, -0.1})), "5", LocalFirestoreHelper.map("foo", "bar", "embedding", FieldValue.vector((double[])new double[]{-1.0, 0.0}))));
        VectorQuery vectorQuery = collection.whereEqualTo("testId", (Object)this.getUniqueTestId()).findNearest("embedding", new double[]{1.0, 0.0}, 5, VectorQuery.DistanceMeasure.COSINE, VectorQueryOptions.newBuilder().setDistanceThreshold(Double.valueOf(1.0)).build());
        VectorQuerySnapshot snapshot = (VectorQuerySnapshot)vectorQuery.get().get();
        Truth.assertThat((Integer)snapshot.size()).isEqualTo((Object)3);
        Truth.assertThat((Object)((QueryDocumentSnapshot)snapshot.getDocuments().get(0)).get("docId")).isEqualTo((Object)this.getUniqueDocId("2"));
        Truth.assertThat((Object)((QueryDocumentSnapshot)snapshot.getDocuments().get(1)).get("docId")).isEqualTo((Object)this.getUniqueDocId("3"));
        Truth.assertThat((Object)((QueryDocumentSnapshot)snapshot.getDocuments().get(2)).get("docId")).isEqualTo((Object)this.getUniqueDocId("4"));
    }

    @Test
    public void queryingWithDistanceThresholdUsingEuclideanDistance() throws Exception {
        CollectionReference collection = this.testCollectionWithDocs(LocalFirestoreHelper.map("1", LocalFirestoreHelper.map("foo", "bar", new Object[0]), "2", LocalFirestoreHelper.map("foo", "bar", "embedding", FieldValue.vector((double[])new double[]{2.0, 0.0})), "3", LocalFirestoreHelper.map("foo", "bar", "embedding", FieldValue.vector((double[])new double[]{1.0, 100.0})), "4", LocalFirestoreHelper.map("foo", "bar", "embedding", FieldValue.vector((double[])new double[]{1.0, -0.1})), "5", LocalFirestoreHelper.map("foo", "bar", "embedding", FieldValue.vector((double[])new double[]{4.0, 4.0}))));
        VectorQuery vectorQuery = collection.whereEqualTo("testId", (Object)this.getUniqueTestId()).findNearest("embedding", new double[]{1.0, 0.0}, 5, VectorQuery.DistanceMeasure.EUCLIDEAN, VectorQueryOptions.newBuilder().setDistanceThreshold(Double.valueOf(5.0)).build());
        VectorQuerySnapshot snapshot = (VectorQuerySnapshot)vectorQuery.get().get();
        Truth.assertThat((Integer)snapshot.size()).isEqualTo((Object)3);
        Truth.assertThat((Object)((QueryDocumentSnapshot)snapshot.getDocuments().get(0)).get("docId")).isEqualTo((Object)this.getUniqueDocId("4"));
        Truth.assertThat((Object)((QueryDocumentSnapshot)snapshot.getDocuments().get(1)).get("docId")).isEqualTo((Object)this.getUniqueDocId("2"));
        Truth.assertThat((Object)((QueryDocumentSnapshot)snapshot.getDocuments().get(2)).get("docId")).isEqualTo((Object)this.getUniqueDocId("5"));
    }

    @Test
    public void queryingWithDistanceThresholdUsingDotProductDistance() throws Exception {
        CollectionReference collection = this.testCollectionWithDocs(LocalFirestoreHelper.map("1", LocalFirestoreHelper.map("foo", "bar", new Object[0]), "2", LocalFirestoreHelper.map("foo", "bar", "embedding", FieldValue.vector((double[])new double[]{2.0, 0.0})), "3", LocalFirestoreHelper.map("foo", "bar", "embedding", FieldValue.vector((double[])new double[]{1.0, 100.0})), "4", LocalFirestoreHelper.map("foo", "bar", "embedding", FieldValue.vector((double[])new double[]{-20.0, 0.0})), "5", LocalFirestoreHelper.map("foo", "bar", "embedding", FieldValue.vector((double[])new double[]{0.1, 4.0}))));
        VectorQuery vectorQuery = collection.whereEqualTo("testId", (Object)this.getUniqueTestId()).findNearest("embedding", new double[]{1.0, 0.0}, 5, VectorQuery.DistanceMeasure.DOT_PRODUCT, VectorQueryOptions.newBuilder().setDistanceThreshold(Double.valueOf(1.0)).build());
        VectorQuerySnapshot snapshot = (VectorQuerySnapshot)vectorQuery.get().get();
        Truth.assertThat((Integer)snapshot.size()).isEqualTo((Object)2);
        Truth.assertThat((Object)((QueryDocumentSnapshot)snapshot.getDocuments().get(0)).get("docId")).isEqualTo((Object)this.getUniqueDocId("2"));
        Truth.assertThat((Object)((QueryDocumentSnapshot)snapshot.getDocuments().get(1)).get("docId")).isEqualTo((Object)this.getUniqueDocId("3"));
    }

    @Test
    public void queryWithDistanceResultFieldAndDistanceThreshold() throws Exception {
        CollectionReference collection = this.testCollectionWithDocs(LocalFirestoreHelper.map("1", LocalFirestoreHelper.map("foo", "bar", new Object[0]), "2", LocalFirestoreHelper.map("foo", "bar", "embedding", FieldValue.vector((double[])new double[]{2.0, 0.0})), "3", LocalFirestoreHelper.map("foo", "bar", "embedding", FieldValue.vector((double[])new double[]{1.0, 100.0})), "4", LocalFirestoreHelper.map("foo", "bar", "embedding", FieldValue.vector((double[])new double[]{-20.0, 0.0})), "5", LocalFirestoreHelper.map("foo", "bar", "embedding", FieldValue.vector((double[])new double[]{0.1, 4.0}))));
        VectorQuery vectorQuery = collection.whereEqualTo("testId", (Object)this.getUniqueTestId()).findNearest("embedding", new double[]{1.0, 0.0}, 5, VectorQuery.DistanceMeasure.DOT_PRODUCT, VectorQueryOptions.newBuilder().setDistanceThreshold(Double.valueOf(0.11)).setDistanceResultField("foo").build());
        VectorQuerySnapshot snapshot = (VectorQuerySnapshot)vectorQuery.get().get();
        Truth.assertThat((Integer)snapshot.size()).isEqualTo((Object)2);
        Truth.assertThat((Object)((QueryDocumentSnapshot)snapshot.getDocuments().get(0)).get("docId")).isEqualTo((Object)this.getUniqueDocId("2"));
        Truth.assertThat((Double)((QueryDocumentSnapshot)snapshot.getDocuments().get(0)).getDouble("foo")).isEqualTo((Object)2);
        Truth.assertThat((Object)((QueryDocumentSnapshot)snapshot.getDocuments().get(1)).get("docId")).isEqualTo((Object)this.getUniqueDocId("3"));
        Truth.assertThat((Double)((QueryDocumentSnapshot)snapshot.getDocuments().get(1)).getDouble("foo")).isEqualTo((Object)1);
    }

    @Test
    public void queryWithDistanceResultFieldAndDistanceThresholdWithFirestoreTypes() throws Exception {
        CollectionReference collection = this.testCollectionWithDocs(LocalFirestoreHelper.map("1", LocalFirestoreHelper.map("foo", "bar", new Object[0]), "2", LocalFirestoreHelper.map("foo", "bar", "embedding", FieldValue.vector((double[])new double[]{2.0, 0.0})), "3", LocalFirestoreHelper.map("foo", "bar", "embedding", FieldValue.vector((double[])new double[]{1.0, 100.0})), "4", LocalFirestoreHelper.map("foo", "bar", "embedding", FieldValue.vector((double[])new double[]{-20.0, 0.0})), "5", LocalFirestoreHelper.map("foo", "bar", "embedding", FieldValue.vector((double[])new double[]{0.1, 4.0}))));
        VectorQuery vectorQuery = collection.whereEqualTo("testId", (Object)this.getUniqueTestId()).findNearest(FieldPath.of((String[])new String[]{"embedding"}), FieldValue.vector((double[])new double[]{1.0, 0.0}), 5, VectorQuery.DistanceMeasure.DOT_PRODUCT, VectorQueryOptions.newBuilder().setDistanceThreshold(Double.valueOf(0.11)).setDistanceResultField("foo").build());
        VectorQuerySnapshot snapshot = (VectorQuerySnapshot)vectorQuery.get().get();
        Truth.assertThat((Integer)snapshot.size()).isEqualTo((Object)2);
        Truth.assertThat((Object)((QueryDocumentSnapshot)snapshot.getDocuments().get(0)).get("docId")).isEqualTo((Object)this.getUniqueDocId("2"));
        Truth.assertThat((Double)((QueryDocumentSnapshot)snapshot.getDocuments().get(0)).getDouble("foo")).isEqualTo((Object)2);
        Truth.assertThat((Object)((QueryDocumentSnapshot)snapshot.getDocuments().get(1)).get("docId")).isEqualTo((Object)this.getUniqueDocId("3"));
        Truth.assertThat((Double)((QueryDocumentSnapshot)snapshot.getDocuments().get(1)).getDouble("foo")).isEqualTo((Object)1);
    }

    @Test
    public void willNotExceedLimitEvenIfThereAreMoreResultsMoreSimilarThanDistanceThreshold() throws Exception {
        CollectionReference collection = this.testCollectionWithDocs(LocalFirestoreHelper.map("1", LocalFirestoreHelper.map("foo", "bar", new Object[0]), "2", LocalFirestoreHelper.map("foo", "bar", "embedding", FieldValue.vector((double[])new double[]{2.0, 0.0})), "3", LocalFirestoreHelper.map("foo", "bar", "embedding", FieldValue.vector((double[])new double[]{1.0, 100.0})), "4", LocalFirestoreHelper.map("foo", "bar", "embedding", FieldValue.vector((double[])new double[]{-20.0, 0.0})), "5", LocalFirestoreHelper.map("foo", "bar", "embedding", FieldValue.vector((double[])new double[]{0.1, 4.0}))));
        VectorQuery vectorQuery = collection.whereEqualTo("testId", (Object)this.getUniqueTestId()).findNearest("embedding", new double[]{1.0, 0.0}, 2, VectorQuery.DistanceMeasure.DOT_PRODUCT, VectorQueryOptions.newBuilder().setDistanceThreshold(Double.valueOf(0.0)).build());
        VectorQuerySnapshot snapshot = (VectorQuerySnapshot)vectorQuery.get().get();
        Truth.assertThat((Integer)snapshot.size()).isEqualTo((Object)2);
        Truth.assertThat((Object)((QueryDocumentSnapshot)snapshot.getDocuments().get(0)).get("docId")).isEqualTo((Object)this.getUniqueDocId("2"));
        Truth.assertThat((Object)((QueryDocumentSnapshot)snapshot.getDocuments().get(1)).get("docId")).isEqualTo((Object)this.getUniqueDocId("3"));
    }

    @Test
    public void testVectorQueryPlan() throws Exception {
        CollectionReference collection = this.testCollectionWithDocs(LocalFirestoreHelper.map("1", LocalFirestoreHelper.map("foo", "bar", new Object[0]), "2", LocalFirestoreHelper.map("foo", "bar", "embedding", FieldValue.vector((double[])new double[]{2.0, 0.0})), "3", LocalFirestoreHelper.map("foo", "bar", "embedding", FieldValue.vector((double[])new double[]{1.0, 100.0})), "4", LocalFirestoreHelper.map("foo", "bar", "embedding", FieldValue.vector((double[])new double[]{-20.0, 0.0})), "5", LocalFirestoreHelper.map("foo", "bar", "embedding", FieldValue.vector((double[])new double[]{0.1, 4.0}))));
        VectorQuery vectorQuery = collection.whereEqualTo("testId", (Object)this.getUniqueTestId()).findNearest("embedding", new double[]{1.0, 0.0}, 5, VectorQuery.DistanceMeasure.DOT_PRODUCT);
        ExplainResults explainResults = (ExplainResults)vectorQuery.explain(ExplainOptions.builder().setAnalyze(false).build()).get();
        VectorQuerySnapshot snapshot = (VectorQuerySnapshot)explainResults.getSnapshot();
        Truth.assertThat((Iterable)snapshot).isNull();
        ExplainMetrics metrics = explainResults.getMetrics();
        Truth.assertThat((Object)metrics).isNotNull();
        PlanSummary planSummary = metrics.getPlanSummary();
        Truth.assertThat((Object)planSummary).isNotNull();
        Truth.assertThat((Iterable)planSummary.getIndexesUsed()).isNotEmpty();
        ExecutionStats stats = metrics.getExecutionStats();
        Truth.assertThat((Object)stats).isNull();
    }

    @Test
    public void testVectorQueryProfile() throws Exception {
        CollectionReference collection = this.testCollectionWithDocs(LocalFirestoreHelper.map("1", LocalFirestoreHelper.map("foo", "bar", new Object[0]), "2", LocalFirestoreHelper.map("foo", "bar", "embedding", FieldValue.vector((double[])new double[]{2.0, 0.0})), "3", LocalFirestoreHelper.map("foo", "bar", "embedding", FieldValue.vector((double[])new double[]{1.0, 100.0})), "4", LocalFirestoreHelper.map("foo", "bar", "embedding", FieldValue.vector((double[])new double[]{-20.0, 0.0})), "5", LocalFirestoreHelper.map("foo", "bar", "embedding", FieldValue.vector((double[])new double[]{0.1, 4.0}))));
        VectorQuery vectorQuery = collection.whereEqualTo("testId", (Object)this.getUniqueTestId()).findNearest("embedding", new double[]{1.0, 0.0}, 5, VectorQuery.DistanceMeasure.DOT_PRODUCT);
        ExplainResults explainResults = (ExplainResults)vectorQuery.explain(ExplainOptions.builder().setAnalyze(true).build()).get();
        VectorQuerySnapshot snapshot = (VectorQuerySnapshot)explainResults.getSnapshot();
        Truth.assertThat((Iterable)snapshot).isNotNull();
        Truth.assertThat((Integer)snapshot.size()).isEqualTo((Object)4);
        ExplainMetrics metrics = explainResults.getMetrics();
        Truth.assertThat((Object)metrics).isNotNull();
        PlanSummary planSummary = metrics.getPlanSummary();
        Truth.assertThat((Object)planSummary).isNotNull();
        Truth.assertThat((Iterable)planSummary.getIndexesUsed()).isNotEmpty();
        ExecutionStats stats = metrics.getExecutionStats();
        Truth.assertThat((Object)stats).isNotNull();
        Truth.assertThat((Map)stats.getDebugStats()).isNotEmpty();
        Truth.assertThat((Long)stats.getReadOperations()).isEqualTo((Object)5);
        Truth.assertThat((Long)stats.getResultsReturned()).isEqualTo((Object)4);
        Truth.assertThat((Comparable)stats.getExecutionDuration()).isGreaterThan((Comparable)Duration.ZERO);
    }

    @Test
    public void vectorQuerySnapshotReturnsVectorQuery() throws Exception {
        CollectionReference collection = this.testCollectionWithDocs(LocalFirestoreHelper.map("a", LocalFirestoreHelper.map("foo", "bar", new Object[0]), "b", LocalFirestoreHelper.map("foo", "xxx", "embedding", FieldValue.vector((double[])new double[]{10.0, 10.0})), "c", LocalFirestoreHelper.map("foo", "bar", "embedding", FieldValue.vector((double[])new double[]{1.0, 1.0})), "d", LocalFirestoreHelper.map("foo", "bar", "embedding", FieldValue.vector((double[])new double[]{10.0, 0.0})), "e", LocalFirestoreHelper.map("foo", "bar", "embedding", FieldValue.vector((double[])new double[]{20.0, 0.0})), "f", LocalFirestoreHelper.map("foo", "bar", "embedding", FieldValue.vector((double[])new double[]{100.0, 100.0}))));
        VectorQuery vectorQuery = collection.whereEqualTo("foo", (Object)"bar").whereEqualTo("testId", (Object)this.getUniqueTestId()).findNearest("embedding", new double[]{10.0, 10.0}, 3, VectorQuery.DistanceMeasure.EUCLIDEAN);
        VectorQuerySnapshot snapshot = (VectorQuerySnapshot)vectorQuery.get().get();
        Assert.assertTrue((snapshot.getQuery() == vectorQuery ? 1 : 0) != 0);
    }
}

