/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore.it;

import com.google.api.core.ApiFuture;
import com.google.api.gax.rpc.ApiStreamObserver;
import com.google.cloud.firestore.AggregateQuery;
import com.google.cloud.firestore.AggregateQuerySnapshot;
import com.google.cloud.firestore.CollectionReference;
import com.google.cloud.firestore.DocumentSnapshot;
import com.google.cloud.firestore.ExecutionStats;
import com.google.cloud.firestore.ExplainMetrics;
import com.google.cloud.firestore.ExplainOptions;
import com.google.cloud.firestore.ExplainResults;
import com.google.cloud.firestore.FieldPath;
import com.google.cloud.firestore.Filter;
import com.google.cloud.firestore.LocalFirestoreHelper;
import com.google.cloud.firestore.PlanSummary;
import com.google.cloud.firestore.Query;
import com.google.cloud.firestore.QuerySnapshot;
import com.google.cloud.firestore.it.ITBaseTest;
import com.google.cloud.firestore.it.TestHelper;
import com.google.common.primitives.Ints;
import com.google.common.truth.Truth;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ITQueryTest
extends ITBaseTest {
    @Rule
    public TestName testName = new TestName();

    private CollectionReference createEmptyCollection() {
        String collectionPath = "java-" + this.testName.getMethodName() + "-" + LocalFirestoreHelper.autoId();
        return this.firestore.collection(collectionPath);
    }

    public static <T> Map<String, T> map(Object ... entries) {
        LinkedHashMap<String, Object> res = new LinkedHashMap<String, Object>();
        for (int i = 0; i < entries.length; i += 2) {
            res.put((String)entries[i], entries[i + 1]);
        }
        return res;
    }

    public CollectionReference testCollectionWithDocs(Map<String, Map<String, Object>> docs) throws ExecutionException, InterruptedException, TimeoutException {
        CollectionReference collection = this.firestore.collection(LocalFirestoreHelper.autoId());
        for (Map.Entry<String, Map<String, Object>> doc : docs.entrySet()) {
            collection.document(doc.getKey()).set(doc.getValue()).get(5L, TimeUnit.SECONDS);
        }
        return collection;
    }

    public static void checkQuerySnapshotContainsDocuments(Query query, String ... docs) throws ExecutionException, InterruptedException {
        QuerySnapshot snapshot = (QuerySnapshot)query.get().get();
        List result = snapshot.getDocuments().stream().map(queryDocumentSnapshot -> queryDocumentSnapshot.getReference().getId()).collect(Collectors.toList());
        Truth.assertThat(result).isEqualTo(Arrays.asList(docs));
    }

    @Test
    public void orQueries() throws Exception {
        Map<String, Map<String, Object>> testDocs = ITQueryTest.map("doc1", ITQueryTest.map("a", 1, "b", 0), "doc2", ITQueryTest.map("a", 2, "b", 1), "doc3", ITQueryTest.map("a", 3, "b", 2), "doc4", ITQueryTest.map("a", 1, "b", 3), "doc5", ITQueryTest.map("a", 1, "b", 1));
        CollectionReference collection = this.testCollectionWithDocs(testDocs);
        ITQueryTest.checkQuerySnapshotContainsDocuments(collection.where(Filter.or((Filter[])new Filter[]{Filter.equalTo((String)"a", (Object)1), Filter.equalTo((String)"b", (Object)1)})), "doc1", "doc2", "doc4", "doc5");
        ITQueryTest.checkQuerySnapshotContainsDocuments(collection.where(Filter.or((Filter[])new Filter[]{Filter.and((Filter[])new Filter[]{Filter.equalTo((String)"a", (Object)1), Filter.equalTo((String)"b", (Object)0)}), Filter.and((Filter[])new Filter[]{Filter.equalTo((String)"a", (Object)3), Filter.equalTo((String)"b", (Object)2)})})), "doc1", "doc3");
        ITQueryTest.checkQuerySnapshotContainsDocuments(collection.where(Filter.and((Filter[])new Filter[]{Filter.equalTo((String)"a", (Object)1), Filter.or((Filter[])new Filter[]{Filter.equalTo((String)"b", (Object)0), Filter.equalTo((String)"b", (Object)3)})})), "doc1", "doc4");
        ITQueryTest.checkQuerySnapshotContainsDocuments(collection.where(Filter.and((Filter[])new Filter[]{Filter.or((Filter[])new Filter[]{Filter.equalTo((String)"a", (Object)2), Filter.equalTo((String)"b", (Object)2)}), Filter.or((Filter[])new Filter[]{Filter.equalTo((String)"a", (Object)3), Filter.equalTo((String)"b", (Object)3)})})), "doc3");
        ITQueryTest.checkQuerySnapshotContainsDocuments(collection.where(Filter.or((Filter[])new Filter[]{Filter.equalTo((String)"a", (Object)2), Filter.equalTo((String)"b", (Object)1)})).limit(1), "doc2");
    }

    @Test
    public void orQueriesWithCompositeIndexes() throws Exception {
        Assume.assumeTrue((String)"Skip this test when running against production because these queries require a composite index.", (boolean)TestHelper.isRunningAgainstFirestoreEmulator(this.firestore));
        Map<String, Map<String, Object>> testDocs = ITQueryTest.map("doc1", ITQueryTest.map("a", 1, "b", 0), "doc2", ITQueryTest.map("a", 2, "b", 1), "doc3", ITQueryTest.map("a", 3, "b", 2), "doc4", ITQueryTest.map("a", 1, "b", 3), "doc5", ITQueryTest.map("a", 1, "b", 1));
        CollectionReference collection = this.testCollectionWithDocs(testDocs);
        ITQueryTest.checkQuerySnapshotContainsDocuments(collection.where(Filter.or((Filter[])new Filter[]{Filter.greaterThan((String)"a", (Object)2), Filter.equalTo((String)"b", (Object)1)})), "doc5", "doc2", "doc3");
        ITQueryTest.checkQuerySnapshotContainsDocuments(collection.where(Filter.or((Filter[])new Filter[]{Filter.equalTo((String)"a", (Object)1), Filter.greaterThan((String)"b", (Object)0)})).limit(2), "doc1", "doc2");
        ITQueryTest.checkQuerySnapshotContainsDocuments(collection.where(Filter.or((Filter[])new Filter[]{Filter.equalTo((String)"a", (Object)1), Filter.greaterThan((String)"b", (Object)0)})).limitToLast(2).orderBy("b"), "doc3", "doc4");
        ITQueryTest.checkQuerySnapshotContainsDocuments(collection.where(Filter.or((Filter[])new Filter[]{Filter.equalTo((String)"a", (Object)2), Filter.equalTo((String)"b", (Object)1)})).limit(1).orderBy("a"), "doc5");
        ITQueryTest.checkQuerySnapshotContainsDocuments(collection.where(Filter.or((Filter[])new Filter[]{Filter.equalTo((String)"a", (Object)2), Filter.equalTo((String)"b", (Object)1)})).limitToLast(1).orderBy("a"), "doc2");
        ITQueryTest.checkQuerySnapshotContainsDocuments(collection.where(Filter.or((Filter[])new Filter[]{Filter.equalTo((String)"a", (Object)2), Filter.equalTo((String)"b", (Object)1)})).limit(1).orderBy("a", Query.Direction.DESCENDING), "doc2");
    }

    @Test
    public void orQueryDoesNotIncludeDocumentsWithMissingFields() throws Exception {
        Map<String, Map<String, Object>> testDocs = ITQueryTest.map("doc1", ITQueryTest.map("a", 1, "b", 0), "doc2", ITQueryTest.map("b", 1), "doc3", ITQueryTest.map("a", 3, "b", 2), "doc4", ITQueryTest.map("a", 1, "b", 3), "doc5", ITQueryTest.map("a", 1), "doc6", ITQueryTest.map("a", 2));
        CollectionReference collection = this.testCollectionWithDocs(testDocs);
        Query query = collection.where(Filter.or((Filter[])new Filter[]{Filter.equalTo((String)"a", (Object)1), Filter.equalTo((String)"b", (Object)1)}));
        ITQueryTest.checkQuerySnapshotContainsDocuments(query, "doc1", "doc2", "doc4", "doc5");
    }

    @Test
    public void orQueryDoesNotIncludeDocumentsWithMissingFields2() throws Exception {
        Assume.assumeTrue((String)"Skip this test when running against production because these queries require a composite index.", (boolean)TestHelper.isRunningAgainstFirestoreEmulator(this.firestore));
        Map<String, Map<String, Object>> testDocs = ITQueryTest.map("doc1", ITQueryTest.map("a", 1, "b", 0), "doc2", ITQueryTest.map("b", 1), "doc3", ITQueryTest.map("a", 3, "b", 2), "doc4", ITQueryTest.map("a", 1, "b", 3), "doc5", ITQueryTest.map("a", 1), "doc6", ITQueryTest.map("a", 2));
        CollectionReference collection = this.testCollectionWithDocs(testDocs);
        Query query1 = collection.where(Filter.or((Filter[])new Filter[]{Filter.equalTo((String)"a", (Object)1), Filter.equalTo((String)"b", (Object)1)})).orderBy("a");
        ITQueryTest.checkQuerySnapshotContainsDocuments(query1, "doc1", "doc4", "doc5");
        Query query2 = collection.where(Filter.or((Filter[])new Filter[]{Filter.equalTo((String)"a", (Object)1), Filter.equalTo((String)"b", (Object)1)})).orderBy("b");
        ITQueryTest.checkQuerySnapshotContainsDocuments(query2, "doc1", "doc2", "doc4");
        Query query3 = collection.where(Filter.or((Filter[])new Filter[]{Filter.greaterThan((String)"a", (Object)2), Filter.equalTo((String)"b", (Object)1)}));
        ITQueryTest.checkQuerySnapshotContainsDocuments(query3, "doc3");
        Query query4 = collection.where(Filter.or((Filter[])new Filter[]{Filter.greaterThan((String)"a", (Object)1), Filter.equalTo((String)"b", (Object)1)})).orderBy("a").orderBy("b");
        ITQueryTest.checkQuerySnapshotContainsDocuments(query4, "doc3");
    }

    @Test
    public void orQueriesWithIn() throws ExecutionException, InterruptedException, TimeoutException {
        Map<String, Map<String, Object>> testDocs = ITQueryTest.map("doc1", ITQueryTest.map("a", 1, "b", 0), "doc2", ITQueryTest.map("b", 1), "doc3", ITQueryTest.map("a", 3, "b", 2), "doc4", ITQueryTest.map("a", 1, "b", 3), "doc5", ITQueryTest.map("a", 1), "doc6", ITQueryTest.map("a", 2));
        CollectionReference collection = this.testCollectionWithDocs(testDocs);
        ITQueryTest.checkQuerySnapshotContainsDocuments(collection.where(Filter.or((Filter[])new Filter[]{Filter.equalTo((String)"a", (Object)2), Filter.inArray((String)"b", (Object)Ints.asList((int[])new int[]{2, 3}))})), "doc3", "doc4", "doc6");
    }

    @Test
    public void orQueriesWithNotIn() throws ExecutionException, InterruptedException, TimeoutException {
        Assume.assumeTrue((String)"Skip this test when running against production because it is currently not supported.", (boolean)TestHelper.isRunningAgainstFirestoreEmulator(this.firestore));
        Map<String, Map<String, Object>> testDocs = ITQueryTest.map("doc1", ITQueryTest.map("a", 1, "b", 0), "doc2", ITQueryTest.map("b", 1), "doc3", ITQueryTest.map("a", 3, "b", 2), "doc4", ITQueryTest.map("a", 1, "b", 3), "doc5", ITQueryTest.map("a", 1), "doc6", ITQueryTest.map("a", 2));
        CollectionReference collection = this.testCollectionWithDocs(testDocs);
        ITQueryTest.checkQuerySnapshotContainsDocuments(collection.where(Filter.or((Filter[])new Filter[]{Filter.equalTo((String)"a", (Object)2), Filter.notInArray((String)"b", (Object)Ints.asList((int[])new int[]{2, 3}))})), "doc1", "doc2");
    }

    @Test
    public void orQueriesWithArrayMembership() throws ExecutionException, InterruptedException, TimeoutException {
        Map<String, Map<String, Object>> testDocs = ITQueryTest.map("doc1", ITQueryTest.map("a", 1, "b", Ints.asList((int[])new int[]{0})), "doc2", ITQueryTest.map("b", Ints.asList((int[])new int[]{1})), "doc3", ITQueryTest.map("a", 3, "b", Ints.asList((int[])new int[]{2, 7})), "doc4", ITQueryTest.map("a", 1, "b", Ints.asList((int[])new int[]{3, 7})), "doc5", ITQueryTest.map("a", 1), "doc6", ITQueryTest.map("a", 2));
        CollectionReference collection = this.testCollectionWithDocs(testDocs);
        ITQueryTest.checkQuerySnapshotContainsDocuments(collection.where(Filter.or((Filter[])new Filter[]{Filter.equalTo((String)"a", (Object)2), Filter.arrayContains((String)"b", (Object)7)})), "doc3", "doc4", "doc6");
        ITQueryTest.checkQuerySnapshotContainsDocuments(collection.where(Filter.or((Filter[])new Filter[]{Filter.equalTo((String)"a", (Object)2), Filter.arrayContainsAny((String)"b", (Object)Ints.asList((int[])new int[]{0, 3}))})), "doc1", "doc4", "doc6");
    }

    @Test
    public void testUsingInWithArrayContains() throws ExecutionException, InterruptedException, TimeoutException {
        Map<String, Map<String, Object>> testDocs = ITQueryTest.map("doc1", ITQueryTest.map("a", 1, "b", Ints.asList((int[])new int[]{0})), "doc2", ITQueryTest.map("b", Ints.asList((int[])new int[]{1})), "doc3", ITQueryTest.map("a", 3, "b", Ints.asList((int[])new int[]{2, 7})), "doc4", ITQueryTest.map("a", 1, "b", Ints.asList((int[])new int[]{3, 7})), "doc5", ITQueryTest.map("a", 1), "doc6", ITQueryTest.map("a", 2));
        CollectionReference collection = this.testCollectionWithDocs(testDocs);
        Query query1 = collection.where(Filter.or((Filter[])new Filter[]{Filter.inArray((String)"a", (Object)Ints.asList((int[])new int[]{2, 3})), Filter.arrayContains((String)"b", (Object)3)}));
        ITQueryTest.checkQuerySnapshotContainsDocuments(query1, "doc3", "doc4", "doc6");
        Query query2 = collection.where(Filter.and((Filter[])new Filter[]{Filter.inArray((String)"a", (Object)Ints.asList((int[])new int[]{2, 3})), Filter.arrayContains((String)"b", (Object)7)}));
        ITQueryTest.checkQuerySnapshotContainsDocuments(query2, "doc3");
        Query query3 = collection.where(Filter.or((Filter[])new Filter[]{Filter.inArray((String)"a", (Object)Ints.asList((int[])new int[]{2, 3})), Filter.and((Filter[])new Filter[]{Filter.arrayContains((String)"b", (Object)3), Filter.equalTo((String)"a", (Object)1)})}));
        ITQueryTest.checkQuerySnapshotContainsDocuments(query3, "doc3", "doc4", "doc6");
        Query query4 = collection.where(Filter.and((Filter[])new Filter[]{Filter.inArray((String)"a", (Object)Ints.asList((int[])new int[]{2, 3})), Filter.or((Filter[])new Filter[]{Filter.arrayContains((String)"b", (Object)7), Filter.equalTo((String)"a", (Object)1)})}));
        ITQueryTest.checkQuerySnapshotContainsDocuments(query4, "doc3");
    }

    @Test
    public void testOrderByEquality() throws ExecutionException, InterruptedException, TimeoutException {
        Assume.assumeTrue((String)"Skip this test if running against production because order-by-equality is not supported yet.", (boolean)TestHelper.isRunningAgainstFirestoreEmulator(this.firestore));
        Map<String, Map<String, Object>> testDocs = ITQueryTest.map("doc1", ITQueryTest.map("a", 1, "b", Ints.asList((int[])new int[]{0})), "doc2", ITQueryTest.map("b", Ints.asList((int[])new int[]{1})), "doc3", ITQueryTest.map("a", 3, "b", Ints.asList((int[])new int[]{2, 7}), "c", 10), "doc4", ITQueryTest.map("a", 1, "b", Ints.asList((int[])new int[]{3, 7})), "doc5", ITQueryTest.map("a", 1), "doc6", ITQueryTest.map("a", 2, "c", 20));
        CollectionReference collection = this.testCollectionWithDocs(testDocs);
        Query query1 = collection.where(Filter.equalTo((String)"a", (Object)1)).orderBy("a");
        ITQueryTest.checkQuerySnapshotContainsDocuments(query1, "doc1", "doc4", "doc5");
        Query query2 = collection.where(Filter.inArray((String)"a", (Object)Ints.asList((int[])new int[]{2, 3}))).orderBy("a");
        ITQueryTest.checkQuerySnapshotContainsDocuments(query2, "doc6", "doc3");
    }

    @Test
    public void multipleInequalityOnDifferentFields() throws Exception {
        Assume.assumeTrue((String)"Skip this test if running against production because multiple inequality is not supported yet.", (boolean)TestHelper.isRunningAgainstFirestoreEmulator(this.firestore));
        CollectionReference collection = this.testCollectionWithDocs(ITQueryTest.map("doc1", ITQueryTest.map("key", "a", "sort", 0, "v", 0), "doc2", ITQueryTest.map("key", "b", "sort", 3, "v", 1), "doc3", ITQueryTest.map("key", "c", "sort", 1, "v", 3), "doc4", ITQueryTest.map("key", "d", "sort", 2, "v", 2)));
        Query query1 = collection.whereNotEqualTo("key", (Object)"a").whereLessThanOrEqualTo("sort", (Object)2).whereGreaterThan("v", (Object)2);
        ITQueryTest.checkQuerySnapshotContainsDocuments(query1, "doc3");
        Query query2 = collection.whereNotEqualTo("key", (Object)"a").whereLessThanOrEqualTo("sort", (Object)2).whereGreaterThan("sort", (Object)1);
        ITQueryTest.checkQuerySnapshotContainsDocuments(query2, "doc4");
        Query query3 = collection.whereGreaterThanOrEqualTo("key", (Object)"a").whereLessThanOrEqualTo("sort", (Object)2).whereIn("v", Ints.asList((int[])new int[]{2, 3, 4})).whereIn("sort", Ints.asList((int[])new int[]{2, 3}));
        ITQueryTest.checkQuerySnapshotContainsDocuments(query3, "doc4");
        Query query4 = collection.whereGreaterThanOrEqualTo("key", (Object)"a").whereLessThanOrEqualTo("sort", (Object)2).whereNotIn("v", Ints.asList((int[])new int[]{2, 4, 5}));
        ITQueryTest.checkQuerySnapshotContainsDocuments(query4, "doc1", "doc3");
        Query query5 = collection.whereGreaterThanOrEqualTo("key", (Object)"a").whereLessThanOrEqualTo("sort", (Object)2).orderBy("v", Query.Direction.DESCENDING);
        ITQueryTest.checkQuerySnapshotContainsDocuments(query5, "doc3", "doc4", "doc1");
        Query query6 = collection.whereGreaterThanOrEqualTo("key", (Object)"a").whereLessThanOrEqualTo("sort", (Object)2).orderBy("v", Query.Direction.DESCENDING).limit(2);
        ITQueryTest.checkQuerySnapshotContainsDocuments(query6, "doc3", "doc4");
        Query query7 = collection.whereGreaterThanOrEqualTo("key", (Object)"a").whereLessThanOrEqualTo("sort", (Object)2).orderBy("v", Query.Direction.DESCENDING).limitToLast(2);
        ITQueryTest.checkQuerySnapshotContainsDocuments(query7, "doc4", "doc1");
    }

    @Test
    public void multipleInequalityOnSpecialValues() throws Exception {
        Assume.assumeTrue((String)"Skip this test if running against production because multiple inequality is not supported yet.", (boolean)TestHelper.isRunningAgainstFirestoreEmulator(this.firestore));
        CollectionReference collection = this.testCollectionWithDocs(ITQueryTest.map("doc1", ITQueryTest.map("key", "a", "sort", 0, "v", 0), "doc2", ITQueryTest.map("key", "b", "sort", Double.NaN, "v", 1), "doc3", ITQueryTest.map("key", "c", "sort", null, "v", 3), "doc4", ITQueryTest.map("key", "d", "v", 2), "doc5", ITQueryTest.map("key", "e", "sort", 0), "doc6", ITQueryTest.map("key", "f", "sort", 1, "v", 1)));
        Query query1 = collection.whereNotEqualTo("key", (Object)"a").whereLessThanOrEqualTo("sort", (Object)2);
        ITQueryTest.checkQuerySnapshotContainsDocuments(query1, "doc5", "doc6");
        Query query2 = collection.whereNotEqualTo("key", (Object)"a").whereLessThanOrEqualTo("sort", (Object)2).whereLessThanOrEqualTo("v", (Object)1);
        ITQueryTest.checkQuerySnapshotContainsDocuments(query2, "doc6");
    }

    @Test
    public void multipleInequalityWithArrayMembership() throws Exception {
        Assume.assumeTrue((String)"Skip this test if running against production because multiple inequality is not supported yet.", (boolean)TestHelper.isRunningAgainstFirestoreEmulator(this.firestore));
        CollectionReference collection = this.testCollectionWithDocs(ITQueryTest.map("doc1", ITQueryTest.map("key", "a", "sort", 0, "v", Ints.asList((int[])new int[]{0})), "doc2", ITQueryTest.map("key", "b", "sort", 1, "v", Ints.asList((int[])new int[]{0, 1, 3})), "doc3", ITQueryTest.map("key", "c", "sort", 1, "v", Ints.asList((int[])new int[0])), "doc4", ITQueryTest.map("key", "d", "sort", 2, "v", Ints.asList((int[])new int[]{1})), "doc5", ITQueryTest.map("key", "e", "sort", 3, "v", Ints.asList((int[])new int[]{2, 4})), "doc6", ITQueryTest.map("key", "f", "sort", 4, "v", Arrays.asList(Double.NaN)), "doc7", ITQueryTest.map("key", "g", "sort", 4, "v", Collections.singletonList(null))));
        Query query1 = collection.whereNotEqualTo("key", (Object)"a").whereGreaterThanOrEqualTo("sort", (Object)1).whereArrayContains("v", (Object)0);
        ITQueryTest.checkQuerySnapshotContainsDocuments(query1, "doc2");
        Query query2 = collection.whereNotEqualTo("key", (Object)"a").whereGreaterThanOrEqualTo("sort", (Object)1).whereArrayContainsAny("v", Ints.asList((int[])new int[]{0, 1}));
        ITQueryTest.checkQuerySnapshotContainsDocuments(query2, "doc2", "doc4");
    }

    private static Map<String, Object> nestedObject(int number) {
        return ITQueryTest.map("name", String.format("room %d", number), "metadata", ITQueryTest.map("createdAt", number), "field", String.format("field %d", number), "field.dot", number, "field\\slash", number);
    }

    @Test
    public void multipleInequalityWithNestedField() throws Exception {
        Assume.assumeTrue((String)"Skip this test if running against production because multiple inequality is not supported yet.", (boolean)TestHelper.isRunningAgainstFirestoreEmulator(this.firestore));
        CollectionReference collection = this.testCollectionWithDocs(ITQueryTest.map("doc1", ITQueryTest.nestedObject(400), "doc2", ITQueryTest.nestedObject(200), "doc3", ITQueryTest.nestedObject(100), "doc4", ITQueryTest.nestedObject(300)));
        Query query1 = collection.whereLessThanOrEqualTo("metadata.createdAt", (Object)500).whereGreaterThan("metadata.createdAt", (Object)100).whereNotEqualTo("name", (Object)"room 200").orderBy("name");
        DocumentSnapshot docSnap = (DocumentSnapshot)collection.document("doc4").get().get();
        Query query1WithCursor = query1.startAt(docSnap);
        ITQueryTest.checkQuerySnapshotContainsDocuments(query1, "doc4", "doc1");
        ITQueryTest.checkQuerySnapshotContainsDocuments(query1WithCursor, "doc4", "doc1");
        Query query2 = collection.whereGreaterThanOrEqualTo("field", (Object)"field 100").whereNotEqualTo(FieldPath.of((String[])new String[]{"field.dot"}), (Object)300).whereLessThan("field\\slash", (Object)400).orderBy("name", Query.Direction.DESCENDING);
        docSnap = (DocumentSnapshot)collection.document("doc2").get().get();
        Query query2WithCursor = query2.startAt(docSnap);
        ITQueryTest.checkQuerySnapshotContainsDocuments(query2, "doc2", "doc3");
        ITQueryTest.checkQuerySnapshotContainsDocuments(query2WithCursor, "doc2", "doc3");
    }

    @Test
    public void multipleInequalityWithCompositeFilters() throws Exception {
        Assume.assumeTrue((String)"Skip this test if running against production because multiple inequality is not supported yet.", (boolean)TestHelper.isRunningAgainstFirestoreEmulator(this.firestore));
        CollectionReference collection = this.testCollectionWithDocs(ITQueryTest.map("doc1", ITQueryTest.map("key", "a", "sort", 0, "v", 5), "doc2", ITQueryTest.map("key", "aa", "sort", 4, "v", 4), "doc3", ITQueryTest.map("key", "c", "sort", 3, "v", 3), "doc4", ITQueryTest.map("key", "b", "sort", 2, "v", 2), "doc5", ITQueryTest.map("key", "b", "sort", 2, "v", 1), "doc6", ITQueryTest.map("key", "b", "sort", 0, "v", 0)));
        Query query1 = collection.where(Filter.or((Filter[])new Filter[]{Filter.and((Filter[])new Filter[]{Filter.equalTo((String)"key", (Object)"b"), Filter.lessThanOrEqualTo((String)"sort", (Object)2)}), Filter.and((Filter[])new Filter[]{Filter.notEqualTo((String)"key", (Object)"b"), Filter.greaterThan((String)"v", (Object)4)})}));
        DocumentSnapshot docSnap = (DocumentSnapshot)collection.document("doc1").get().get();
        Query query1WithCursor = query1.startAt(docSnap);
        ITQueryTest.checkQuerySnapshotContainsDocuments(query1, "doc1", "doc6", "doc5", "doc4");
        ITQueryTest.checkQuerySnapshotContainsDocuments(query1WithCursor, "doc1", "doc6", "doc5", "doc4");
        Query query2 = collection.where(Filter.or((Filter[])new Filter[]{Filter.and((Filter[])new Filter[]{Filter.equalTo((String)"key", (Object)"b"), Filter.lessThanOrEqualTo((String)"sort", (Object)2)}), Filter.and((Filter[])new Filter[]{Filter.notEqualTo((String)"key", (Object)"b"), Filter.greaterThan((String)"v", (Object)4)})})).orderBy("sort", Query.Direction.DESCENDING).orderBy("key");
        docSnap = (DocumentSnapshot)collection.document("doc5").get().get();
        Query query2WithCursor = query2.startAt(docSnap);
        ITQueryTest.checkQuerySnapshotContainsDocuments(query2, "doc5", "doc4", "doc1", "doc6");
        ITQueryTest.checkQuerySnapshotContainsDocuments(query2WithCursor, "doc5", "doc4", "doc1", "doc6");
        Query query3 = collection.where(Filter.and((Filter[])new Filter[]{Filter.or((Filter[])new Filter[]{Filter.and((Filter[])new Filter[]{Filter.equalTo((String)"key", (Object)"b"), Filter.lessThanOrEqualTo((String)"sort", (Object)4)}), Filter.and((Filter[])new Filter[]{Filter.notEqualTo((String)"key", (Object)"b"), Filter.greaterThanOrEqualTo((String)"v", (Object)4)})}), Filter.or((Filter[])new Filter[]{Filter.and((Filter[])new Filter[]{Filter.greaterThan((String)"key", (Object)"b"), Filter.greaterThanOrEqualTo((String)"sort", (Object)1)}), Filter.and((Filter[])new Filter[]{Filter.lessThan((String)"key", (Object)"b"), Filter.greaterThan((String)"v", (Object)0)})})}));
        docSnap = (DocumentSnapshot)collection.document("doc1").get().get();
        Query query3WithCursor = query3.startAt(docSnap);
        ITQueryTest.checkQuerySnapshotContainsDocuments(query3, "doc1", "doc2");
        ITQueryTest.checkQuerySnapshotContainsDocuments(query3WithCursor, "doc1", "doc2");
    }

    @Test
    public void multipleInequalityFieldsWillBeImplicitlyOrderedLexicographicallyByServer() throws Exception {
        Assume.assumeTrue((String)"Skip this test if running against production because multiple inequality is not supported yet.", (boolean)TestHelper.isRunningAgainstFirestoreEmulator(this.firestore));
        CollectionReference collection = this.testCollectionWithDocs(ITQueryTest.map("doc1", ITQueryTest.map("key", "a", "sort", 0, "v", 5), "doc2", ITQueryTest.map("key", "aa", "sort", 4, "v", 4), "doc3", ITQueryTest.map("key", "b", "sort", 3, "v", 3), "doc4", ITQueryTest.map("key", "b", "sort", 2, "v", 2), "doc5", ITQueryTest.map("key", "b", "sort", 2, "v", 1), "doc6", ITQueryTest.map("key", "b", "sort", 0, "v", 0)));
        DocumentSnapshot docSnap = (DocumentSnapshot)collection.document("doc2").get().get();
        Query query1 = collection.whereNotEqualTo("key", (Object)"a").whereGreaterThan("sort", (Object)1).whereIn("v", Ints.asList((int[])new int[]{1, 2, 3, 4}));
        Query query1WithCursor = query1.startAt(docSnap);
        ITQueryTest.checkQuerySnapshotContainsDocuments(query1, "doc2", "doc4", "doc5", "doc3");
        ITQueryTest.checkQuerySnapshotContainsDocuments(query1WithCursor, "doc2", "doc4", "doc5", "doc3");
        Query query2 = collection.whereGreaterThan("sort", (Object)1).whereNotEqualTo("key", (Object)"a").whereIn("v", Ints.asList((int[])new int[]{1, 2, 3, 4}));
        Query query2WithCursor = query2.startAt(docSnap);
        ITQueryTest.checkQuerySnapshotContainsDocuments(query2, "doc2", "doc4", "doc5", "doc3");
        ITQueryTest.checkQuerySnapshotContainsDocuments(query2WithCursor, "doc2", "doc4", "doc5", "doc3");
    }

    @Test
    public void multipleInequalityWithMultipleExplicitOrderBy() throws Exception {
        Assume.assumeTrue((String)"Skip this test if running against production because multiple inequality is not supported yet.", (boolean)TestHelper.isRunningAgainstFirestoreEmulator(this.firestore));
        CollectionReference collection = this.testCollectionWithDocs(ITQueryTest.map("doc1", ITQueryTest.map("key", "a", "sort", 5, "v", 0), "doc2", ITQueryTest.map("key", "aa", "sort", 4, "v", 0), "doc3", ITQueryTest.map("key", "b", "sort", 3, "v", 1), "doc4", ITQueryTest.map("key", "b", "sort", 2, "v", 1), "doc5", ITQueryTest.map("key", "bb", "sort", 1, "v", 1), "doc6", ITQueryTest.map("key", "c", "sort", 0, "v", 2)));
        DocumentSnapshot docSnap = (DocumentSnapshot)collection.document("doc2").get().get();
        Query query1 = collection.whereGreaterThan("key", (Object)"a").whereGreaterThanOrEqualTo("sort", (Object)1).orderBy("v");
        Query query1WithCursor = query1.startAt(docSnap);
        ITQueryTest.checkQuerySnapshotContainsDocuments(query1, "doc2", "doc4", "doc3", "doc5");
        ITQueryTest.checkQuerySnapshotContainsDocuments(query1WithCursor, "doc2", "doc4", "doc3", "doc5");
        Query query2 = collection.whereGreaterThan("key", (Object)"a").whereGreaterThanOrEqualTo("sort", (Object)1).orderBy("v").orderBy("sort");
        Query query2WithCursor = query2.startAt(docSnap);
        ITQueryTest.checkQuerySnapshotContainsDocuments(query2, "doc2", "doc5", "doc4", "doc3");
        ITQueryTest.checkQuerySnapshotContainsDocuments(query2WithCursor, "doc2", "doc5", "doc4", "doc3");
        docSnap = (DocumentSnapshot)collection.document("doc5").get().get();
        Query query3 = collection.whereGreaterThan("key", (Object)"a").whereGreaterThanOrEqualTo("sort", (Object)1).orderBy("v", Query.Direction.DESCENDING);
        Query query3WithCursor = query3.startAt(docSnap);
        ITQueryTest.checkQuerySnapshotContainsDocuments(query3, "doc5", "doc3", "doc4", "doc2");
        ITQueryTest.checkQuerySnapshotContainsDocuments(query3WithCursor, "doc5", "doc3", "doc4", "doc2");
        Query query4 = collection.whereGreaterThan("key", (Object)"a").whereGreaterThanOrEqualTo("sort", (Object)1).orderBy("v", Query.Direction.DESCENDING).orderBy("sort");
        Query query4WithCursor = query4.startAt(docSnap);
        ITQueryTest.checkQuerySnapshotContainsDocuments(query4, "doc5", "doc4", "doc3", "doc2");
        ITQueryTest.checkQuerySnapshotContainsDocuments(query4WithCursor, "doc5", "doc4", "doc3", "doc2");
    }

    @Test
    public void multipleInequalityFieldsInAggregateQuery() throws Exception {
        Assume.assumeTrue((String)"Skip this test if running against production because multiple inequality is not supported yet.", (boolean)TestHelper.isRunningAgainstFirestoreEmulator(this.firestore));
        CollectionReference collection = this.testCollectionWithDocs(ITQueryTest.map("doc1", ITQueryTest.map("key", "a", "sort", 5, "v", 0), "doc2", ITQueryTest.map("key", "aa", "sort", 4, "v", 0), "doc3", ITQueryTest.map("key", "b", "sort", 3, "v", 1), "doc4", ITQueryTest.map("key", "b", "sort", 2, "v", 1), "doc5", ITQueryTest.map("key", "bb", "sort", 1, "v", 1)));
        AggregateQuery query = collection.whereGreaterThan("key", (Object)"a").whereGreaterThanOrEqualTo("sort", (Object)1).orderBy("v").count();
        Truth.assertThat((Long)((AggregateQuerySnapshot)query.get().get()).getCount()).isEqualTo((Object)4);
    }

    @Test
    public void multipleInequalityFieldsWithDocumentKey() throws Exception {
        Assume.assumeTrue((String)"Skip this test if running against production because multiple inequality is not supported yet.", (boolean)TestHelper.isRunningAgainstFirestoreEmulator(this.firestore));
        CollectionReference collection = this.testCollectionWithDocs(ITQueryTest.map("doc1", ITQueryTest.map("key", "a", "sort", 5), "doc2", ITQueryTest.map("key", "aa", "sort", 4), "doc3", ITQueryTest.map("key", "b", "sort", 3), "doc4", ITQueryTest.map("key", "b", "sort", 2), "doc5", ITQueryTest.map("key", "bb", "sort", 1)));
        DocumentSnapshot docSnap = (DocumentSnapshot)collection.document("doc2").get().get();
        Query query1 = collection.whereGreaterThan("sort", (Object)1).whereNotEqualTo("key", (Object)"a").whereLessThan(FieldPath.documentId(), (Object)"doc5");
        Query query1WithCursor = query1.startAt(docSnap);
        ITQueryTest.checkQuerySnapshotContainsDocuments(query1, "doc2", "doc4", "doc3");
        ITQueryTest.checkQuerySnapshotContainsDocuments(query1WithCursor, "doc2", "doc4", "doc3");
        Query query2 = collection.whereLessThan(FieldPath.documentId(), (Object)"doc5").whereGreaterThan("sort", (Object)1).whereNotEqualTo("key", (Object)"a");
        Query query2WithCursor = query2.startAt(docSnap);
        ITQueryTest.checkQuerySnapshotContainsDocuments(query2, "doc2", "doc4", "doc3");
        ITQueryTest.checkQuerySnapshotContainsDocuments(query2WithCursor, "doc2", "doc4", "doc3");
        Query query3 = collection.whereLessThan(FieldPath.documentId(), (Object)"doc5").whereGreaterThan("sort", (Object)1).whereNotEqualTo("key", (Object)"a").orderBy("sort", Query.Direction.DESCENDING);
        Query query3WithCursor = query3.startAt(docSnap);
        ITQueryTest.checkQuerySnapshotContainsDocuments(query3, "doc2", "doc3", "doc4");
        ITQueryTest.checkQuerySnapshotContainsDocuments(query3WithCursor, "doc2", "doc3", "doc4");
    }

    @Test
    public void testQueryPlan() throws Exception {
        Map<String, Map<String, Object>> testDocs = ITQueryTest.map("doc1", ITQueryTest.map("a", 1, "b", Ints.asList((int[])new int[]{0})), "doc2", ITQueryTest.map("b", Ints.asList((int[])new int[]{1})), "doc3", ITQueryTest.map("a", 3, "b", Ints.asList((int[])new int[]{2, 7}), "c", 10), "doc4", ITQueryTest.map("a", 1, "b", Ints.asList((int[])new int[]{3, 7})), "doc5", ITQueryTest.map("a", 1), "doc6", ITQueryTest.map("a", 2, "c", 20));
        CollectionReference collection = this.testCollectionWithDocs(testDocs);
        Query query = collection.where(Filter.equalTo((String)"a", (Object)1)).orderBy("a");
        ExplainResults explainResults = (ExplainResults)query.explain(ExplainOptions.builder().setAnalyze(false).build()).get();
        QuerySnapshot snapshot = (QuerySnapshot)explainResults.getSnapshot();
        Truth.assertThat((Iterable)snapshot).isNull();
        ExplainMetrics metrics = explainResults.getMetrics();
        Truth.assertThat((Object)metrics).isNotNull();
        PlanSummary planSummary = metrics.getPlanSummary();
        Truth.assertThat((Object)planSummary).isNotNull();
        Truth.assertThat((Iterable)planSummary.getIndexesUsed()).isNotEmpty();
        ExecutionStats stats = metrics.getExecutionStats();
        Truth.assertThat((Object)stats).isNull();
    }

    @Test
    public void testQueryProfile() throws Exception {
        Map<String, Map<String, Object>> testDocs = ITQueryTest.map("doc1", ITQueryTest.map("a", 1, "b", Ints.asList((int[])new int[]{0})), "doc2", ITQueryTest.map("b", Ints.asList((int[])new int[]{1})), "doc3", ITQueryTest.map("a", 3, "b", Ints.asList((int[])new int[]{2, 7}), "c", 10), "doc4", ITQueryTest.map("a", 1, "b", Ints.asList((int[])new int[]{3, 7})), "doc5", ITQueryTest.map("a", 1), "doc6", ITQueryTest.map("a", 2, "c", 20));
        CollectionReference collection = this.testCollectionWithDocs(testDocs);
        Query query = collection.where(Filter.equalTo((String)"a", (Object)1)).orderBy("a");
        ExplainResults explainResults = (ExplainResults)query.explain(ExplainOptions.builder().setAnalyze(true).build()).get();
        QuerySnapshot snapshot = (QuerySnapshot)explainResults.getSnapshot();
        Truth.assertThat((Iterable)snapshot).isNotNull();
        Truth.assertThat((Integer)snapshot.size()).isEqualTo((Object)3);
        ExplainMetrics metrics = explainResults.getMetrics();
        Truth.assertThat((Object)metrics).isNotNull();
        PlanSummary planSummary = metrics.getPlanSummary();
        Truth.assertThat((Object)planSummary).isNotNull();
        Truth.assertThat((Iterable)planSummary.getIndexesUsed()).isNotEmpty();
        ExecutionStats stats = metrics.getExecutionStats();
        Truth.assertThat((Object)stats).isNotNull();
        Truth.assertThat((Map)stats.getDebugStats()).isNotEmpty();
        Truth.assertThat((Long)stats.getReadOperations()).isEqualTo((Object)3);
        Truth.assertThat((Long)stats.getResultsReturned()).isEqualTo((Object)3);
        Truth.assertThat((Comparable)stats.getExecutionDuration()).isGreaterThan((Comparable)Duration.ZERO);
    }

    @Test
    public void testQueryProfileForQueryWithNoResultSet() throws Exception {
        Map<String, Map<String, Object>> testDocs = ITQueryTest.map("doc1", ITQueryTest.map("a", 1, "b", Ints.asList((int[])new int[]{0})), "doc2", ITQueryTest.map("b", Ints.asList((int[])new int[]{1})), "doc3", ITQueryTest.map("a", 3, "b", Ints.asList((int[])new int[]{2, 7}), "c", 10), "doc4", ITQueryTest.map("a", 1, "b", Ints.asList((int[])new int[]{3, 7})), "doc5", ITQueryTest.map("a", 1), "doc6", ITQueryTest.map("a", 2, "c", 20));
        CollectionReference collection = this.testCollectionWithDocs(testDocs);
        Query query = collection.where(Filter.equalTo((String)"a", (Object)100)).orderBy("a");
        QuerySnapshot getSnapshot = (QuerySnapshot)query.get().get();
        Truth.assertThat((Integer)getSnapshot.size()).isEqualTo((Object)0);
        ExplainResults explainResults = (ExplainResults)query.explain(ExplainOptions.builder().setAnalyze(true).build()).get();
        QuerySnapshot snapshot = (QuerySnapshot)explainResults.getSnapshot();
        Truth.assertThat((Iterable)snapshot).isNotNull();
        Truth.assertThat((Integer)snapshot.size()).isEqualTo((Object)0);
        ExplainMetrics metrics = explainResults.getMetrics();
        Truth.assertThat((Object)metrics).isNotNull();
        PlanSummary planSummary = metrics.getPlanSummary();
        Truth.assertThat((Object)planSummary).isNotNull();
        Truth.assertThat((Iterable)planSummary.getIndexesUsed()).isNotEmpty();
        ExecutionStats stats = metrics.getExecutionStats();
        Truth.assertThat((Object)stats).isNotNull();
        Truth.assertThat((Map)stats.getDebugStats()).isNotEmpty();
        Truth.assertThat((Long)stats.getReadOperations()).isGreaterThan(0);
        Truth.assertThat((Long)stats.getResultsReturned()).isEqualTo((Object)0);
        Truth.assertThat((Comparable)stats.getExecutionDuration()).isGreaterThan((Comparable)Duration.ZERO);
    }

    @Test
    public void testExplainStreamWithoutAnalyze() throws Exception {
        CollectionReference collection = this.testCollectionWithDocs(Collections.emptyMap());
        Query query = collection.where(Filter.equalTo((String)"a", (Object)1)).orderBy("a");
        ApiFuture metricsFuture = query.explainStream(ExplainOptions.builder().setAnalyze(false).build(), (ApiStreamObserver)new ApiStreamObserver<DocumentSnapshot>(){

            public void onNext(DocumentSnapshot documentSnapshot) {
                Assert.fail((String)"No DocumentSnapshot should be received because analyze option was disabled.");
            }

            public void onError(Throwable throwable) {
                Assert.fail((String)throwable.getMessage());
            }

            public void onCompleted() {
            }
        });
        ExplainMetrics metrics = (ExplainMetrics)metricsFuture.get();
        Truth.assertThat((Integer)metrics.getPlanSummary().getIndexesUsed().size()).isGreaterThan((Comparable)Integer.valueOf(0));
        Truth.assertThat((Object)metrics.getExecutionStats()).isNull();
    }

    @Test
    public void testExplainStreamWithAnalyze() throws Exception {
        Map<String, Map<String, Object>> testDocs = ITQueryTest.map("doc1", ITQueryTest.map("a", 1, "b", Ints.asList((int[])new int[]{0})), "doc2", ITQueryTest.map("b", Ints.asList((int[])new int[]{1})), "doc3", ITQueryTest.map("a", 3, "b", Ints.asList((int[])new int[]{2, 7}), "c", 10), "doc4", ITQueryTest.map("a", 1, "b", Ints.asList((int[])new int[]{3, 7})), "doc5", ITQueryTest.map("a", 1), "doc6", ITQueryTest.map("a", 2, "c", 20));
        CollectionReference collection = this.testCollectionWithDocs(testDocs);
        Query query = collection.where(Filter.equalTo((String)"a", (Object)1)).orderBy("a");
        final Iterator<String> iterator = Arrays.asList("doc1", "doc4", "doc5").iterator();
        ApiFuture metricsFuture = query.explainStream(ExplainOptions.builder().setAnalyze(true).build(), (ApiStreamObserver)new ApiStreamObserver<DocumentSnapshot>(){

            public void onNext(DocumentSnapshot documentSnapshot) {
                Assert.assertEquals(iterator.next(), (Object)documentSnapshot.getId());
            }

            public void onError(Throwable throwable) {
                Assert.fail((String)throwable.getMessage());
            }

            public void onCompleted() {
            }
        });
        ExplainMetrics metrics = (ExplainMetrics)metricsFuture.get();
        Truth.assertThat((Integer)metrics.getPlanSummary().getIndexesUsed().size()).isGreaterThan((Comparable)Integer.valueOf(0));
        Truth.assertThat((Object)metrics.getExecutionStats()).isNotNull();
        Truth.assertThat((Long)metrics.getExecutionStats().getResultsReturned()).isEqualTo((Object)3);
    }

    @Test
    public void testAggregateQueryPlan() throws Exception {
        Map<String, Map<String, Object>> testDocs = ITQueryTest.map("doc1", ITQueryTest.map("a", 1, "b", Ints.asList((int[])new int[]{0})), "doc2", ITQueryTest.map("b", Ints.asList((int[])new int[]{1})), "doc3", ITQueryTest.map("a", 3, "b", Ints.asList((int[])new int[]{2, 7}), "c", 10), "doc4", ITQueryTest.map("a", 1, "b", Ints.asList((int[])new int[]{3, 7})), "doc5", ITQueryTest.map("a", 1), "doc6", ITQueryTest.map("a", 2, "c", 20));
        CollectionReference collection = this.testCollectionWithDocs(testDocs);
        AggregateQuery query = collection.where(Filter.equalTo((String)"a", (Object)1)).orderBy("a").count();
        ExplainResults explainResults = (ExplainResults)query.explain(ExplainOptions.builder().setAnalyze(false).build()).get();
        AggregateQuerySnapshot snapshot = (AggregateQuerySnapshot)explainResults.getSnapshot();
        Truth.assertThat((Object)snapshot).isNull();
        ExplainMetrics metrics = explainResults.getMetrics();
        Truth.assertThat((Object)metrics).isNotNull();
        PlanSummary planSummary = metrics.getPlanSummary();
        Truth.assertThat((Object)planSummary).isNotNull();
        Truth.assertThat((Iterable)planSummary.getIndexesUsed()).isNotEmpty();
        ExecutionStats stats = metrics.getExecutionStats();
        Truth.assertThat((Object)stats).isNull();
    }

    @Test
    public void testAggregateQueryProfile() throws Exception {
        Map<String, Map<String, Object>> testDocs = ITQueryTest.map("doc1", ITQueryTest.map("a", 1, "b", Ints.asList((int[])new int[]{0})), "doc2", ITQueryTest.map("b", Ints.asList((int[])new int[]{1})), "doc3", ITQueryTest.map("a", 3, "b", Ints.asList((int[])new int[]{2, 7}), "c", 10), "doc4", ITQueryTest.map("a", 1, "b", Ints.asList((int[])new int[]{3, 7})), "doc5", ITQueryTest.map("a", 1), "doc6", ITQueryTest.map("a", 2, "c", 20));
        CollectionReference collection = this.testCollectionWithDocs(testDocs);
        AggregateQuery query = collection.where(Filter.equalTo((String)"a", (Object)1)).orderBy("a").count();
        ExplainResults explainResults = (ExplainResults)query.explain(ExplainOptions.builder().setAnalyze(true).build()).get();
        AggregateQuerySnapshot snapshot = (AggregateQuerySnapshot)explainResults.getSnapshot();
        Truth.assertThat((Object)snapshot).isNotNull();
        Truth.assertThat((Long)snapshot.getCount()).isEqualTo((Object)3);
        ExplainMetrics metrics = explainResults.getMetrics();
        Truth.assertThat((Object)metrics).isNotNull();
        PlanSummary planSummary = metrics.getPlanSummary();
        Truth.assertThat((Object)planSummary).isNotNull();
        Truth.assertThat((Iterable)planSummary.getIndexesUsed()).isNotEmpty();
        ExecutionStats stats = metrics.getExecutionStats();
        Truth.assertThat((Object)stats).isNotNull();
        Truth.assertThat((Map)stats.getDebugStats()).isNotEmpty();
        Truth.assertThat((Long)stats.getReadOperations()).isEqualTo((Object)1);
        Truth.assertThat((Long)stats.getResultsReturned()).isEqualTo((Object)1);
        Truth.assertThat((Comparable)stats.getExecutionDuration()).isGreaterThan((Comparable)Duration.ZERO);
    }
}

