/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore.it;

import com.google.cloud.firestore.CollectionReference;
import com.google.cloud.firestore.DocumentChange;
import com.google.cloud.firestore.DocumentReference;
import com.google.cloud.firestore.DocumentSnapshot;
import com.google.cloud.firestore.EventListener;
import com.google.cloud.firestore.FieldPath;
import com.google.cloud.firestore.FieldValue;
import com.google.cloud.firestore.FirestoreException;
import com.google.cloud.firestore.ListenerRegistration;
import com.google.cloud.firestore.LocalFirestoreHelper;
import com.google.cloud.firestore.Query;
import com.google.cloud.firestore.QueryDocumentSnapshot;
import com.google.cloud.firestore.QuerySnapshot;
import com.google.cloud.firestore.WriteBatch;
import com.google.cloud.firestore.it.ITBaseTest;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import com.google.common.truth.Truth;
import com.google.firestore.v1.ExistenceFilter;
import com.google.firestore.v1.ListenResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public final class ITQueryWatchTest
extends ITBaseTest {
    @Rule
    public TestName testName = new TestName();
    private CollectionReference randomColl;

    @Override
    @Before
    public void before() throws Exception {
        super.before();
        this.useFirestoreSpy();
        String autoId = LocalFirestoreHelper.autoId();
        String collPath = String.format("java-%s-%s", this.testName.getMethodName(), autoId);
        this.randomColl = this.firestore.collection(collPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void emptyResults() throws InterruptedException {
        Query query = this.randomColl.whereEqualTo("foo", (Object)"bar");
        QuerySnapshotEventListener listener = QuerySnapshotEventListener.builder().setInitialEventCount(1).build();
        ListenerRegistration registration = query.addSnapshotListener((EventListener)listener);
        try {
            listener.eventsCountDownLatch.awaitInitialEvents();
        }
        finally {
            registration.remove();
        }
        QuerySnapshotEventListener.ListenerAssertions listenerAssertions = listener.assertions();
        listenerAssertions.noError();
        listenerAssertions.eventCountIsAnyOf((Range<Integer>)Range.closed((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(1)));
        listenerAssertions.addedIdsIsEmpty();
        listenerAssertions.modifiedIdsIsEmpty();
        listenerAssertions.removedIdsIsEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void nonEmptyResults() throws Exception {
        this.setDocument("doc", LocalFirestoreHelper.map("foo", "bar", new Object[0]));
        Query query = this.randomColl.whereEqualTo("foo", (Object)"bar");
        QuerySnapshotEventListener listener = QuerySnapshotEventListener.builder().setInitialEventCount(1).build();
        ListenerRegistration registration = query.addSnapshotListener((EventListener)listener);
        try {
            listener.eventsCountDownLatch.awaitInitialEvents();
        }
        finally {
            registration.remove();
        }
        QuerySnapshotEventListener.ListenerAssertions listenerAssertions = listener.assertions();
        listenerAssertions.noError();
        listenerAssertions.eventCountIsAnyOf((Range<Integer>)Range.closed((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(1)));
        listenerAssertions.addedIdsIsAnyOf("doc");
        listenerAssertions.modifiedIdsIsEmpty();
        listenerAssertions.removedIdsIsEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void emptyResults_newDocument_ADDED() throws InterruptedException, TimeoutException, ExecutionException {
        Query query = this.randomColl.whereEqualTo("foo", (Object)"bar");
        QuerySnapshotEventListener listener = QuerySnapshotEventListener.builder().setInitialEventCount(1).setAddedEventCount(1).build();
        ListenerRegistration registration = query.addSnapshotListener((EventListener)listener);
        try {
            listener.eventsCountDownLatch.awaitInitialEvents();
            this.randomColl.document("doc").set(LocalFirestoreHelper.map("foo", "bar", new Object[0])).get(5L, TimeUnit.SECONDS);
            listener.eventsCountDownLatch.await(DocumentChange.Type.ADDED);
        }
        finally {
            registration.remove();
        }
        QuerySnapshotEventListener.ListenerAssertions listenerAssertions = listener.assertions();
        listenerAssertions.noError();
        listenerAssertions.eventCountIsAnyOf((Range<Integer>)Range.closed((Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(2)));
        listenerAssertions.addedIdsIsAnyOf(Collections.emptyList(), Collections.singletonList("doc"));
        listenerAssertions.modifiedIdsIsEmpty();
        listenerAssertions.removedIdsIsEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void emptyResults_modifiedDocument_ADDED() throws Exception {
        DocumentReference testDoc = this.setDocument("doc", LocalFirestoreHelper.map("baz", "baz", new Object[0]));
        Query query = this.randomColl.whereEqualTo("foo", (Object)"bar");
        QuerySnapshotEventListener listener = QuerySnapshotEventListener.builder().setInitialEventCount(1).setAddedEventCount(1).build();
        ListenerRegistration registration = query.addSnapshotListener((EventListener)listener);
        try {
            listener.eventsCountDownLatch.awaitInitialEvents();
            testDoc.update("foo", (Object)"bar", new Object[0]).get(5L, TimeUnit.SECONDS);
            listener.eventsCountDownLatch.await(DocumentChange.Type.ADDED);
        }
        finally {
            registration.remove();
        }
        QuerySnapshotEventListener.ListenerAssertions listenerAssertions = listener.assertions();
        listenerAssertions.noError();
        listenerAssertions.eventCountIsAnyOf((Range<Integer>)Range.closed((Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(2)));
        listenerAssertions.addedIdsIsAnyOf(Collections.emptyList(), Collections.singletonList("doc"));
        listenerAssertions.modifiedIdsIsEmpty();
        listenerAssertions.removedIdsIsEmpty();
        ListenerEvent event = listener.lastListenerEvent();
        QueryDocumentSnapshot doc = ((DocumentChange)event.value.getDocumentChanges().get(0)).getDocument();
        Truth.assertThat((Object)doc.get("foo")).isEqualTo((Object)"bar");
        Truth.assertThat((Object)doc.get("baz")).isEqualTo((Object)"baz");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void nonEmptyResults_modifiedDocument_MODIFIED() throws Exception {
        DocumentReference testDoc = this.setDocument("doc", LocalFirestoreHelper.map("foo", "bar", new Object[0]));
        Query query = this.randomColl.whereEqualTo("foo", (Object)"bar");
        QuerySnapshotEventListener listener = QuerySnapshotEventListener.builder().setInitialEventCount(1).setModifiedEventCount(1).build();
        ListenerRegistration registration = query.addSnapshotListener((EventListener)listener);
        try {
            listener.eventsCountDownLatch.awaitInitialEvents();
            testDoc.update("baz", (Object)"baz", new Object[0]).get(5L, TimeUnit.SECONDS);
            listener.eventsCountDownLatch.await(DocumentChange.Type.MODIFIED);
        }
        finally {
            registration.remove();
        }
        QuerySnapshotEventListener.ListenerAssertions listenerAssertions = listener.assertions();
        listenerAssertions.noError();
        listenerAssertions.eventCountIsAnyOf((Range<Integer>)Range.closed((Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(2)));
        listenerAssertions.addedIdsIsAnyOf(Collections.emptyList(), Collections.singletonList("doc"));
        listenerAssertions.modifiedIdsIsAnyOf(Collections.emptyList(), Collections.singletonList("doc"));
        listenerAssertions.removedIdsIsEmpty();
        ListenerEvent event = listener.lastListenerEvent();
        QueryDocumentSnapshot doc = ((DocumentChange)event.value.getDocumentChanges().get(0)).getDocument();
        Truth.assertThat((Object)doc.get("foo")).isEqualTo((Object)"bar");
        Truth.assertThat((Object)doc.get("baz")).isEqualTo((Object)"baz");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void nonEmptyResults_deletedDocument_REMOVED() throws Exception {
        DocumentReference testDoc = this.setDocument("doc", LocalFirestoreHelper.map("foo", "bar", new Object[0]));
        Query query = this.randomColl.whereEqualTo("foo", (Object)"bar");
        QuerySnapshotEventListener listener = QuerySnapshotEventListener.builder().setInitialEventCount(1).setRemovedEventCount(1).build();
        ListenerRegistration registration = query.addSnapshotListener((EventListener)listener);
        try {
            listener.eventsCountDownLatch.awaitInitialEvents();
            testDoc.delete().get(5L, TimeUnit.SECONDS);
            listener.eventsCountDownLatch.await(DocumentChange.Type.REMOVED);
        }
        finally {
            registration.remove();
        }
        QuerySnapshotEventListener.ListenerAssertions listenerAssertions = listener.assertions();
        listenerAssertions.noError();
        listenerAssertions.eventCountIsAnyOf((Range<Integer>)Range.closed((Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(2)));
        listenerAssertions.addedIdsIsAnyOf(Collections.emptyList(), Collections.singletonList("doc"));
        listenerAssertions.modifiedIdsIsEmpty();
        listenerAssertions.removedIdsIsAnyOf(Collections.emptyList(), Collections.singletonList("doc"));
        ListenerEvent event = listener.lastListenerEvent();
        QueryDocumentSnapshot doc = ((DocumentChange)event.value.getDocumentChanges().get(0)).getDocument();
        Truth.assertThat((Object)doc.get("foo")).isEqualTo((Object)"bar");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void nonEmptyResults_modifiedDocument_REMOVED() throws Exception {
        DocumentReference testDoc = this.setDocument("doc", LocalFirestoreHelper.map("foo", "bar", new Object[0]));
        Query query = this.randomColl.whereEqualTo("foo", (Object)"bar");
        QuerySnapshotEventListener listener = QuerySnapshotEventListener.builder().setInitialEventCount(1).setRemovedEventCount(1).build();
        ListenerRegistration registration = query.addSnapshotListener((EventListener)listener);
        try {
            listener.eventsCountDownLatch.awaitInitialEvents();
            testDoc.set(LocalFirestoreHelper.map("bar", "foo", new Object[0])).get(5L, TimeUnit.SECONDS);
            listener.eventsCountDownLatch.await(DocumentChange.Type.REMOVED);
        }
        finally {
            registration.remove();
        }
        QuerySnapshotEventListener.ListenerAssertions listenerAssertions = listener.assertions();
        listenerAssertions.noError();
        listenerAssertions.eventCountIsAnyOf((Range<Integer>)Range.closed((Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(2)));
        listenerAssertions.addedIdsIsAnyOf(Collections.emptyList(), Collections.singletonList("doc"));
        listenerAssertions.modifiedIdsIsEmpty();
        listenerAssertions.removedIdsIsAnyOf(Collections.emptyList(), Collections.singletonList("doc"));
        ListenerEvent event = listener.lastListenerEvent();
        QueryDocumentSnapshot doc = ((DocumentChange)event.value.getDocumentChanges().get(0)).getDocument();
        Truth.assertThat((Object)doc.get("foo")).isEqualTo((Object)"bar");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void restartAfterFailedFilter() throws Exception {
        DocumentReference testDoc1 = this.setDocument("doc1", LocalFirestoreHelper.map("foo", "bar", new Object[0]));
        DocumentReference testDoc2 = this.setDocument("doc2", LocalFirestoreHelper.map("foo", "bar", new Object[0]));
        Query query = this.randomColl.whereEqualTo("foo", (Object)"bar");
        QuerySnapshotEventListener listener = QuerySnapshotEventListener.builder().setInitialEventCount(1).setAddedEventCount(3).setRemovedEventCount(1).build();
        ListenerRegistration registration = query.addSnapshotListener((EventListener)listener);
        try {
            listener.eventsCountDownLatch.awaitInitialEvents();
            listener.assertionsForLastEvent().noError().addedIdsIsAnyOf("doc1", "doc2").modifiedIdsIsEmpty().removedIdsIsEmpty();
            listener.lastDocumentIdsIsAnyOf("doc1", "doc2");
            this.firestoreSpy.streamRequestBidiStreamObserver.onResponse((Object)this.filter(0));
            this.setDocument("doc3", LocalFirestoreHelper.map("foo", "bar", new Object[0]));
            listener.eventsCountDownLatch.await(DocumentChange.Type.ADDED);
            listener.assertionsForLastEvent().noError().addedIdsIsAnyOf("doc3").modifiedIdsIsEmpty().removedIdsIsEmpty();
            listener.lastDocumentIdsIsAnyOf("doc1", "doc2", "doc3");
            testDoc1.set(LocalFirestoreHelper.map("bar", "foo", new Object[0])).get(5L, TimeUnit.SECONDS);
            listener.eventsCountDownLatch.await(DocumentChange.Type.REMOVED);
            listener.assertionsForLastEvent().noError().addedIdsIsEmpty().modifiedIdsIsEmpty().removedIdsIsAnyOf("doc1");
            listener.lastDocumentIdsIsAnyOf("doc2", "doc3");
        }
        finally {
            registration.remove();
        }
        QuerySnapshotEventListener.ListenerAssertions listenerAssertions = listener.assertions();
        listenerAssertions.noError();
        listenerAssertions.eventCountIsAnyOf((Range<Integer>)Range.singleton((Comparable)Integer.valueOf(3)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void limitToLast() throws Exception {
        this.setDocument("doc1", Collections.singletonMap("counter", 1));
        this.setDocument("doc2", Collections.singletonMap("counter", 2));
        this.setDocument("doc3", Collections.singletonMap("counter", 3));
        Query query = this.randomColl.orderBy("counter").limitToLast(2);
        QuerySnapshotEventListener listener = QuerySnapshotEventListener.builder().setInitialEventCount(1).build();
        ListenerRegistration registration = query.addSnapshotListener((EventListener)listener);
        try {
            listener.eventsCountDownLatch.awaitInitialEvents();
        }
        finally {
            registration.remove();
        }
        QuerySnapshotEventListener.ListenerAssertions listenerAssertions = listener.assertions();
        listenerAssertions.noError();
        listenerAssertions.addedIdsIsAnyOf(Collections.emptyList(), Arrays.asList("doc2", "doc3"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void vectorFieldOrder() throws Exception {
        List<Map> docsInOrder = Arrays.asList(LocalFirestoreHelper.map("embedding", Arrays.asList(1, 2, 3, 4, 5, 6), new Object[0]), LocalFirestoreHelper.map("embedding", Arrays.asList(100), new Object[0]), LocalFirestoreHelper.map("embedding", FieldValue.vector((double[])new double[]{Double.NEGATIVE_INFINITY}), new Object[0]), LocalFirestoreHelper.map("embedding", FieldValue.vector((double[])new double[]{-100.0}), new Object[0]), LocalFirestoreHelper.map("embedding", FieldValue.vector((double[])new double[]{100.0}), new Object[0]), LocalFirestoreHelper.map("embedding", FieldValue.vector((double[])new double[]{Double.POSITIVE_INFINITY}), new Object[0]), LocalFirestoreHelper.map("embedding", FieldValue.vector((double[])new double[]{1.0, 2.0}), new Object[0]), LocalFirestoreHelper.map("embedding", FieldValue.vector((double[])new double[]{2.0, 2.0}), new Object[0]), LocalFirestoreHelper.map("embedding", FieldValue.vector((double[])new double[]{1.0, 2.0, 3.0}), new Object[0]), LocalFirestoreHelper.map("embedding", FieldValue.vector((double[])new double[]{1.0, 2.0, 3.0, 4.0}), new Object[0]), LocalFirestoreHelper.map("embedding", FieldValue.vector((double[])new double[]{1.0, 2.0, 3.0, 4.0, 5.0}), new Object[0]), LocalFirestoreHelper.map("embedding", FieldValue.vector((double[])new double[]{1.0, 2.0, 100.0, 4.0, 4.0}), new Object[0]), LocalFirestoreHelper.map("embedding", FieldValue.vector((double[])new double[]{100.0, 2.0, 3.0, 4.0, 5.0}), new Object[0]), LocalFirestoreHelper.map("embedding", LocalFirestoreHelper.map(), new Object[0]), LocalFirestoreHelper.map("embedding", LocalFirestoreHelper.map("HELLO", "WORLD", new Object[0]), new Object[0]), LocalFirestoreHelper.map("embedding", LocalFirestoreHelper.map("hello", "world", new Object[0]), new Object[0]));
        ArrayList<String> docIds = new ArrayList<String>();
        for (int i = 0; i < docsInOrder.size(); ++i) {
            DocumentReference docRef = (DocumentReference)this.randomColl.add(docsInOrder.get(i)).get();
            docIds.add(docRef.getId());
        }
        Query orderedQuery = this.randomColl.orderBy("embedding");
        QuerySnapshotEventListener listener = QuerySnapshotEventListener.builder().setInitialEventCount(1).build();
        ListenerRegistration registration = orderedQuery.addSnapshotListener((EventListener)listener);
        try {
            listener.eventsCountDownLatch.awaitInitialEvents();
        }
        finally {
            registration.remove();
        }
        QuerySnapshotEventListener.ListenerAssertions listenerAssertions = listener.assertions();
        listenerAssertions.noError();
        List listenerIds = listenerAssertions.addedIds;
        QuerySnapshot querySnapshot = (QuerySnapshot)orderedQuery.get().get();
        List<String> getIds = querySnapshot.getDocuments().stream().map(ds -> ds.getId()).collect(Collectors.toList());
        Assert.assertArrayEquals((Object[])docIds.toArray(new String[0]), (Object[])getIds.toArray(new String[0]));
        Assert.assertArrayEquals((Object[])docIds.toArray(new String[0]), (Object[])listenerIds.toArray(new String[0]));
    }

    @Test
    public void limitToLastWithStartAtFullLimit() throws Exception {
        for (int i = 0; i < 10; ++i) {
            this.setDocument("doc" + i, Collections.singletonMap("counter", i));
        }
        Query query = this.randomColl.orderBy("counter").startAt(new Object[]{5}).limitToLast(3);
        ITQueryWatchTest.assertQueryResultContainsDocsInOrder(query, "doc7", "doc8", "doc9");
    }

    @Test
    public void limitToLastWithStartAtPartialLimit() throws Exception {
        for (int i = 0; i < 10; ++i) {
            this.setDocument("doc" + i, Collections.singletonMap("counter", i));
        }
        Query query = this.randomColl.orderBy("counter").startAt(new Object[]{8}).limitToLast(3);
        ITQueryWatchTest.assertQueryResultContainsDocsInOrder(query, "doc8", "doc9");
    }

    @Test
    public void limitToLastWithStartAfterFullLimit() throws Exception {
        for (int i = 0; i < 10; ++i) {
            this.setDocument("doc" + i, Collections.singletonMap("counter", i));
        }
        Query query = this.randomColl.orderBy("counter").startAfter(new Object[]{5}).limitToLast(3);
        ITQueryWatchTest.assertQueryResultContainsDocsInOrder(query, "doc7", "doc8", "doc9");
    }

    @Test
    public void limitToLastWithStartAfterPartialLimit() throws Exception {
        for (int i = 0; i < 10; ++i) {
            this.setDocument("doc" + i, Collections.singletonMap("counter", i));
        }
        Query query = this.randomColl.orderBy("counter").startAfter(new Object[]{7}).limitToLast(3);
        ITQueryWatchTest.assertQueryResultContainsDocsInOrder(query, "doc8", "doc9");
    }

    @Test
    public void limitToLastWithEndAt() throws Exception {
        for (int i = 0; i < 10; ++i) {
            this.setDocument("doc" + i, Collections.singletonMap("counter", i));
        }
        Query query = this.randomColl.orderBy("counter").endAt(new Object[]{5}).limitToLast(3);
        ITQueryWatchTest.assertQueryResultContainsDocsInOrder(query, "doc3", "doc4", "doc5");
    }

    @Test
    public void limitToLastWithEndBefore() throws Exception {
        for (int i = 0; i < 10; ++i) {
            this.setDocument("doc" + i, Collections.singletonMap("counter", i));
        }
        Query query = this.randomColl.orderBy("counter").endBefore(new Object[]{5}).limitToLast(3);
        ITQueryWatchTest.assertQueryResultContainsDocsInOrder(query, "doc2", "doc3", "doc4");
    }

    @Test
    public void limitToLastWithStartAtAndEndAtFullLimit() throws Exception {
        for (int i = 0; i < 10; ++i) {
            this.setDocument("doc" + i, Collections.singletonMap("counter", i));
        }
        Query query = this.randomColl.orderBy("counter").startAt(new Object[]{3}).endAt(new Object[]{6}).limitToLast(3);
        ITQueryWatchTest.assertQueryResultContainsDocsInOrder(query, "doc4", "doc5", "doc6");
    }

    @Test
    public void limitToLastWithStartAtAndEndAtPartialLimit() throws Exception {
        for (int i = 0; i < 10; ++i) {
            this.setDocument("doc" + i, Collections.singletonMap("counter", i));
        }
        Query query = this.randomColl.orderBy("counter").startAt(new Object[]{5}).endAt(new Object[]{6}).limitToLast(3);
        ITQueryWatchTest.assertQueryResultContainsDocsInOrder(query, "doc5", "doc6");
    }

    private static void assertQueryResultContainsDocsInOrder(Query query, String ... docIds) throws ExecutionException, InterruptedException {
        QuerySnapshot snapshot = (QuerySnapshot)query.get().get();
        ImmutableList actualDocIds = (ImmutableList)snapshot.getDocuments().stream().map(DocumentSnapshot::getId).collect(ImmutableList.toImmutableList());
        Truth.assertThat((Iterable)actualDocIds).containsExactlyElementsIn((Object[])docIds).inOrder();
    }

    @Test
    public void shutdownNowTerminatesActiveListener() throws Exception {
        Query query = this.randomColl.whereEqualTo("foo", (Object)"bar");
        QuerySnapshotEventListener listener = QuerySnapshotEventListener.builder().setExpectError().build();
        query.addSnapshotListener((EventListener)listener);
        this.firestore.shutdownNow();
        listener.eventsCountDownLatch.awaitError();
        QuerySnapshotEventListener.ListenerAssertions listenerAssertions = listener.assertions();
        listenerAssertions.hasError();
    }

    @Test
    public void shutdownNowPreventsAddingNewListener() throws Exception {
        Query query = this.randomColl.whereEqualTo("foo", (Object)"bar");
        QuerySnapshotEventListener listener = QuerySnapshotEventListener.builder().setExpectError().build();
        this.firestore.shutdownNow();
        query.addSnapshotListener((EventListener)listener);
        listener.eventsCountDownLatch.awaitError();
        QuerySnapshotEventListener.ListenerAssertions listenerAssertions = listener.assertions();
        listenerAssertions.hasError();
    }

    @Test
    public void snapshotListenerSortsQueryByDocumentIdInTheSameOrderAsServer() throws Exception {
        CollectionReference col = this.randomColl;
        ((WriteBatch)((WriteBatch)((WriteBatch)((WriteBatch)((WriteBatch)((WriteBatch)((WriteBatch)((WriteBatch)((WriteBatch)((WriteBatch)((WriteBatch)this.firestore.batch().set(col.document("A"), Collections.singletonMap("a", 1))).set(col.document("a"), Collections.singletonMap("a", 1))).set(col.document("Aa"), Collections.singletonMap("a", 1))).set(col.document("7"), Collections.singletonMap("a", 1))).set(col.document("12"), Collections.singletonMap("a", 1))).set(col.document("__id7__"), Collections.singletonMap("a", 1))).set(col.document("__id12__"), Collections.singletonMap("a", 1))).set(col.document("__id-2__"), Collections.singletonMap("a", 1))).set(col.document("_id1__"), Collections.singletonMap("a", 1))).set(col.document("__id1_"), Collections.singletonMap("a", 1))).set(col.document("__id"), Collections.singletonMap("a", 1))).commit().get();
        Query query = col.orderBy("__name__", Query.Direction.ASCENDING);
        List<String> expectedOrder = Arrays.asList("__id-2__", "__id7__", "__id12__", "12", "7", "A", "Aa", "__id", "__id1_", "_id1__", "a");
        QuerySnapshot snapshot = (QuerySnapshot)query.get().get();
        List queryOrder = snapshot.getDocuments().stream().map(doc -> doc.getId()).collect(Collectors.toList());
        Assert.assertEquals(expectedOrder, queryOrder);
        CountDownLatch latch = new CountDownLatch(1);
        ArrayList listenerOrder = new ArrayList();
        ListenerRegistration registration = query.addSnapshotListener((value, error) -> {
            listenerOrder.addAll(value.getDocuments().stream().map(doc -> doc.getId()).collect(Collectors.toList()));
            latch.countDown();
        });
        latch.await();
        registration.remove();
        Assert.assertEquals(expectedOrder, listenerOrder);
    }

    @Test
    public void snapshotListenerSortsFilteredQueryByDocumentIdInTheSameOrderAsServer() throws Exception {
        CollectionReference col = this.randomColl;
        ((WriteBatch)((WriteBatch)((WriteBatch)((WriteBatch)((WriteBatch)((WriteBatch)((WriteBatch)((WriteBatch)((WriteBatch)((WriteBatch)((WriteBatch)this.firestore.batch().set(col.document("A"), Collections.singletonMap("a", 1))).set(col.document("a"), Collections.singletonMap("a", 1))).set(col.document("Aa"), Collections.singletonMap("a", 1))).set(col.document("7"), Collections.singletonMap("a", 1))).set(col.document("12"), Collections.singletonMap("a", 1))).set(col.document("__id7__"), Collections.singletonMap("a", 1))).set(col.document("__id12__"), Collections.singletonMap("a", 1))).set(col.document("__id-2__"), Collections.singletonMap("a", 1))).set(col.document("_id1__"), Collections.singletonMap("a", 1))).set(col.document("__id1_"), Collections.singletonMap("a", 1))).set(col.document("__id"), Collections.singletonMap("a", 1))).commit().get();
        Query query = col.whereGreaterThan(FieldPath.documentId(), (Object)"__id7__").whereLessThanOrEqualTo(FieldPath.documentId(), (Object)"A").orderBy("__name__", Query.Direction.ASCENDING);
        List<String> expectedOrder = Arrays.asList("__id12__", "12", "7", "A");
        QuerySnapshot snapshot = (QuerySnapshot)query.get().get();
        List queryOrder = snapshot.getDocuments().stream().map(doc -> doc.getId()).collect(Collectors.toList());
        Assert.assertEquals(expectedOrder, queryOrder);
        CountDownLatch latch = new CountDownLatch(1);
        ArrayList listenerOrder = new ArrayList();
        ListenerRegistration registration = query.addSnapshotListener((value, error) -> {
            listenerOrder.addAll(value.getDocuments().stream().map(doc -> doc.getId()).collect(Collectors.toList()));
            latch.countDown();
        });
        latch.await();
        registration.remove();
        Assert.assertEquals(expectedOrder, listenerOrder);
    }

    private DocumentReference setDocument(String documentId, Map<String, ?> fields) throws Exception {
        DocumentReference documentReference = this.randomColl.document(documentId);
        documentReference.set(fields).get();
        return documentReference;
    }

    private ListenResponse filter(int documentCount) {
        ListenResponse.Builder response = ListenResponse.newBuilder();
        response.setFilter(ExistenceFilter.newBuilder().setCount(documentCount).build());
        return response.build();
    }

    static class QuerySnapshotEventListener
    implements EventListener<QuerySnapshot> {
        final List<ListenerEvent> receivedEvents = Collections.synchronizedList(new ArrayList());
        final EventsCountDownLatch eventsCountDownLatch;

        private QuerySnapshotEventListener(int initialCount, int addedEventCount, int modifiedEventCount, int removedEventCount, int errorCount) {
            this.eventsCountDownLatch = new EventsCountDownLatch(initialCount, addedEventCount, modifiedEventCount, removedEventCount, errorCount);
        }

        public void onEvent(@Nullable QuerySnapshot value, @Nullable FirestoreException error) {
            this.receivedEvents.add(new ListenerEvent(value, error));
            if (value != null) {
                List documentChanges = value.getDocumentChanges();
                for (DocumentChange docChange : documentChanges) {
                    this.eventsCountDownLatch.countDown(docChange.getType());
                }
            }
            if (error != null) {
                this.eventsCountDownLatch.countError();
            }
            this.eventsCountDownLatch.countDown();
        }

        ListenerAssertions assertions() {
            return new ListenerAssertions(this.receivedEvents);
        }

        ListenerAssertions assertionsForLastEvent() {
            return new ListenerAssertions(Collections.singletonList(this.lastListenerEvent()));
        }

        ListenerEvent lastListenerEvent() {
            return this.receivedEvents.get(this.receivedEvents.size() - 1);
        }

        void lastDocumentIdsIsAnyOf(String ... s) {
            List ids = Lists.transform((List)this.lastListenerEvent().value.getDocuments(), DocumentSnapshot::getId);
            Truth.assertThat((Iterable)ids).containsExactlyElementsIn((Object[])s);
        }

        static Builder builder() {
            return new Builder();
        }

        static final class ListenerAssertions {
            private static final Joiner.MapJoiner MAP_JOINER = Joiner.on((String)",").withKeyValueSeparator("=");
            private final List<String> addedIds;
            private final List<String> modifiedIds;
            private final List<String> removedIds;
            private final List<ListenerEvent> receivedEvents;

            ListenerAssertions(List<ListenerEvent> receivedEvents) {
                this.receivedEvents = receivedEvents;
                List<QuerySnapshot> querySnapshots = ListenerAssertions.getQuerySnapshots(receivedEvents);
                this.addedIds = ListenerAssertions.getIds(querySnapshots, DocumentChange.Type.ADDED);
                this.modifiedIds = ListenerAssertions.getIds(querySnapshots, DocumentChange.Type.MODIFIED);
                this.removedIds = ListenerAssertions.getIds(querySnapshots, DocumentChange.Type.REMOVED);
            }

            private ListenerAssertions noError() {
                Optional<ListenerEvent> anyError = this.receivedEvents.stream().filter(input -> ((ListenerEvent)input).error != null).findFirst();
                if (anyError.isPresent()) {
                    throw new Error("snapshotListener received an error", anyError.get().error);
                }
                return this;
            }

            private ListenerAssertions hasError() {
                Optional<ListenerEvent> anyError = this.receivedEvents.stream().filter(input -> ((ListenerEvent)input).error != null).findFirst();
                Truth.assertWithMessage((String)"snapshotListener did not receive an expected error").that(Boolean.valueOf(anyError.isPresent())).isTrue();
                return this;
            }

            private static List<QuerySnapshot> getQuerySnapshots(List<ListenerEvent> events) {
                return events.stream().filter(input -> ((ListenerEvent)input).value != null).map(input -> ((ListenerEvent)input).value).collect(Collectors.toList());
            }

            private static List<String> getIds(List<QuerySnapshot> querySnapshots, DocumentChange.Type type) {
                ArrayList<String> documentIds = new ArrayList<String>();
                for (QuerySnapshot querySnapshot : querySnapshots) {
                    List changes = querySnapshot.getDocumentChanges();
                    for (DocumentChange change : changes) {
                        if (change.getType() != type) continue;
                        documentIds.add(change.getDocument().getId());
                    }
                }
                return documentIds;
            }

            ListenerAssertions addedIdsIsEmpty() {
                Truth.assertWithMessage((String)this.debugMessage()).that(this.addedIds).isEmpty();
                return this;
            }

            ListenerAssertions addedIdsIsAnyOf(String ... s) {
                Truth.assertWithMessage((String)this.debugMessage()).that(this.addedIds).containsExactlyElementsIn((Object[])s);
                return this;
            }

            ListenerAssertions addedIdsIsAnyOf(List<?> s1, List<?> s2) {
                Truth.assertWithMessage((String)this.debugMessage()).that(this.addedIds).isAnyOf(s1, s2, new Object[0]);
                return this;
            }

            ListenerAssertions modifiedIdsIsEmpty() {
                Truth.assertWithMessage((String)this.debugMessage()).that(this.modifiedIds).isEmpty();
                return this;
            }

            ListenerAssertions modifiedIdsIsAnyOf(String ... s) {
                Truth.assertWithMessage((String)this.debugMessage()).that(this.modifiedIds).containsExactlyElementsIn((Object[])s);
                return this;
            }

            ListenerAssertions modifiedIdsIsAnyOf(List<?> s1, List<?> s2) {
                Truth.assertWithMessage((String)this.debugMessage()).that(this.modifiedIds).isAnyOf(s1, s2, new Object[0]);
                return this;
            }

            ListenerAssertions removedIdsIsEmpty() {
                Truth.assertWithMessage((String)this.debugMessage()).that(this.removedIds).isEmpty();
                return this;
            }

            ListenerAssertions removedIdsIsAnyOf(String ... s) {
                Truth.assertWithMessage((String)this.debugMessage()).that(this.removedIds).containsExactlyElementsIn((Object[])s);
                return this;
            }

            ListenerAssertions removedIdsIsAnyOf(List<?> s1, List<?> s2) {
                Truth.assertWithMessage((String)this.debugMessage()).that(this.removedIds).isAnyOf(s1, s2, new Object[0]);
                return this;
            }

            ListenerAssertions eventCountIsAnyOf(Range<Integer> range) {
                Truth.assertWithMessage((String)this.debugMessage()).that(Integer.valueOf(this.receivedEvents.size())).isIn(range);
                return this;
            }

            private String debugMessage() {
                StringBuilder builder = new StringBuilder();
                builder.append("events[\n");
                for (ListenerEvent receivedEvent : this.receivedEvents) {
                    builder.append("event{");
                    builder.append("error=").append((Object)receivedEvent.error);
                    builder.append(",");
                    builder.append("value=");
                    ListenerAssertions.debugMessage(builder, receivedEvent.value);
                    builder.append("},\n");
                }
                builder.append("]");
                return builder.toString();
            }

            private static void debugMessage(StringBuilder builder, QuerySnapshot qs) {
                if (qs == null) {
                    builder.append("null");
                } else {
                    builder.append("{");
                    List documents = qs.getDocuments();
                    builder.append("documents[");
                    for (QueryDocumentSnapshot document : documents) {
                        ListenerAssertions.debugMessage(builder, document);
                    }
                    builder.append("],");
                    List changes = qs.getDocumentChanges();
                    builder.append("documentChanges[");
                    for (DocumentChange change : changes) {
                        ListenerAssertions.debugMessage(builder, change.getDocument());
                    }
                    builder.append("]");
                    builder.append("}");
                }
            }

            private static void debugMessage(StringBuilder builder, QueryDocumentSnapshot queryDocumentSnapshot) {
                if (queryDocumentSnapshot == null) {
                    builder.append("null");
                } else {
                    builder.append("{");
                    builder.append("path=").append(queryDocumentSnapshot.getReference().getPath());
                    builder.append(",");
                    builder.append("data=");
                    ListenerAssertions.debugMessage(builder, queryDocumentSnapshot.getData());
                    builder.append("}");
                }
            }

            private static void debugMessage(StringBuilder builder, Map<String, Object> data) {
                builder.append("{");
                MAP_JOINER.appendTo(builder, data);
                builder.append("}");
            }
        }

        static final class Builder {
            private int initialEventCount = 0;
            private int addedEventCount = 0;
            private int modifiedEventCount = 0;
            private int removedEventCount = 0;
            private int errorCount = 0;

            private Builder() {
            }

            Builder setInitialEventCount(int initialEventCount) {
                this.initialEventCount = initialEventCount;
                return this;
            }

            Builder setAddedEventCount(int addedEventCount) {
                this.addedEventCount = addedEventCount;
                return this;
            }

            Builder setModifiedEventCount(int modifiedEventCount) {
                this.modifiedEventCount = modifiedEventCount;
                return this;
            }

            Builder setRemovedEventCount(int removedEventCount) {
                this.removedEventCount = removedEventCount;
                return this;
            }

            Builder setExpectError() {
                this.errorCount = 1;
                return this;
            }

            public QuerySnapshotEventListener build() {
                return new QuerySnapshotEventListener(this.initialEventCount, this.addedEventCount, this.modifiedEventCount, this.removedEventCount, this.errorCount);
            }
        }
    }

    private static final class EventsCountDownLatch {
        private final CountDownLatch initialEventsCountDownLatch;
        private final int initialEventCount;
        private final CountDownLatch errorCountDownLatch;
        private final EnumMap<DocumentChange.Type, Integer> eventsCounts;
        private final EnumMap<DocumentChange.Type, CountDownLatch> eventsCountDownLatches;

        EventsCountDownLatch(int initialEventCount, int addedInitialCount, int modifiedInitialCount, int removedInitialCount, int errorCount) {
            this.initialEventsCountDownLatch = new CountDownLatch(initialEventCount);
            this.initialEventCount = initialEventCount;
            this.errorCountDownLatch = new CountDownLatch(errorCount);
            this.eventsCounts = new EnumMap(DocumentChange.Type.class);
            this.eventsCounts.put(DocumentChange.Type.ADDED, addedInitialCount);
            this.eventsCounts.put(DocumentChange.Type.MODIFIED, modifiedInitialCount);
            this.eventsCounts.put(DocumentChange.Type.REMOVED, removedInitialCount);
            this.eventsCountDownLatches = new EnumMap(DocumentChange.Type.class);
            this.eventsCountDownLatches.put(DocumentChange.Type.ADDED, new CountDownLatch(addedInitialCount));
            this.eventsCountDownLatches.put(DocumentChange.Type.MODIFIED, new CountDownLatch(modifiedInitialCount));
            this.eventsCountDownLatches.put(DocumentChange.Type.REMOVED, new CountDownLatch(removedInitialCount));
        }

        void countDown() {
            this.initialEventsCountDownLatch.countDown();
        }

        void countDown(DocumentChange.Type type) {
            this.eventsCountDownLatches.get(type).countDown();
        }

        void countError() {
            this.errorCountDownLatch.countDown();
        }

        void awaitInitialEvents() throws InterruptedException {
            this.initialEventsCountDownLatch.await(5 * this.initialEventCount, TimeUnit.SECONDS);
        }

        void awaitError() throws InterruptedException {
            this.errorCountDownLatch.await(5L, TimeUnit.SECONDS);
        }

        void await(DocumentChange.Type type) throws InterruptedException {
            int count = this.eventsCounts.get(type);
            this.eventsCountDownLatches.get(type).await(5 * count, TimeUnit.SECONDS);
        }
    }

    private static final class ListenerEvent {
        @Nullable
        private final QuerySnapshot value;
        @Nullable
        private final FirestoreException error;

        ListenerEvent(@Nullable QuerySnapshot value, @Nullable FirestoreException error) {
            this.value = value;
            this.error = error;
        }
    }
}

