/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore.it;

import com.google.api.core.SettableApiFuture;
import com.google.cloud.firestore.Firestore;
import com.google.cloud.firestore.FirestoreOptions;
import com.google.cloud.firestore.ListenerRegistration;
import com.google.cloud.firestore.LocalFirestoreHelper;
import com.google.cloud.firestore.it.ITBaseTest;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.junit.rules.Timeout;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ITShutdownTest
extends ITBaseTest {
    @Rule
    public final Timeout timeout = new Timeout(5L, TimeUnit.SECONDS);
    @Rule
    public TestName testName = new TestName();

    @Test
    public void closeSuccess_withListenerRemove() throws Exception {
        Firestore fs = (Firestore)FirestoreOptions.getDefaultInstance().getService();
        ListenerRegistration listener = this.attachListener(fs);
        listener.remove();
        fs.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void closeFailure_withoutListenerRemove() throws Exception {
        Firestore fs = (Firestore)FirestoreOptions.getDefaultInstance().getService();
        this.attachListener(fs);
        ExecutorService testExecutorService = Executors.newSingleThreadExecutor();
        SettableApiFuture result = SettableApiFuture.create();
        testExecutorService.submit(() -> {
            try {
                fs.close();
                result.set(null);
            }
            catch (Throwable throwable) {
                result.setException(throwable);
            }
        });
        try {
            result.get(1L, TimeUnit.SECONDS);
            Assert.fail();
        }
        catch (TimeoutException timeoutException) {
        }
        finally {
            testExecutorService.shutdown();
        }
    }

    @Test
    public void shutdownNowSuccess_withoutListenerRemove() throws Exception {
        Firestore fs = (Firestore)FirestoreOptions.getDefaultInstance().getService();
        this.attachListener(fs);
        fs.shutdownNow();
    }

    @Test
    public void shutdownSuccess_withoutListenerRemove() throws Exception {
        Firestore fs = (Firestore)FirestoreOptions.getDefaultInstance().getService();
        this.attachListener(fs);
        fs.shutdown();
    }

    @Test
    public void closeAndShutdown() throws Exception {
        Firestore fs = (Firestore)FirestoreOptions.getDefaultInstance().getService();
        this.attachListener(fs);
        fs.shutdown();
        fs.shutdownNow();
        fs.close();
    }

    private ListenerRegistration attachListener(Firestore fs) throws InterruptedException {
        CountDownLatch cdl = new CountDownLatch(1);
        ListenerRegistration listenerRegistration = fs.collection(String.format("java-%s-%s", this.testName.getMethodName(), LocalFirestoreHelper.autoId())).addSnapshotListener((value, error) -> cdl.countDown());
        cdl.await();
        return listenerRegistration;
    }
}

