/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore.it;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.SettableApiFuture;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiStreamObserver;
import com.google.cloud.Timestamp;
import com.google.cloud.firestore.BulkWriter;
import com.google.cloud.firestore.CollectionReference;
import com.google.cloud.firestore.DocumentReference;
import com.google.cloud.firestore.DocumentSnapshot;
import com.google.cloud.firestore.FieldMask;
import com.google.cloud.firestore.FieldPath;
import com.google.cloud.firestore.FieldValue;
import com.google.cloud.firestore.Firestore;
import com.google.cloud.firestore.FirestoreBundle;
import com.google.cloud.firestore.FirestoreBundleTest;
import com.google.cloud.firestore.FirestoreException;
import com.google.cloud.firestore.FirestoreOptions;
import com.google.cloud.firestore.ListenerRegistration;
import com.google.cloud.firestore.LocalFirestoreHelper;
import com.google.cloud.firestore.Precondition;
import com.google.cloud.firestore.Query;
import com.google.cloud.firestore.QueryDocumentSnapshot;
import com.google.cloud.firestore.QueryPartition;
import com.google.cloud.firestore.QuerySnapshot;
import com.google.cloud.firestore.SetOptions;
import com.google.cloud.firestore.TransactionOptions;
import com.google.cloud.firestore.VectorValue;
import com.google.cloud.firestore.WriteBatch;
import com.google.cloud.firestore.WriteResult;
import com.google.cloud.firestore.it.ITBaseTest;
import com.google.cloud.firestore.it.TestHelper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.truth.Truth;
import com.google.firestore.bundle.BundleElement;
import com.google.firestore.bundle.BundledDocumentMetadata;
import com.google.firestore.bundle.BundledQuery;
import com.google.firestore.bundle.NamedQuery;
import com.google.firestore.v1.RunQueryRequest;
import com.google.protobuf.TimestampOrBuilder;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ITSystemTest
extends ITBaseTest {
    private static final double DOUBLE_EPSILON = 1.0E-6;
    private final Map<String, Object> SINGLE_FIELD_MAP = LocalFirestoreHelper.SINGLE_FIELD_MAP;
    private final Map<String, Object> ALL_SUPPORTED_TYPES_MAP = LocalFirestoreHelper.ALL_SUPPORTED_TYPES_MAP;
    private final LocalFirestoreHelper.SingleField SINGLE_FIELD_OBJECT = LocalFirestoreHelper.SINGLE_FIELD_OBJECT;
    private final LocalFirestoreHelper.AllSupportedTypes ALL_SUPPORTED_TYPES_OBJECT = LocalFirestoreHelper.ALL_SUPPORTED_TYPES_OBJECT;
    private final Map<String, Object> SINGLE_FILED_MAP_WITH_DOT = LocalFirestoreHelper.SINGLE_FILED_MAP_WITH_DOT;
    @Rule
    public TestName testName = new TestName();
    private CollectionReference randomColl;
    private DocumentReference randomDoc;

    @Override
    @Before
    public void before() throws Exception {
        super.before();
        this.randomColl = this.firestore.collection(String.format("java-%s-%s", this.testName.getMethodName(), LocalFirestoreHelper.autoId()));
        this.randomDoc = this.randomColl.document();
    }

    private DocumentReference setDocument(String documentId, Map<String, ?> fields) throws Exception {
        DocumentReference documentReference = this.randomColl.document(documentId);
        documentReference.set(fields).get();
        return documentReference;
    }

    private DocumentReference addDocument(String key, Object value, Object ... fields) throws Exception {
        DocumentReference documentReference = this.randomColl.document();
        documentReference.update(Precondition.NONE, key, value, fields).get();
        return documentReference;
    }

    private List<String> querySnapshotToIds(QuerySnapshot querySnapshot) {
        ArrayList<String> documentIds = new ArrayList<String>();
        for (QueryDocumentSnapshot snapshot : querySnapshot.getDocuments()) {
            documentIds.add(snapshot.getId());
        }
        return documentIds;
    }

    @Test
    public void getAll() throws Exception {
        DocumentReference ref1 = this.randomColl.document("doc1");
        DocumentReference ref2 = this.randomColl.document("doc2");
        ApiFutures.allAsList((Iterable)ImmutableList.of((Object)ref1.set(this.SINGLE_FIELD_MAP), (Object)ref2.set(this.SINGLE_FIELD_MAP))).get();
        List documentSnapshots = (List)this.firestore.getAll(new DocumentReference[]{ref1, ref2}).get();
        Assert.assertEquals((long)2L, (long)documentSnapshots.size());
        Assert.assertEquals((Object)"doc1", (Object)((DocumentSnapshot)documentSnapshots.get(0)).getId());
        Assert.assertEquals((Object)this.SINGLE_FIELD_OBJECT, (Object)((DocumentSnapshot)documentSnapshots.get(0)).toObject(LocalFirestoreHelper.SingleField.class));
        Assert.assertEquals((Object)"doc2", (Object)((DocumentSnapshot)documentSnapshots.get(1)).getId());
        Assert.assertEquals((Object)this.SINGLE_FIELD_OBJECT, (Object)((DocumentSnapshot)documentSnapshots.get(1)).toObject(LocalFirestoreHelper.SingleField.class));
    }

    @Test
    public void getAllWithFieldMask() throws Exception {
        DocumentReference ref = this.randomColl.document("doc1");
        ref.set(this.ALL_SUPPORTED_TYPES_MAP).get();
        List documentSnapshots = (List)this.firestore.getAll(new DocumentReference[]{ref}, FieldMask.of((String[])new String[]{"foo"})).get();
        Assert.assertEquals(LocalFirestoreHelper.map("foo", "bar", new Object[0]), (Object)((DocumentSnapshot)documentSnapshots.get(0)).getData());
    }

    @Test
    public void getFieldMaskWithDocumentReference() throws Exception {
        DocumentReference ref = this.randomColl.document("doc1");
        ref.set(this.ALL_SUPPORTED_TYPES_MAP).get();
        DocumentSnapshot documentSnapshots = (DocumentSnapshot)ref.get(FieldMask.of((String[])new String[]{"foo", "foobar"})).get();
        Assert.assertEquals((Object)"bar", (Object)documentSnapshots.get("foo"));
        Assert.assertNull((Object)documentSnapshots.get("foobar"));
    }

    @Test
    public void addDocument() throws Exception {
        DocumentReference documentReference = (DocumentReference)this.randomColl.add(this.SINGLE_FIELD_MAP).get();
        Assert.assertEquals((long)20L, (long)documentReference.getId().length());
        DocumentSnapshot documentSnapshot = (DocumentSnapshot)documentReference.get().get();
        Assert.assertEquals((Object)this.SINGLE_FIELD_OBJECT, (Object)documentSnapshot.toObject(LocalFirestoreHelper.SingleField.class));
    }

    @Test
    public void createDocument() throws Exception {
        Assert.assertEquals((long)20L, (long)this.randomDoc.getId().length());
        this.randomDoc.create(this.SINGLE_FIELD_MAP).get();
        DocumentSnapshot documentSnapshot = (DocumentSnapshot)this.randomDoc.get().get();
        Assert.assertEquals((Object)this.SINGLE_FIELD_OBJECT, (Object)documentSnapshot.toObject(LocalFirestoreHelper.SingleField.class));
    }

    @Test
    public void createDocumentWithValue() throws Exception {
        Assert.assertEquals((long)20L, (long)this.randomDoc.getId().length());
        this.randomDoc.create(LocalFirestoreHelper.SINGLE_FIELD_PROTO).get();
        DocumentSnapshot documentSnapshot = (DocumentSnapshot)this.randomDoc.get().get();
        Assert.assertEquals((Object)this.SINGLE_FIELD_OBJECT, (Object)documentSnapshot.toObject(LocalFirestoreHelper.SingleField.class));
    }

    @Test
    public void createDocumentWithFloat() throws Exception {
        Assert.assertEquals((long)20L, (long)this.randomDoc.getId().length());
        this.randomDoc.create(LocalFirestoreHelper.SINGLE_FLOAT_PROTO).get();
        DocumentSnapshot documentSnapshot = (DocumentSnapshot)this.randomDoc.get().get();
        Assert.assertEquals((Object)this.SINGLE_FIELD_OBJECT, (Object)documentSnapshot.toObject(LocalFirestoreHelper.SingleField.class));
    }

    @Test
    public void setDocument() throws Exception {
        HashMap<String, Double> nanNullMap = new HashMap<String, Double>();
        nanNullMap.put("nan", Double.NaN);
        nanNullMap.put("null", null);
        this.randomDoc.set(nanNullMap).get();
        DocumentSnapshot documentSnapshot = (DocumentSnapshot)this.randomDoc.get().get();
        Assert.assertEquals((Object)Double.NaN, (Object)documentSnapshot.getDouble("nan"));
        Assert.assertEquals(null, (Object)documentSnapshot.get("null"));
    }

    @Test
    public void setDocumentWithValue() throws Exception {
        Assert.assertEquals((long)20L, (long)this.randomDoc.getId().length());
        this.randomDoc.set(LocalFirestoreHelper.SINGLE_FIELD_PROTO).get();
        DocumentSnapshot documentSnapshot = (DocumentSnapshot)this.randomDoc.get().get();
        Assert.assertEquals((Object)this.SINGLE_FIELD_OBJECT, (Object)documentSnapshot.toObject(LocalFirestoreHelper.SingleField.class));
    }

    @Test
    public void setDocumentWithFloat() throws Exception {
        Assert.assertEquals((long)20L, (long)this.randomDoc.getId().length());
        this.randomDoc.set(LocalFirestoreHelper.SINGLE_FLOAT_PROTO).get();
        DocumentSnapshot documentSnapshot = (DocumentSnapshot)this.randomDoc.get().get();
        Assert.assertEquals((Object)this.SINGLE_FIELD_OBJECT, (Object)documentSnapshot.toObject(LocalFirestoreHelper.SingleField.class));
    }

    @Test
    public void setDocumentWithMerge() throws Exception {
        Map<String, String> originalMap = LocalFirestoreHelper.map("a.b", "c", "nested", LocalFirestoreHelper.map("d", "e", new Object[0]));
        Map<String, String> updateMap = LocalFirestoreHelper.map("f.g", "h", "nested", LocalFirestoreHelper.map("i", "j", new Object[0]));
        Map<String, String> resultMap = LocalFirestoreHelper.map("a.b", "c", "f.g", "h", "nested", LocalFirestoreHelper.map("d", "e", "i", "j"));
        this.randomDoc.set(originalMap).get();
        this.randomDoc.set(updateMap, SetOptions.merge()).get();
        DocumentSnapshot documentSnapshot = (DocumentSnapshot)this.randomDoc.get().get();
        Assert.assertEquals(resultMap, (Object)documentSnapshot.getData());
    }

    @Test
    public void setWithIncrementAndMerge() throws ExecutionException, InterruptedException {
        DocumentReference docRef = this.randomColl.document();
        docRef.set(Collections.singletonMap("sum", 1L)).get();
        docRef.set(Collections.singletonMap("sum", FieldValue.increment((long)2L)), SetOptions.merge()).get();
        DocumentSnapshot docSnap = (DocumentSnapshot)docRef.get().get();
        Assert.assertEquals((Object)3L, (Object)docSnap.get("sum"));
    }

    @Test
    public void mergeDocumentWithServerTimestamp() throws Exception {
        Map<String, String> originalMap = LocalFirestoreHelper.map("a", "b", new Object[0]);
        Map<String, FieldValue> updateMap = LocalFirestoreHelper.map("c", FieldValue.serverTimestamp(), new Object[0]);
        this.randomDoc.set(originalMap).get();
        this.randomDoc.set(updateMap, SetOptions.merge()).get();
        DocumentSnapshot documentSnapshot = (DocumentSnapshot)this.randomDoc.get().get();
        Assert.assertEquals((Object)"b", (Object)documentSnapshot.getString("a"));
        Assert.assertNotNull((Object)documentSnapshot.getDate("c"));
    }

    @Test
    public void updateDocument() throws Exception {
        LocalFirestoreHelper.AllSupportedTypes expectedResult = new LocalFirestoreHelper.AllSupportedTypes();
        WriteResult writeResult = (WriteResult)this.randomDoc.set(this.ALL_SUPPORTED_TYPES_MAP).get();
        DocumentSnapshot documentSnapshot = (DocumentSnapshot)this.randomDoc.get().get();
        Assert.assertEquals((Object)expectedResult, (Object)documentSnapshot.toObject(LocalFirestoreHelper.AllSupportedTypes.class));
        this.randomDoc.update(Precondition.updatedAt((Timestamp)writeResult.getUpdateTime()), "foo", (Object)"updated", new Object[0]).get();
        documentSnapshot = (DocumentSnapshot)this.randomDoc.get().get();
        expectedResult.foo = "updated";
        Assert.assertEquals((Object)expectedResult, (Object)documentSnapshot.toObject(LocalFirestoreHelper.AllSupportedTypes.class));
        expectedResult.model = ImmutableMap.of((Object)"foo", (Object)LocalFirestoreHelper.UPDATE_SINGLE_FIELD_OBJECT.foo);
        this.randomDoc.update("model", (Object)LocalFirestoreHelper.UPDATE_SINGLE_FIELD_OBJECT, new Object[0]).get();
        documentSnapshot = (DocumentSnapshot)this.randomDoc.get().get();
        Assert.assertEquals((Object)expectedResult, (Object)documentSnapshot.toObject(LocalFirestoreHelper.AllSupportedTypes.class));
    }

    @Test(expected=ExecutionException.class)
    public void updateDocumentExists() throws Exception {
        this.randomDoc.update(this.SINGLE_FIELD_MAP).get();
    }

    @Test
    public void serverTimestamp() throws Exception {
        this.randomDoc.set(LocalFirestoreHelper.map("time", FieldValue.serverTimestamp(), new Object[0])).get();
        DocumentSnapshot documentSnapshot = (DocumentSnapshot)this.randomDoc.get().get();
        Assert.assertTrue((documentSnapshot.getDate("time").getTime() > 0L ? 1 : 0) != 0);
    }

    @Test
    public void timestampDoesntGetTruncatedDuringUpdate() throws Exception {
        DocumentReference documentReference = this.addDocument("time", Timestamp.ofTimeSecondsAndNanos((long)0L, (int)123000), new Object[0]);
        DocumentSnapshot documentSnapshot = (DocumentSnapshot)documentReference.get().get();
        Timestamp timestamp = documentSnapshot.getTimestamp("time");
        documentReference.update("time", (Object)timestamp, new Object[0]);
        documentSnapshot = (DocumentSnapshot)documentReference.get().get();
        timestamp = documentSnapshot.getTimestamp("time");
        Assert.assertEquals((long)123000L, (long)timestamp.getNanos());
    }

    @Test
    public void fieldDelete() throws Exception {
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("foo1", "bar1");
        fields.put("foo2", "bar2");
        this.randomDoc.set(fields).get();
        DocumentSnapshot documentSnapshot = (DocumentSnapshot)this.randomDoc.get().get();
        Assert.assertEquals((Object)"bar1", (Object)documentSnapshot.getString("foo1"));
        Assert.assertEquals((Object)"bar2", (Object)documentSnapshot.getString("foo2"));
        this.randomDoc.update("foo1", (Object)"bar3", new Object[]{"foo2", FieldValue.delete()}).get();
        documentSnapshot = (DocumentSnapshot)this.randomDoc.get().get();
        Assert.assertEquals((Object)"bar3", (Object)documentSnapshot.getString("foo1"));
        Assert.assertNull((Object)documentSnapshot.getString("foo2"));
    }

    @Test
    public void deleteDocument() throws Exception {
        this.randomDoc.delete().get();
        WriteResult writeResult = (WriteResult)this.randomDoc.set(this.ALL_SUPPORTED_TYPES_MAP).get();
        try {
            this.randomDoc.delete(Precondition.updatedAt((Timestamp)Timestamp.ofTimeSecondsAndNanos((long)1L, (int)0))).get();
            Assert.fail();
        }
        catch (ExecutionException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("FAILED_PRECONDITION"));
        }
        writeResult = (WriteResult)this.randomDoc.delete(Precondition.updatedAt((Timestamp)writeResult.getUpdateTime())).get();
        DocumentSnapshot documentSnapshot = (DocumentSnapshot)this.randomDoc.get().get();
        Assert.assertFalse((boolean)documentSnapshot.exists());
        Assert.assertTrue((writeResult.getUpdateTime().getSeconds() > 0L ? 1 : 0) != 0);
    }

    @Test
    public void defaultQuery() throws Exception {
        this.addDocument("foo", "bar", new Object[0]);
        this.addDocument("foo", "bar", new Object[0]);
        QuerySnapshot querySnapshot = (QuerySnapshot)this.randomColl.get().get();
        Assert.assertEquals((long)2L, (long)querySnapshot.size());
        Iterator documents = querySnapshot.iterator();
        Assert.assertEquals((Object)"bar", (Object)((QueryDocumentSnapshot)documents.next()).get("foo"));
        Assert.assertEquals((Object)"bar", (Object)((QueryDocumentSnapshot)documents.next()).get("foo"));
    }

    @Test
    public void defaultQueryStream() throws Exception {
        this.addDocument("foo", "bar", new Object[0]);
        this.addDocument("foo", "bar", new Object[0]);
        final Semaphore semaphore = new Semaphore(0);
        final Iterator<String> iterator = Arrays.asList("bar", "bar").iterator();
        this.randomColl.stream((ApiStreamObserver)new ApiStreamObserver<DocumentSnapshot>(){

            public void onNext(DocumentSnapshot documentSnapshot) {
                Assert.assertEquals(iterator.next(), (Object)documentSnapshot.get("foo"));
            }

            public void onError(Throwable throwable) {
            }

            public void onCompleted() {
                semaphore.release();
            }
        });
        semaphore.acquire();
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void largeQuery() throws Exception {
        int count = 100;
        while (count-- > 0) {
            this.addDocument("foo", "bar", new Object[0]);
        }
        QuerySnapshot querySnapshot = (QuerySnapshot)this.randomColl.get().get();
        Assert.assertEquals((long)100L, (long)querySnapshot.size());
    }

    @Test
    public void largeQueryStream() throws Exception {
        int count = 100;
        while (count-- > 0) {
            this.addDocument("foo", "bar", new Object[0]);
        }
        final Semaphore semaphore = new Semaphore(0);
        final int[] docCount = new int[]{0};
        this.randomColl.stream((ApiStreamObserver)new ApiStreamObserver<DocumentSnapshot>(){

            public void onNext(DocumentSnapshot documentSnapshot) {
                docCount[0] = docCount[0] + 1;
            }

            public void onError(Throwable throwable) {
                Assert.fail();
            }

            public void onCompleted() {
                semaphore.release();
            }
        });
        semaphore.acquire();
        Assert.assertEquals((long)100L, (long)docCount[0]);
    }

    @Test
    public void noResults() throws Exception {
        QuerySnapshot querySnapshot = (QuerySnapshot)this.randomColl.get().get();
        Assert.assertTrue((boolean)querySnapshot.isEmpty());
        Assert.assertNotNull((Object)querySnapshot.getReadTime());
    }

    @Test
    public void noResultsStream() throws Exception {
        final Semaphore semaphore = new Semaphore(0);
        final int[] docCount = new int[]{0};
        this.randomColl.stream((ApiStreamObserver)new ApiStreamObserver<DocumentSnapshot>(){

            public void onNext(DocumentSnapshot documentSnapshot) {
                docCount[0] = docCount[0] + 1;
            }

            public void onError(Throwable throwable) {
                Assert.fail();
            }

            public void onCompleted() {
                semaphore.release();
            }
        });
        semaphore.acquire();
        Assert.assertEquals((long)0L, (long)docCount[0]);
    }

    @Test
    public void queryWithMicrosecondPrecision() throws Exception {
        Timestamp microsecondTimestamp = Timestamp.ofTimeSecondsAndNanos((long)0L, (int)123000);
        DocumentReference documentReference = this.addDocument("time", microsecondTimestamp, new Object[0]);
        DocumentSnapshot documentSnapshot = (DocumentSnapshot)documentReference.get().get();
        Query query = this.randomColl.whereEqualTo("time", (Object)microsecondTimestamp);
        QuerySnapshot querySnapshot = (QuerySnapshot)query.get().get();
        Assert.assertEquals((long)1L, (long)querySnapshot.size());
        query = this.randomColl.whereEqualTo("time", (Object)microsecondTimestamp.toDate());
        querySnapshot = (QuerySnapshot)query.get().get();
        Assert.assertEquals((long)0L, (long)querySnapshot.size());
    }

    @Test
    public void nestedQuery() throws Exception {
        this.randomColl = this.randomColl.document("foo").collection("bar");
        this.addDocument("foo", "bar", new Object[0]);
        QuerySnapshot querySnapshot = (QuerySnapshot)this.randomColl.get().get();
        DocumentSnapshot documentSnapshot = (DocumentSnapshot)querySnapshot.getDocuments().get(0);
        Assert.assertTrue((boolean)documentSnapshot.getReference().getPath().contains("/foo/bar"));
    }

    @Test
    public void limitQuery() throws Exception {
        this.setDocument("doc1", Collections.singletonMap("counter", 1));
        this.setDocument("doc2", Collections.singletonMap("counter", 2));
        this.setDocument("doc3", Collections.singletonMap("counter", 3));
        QuerySnapshot querySnapshot = (QuerySnapshot)this.randomColl.orderBy("counter").limit(2).get().get();
        Assert.assertEquals(Arrays.asList("doc1", "doc2"), this.querySnapshotToIds(querySnapshot));
    }

    @Test
    public void limitQueryStream() throws Exception {
        this.setDocument("doc1", Collections.singletonMap("counter", 1));
        this.setDocument("doc2", Collections.singletonMap("counter", 2));
        this.setDocument("doc3", Collections.singletonMap("counter", 3));
        final Semaphore semaphore = new Semaphore(0);
        final Iterator<String> iterator = Arrays.asList("doc1", "doc2").iterator();
        this.randomColl.orderBy("counter").limit(2).stream((ApiStreamObserver)new ApiStreamObserver<DocumentSnapshot>(){

            public void onNext(DocumentSnapshot documentSnapshot) {
                Assert.assertEquals(iterator.next(), (Object)documentSnapshot.getId());
            }

            public void onError(Throwable throwable) {
                Assert.fail();
            }

            public void onCompleted() {
                semaphore.release();
            }
        });
        semaphore.acquire();
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void limitToLastQuery() throws Exception {
        this.setDocument("doc1", Collections.singletonMap("counter", 1));
        this.setDocument("doc2", Collections.singletonMap("counter", 2));
        this.setDocument("doc3", Collections.singletonMap("counter", 3));
        QuerySnapshot querySnapshot = (QuerySnapshot)this.randomColl.orderBy("counter").limitToLast(2).get().get();
        Assert.assertEquals(Arrays.asList("doc2", "doc3"), this.querySnapshotToIds(querySnapshot));
    }

    @Test
    public void largerLimitQuery() throws Exception {
        this.setDocument("doc1", Collections.singletonMap("counter", 1));
        this.setDocument("doc2", Collections.singletonMap("counter", 2));
        this.setDocument("doc3", Collections.singletonMap("counter", 3));
        QuerySnapshot querySnapshot = (QuerySnapshot)this.randomColl.orderBy("counter").limit(4).get().get();
        Assert.assertEquals(Arrays.asList("doc1", "doc2", "doc3"), this.querySnapshotToIds(querySnapshot));
    }

    @Test
    public void largerLimitQueryStream() throws Exception {
        this.setDocument("doc1", Collections.singletonMap("counter", 1));
        this.setDocument("doc2", Collections.singletonMap("counter", 2));
        this.setDocument("doc3", Collections.singletonMap("counter", 3));
        final Semaphore semaphore = new Semaphore(0);
        final Iterator<String> iterator = Arrays.asList("doc1", "doc2", "doc3").iterator();
        this.randomColl.orderBy("counter").limit(4).stream((ApiStreamObserver)new ApiStreamObserver<DocumentSnapshot>(){

            public void onNext(DocumentSnapshot documentSnapshot) {
                Assert.assertEquals(iterator.next(), (Object)documentSnapshot.getId());
            }

            public void onError(Throwable throwable) {
                Assert.fail();
            }

            public void onCompleted() {
                semaphore.release();
            }
        });
        semaphore.acquire();
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void offsetQuery() throws Exception {
        this.addDocument("foo", "bar", new Object[0]);
        this.addDocument("foo", "bar", new Object[0]);
        QuerySnapshot querySnapshot = (QuerySnapshot)this.randomColl.offset(1).get().get();
        Assert.assertEquals((long)1L, (long)querySnapshot.size());
        Assert.assertEquals((Object)"bar", (Object)((QueryDocumentSnapshot)querySnapshot.getDocuments().get(0)).get("foo"));
    }

    @Test
    public void offsetQueryStream() throws Exception {
        this.addDocument("foo", "bar", new Object[0]);
        this.addDocument("foo", "bar", new Object[0]);
        final Semaphore semaphore = new Semaphore(0);
        final Iterator<String> iterator = Collections.singletonList("bar").iterator();
        this.randomColl.offset(1).stream((ApiStreamObserver)new ApiStreamObserver<DocumentSnapshot>(){

            public void onNext(DocumentSnapshot documentSnapshot) {
                Assert.assertEquals(iterator.next(), (Object)documentSnapshot.get("foo"));
            }

            public void onError(Throwable throwable) {
                Assert.fail();
            }

            public void onCompleted() {
                semaphore.release();
            }
        });
        semaphore.acquire();
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void largerOffsetQuery() throws Exception {
        this.addDocument("foo", "bar", new Object[0]);
        this.addDocument("foo", "bar", new Object[0]);
        QuerySnapshot querySnapshot = (QuerySnapshot)this.randomColl.offset(3).get().get();
        Assert.assertEquals((long)0L, (long)querySnapshot.size());
    }

    @Test
    public void largerOffsetQueryStream() throws Exception {
        this.addDocument("foo", "bar", new Object[0]);
        this.addDocument("foo", "bar", new Object[0]);
        final Semaphore semaphore = new Semaphore(0);
        final int[] docCount = new int[]{0};
        this.randomColl.offset(3).stream((ApiStreamObserver)new ApiStreamObserver<DocumentSnapshot>(){

            public void onNext(DocumentSnapshot documentSnapshot) {
                docCount[0] = docCount[0] + 1;
            }

            public void onError(Throwable throwable) {
                Assert.fail();
            }

            public void onCompleted() {
                semaphore.release();
            }
        });
        semaphore.acquire();
        Assert.assertEquals((long)0L, (long)docCount[0]);
    }

    @Test
    public void orderByQuery() throws Exception {
        this.addDocument("foo", 1, new Object[0]);
        this.addDocument("foo", 2, new Object[0]);
        QuerySnapshot querySnapshot = (QuerySnapshot)this.randomColl.orderBy("foo").get().get();
        Iterator documents = querySnapshot.iterator();
        Assert.assertEquals((Object)1L, (Object)((QueryDocumentSnapshot)documents.next()).get("foo"));
        Assert.assertEquals((Object)2L, (Object)((QueryDocumentSnapshot)documents.next()).get("foo"));
        querySnapshot = (QuerySnapshot)this.randomColl.orderBy("foo", Query.Direction.DESCENDING).get().get();
        documents = querySnapshot.iterator();
        Assert.assertEquals((Object)2L, (Object)((QueryDocumentSnapshot)documents.next()).get("foo"));
        Assert.assertEquals((Object)1L, (Object)((QueryDocumentSnapshot)documents.next()).get("foo"));
    }

    @Test
    public void orderByQueryStream() throws Exception {
        this.addDocument("foo", 1, new Object[0]);
        this.addDocument("foo", 2, new Object[0]);
        final Semaphore semaphore = new Semaphore(0);
        final Iterator<Long> iteratorAscending = Arrays.asList(1L, 2L).iterator();
        this.randomColl.orderBy("foo").stream((ApiStreamObserver)new ApiStreamObserver<DocumentSnapshot>(){

            public void onNext(DocumentSnapshot documentSnapshot) {
                Assert.assertEquals(iteratorAscending.next(), (Object)documentSnapshot.get("foo"));
            }

            public void onError(Throwable throwable) {
                Assert.fail();
            }

            public void onCompleted() {
                semaphore.release();
            }
        });
        semaphore.acquire();
        Assert.assertFalse((boolean)iteratorAscending.hasNext());
        final Iterator<Long> iteratorDescending = Arrays.asList(2L, 1L).iterator();
        this.randomColl.orderBy("foo", Query.Direction.DESCENDING).stream((ApiStreamObserver)new ApiStreamObserver<DocumentSnapshot>(){

            public void onNext(DocumentSnapshot documentSnapshot) {
                Assert.assertEquals(iteratorDescending.next(), (Object)documentSnapshot.get("foo"));
            }

            public void onError(Throwable throwable) {
                Assert.fail();
            }

            public void onCompleted() {
                semaphore.release();
            }
        });
        semaphore.acquire();
        Assert.assertFalse((boolean)iteratorDescending.hasNext());
    }

    @Test
    public void selectQuery() throws Exception {
        this.addDocument("foo", 1, "bar", 2);
        QuerySnapshot querySnapshot = (QuerySnapshot)this.randomColl.select(new String[]{"foo"}).get().get();
        Assert.assertEquals((long)1L, (long)querySnapshot.size());
        DocumentSnapshot documentSnapshot = (DocumentSnapshot)querySnapshot.getDocuments().get(0);
        Assert.assertEquals((Object)1L, (Object)documentSnapshot.get("foo"));
        Assert.assertNull((Object)documentSnapshot.get("bar"));
    }

    @Test
    public void equalsQuery() throws Exception {
        this.addDocument("foo", 1, new Object[0]);
        this.addDocument("foo", 2, new Object[0]);
        QuerySnapshot querySnapshot = (QuerySnapshot)this.randomColl.whereEqualTo("foo", (Object)1).get().get();
        Assert.assertEquals((long)1L, (long)querySnapshot.size());
        Assert.assertEquals((Object)1L, (Object)((QueryDocumentSnapshot)querySnapshot.getDocuments().get(0)).get("foo"));
    }

    @Test
    public void greaterThanQuery() throws Exception {
        this.addDocument("foo", 1, new Object[0]);
        this.addDocument("foo", 2, new Object[0]);
        QuerySnapshot querySnapshot = (QuerySnapshot)this.randomColl.whereGreaterThan("foo", (Object)1).get().get();
        Assert.assertEquals((long)1L, (long)querySnapshot.size());
        Assert.assertEquals((Object)2L, (Object)((QueryDocumentSnapshot)querySnapshot.getDocuments().get(0)).get("foo"));
    }

    @Test
    public void multipleInequalityQueryOnSamePropertiesShouldBeSupported() throws Exception {
        this.addDocument("foo", 1, new Object[0]);
        QuerySnapshot querySnapshot = (QuerySnapshot)this.randomColl.whereGreaterThan("foo", (Object)0).whereLessThanOrEqualTo("foo", (Object)2).get().get();
        Assert.assertEquals((long)1L, (long)querySnapshot.size());
        Assert.assertEquals((Object)1L, (Object)((QueryDocumentSnapshot)querySnapshot.getDocuments().get(0)).get("foo"));
    }

    @Test
    public void multipleInequalityQueryOnDifferentPropertiesShouldBeSupported() throws Exception {
        Assume.assumeTrue((String)"Skip this test if running against production because multiple inequality is not supported yet.", (boolean)TestHelper.isRunningAgainstFirestoreEmulator(this.firestore));
        this.addDocument("foo", 1, "bar", 2);
        QuerySnapshot querySnapshot = (QuerySnapshot)this.randomColl.whereGreaterThan("foo", (Object)0).whereLessThanOrEqualTo("bar", (Object)2).get().get();
        Assert.assertEquals((long)1L, (long)querySnapshot.size());
        Assert.assertEquals((Object)1L, (Object)((QueryDocumentSnapshot)querySnapshot.getDocuments().get(0)).get("foo"));
    }

    @Test
    public void greaterThanOrEqualQuery() throws Exception {
        this.addDocument("foo", 1, new Object[0]);
        this.addDocument("foo", 2, new Object[0]);
        QuerySnapshot querySnapshot = (QuerySnapshot)this.randomColl.whereGreaterThanOrEqualTo("foo", (Object)1).get().get();
        Assert.assertEquals((long)2L, (long)querySnapshot.size());
    }

    @Test
    public void lessThanQuery() throws Exception {
        this.addDocument("foo", 1, new Object[0]);
        this.addDocument("foo", 2, new Object[0]);
        QuerySnapshot querySnapshot = (QuerySnapshot)this.randomColl.whereLessThan("foo", (Object)2).get().get();
        Assert.assertEquals((long)1L, (long)querySnapshot.size());
        Assert.assertEquals((Object)1L, (Object)((QueryDocumentSnapshot)querySnapshot.getDocuments().get(0)).get("foo"));
    }

    @Test
    public void lessThanOrEqualQuery() throws Exception {
        this.addDocument("foo", 1, new Object[0]);
        this.addDocument("foo", 2, new Object[0]);
        QuerySnapshot querySnapshot = (QuerySnapshot)this.randomColl.whereLessThanOrEqualTo("foo", (Object)2).get().get();
        Assert.assertEquals((long)2L, (long)querySnapshot.size());
    }

    @Test
    public void unaryQuery() throws Exception {
        this.addDocument("foo", 1, "bar", Double.NaN);
        this.addDocument("foo", 2, "bar", null);
        QuerySnapshot querySnapshot = (QuerySnapshot)this.randomColl.whereEqualTo("bar", (Object)Double.NaN).get().get();
        Assert.assertEquals((long)1L, (long)querySnapshot.size());
        DocumentSnapshot documentSnapshot = (DocumentSnapshot)querySnapshot.getDocuments().get(0);
        Assert.assertEquals((Object)1L, (Object)documentSnapshot.get("foo"));
        Assert.assertEquals((Object)Double.NaN, (Object)documentSnapshot.get("bar"));
        querySnapshot = (QuerySnapshot)this.randomColl.whereEqualTo("bar", null).get().get();
        Assert.assertEquals((long)1L, (long)querySnapshot.size());
        documentSnapshot = (DocumentSnapshot)querySnapshot.getDocuments().get(0);
        Assert.assertEquals((Object)2L, (Object)documentSnapshot.get("foo"));
        Assert.assertNull((Object)documentSnapshot.get("bar"));
    }

    @Test
    public void startAt() throws Exception {
        this.addDocument("foo", 1, new Object[0]);
        this.addDocument("foo", 2, new Object[0]);
        QuerySnapshot querySnapshot = (QuerySnapshot)this.randomColl.orderBy("foo").startAt(new Object[]{1}).get().get();
        Assert.assertEquals((long)2L, (long)querySnapshot.size());
        Iterator documents = querySnapshot.iterator();
        Assert.assertEquals((Object)1L, (Object)((QueryDocumentSnapshot)documents.next()).get("foo"));
        Assert.assertEquals((Object)2L, (Object)((QueryDocumentSnapshot)documents.next()).get("foo"));
    }

    @Test
    public void startAfter() throws Exception {
        this.addDocument("foo", 1, new Object[0]);
        this.addDocument("foo", 2, new Object[0]);
        QuerySnapshot querySnapshot = (QuerySnapshot)this.randomColl.orderBy("foo").startAfter(new Object[]{1}).get().get();
        Assert.assertEquals((long)1L, (long)querySnapshot.size());
        Assert.assertEquals((Object)2L, (Object)((QueryDocumentSnapshot)querySnapshot.getDocuments().get(0)).get("foo"));
    }

    @Test
    public void startAfterAddsAnImplicitOrderByForDocumentReferences() throws Exception {
        DocumentReference doc1 = this.randomColl.document("doc1");
        DocumentReference doc2 = this.randomColl.document("doc2");
        doc1.set(LocalFirestoreHelper.map("foo", 1, new Object[0])).get();
        doc2.set(LocalFirestoreHelper.map("foo", 1, new Object[0])).get();
        QuerySnapshot querySnapshot = (QuerySnapshot)this.randomColl.startAfter(new Object[]{doc1}).get().get();
        Assert.assertEquals((long)1L, (long)querySnapshot.size());
        Iterator documents = querySnapshot.iterator();
        Assert.assertEquals((Object)doc2, (Object)((QueryDocumentSnapshot)documents.next()).getReference());
    }

    @Test
    public void endAt() throws Exception {
        this.addDocument("foo", 1, new Object[0]);
        this.addDocument("foo", 2, new Object[0]);
        QuerySnapshot querySnapshot = (QuerySnapshot)this.randomColl.orderBy("foo").endAt(new Object[]{2}).get().get();
        Assert.assertEquals((long)2L, (long)querySnapshot.size());
        Iterator documents = querySnapshot.iterator();
        Assert.assertEquals((Object)1L, (Object)((QueryDocumentSnapshot)documents.next()).get("foo"));
        Assert.assertEquals((Object)2L, (Object)((QueryDocumentSnapshot)documents.next()).get("foo"));
    }

    @Test
    public void endBefore() throws Exception {
        this.addDocument("foo", 1, new Object[0]);
        this.addDocument("foo", 2, new Object[0]);
        QuerySnapshot querySnapshot = (QuerySnapshot)this.randomColl.orderBy("foo").endBefore(new Object[]{2}).get().get();
        Assert.assertEquals((long)1L, (long)querySnapshot.size());
        Assert.assertEquals((Object)1L, (Object)((QueryDocumentSnapshot)querySnapshot.getDocuments().get(0)).get("foo"));
    }

    @Test
    public void partitionedQuery() throws Exception {
        int documentCount = 383;
        WriteBatch batch = this.firestore.batch();
        for (int i = 0; i < documentCount; ++i) {
            batch.create(this.randomColl.document(), LocalFirestoreHelper.map("foo", i, new Object[0]));
        }
        batch.commit().get();
        StreamConsumer consumer = new StreamConsumer();
        this.firestore.collectionGroup(this.randomColl.getId()).getPartitions(3L, consumer);
        List partitions = (List)consumer.consume().get();
        Assert.assertNull((Object)((QueryPartition)partitions.get(0)).getStartAt());
        for (int i = 0; i < partitions.size() - 1; ++i) {
            Assert.assertArrayEquals((Object[])((QueryPartition)partitions.get(i)).getEndBefore(), (Object[])((QueryPartition)partitions.get(i + 1)).getStartAt());
        }
        Assert.assertNull((Object)((QueryPartition)partitions.get(partitions.size() - 1)).getEndBefore());
        int resultCount = 0;
        for (QueryPartition partition : partitions) {
            resultCount += ((QuerySnapshot)partition.createQuery().get().get()).size();
        }
        Assert.assertEquals((long)documentCount, (long)resultCount);
    }

    @Test
    public void partitionedQuery_future() throws Exception {
        int documentCount = 383;
        WriteBatch batch = this.firestore.batch();
        for (int i = 0; i < documentCount; ++i) {
            batch.create(this.randomColl.document(), LocalFirestoreHelper.map("foo", i, new Object[0]));
        }
        batch.commit().get();
        ApiFuture future = this.firestore.collectionGroup(this.randomColl.getId()).getPartitions(3L);
        List partitions = (List)future.get();
        Assert.assertNull((Object)((QueryPartition)partitions.get(0)).getStartAt());
        for (int i = 0; i < partitions.size() - 1; ++i) {
            Assert.assertArrayEquals((Object[])((QueryPartition)partitions.get(i)).getEndBefore(), (Object[])((QueryPartition)partitions.get(i + 1)).getStartAt());
        }
        Assert.assertNull((Object)((QueryPartition)partitions.get(partitions.size() - 1)).getEndBefore());
        int resultCount = 0;
        for (QueryPartition partition : partitions) {
            resultCount += ((QuerySnapshot)partition.createQuery().get().get()).size();
        }
        Assert.assertEquals((long)documentCount, (long)resultCount);
    }

    @Test
    public void emptyPartitionedQuery() throws Exception {
        StreamConsumer consumer = new StreamConsumer();
        this.firestore.collectionGroup(this.randomColl.getId()).getPartitions(3L, consumer);
        List partitions = (List)consumer.consume().get();
        Assert.assertEquals((long)1L, (long)partitions.size());
        Assert.assertNull((Object)((QueryPartition)partitions.get(0)).getStartAt());
        Assert.assertNull((Object)((QueryPartition)partitions.get(0)).getEndBefore());
    }

    @Test
    public void validatesPartitionCount() {
        StreamConsumer consumer = new StreamConsumer();
        try {
            this.firestore.collectionGroup(this.randomColl.getId()).getPartitions(0L, consumer);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Desired partition count must be one or greater", (Object)e.getMessage());
        }
    }

    @Test
    public void failedTransaction() {
        try {
            this.firestore.runTransaction(transaction -> {
                throw new RuntimeException("User exception");
            }).get();
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().endsWith("User exception"));
        }
    }

    @Test
    public void asyncTxFailsWithUserError() throws Exception {
        try {
            this.firestore.runAsyncTransaction(transaction -> {
                throw new RuntimeException("User exception");
            }).get();
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().endsWith("User exception"));
        }
    }

    @Test
    public void doesNotRetryTransactionsWithFailedPreconditions() {
        DocumentReference documentReference = this.randomColl.document();
        AtomicInteger attempts = new AtomicInteger();
        ApiFuture firstTransaction = this.firestore.runTransaction(transaction -> {
            attempts.incrementAndGet();
            transaction.update(documentReference, "foo", (Object)"bar", new Object[0]);
            return null;
        });
        try {
            firstTransaction.get();
            Assert.fail((String)"ApiFuture should fail with ExecutionException");
        }
        catch (InterruptedException e) {
            Assert.fail((String)"ApiFuture should fail with ExecutionException");
        }
        catch (ExecutionException e) {
            Assert.assertEquals((long)1L, (long)attempts.intValue());
            Assert.assertEquals((long)404L, (long)((FirestoreException)e.getCause()).getCode());
        }
    }

    @Test
    public void successfulTransactionWithContention() throws Exception {
        DocumentReference documentReference = this.addDocument("counter", 1, new Object[0]);
        CountDownLatch latch = new CountDownLatch(2);
        AtomicInteger attempts = new AtomicInteger();
        ApiFuture firstTransaction = this.firestore.runTransaction(transaction -> {
            attempts.incrementAndGet();
            DocumentSnapshot documentSnapshot = (DocumentSnapshot)transaction.get(documentReference).get();
            latch.countDown();
            latch.await();
            transaction.update(documentReference, "counter", (Object)(documentSnapshot.getLong("counter") + 1L), new Object[0]);
            return "foo";
        });
        ApiFuture secondTransaction = this.firestore.runTransaction(transaction -> {
            attempts.incrementAndGet();
            List documentSnapshots = (List)transaction.getAll(new DocumentReference[]{documentReference}).get();
            latch.countDown();
            latch.await();
            transaction.update(documentReference, "counter", (Object)(((DocumentSnapshot)documentSnapshots.get(0)).getLong("counter") + 1L), new Object[0]);
            return "bar";
        });
        Assert.assertEquals((Object)"foo", (Object)firstTransaction.get());
        Assert.assertEquals((Object)"bar", (Object)secondTransaction.get());
        Assert.assertEquals((long)3L, (long)attempts.intValue());
        Assert.assertEquals((long)3L, (long)((DocumentSnapshot)documentReference.get().get()).getLong("counter"));
    }

    @Test
    public void writeBatch() throws Exception {
        DocumentReference createDocument = this.randomColl.document();
        DocumentReference setDocument = this.randomColl.document();
        DocumentReference updateDocument = this.addDocument("foo", "bar", new Object[0]);
        DocumentReference deleteDocument = this.addDocument("foo", "bar", new Object[0]);
        WriteBatch batch = this.firestore.batch();
        batch.create(createDocument, (Object)this.SINGLE_FIELD_OBJECT);
        batch.set(setDocument, (Object)this.ALL_SUPPORTED_TYPES_OBJECT);
        batch.update(updateDocument, "foo", (Object)"foobar", new Object[0]);
        batch.delete(deleteDocument);
        batch.commit().get();
        List documentSnapshots = (List)this.firestore.getAll(new DocumentReference[]{createDocument, setDocument, updateDocument, deleteDocument}).get();
        Iterator iterator = documentSnapshots.iterator();
        Assert.assertEquals((Object)this.SINGLE_FIELD_OBJECT, (Object)((DocumentSnapshot)iterator.next()).toObject(LocalFirestoreHelper.SingleField.class));
        Assert.assertEquals((Object)this.ALL_SUPPORTED_TYPES_OBJECT, (Object)((DocumentSnapshot)iterator.next()).toObject(LocalFirestoreHelper.AllSupportedTypes.class));
        Assert.assertEquals((Object)"foobar", (Object)((DocumentSnapshot)iterator.next()).get("foo"));
        Assert.assertFalse((boolean)((DocumentSnapshot)iterator.next()).exists());
    }

    @Test
    public void omitWriteResultForDocumentTransforms() throws ExecutionException, InterruptedException {
        WriteBatch batch = this.firestore.batch();
        batch.set(this.randomColl.document(), this.SINGLE_FIELD_MAP);
        batch.set(this.randomColl.document(), LocalFirestoreHelper.map("time", FieldValue.serverTimestamp(), new Object[0]));
        List writeResults = (List)batch.commit().get();
        Assert.assertEquals((long)2L, (long)writeResults.size());
    }

    @Test
    public void listCollections() throws Exception {
        Object[] collections = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21"};
        Arrays.sort(collections);
        WriteBatch batch = this.firestore.batch();
        for (Object collection : collections) {
            batch.create(this.randomDoc.collection((String)collection).document("doc"), (Object)this.SINGLE_FIELD_OBJECT);
        }
        batch.commit().get();
        Iterable collectionRefs = this.randomDoc.listCollections();
        int count = 0;
        for (CollectionReference collectionRef : collectionRefs) {
            Assert.assertEquals((Object)collections[count++], (Object)collectionRef.getId());
        }
        Assert.assertEquals((long)collections.length, (long)count);
    }

    @Test
    public void listDocuments() throws Exception {
        Object[] documents = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21"};
        Arrays.sort(documents);
        WriteBatch batch = this.firestore.batch();
        for (Object document : documents) {
            batch.create(this.randomColl.document((String)document), (Object)this.SINGLE_FIELD_OBJECT);
        }
        batch.commit().get();
        Iterable collectionRefs = this.randomColl.listDocuments();
        int count = 0;
        for (DocumentReference documentRef : collectionRefs) {
            Assert.assertEquals((Object)documents[count++], (Object)documentRef.getId());
        }
        Assert.assertEquals((long)documents.length, (long)count);
    }

    @Test
    public void listDocumentsListsMissingDocument() throws Exception {
        this.randomColl.document("missing/foo/bar").set(this.SINGLE_FIELD_MAP).get();
        Iterable collectionRefs = this.randomColl.listDocuments();
        Assert.assertEquals((Object)this.randomColl.document("missing"), collectionRefs.iterator().next());
    }

    @Test
    public void addAndRemoveFields() throws ExecutionException, InterruptedException {
        Map<Object, Object> expected = new HashMap<String, Map<String, String>>();
        this.randomDoc.create(Collections.emptyMap()).get();
        Assert.assertEquals(expected, this.getData());
        this.randomDoc.delete().get();
        Assert.assertFalse((boolean)((DocumentSnapshot)this.randomDoc.get().get()).exists());
        this.randomDoc.create(LocalFirestoreHelper.map("a", LocalFirestoreHelper.map("b", "c", new Object[0]), new Object[0])).get();
        expected.put("a", LocalFirestoreHelper.map("b", "c", new Object[0]));
        Assert.assertEquals(expected, this.getData());
        this.randomDoc.set(Collections.emptyMap()).get();
        expected = LocalFirestoreHelper.map();
        Assert.assertEquals(expected, this.getData());
        this.randomDoc.set(LocalFirestoreHelper.map("a", LocalFirestoreHelper.map("b", "c", new Object[0]), new Object[0])).get();
        expected.put("a", LocalFirestoreHelper.map("b", "c", new Object[0]));
        Assert.assertEquals(expected, this.getData());
        this.randomDoc.set(LocalFirestoreHelper.map("a", LocalFirestoreHelper.map("d", "e", new Object[0]), new Object[0]), SetOptions.merge()).get();
        this.getNestedMap(expected, "a").put("d", "e");
        Assert.assertEquals(expected, this.getData());
        this.randomDoc.set(LocalFirestoreHelper.map("a", LocalFirestoreHelper.map("d", FieldValue.delete(), new Object[0]), new Object[0]), SetOptions.merge()).get();
        this.getNestedMap(expected, "a").remove("d");
        Assert.assertEquals(expected, this.getData());
        this.randomDoc.set(LocalFirestoreHelper.map("a", LocalFirestoreHelper.map("b", FieldValue.delete(), new Object[0]), new Object[0]), SetOptions.merge()).get();
        this.getNestedMap(expected, "a").remove("b");
        Assert.assertEquals(expected, this.getData());
        this.randomDoc.set(LocalFirestoreHelper.map("a", LocalFirestoreHelper.map("e", "foo", new Object[0]), new Object[0]), SetOptions.merge()).get();
        this.getNestedMap(expected, "a").put("e", "foo");
        Assert.assertEquals(expected, this.getData());
        this.randomDoc.set(LocalFirestoreHelper.map("f", "foo", new Object[0]), SetOptions.merge()).get();
        expected.put("f", "foo");
        Assert.assertEquals(expected, this.getData());
        this.randomDoc.set(LocalFirestoreHelper.map("f", LocalFirestoreHelper.map("g", "foo", new Object[0]), new Object[0]), SetOptions.merge()).get();
        expected.put("f", LocalFirestoreHelper.map("g", "foo", new Object[0]));
        Assert.assertEquals(expected, this.getData());
        this.randomDoc.update("f.h", (Object)"foo", new Object[0]).get();
        this.getNestedMap(expected, "f").put("h", "foo");
        Assert.assertEquals(expected, this.getData());
        this.randomDoc.update("f.g", (Object)FieldValue.delete(), new Object[0]).get();
        this.getNestedMap(expected, "f").remove("g");
        Assert.assertEquals(expected, this.getData());
        this.randomDoc.update("f.h", (Object)FieldValue.delete(), new Object[0]).get();
        this.getNestedMap(expected, "f").remove("h");
        Assert.assertEquals(expected, this.getData());
        this.randomDoc.update("f", (Object)FieldValue.delete(), new Object[0]).get();
        expected.remove("f");
        Assert.assertEquals(expected, this.getData());
        this.randomDoc.update("i.j", LocalFirestoreHelper.map(), new Object[0]).get();
        expected.put("i", LocalFirestoreHelper.map("j", LocalFirestoreHelper.map(), new Object[0]));
        Assert.assertEquals(expected, this.getData());
        this.randomDoc.update("i.j", LocalFirestoreHelper.map("k", "foo", new Object[0]), new Object[0]).get();
        this.getNestedMap(expected, "i").put("j", LocalFirestoreHelper.map("k", "foo", new Object[0]));
        Assert.assertEquals(expected, this.getData());
        this.randomDoc.update("i.j", LocalFirestoreHelper.map("l", LocalFirestoreHelper.map("k", "foo", new Object[0]), new Object[0]), new Object[0]).get();
        this.getNestedMap(expected, "i").put("j", LocalFirestoreHelper.map("l", LocalFirestoreHelper.map("k", "foo", new Object[0]), new Object[0]));
        Assert.assertEquals(expected, this.getData());
        this.randomDoc.update("i.j", LocalFirestoreHelper.map("l", LocalFirestoreHelper.map(), new Object[0]), new Object[0]).get();
        this.getNestedMap(expected, "i").put("j", LocalFirestoreHelper.map("l", LocalFirestoreHelper.map(), new Object[0]));
        Assert.assertEquals(expected, this.getData());
        this.randomDoc.update("i", (Object)FieldValue.delete(), new Object[0]).get();
        expected.remove("i");
        Assert.assertEquals(expected, this.getData());
        this.randomDoc.update("a", (Object)FieldValue.delete(), new Object[0]).get();
        expected.remove("a");
        Assert.assertEquals(expected, this.getData());
    }

    @Test
    public void addAndRemoveServerTimestamps() throws ExecutionException, InterruptedException {
        HashMap<String, Object> expected = new HashMap<String, Object>();
        this.randomDoc.create(LocalFirestoreHelper.map("time", FieldValue.serverTimestamp(), "a", LocalFirestoreHelper.map("b", FieldValue.serverTimestamp(), new Object[0]))).get();
        Timestamp time = (Timestamp)this.getData().get("time");
        expected.put("time", time);
        expected.put("a", LocalFirestoreHelper.map("b", time, new Object[0]));
        Assert.assertEquals(expected, this.getData());
        this.randomDoc.set(LocalFirestoreHelper.map("time", FieldValue.serverTimestamp(), "a", LocalFirestoreHelper.map("c", FieldValue.serverTimestamp(), new Object[0]))).get();
        time = this.updateTime(expected);
        expected.put("a", LocalFirestoreHelper.map("c", time, new Object[0]));
        Assert.assertEquals(expected, this.getData());
        this.randomDoc.set(LocalFirestoreHelper.map("time", FieldValue.serverTimestamp(), "e", FieldValue.serverTimestamp()), SetOptions.merge()).get();
        time = this.updateTime(expected);
        expected.put("e", time);
        Assert.assertEquals(expected, this.getData());
        this.randomDoc.set(LocalFirestoreHelper.map("time", FieldValue.serverTimestamp(), "e", LocalFirestoreHelper.map("f", FieldValue.serverTimestamp(), new Object[0])), SetOptions.merge()).get();
        time = this.updateTime(expected);
        expected.put("e", LocalFirestoreHelper.map("f", time, new Object[0]));
        Assert.assertEquals(expected, this.getData());
        this.randomDoc.update("time", (Object)FieldValue.serverTimestamp(), new Object[]{"g.h", FieldValue.serverTimestamp()}).get();
        time = this.updateTime(expected);
        expected.put("g", LocalFirestoreHelper.map("h", time, new Object[0]));
        Assert.assertEquals(expected, this.getData());
        this.randomDoc.update("time", (Object)FieldValue.serverTimestamp(), new Object[]{"g.j", LocalFirestoreHelper.map("k", FieldValue.serverTimestamp(), new Object[0])}).get();
        time = this.updateTime(expected);
        this.getNestedMap(expected, "g").put("j", LocalFirestoreHelper.map("k", time, new Object[0]));
        Assert.assertEquals(expected, this.getData());
    }

    private Timestamp updateTime(Map<String, Object> dataWithTime) throws ExecutionException, InterruptedException {
        Timestamp time = (Timestamp)this.getData().get("time");
        dataWithTime.put("time", time);
        return time;
    }

    private Map<String, Object> getNestedMap(Map<String, Object> map, String key) {
        return (Map)map.get(key);
    }

    private Map<String, Object> getData() throws ExecutionException, InterruptedException {
        return ((DocumentSnapshot)this.randomDoc.get().get()).getData();
    }

    @Test
    public void writeAndReadVectorEmbeddings() throws ExecutionException, InterruptedException {
        HashMap<String, VectorValue> expected = new HashMap<String, VectorValue>();
        this.randomDoc.create(LocalFirestoreHelper.map("vector0", FieldValue.vector((double[])new double[]{0.0}), "vector1", FieldValue.vector((double[])new double[]{1.0, 2.0, 3.99}))).get();
        this.randomDoc.set(LocalFirestoreHelper.map("vector0", FieldValue.vector((double[])new double[]{0.0}), "vector1", FieldValue.vector((double[])new double[]{1.0, 2.0, 3.99}), "vector2", FieldValue.vector((double[])new double[]{0.0, 0.0, 0.0}))).get();
        this.randomDoc.update(LocalFirestoreHelper.map("vector3", FieldValue.vector((double[])new double[]{-1.0, -200.0, -9999.0}), new Object[0])).get();
        expected.put("vector0", FieldValue.vector((double[])new double[]{0.0}));
        expected.put("vector1", FieldValue.vector((double[])new double[]{1.0, 2.0, 3.99}));
        expected.put("vector2", FieldValue.vector((double[])new double[]{0.0, 0.0, 0.0}));
        expected.put("vector3", FieldValue.vector((double[])new double[]{-1.0, -200.0, -9999.0}));
        DocumentSnapshot actual = (DocumentSnapshot)this.randomDoc.get().get();
        Assert.assertTrue((boolean)(actual.get("vector0") instanceof VectorValue));
        Assert.assertTrue((boolean)(actual.get("vector1") instanceof VectorValue));
        Assert.assertTrue((boolean)(actual.get("vector2") instanceof VectorValue));
        Assert.assertTrue((boolean)(actual.get("vector3") instanceof VectorValue));
        Assert.assertArrayEquals((double[])((VectorValue)expected.get("vector0")).toArray(), (double[])((VectorValue)actual.get("vector0", VectorValue.class)).toArray(), (double)1.0E-6);
        Assert.assertArrayEquals((double[])((VectorValue)expected.get("vector1")).toArray(), (double[])((VectorValue)actual.get("vector1", VectorValue.class)).toArray(), (double)1.0E-6);
        Assert.assertArrayEquals((double[])((VectorValue)expected.get("vector2")).toArray(), (double[])((VectorValue)actual.get("vector2", VectorValue.class)).toArray(), (double)1.0E-6);
        Assert.assertArrayEquals((double[])((VectorValue)expected.get("vector3")).toArray(), (double[])((VectorValue)actual.get("vector3", VectorValue.class)).toArray(), (double)1.0E-6);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void listenToDocumentsWithVectors() throws Throwable {
        CompletableFuture listen = new CompletableFuture();
        ListenerRegistration registration = null;
        DocumentReference ref = this.randomColl.document();
        AtomicInteger snapshotCount = new AtomicInteger();
        try {
            registration = this.randomColl.whereEqualTo("purpose", (Object)"vector tests").addSnapshotListener((value, error) -> {
                try {
                    DocumentSnapshot docSnap = value.isEmpty() ? null : (DocumentSnapshot)value.getDocuments().get(0);
                    switch (snapshotCount.getAndIncrement()) {
                        case 0: {
                            Assert.assertNull((Object)docSnap);
                            ref.create(LocalFirestoreHelper.map("purpose", "vector tests", "vector0", FieldValue.vector((double[])new double[]{0.0}), "vector1", FieldValue.vector((double[])new double[]{1.0, 2.0, 3.99}))).get();
                            break;
                        }
                        case 1: {
                            Assert.assertNotNull((Object)docSnap);
                            Assert.assertEquals((Object)docSnap.getVectorValue("vector0"), (Object)FieldValue.vector((double[])new double[]{0.0}));
                            Assert.assertEquals((Object)docSnap.getVectorValue("vector1"), (Object)FieldValue.vector((double[])new double[]{1.0, 2.0, 3.99}));
                            ref.set(LocalFirestoreHelper.map("purpose", "vector tests", "vector0", FieldValue.vector((double[])new double[]{0.0}), "vector1", FieldValue.vector((double[])new double[]{1.0, 2.0, 3.99}), "vector2", FieldValue.vector((double[])new double[]{0.0, 0.0, 0.0}))).get();
                            break;
                        }
                        case 2: {
                            Assert.assertNotNull((Object)docSnap);
                            Assert.assertEquals((Object)docSnap.getVectorValue("vector0"), (Object)FieldValue.vector((double[])new double[]{0.0}));
                            Assert.assertEquals((Object)docSnap.getVectorValue("vector1"), (Object)FieldValue.vector((double[])new double[]{1.0, 2.0, 3.99}));
                            Assert.assertEquals((Object)docSnap.getVectorValue("vector2"), (Object)FieldValue.vector((double[])new double[]{0.0, 0.0, 0.0}));
                            ref.update(LocalFirestoreHelper.map("vector3", FieldValue.vector((double[])new double[]{-1.0, -200.0, -999.0}), new Object[0])).get();
                            break;
                        }
                        case 3: {
                            Assert.assertNotNull((Object)docSnap);
                            Assert.assertEquals((Object)docSnap.getVectorValue("vector0"), (Object)FieldValue.vector((double[])new double[]{0.0}));
                            Assert.assertEquals((Object)docSnap.getVectorValue("vector1"), (Object)FieldValue.vector((double[])new double[]{1.0, 2.0, 3.99}));
                            Assert.assertEquals((Object)docSnap.getVectorValue("vector2"), (Object)FieldValue.vector((double[])new double[]{0.0, 0.0, 0.0}));
                            Assert.assertEquals((Object)docSnap.getVectorValue("vector3"), (Object)FieldValue.vector((double[])new double[]{-1.0, -200.0, -999.0}));
                            ref.delete().get();
                            break;
                        }
                        case 4: {
                            Assert.assertNull((Object)docSnap);
                            listen.complete(null);
                        }
                    }
                }
                catch (Throwable t) {
                    listen.completeExceptionally(t);
                }
            });
            listen.get();
        }
        finally {
            if (registration != null) {
                registration.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void documentWatch() throws Exception {
        CompletableFuture listen = new CompletableFuture();
        DocumentReference documentReference = this.randomColl.document();
        ListenerRegistration registration = null;
        AtomicInteger snapshotCount = new AtomicInteger();
        try {
            registration = documentReference.addSnapshotListener((value, error) -> {
                try {
                    switch (snapshotCount.getAndIncrement()) {
                        case 0: {
                            Assert.assertFalse((boolean)value.exists());
                            documentReference.set(LocalFirestoreHelper.map("foo", "foo", new Object[0]));
                            break;
                        }
                        case 1: {
                            Assert.assertTrue((boolean)value.exists());
                            DocumentSnapshot documentSnapshot = (DocumentSnapshot)documentReference.get().get();
                            Assert.assertEquals((Object)"foo", (Object)documentSnapshot.getString("foo"));
                            documentReference.set(LocalFirestoreHelper.map("foo", "bar", new Object[0]));
                            break;
                        }
                        case 2: {
                            Assert.assertTrue((boolean)value.exists());
                            DocumentSnapshot documentSnapshot = (DocumentSnapshot)documentReference.get().get();
                            Assert.assertEquals((Object)"bar", (Object)documentSnapshot.getString("foo"));
                            documentReference.delete();
                            break;
                        }
                        case 3: {
                            Assert.assertFalse((boolean)value.exists());
                            listen.complete(null);
                        }
                    }
                }
                catch (Exception e) {
                    listen.completeExceptionally(e);
                }
            });
            listen.get();
        }
        finally {
            if (registration != null) {
                registration.remove();
            }
        }
    }

    private int paginateResults(Query query, List<DocumentSnapshot> results) throws ExecutionException, InterruptedException {
        QuerySnapshot querySnapshot;
        if (!results.isEmpty()) {
            query = query.startAfter(results.get(results.size() - 1));
        }
        if ((querySnapshot = (QuerySnapshot)query.get().get()).isEmpty()) {
            return 0;
        }
        results.addAll(querySnapshot.getDocuments());
        return 1 + this.paginateResults(query, results);
    }

    @Test
    public void queryPaginationWithOrderByClause() throws ExecutionException, InterruptedException {
        WriteBatch batch = this.firestore.batch();
        for (int i = 0; i < 10; ++i) {
            batch.set(this.randomColl.document(), LocalFirestoreHelper.map("val", i, new Object[0]));
        }
        batch.commit().get();
        Query query = this.randomColl.orderBy("val").limit(3);
        ArrayList<DocumentSnapshot> results = new ArrayList<DocumentSnapshot>();
        int pageCount = this.paginateResults(query, results);
        Assert.assertEquals((long)4L, (long)pageCount);
        Assert.assertEquals((long)10L, (long)results.size());
    }

    @Test
    public void queryPaginationWithWhereClause() throws ExecutionException, InterruptedException {
        WriteBatch batch = this.firestore.batch();
        for (int i = 0; i < 10; ++i) {
            batch.set(this.randomColl.document(), LocalFirestoreHelper.map("val", i, new Object[0]));
        }
        batch.commit().get();
        Query query = this.randomColl.whereGreaterThanOrEqualTo("val", (Object)1).limit(3);
        ArrayList<DocumentSnapshot> results = new ArrayList<DocumentSnapshot>();
        int pageCount = this.paginateResults(query, results);
        Assert.assertEquals((long)3L, (long)pageCount);
        Assert.assertEquals((long)9L, (long)results.size());
    }

    @Test
    public void arrayOperators() throws ExecutionException, InterruptedException {
        Query containsQuery = this.randomColl.whereArrayContains("foo", (Object)"bar");
        Assert.assertTrue((boolean)((QuerySnapshot)containsQuery.get().get()).isEmpty());
        DocumentReference doc1 = this.randomColl.document();
        DocumentReference doc2 = this.randomColl.document();
        doc1.set(Collections.singletonMap("foo", FieldValue.arrayUnion((Object[])new Object[]{"bar"}))).get();
        doc2.set(Collections.singletonMap("foo", FieldValue.arrayUnion((Object[])new Object[]{"baz"}))).get();
        Assert.assertEquals((long)1L, (long)((QuerySnapshot)containsQuery.get().get()).size());
        doc1.set(Collections.singletonMap("foo", FieldValue.arrayRemove((Object[])new Object[]{"bar"}))).get();
        doc2.set(Collections.singletonMap("foo", FieldValue.arrayRemove((Object[])new Object[]{"baz"}))).get();
        Assert.assertTrue((boolean)((QuerySnapshot)containsQuery.get().get()).isEmpty());
    }

    @Test
    public void testCollectionGroupQueries() throws ExecutionException, InterruptedException {
        String collectionGroup = "b" + this.randomColl.getId();
        String[] docPaths = new String[]{"abc/123/${collectionGroup}/cg-doc1", "abc/123/${collectionGroup}/cg-doc2", "${collectionGroup}/cg-doc3", "${collectionGroup}/cg-doc4", "def/456/${collectionGroup}/cg-doc5", "${collectionGroup}/virtual-doc/nested-coll/not-cg-doc", "x${collectionGroup}/not-cg-doc", "${collectionGroup}x/not-cg-doc", "abc/123/${collectionGroup}x/not-cg-doc", "abc/123/x${collectionGroup}/not-cg-doc", "abc/${collectionGroup}"};
        WriteBatch batch = this.firestore.batch();
        for (String path : docPaths) {
            batch.set(this.firestore.document(path.replace("${collectionGroup}", collectionGroup)), LocalFirestoreHelper.map("x", 1, new Object[0]));
        }
        batch.commit().get();
        QuerySnapshot querySnapshot = (QuerySnapshot)this.firestore.collectionGroup(collectionGroup).get().get();
        Assert.assertEquals(Arrays.asList("cg-doc1", "cg-doc2", "cg-doc3", "cg-doc4", "cg-doc5"), this.querySnapshotToIds(querySnapshot));
    }

    @Test
    public void collectionGroupQueriesWithStartAtEndAtWithArbitraryDocumentIds() throws ExecutionException, InterruptedException {
        String collectionGroup = "b" + this.randomColl.getId();
        String[] docPaths = new String[]{"a/a/${collectionGroup}/cg-doc1", "a/b/a/b/${collectionGroup}/cg-doc2", "a/b/${collectionGroup}/cg-doc3", "a/b/c/d/${collectionGroup}/cg-doc4", "a/c/${collectionGroup}/cg-doc5", "${collectionGroup}/cg-doc6", "a/b/nope/nope"};
        WriteBatch batch = this.firestore.batch();
        for (String path : docPaths) {
            batch.set(this.firestore.document(path.replace("${collectionGroup}", collectionGroup)), LocalFirestoreHelper.map("x", 1, new Object[0]));
        }
        batch.commit().get();
        QuerySnapshot querySnapshot = (QuerySnapshot)this.firestore.collectionGroup(collectionGroup).orderBy(FieldPath.documentId()).startAt(new Object[]{"a/b"}).endAt(new Object[]{"a/b0"}).get().get();
        Assert.assertEquals(Arrays.asList("cg-doc2", "cg-doc3", "cg-doc4"), this.querySnapshotToIds(querySnapshot));
        querySnapshot = (QuerySnapshot)this.firestore.collectionGroup(collectionGroup).orderBy(FieldPath.documentId()).startAfter(new Object[]{"a/b"}).endBefore(new Object[]{"a/b/" + collectionGroup + "/cg-doc3"}).get().get();
        Assert.assertEquals(Arrays.asList("cg-doc2"), this.querySnapshotToIds(querySnapshot));
    }

    @Test
    public void collectionGroupQueriesWithWhereFiltersOnArbitraryDocumentIds() throws ExecutionException, InterruptedException {
        String collectionGroup = "b" + this.randomColl.getId();
        String[] docPaths = new String[]{"a/a/${collectionGroup}/cg-doc1", "a/b/a/b/${collectionGroup}/cg-doc2", "a/b/${collectionGroup}/cg-doc3", "a/b/c/d/${collectionGroup}/cg-doc4", "a/c/${collectionGroup}/cg-doc5", "${collectionGroup}/cg-doc6", "a/b/nope/nope"};
        WriteBatch batch = this.firestore.batch();
        for (String path : docPaths) {
            batch.set(this.firestore.document(path.replace("${collectionGroup}", collectionGroup)), LocalFirestoreHelper.map("x", 1, new Object[0]));
        }
        batch.commit().get();
        QuerySnapshot querySnapshot = (QuerySnapshot)this.firestore.collectionGroup(collectionGroup).whereGreaterThanOrEqualTo(FieldPath.documentId(), (Object)"a/b").whereLessThanOrEqualTo(FieldPath.documentId(), (Object)"a/b0").get().get();
        Assert.assertEquals(Arrays.asList("cg-doc2", "cg-doc3", "cg-doc4"), this.querySnapshotToIds(querySnapshot));
        querySnapshot = (QuerySnapshot)this.firestore.collectionGroup(collectionGroup).whereGreaterThan(FieldPath.documentId(), (Object)"a/b").whereLessThan(FieldPath.documentId(), (Object)("a/b/" + collectionGroup + "/cg-doc3")).get().get();
        Assert.assertEquals(Arrays.asList("cg-doc2"), this.querySnapshotToIds(querySnapshot));
    }

    @Test
    public void inQueries() throws Exception {
        this.setDocument("a", LocalFirestoreHelper.map("zip", 98101, new Object[0]));
        this.setDocument("b", LocalFirestoreHelper.map("zip", 91102, new Object[0]));
        this.setDocument("c", LocalFirestoreHelper.map("zip", 98103, new Object[0]));
        this.setDocument("d", LocalFirestoreHelper.map("zip", Arrays.asList(98101), new Object[0]));
        this.setDocument("e", LocalFirestoreHelper.map("zip", Arrays.asList("98101", LocalFirestoreHelper.map("zip", 98101, new Object[0])), new Object[0]));
        this.setDocument("f", LocalFirestoreHelper.map("zip", LocalFirestoreHelper.map("code", 500, new Object[0]), new Object[0]));
        QuerySnapshot querySnapshot = (QuerySnapshot)this.randomColl.whereIn("zip", Arrays.asList(98101, 98103)).get().get();
        Assert.assertEquals(Arrays.asList("a", "c"), this.querySnapshotToIds(querySnapshot));
    }

    @Test
    public void notEqualQueries() throws Exception {
        this.setDocument("a", LocalFirestoreHelper.map("zip", Double.NaN, new Object[0]));
        this.setDocument("b", LocalFirestoreHelper.map("zip", 91102, new Object[0]));
        this.setDocument("c", LocalFirestoreHelper.map("zip", 98101, new Object[0]));
        this.setDocument("d", LocalFirestoreHelper.map("zip", 98103, new Object[0]));
        this.setDocument("e", LocalFirestoreHelper.map("zip", Arrays.asList(98101), new Object[0]));
        this.setDocument("f", LocalFirestoreHelper.map("zip", Arrays.asList("98101", LocalFirestoreHelper.map("zip", 98101, new Object[0])), new Object[0]));
        this.setDocument("g", LocalFirestoreHelper.map("zip", LocalFirestoreHelper.map("zip", 98101, new Object[0]), new Object[0]));
        this.setDocument("h", LocalFirestoreHelper.map("zip", null, new Object[0]));
        QuerySnapshot querySnapshot = (QuerySnapshot)this.randomColl.whereNotEqualTo("zip", (Object)98101).get().get();
        Assert.assertEquals(Arrays.asList("a", "b", "d", "e", "f", "g"), this.querySnapshotToIds(querySnapshot));
        querySnapshot = (QuerySnapshot)this.randomColl.whereNotEqualTo("zip", (Object)Double.NaN).get().get();
        Assert.assertEquals(Arrays.asList("b", "c", "d", "e", "f", "g"), this.querySnapshotToIds(querySnapshot));
        querySnapshot = (QuerySnapshot)this.randomColl.whereNotEqualTo("zip", null).get().get();
        Assert.assertEquals(Arrays.asList("a", "b", "c", "d", "e", "f", "g"), this.querySnapshotToIds(querySnapshot));
    }

    @Test
    public void notEqualQueriesWithDocumentId() throws Exception {
        DocumentReference doc1 = this.setDocument("a", LocalFirestoreHelper.map("count", 1, new Object[0]));
        DocumentReference doc2 = this.setDocument("b", LocalFirestoreHelper.map("count", 2, new Object[0]));
        this.setDocument("c", LocalFirestoreHelper.map("count", 3, new Object[0]));
        QuerySnapshot querySnapshot = (QuerySnapshot)this.randomColl.whereNotEqualTo(FieldPath.documentId(), (Object)doc1.getId()).get().get();
        Assert.assertEquals(Arrays.asList("b", "c"), this.querySnapshotToIds(querySnapshot));
    }

    @Test
    public void inQueriesWithDocumentId() throws Exception {
        DocumentReference doc1 = this.setDocument("a", LocalFirestoreHelper.map("count", 1, new Object[0]));
        DocumentReference doc2 = this.setDocument("b", LocalFirestoreHelper.map("count", 2, new Object[0]));
        this.setDocument("c", LocalFirestoreHelper.map("count", 3, new Object[0]));
        QuerySnapshot querySnapshot = (QuerySnapshot)this.randomColl.whereIn(FieldPath.documentId(), Arrays.asList(doc1.getId(), doc2)).get().get();
        Assert.assertEquals(Arrays.asList("a", "b"), this.querySnapshotToIds(querySnapshot));
    }

    @Test
    public void notInQueries() throws Exception {
        this.setDocument("a", LocalFirestoreHelper.map("zip", 98101, new Object[0]));
        this.setDocument("b", LocalFirestoreHelper.map("zip", 91102, new Object[0]));
        this.setDocument("c", LocalFirestoreHelper.map("zip", 98103, new Object[0]));
        this.setDocument("d", LocalFirestoreHelper.map("zip", Arrays.asList(98101), new Object[0]));
        this.setDocument("e", LocalFirestoreHelper.map("zip", Arrays.asList("98101", LocalFirestoreHelper.map("zip", 98101, new Object[0])), new Object[0]));
        this.setDocument("f", LocalFirestoreHelper.map("zip", LocalFirestoreHelper.map("code", 500, new Object[0]), new Object[0]));
        QuerySnapshot querySnapshot = (QuerySnapshot)this.randomColl.whereNotIn("zip", Arrays.asList(98101, 98103)).get().get();
        Assert.assertEquals(Arrays.asList("b", "d", "e", "f"), this.querySnapshotToIds(querySnapshot));
        querySnapshot = (QuerySnapshot)this.randomColl.whereNotIn("zip", Arrays.asList(Double.NaN)).get().get();
        Assert.assertEquals(Arrays.asList("b", "a", "c", "d", "e", "f"), this.querySnapshotToIds(querySnapshot));
        ArrayList<Object> nullArray = new ArrayList<Object>();
        nullArray.add(null);
        querySnapshot = (QuerySnapshot)this.randomColl.whereNotIn("zip", nullArray).get().get();
        Assert.assertEquals(new ArrayList(), this.querySnapshotToIds(querySnapshot));
    }

    @Test
    public void notInQueriesWithDocumentId() throws Exception {
        DocumentReference doc1 = this.setDocument("a", LocalFirestoreHelper.map("count", 1, new Object[0]));
        DocumentReference doc2 = this.setDocument("b", LocalFirestoreHelper.map("count", 2, new Object[0]));
        this.setDocument("c", LocalFirestoreHelper.map("count", 3, new Object[0]));
        QuerySnapshot querySnapshot = (QuerySnapshot)this.randomColl.whereNotIn(FieldPath.documentId(), Arrays.asList(doc1.getId(), doc2)).get().get();
        Assert.assertEquals(Arrays.asList("c"), this.querySnapshotToIds(querySnapshot));
    }

    @Test
    public void arrayContainsAnyQueries() throws Exception {
        this.setDocument("a", LocalFirestoreHelper.map("array", Arrays.asList(42), new Object[0]));
        this.setDocument("b", LocalFirestoreHelper.map("array", Arrays.asList("a", 42, "c"), new Object[0]));
        this.setDocument("c", LocalFirestoreHelper.map("array", Arrays.asList(41.999, "42", LocalFirestoreHelper.map("a", 42, new Object[0])), new Object[0]));
        this.setDocument("d", LocalFirestoreHelper.map("array", Arrays.asList(42), "array2", "sigh"));
        this.setDocument("e", LocalFirestoreHelper.map("array", Arrays.asList(43), new Object[0]));
        this.setDocument("f", LocalFirestoreHelper.map("array", Arrays.asList(LocalFirestoreHelper.map("a", 42, new Object[0])), new Object[0]));
        this.setDocument("g", LocalFirestoreHelper.map("array", 42, new Object[0]));
        QuerySnapshot querySnapshot = (QuerySnapshot)this.randomColl.whereArrayContainsAny("array", Arrays.asList(42, 43)).get().get();
        Assert.assertEquals(Arrays.asList("a", "b", "d", "e"), this.querySnapshotToIds(querySnapshot));
    }

    @Test
    public void integerIncrement() throws ExecutionException, InterruptedException {
        DocumentReference docRef = this.randomColl.document();
        docRef.set(Collections.singletonMap("sum", 1L)).get();
        docRef.update("sum", (Object)FieldValue.increment((long)2L), new Object[0]).get();
        DocumentSnapshot docSnap = (DocumentSnapshot)docRef.get().get();
        Assert.assertEquals((Object)3L, (Object)docSnap.get("sum"));
    }

    @Test
    public void floatIncrement() throws ExecutionException, InterruptedException {
        DocumentReference docRef = this.randomColl.document();
        docRef.set(Collections.singletonMap("sum", 1.1)).get();
        docRef.update("sum", (Object)FieldValue.increment((double)2.2), new Object[0]).get();
        DocumentSnapshot docSnap = (DocumentSnapshot)docRef.get().get();
        Assert.assertEquals((double)3.3, (double)((Double)docSnap.get("sum")), (double)1.0E-6);
    }

    @Test
    public void getAllWithObserver() throws Exception {
        DocumentReference ref1 = this.randomColl.document("doc1");
        ref1.set(this.ALL_SUPPORTED_TYPES_MAP).get();
        DocumentReference ref2 = this.randomColl.document("doc2");
        ref2.set(this.ALL_SUPPORTED_TYPES_MAP).get();
        DocumentReference ref3 = this.randomColl.document("doc3");
        DocumentReference[] documentReferences = new DocumentReference[]{ref1, ref2, ref3};
        StreamConsumer consumer = new StreamConsumer();
        this.firestore.getAll(documentReferences, FieldMask.of((String[])new String[]{"foo"}), consumer);
        List documentSnapshots = (List)consumer.consume().get();
        Assert.assertEquals((Object)this.ALL_SUPPORTED_TYPES_OBJECT, (Object)((DocumentSnapshot)documentSnapshots.get(0)).toObject(LocalFirestoreHelper.AllSupportedTypes.class));
        Assert.assertEquals((Object)this.ALL_SUPPORTED_TYPES_OBJECT, (Object)((DocumentSnapshot)documentSnapshots.get(1)).toObject(LocalFirestoreHelper.AllSupportedTypes.class));
        Assert.assertNotEquals((Object)this.ALL_SUPPORTED_TYPES_OBJECT, (Object)((DocumentSnapshot)documentSnapshots.get(2)).toObject(LocalFirestoreHelper.AllSupportedTypes.class));
        Assert.assertEquals((Object)ref1.getId(), (Object)((DocumentSnapshot)documentSnapshots.get(0)).getId());
        Assert.assertEquals((Object)ref2.getId(), (Object)((DocumentSnapshot)documentSnapshots.get(1)).getId());
        Assert.assertEquals((Object)ref3.getId(), (Object)((DocumentSnapshot)documentSnapshots.get(2)).getId());
        Assert.assertEquals((long)3L, (long)documentSnapshots.size());
    }

    @Test
    public void testInstanceReturnedByGetServiceCanBeUsedToDeserializeAQuery() throws Exception {
        Firestore fs = (Firestore)FirestoreOptions.getDefaultInstance().getService();
        RunQueryRequest proto = fs.collection("coll").whereEqualTo("bob", (Object)"alice").toProto();
        fs.close();
        Query.fromProto((Firestore)fs, (RunQueryRequest)proto);
    }

    @Test
    public void deleteNestedFieldUsingFieldPath() throws Exception {
        DocumentReference documentReference = this.randomColl.document("doc1");
        documentReference.set(LocalFirestoreHelper.map("a.b", this.SINGLE_FILED_MAP_WITH_DOT, new Object[0])).get();
        DocumentSnapshot documentSnapshots = (DocumentSnapshot)documentReference.get().get();
        Assert.assertEquals(this.SINGLE_FILED_MAP_WITH_DOT, documentSnapshots.getData().get("a.b"));
        FieldPath path = FieldPath.of((String[])new String[]{"a.b", "c.d"});
        documentReference.update(path, (Object)FieldValue.delete(), new Object[0]).get();
        documentSnapshots = (DocumentSnapshot)documentReference.get().get();
        Assert.assertNull(documentSnapshots.getData().get("c.d"));
    }

    @Test
    public void readOnlyTransaction_successfulGet() throws ExecutionException, InterruptedException, TimeoutException {
        DocumentReference documentReference = (DocumentReference)this.randomColl.add(this.SINGLE_FIELD_MAP).get();
        AtomicReference ref = new AtomicReference();
        ApiFuture runTransaction = this.firestore.runTransaction(transaction -> {
            DocumentSnapshot snapshot = (DocumentSnapshot)transaction.get(documentReference).get(5L, TimeUnit.SECONDS);
            ref.compareAndSet(null, snapshot);
            return null;
        }, TransactionOptions.createReadOnlyOptionsBuilder().build());
        runTransaction.get(10L, TimeUnit.SECONDS);
        Assert.assertEquals((Object)"bar", (Object)((DocumentSnapshot)ref.get()).get("foo"));
    }

    @Test
    public void readOnlyTransaction_failureWhenAttemptingWrite() throws InterruptedException, TimeoutException {
        DocumentReference documentReference = this.randomColl.document("tx/ro/writeShouldFail");
        ApiFuture runTransaction = this.firestore.runTransaction(transaction -> {
            transaction.set(documentReference, this.SINGLE_FIELD_MAP);
            return null;
        }, TransactionOptions.createReadOnlyOptionsBuilder().build());
        ExecutionException e = (ExecutionException)Assert.assertThrows(ExecutionException.class, () -> runTransaction.get(10L, TimeUnit.SECONDS));
        Throwable cause = e.getCause();
        Truth.assertThat((Throwable)cause).isInstanceOf(FirestoreException.class);
        Throwable rootCause = ExceptionUtils.getRootCause((Throwable)cause);
        Truth.assertThat((Throwable)rootCause).isInstanceOf(StatusRuntimeException.class);
        StatusRuntimeException invalidArgument = (StatusRuntimeException)rootCause;
        Status status = invalidArgument.getStatus();
        Truth.assertThat((Comparable)status.getCode()).isEqualTo((Object)Status.Code.INVALID_ARGUMENT);
        Truth.assertThat((String)status.getDescription()).contains((CharSequence)"read-only");
    }

    @Test
    public void readOnlyTransaction_successfulRead() throws Exception {
        DocumentReference documentReference = (DocumentReference)this.randomColl.add(this.SINGLE_FIELD_MAP).get();
        Timestamp firstWriteTime = ((WriteResult)documentReference.set(Collections.singletonMap("counter", 1)).get()).getUpdateTime();
        documentReference.set(Collections.singletonMap("counter", 2)).get();
        TransactionOptions options = TransactionOptions.createReadOnlyOptionsBuilder().setReadTime((TimestampOrBuilder)com.google.protobuf.Timestamp.newBuilder().setSeconds(firstWriteTime.getSeconds()).setNanos(firstWriteTime.getNanos())).build();
        ApiFuture runTransaction = this.firestore.runTransaction(transaction -> {
            DocumentSnapshot snapshot = (DocumentSnapshot)transaction.get(documentReference).get(5L, TimeUnit.SECONDS);
            return snapshot.getLong("counter");
        }, options);
        Assert.assertEquals((long)1L, (long)((Long)runTransaction.get(10L, TimeUnit.SECONDS)));
        DocumentSnapshot documentSnapshot = (DocumentSnapshot)documentReference.get().get();
        Assert.assertEquals((long)2L, (long)((Long)documentSnapshot.getData().get("counter")));
    }

    @Test
    public void readOnlyTransaction_failureWhenAttemptReadOlderThan60Seconds() throws ExecutionException, InterruptedException, TimeoutException {
        DocumentReference documentReference = (DocumentReference)this.randomColl.add(this.SINGLE_FIELD_MAP).get();
        long twoHours = (System.currentTimeMillis() / 60000L - 120L) * 60L;
        TransactionOptions options = TransactionOptions.createReadOnlyOptionsBuilder().setReadTime((TimestampOrBuilder)com.google.protobuf.Timestamp.newBuilder().setSeconds(twoHours).setNanos(0)).build();
        ApiFuture runTransaction = this.firestore.runTransaction(transaction -> {
            transaction.get(documentReference).get(5L, TimeUnit.SECONDS);
            return null;
        }, options);
        ExecutionException e = (ExecutionException)Assert.assertThrows(ExecutionException.class, () -> runTransaction.get(10L, TimeUnit.SECONDS));
        Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
        Truth.assertThat((Throwable)rootCause).isInstanceOf(StatusRuntimeException.class);
        StatusRuntimeException invalidArgument = (StatusRuntimeException)rootCause;
        Status status = invalidArgument.getStatus();
        Truth.assertThat((Comparable)status.getCode()).isEqualTo((Object)Status.Code.FAILED_PRECONDITION);
    }

    @Test
    public void deserializeCustomList() throws Exception {
        LocalFirestoreHelper.CustomList customList = new LocalFirestoreHelper.CustomList();
        customList.fooList = LocalFirestoreHelper.FOO_LIST;
        DocumentReference documentReference = this.randomColl.document("doc1");
        documentReference.set((Object)customList).get();
        DocumentSnapshot documentSnapshots = (DocumentSnapshot)documentReference.get().get();
        LocalFirestoreHelper.CustomList targetCustomList = (LocalFirestoreHelper.CustomList)documentSnapshots.toObject(LocalFirestoreHelper.CustomList.class);
        Assert.assertEquals(LocalFirestoreHelper.FOO_LIST, targetCustomList.fooList);
        Assert.assertEquals((Object)this.SINGLE_FIELD_OBJECT, targetCustomList.fooList.get(0));
    }

    @Test
    public void deserializeCustomMap() throws Exception {
        LocalFirestoreHelper.CustomMap customMap = new LocalFirestoreHelper.CustomMap();
        customMap.fooMap = LocalFirestoreHelper.FOO_MAP;
        DocumentReference documentReference = this.randomColl.document("doc1");
        documentReference.set((Object)customMap).get();
        DocumentSnapshot documentSnapshots = (DocumentSnapshot)documentReference.get().get();
        LocalFirestoreHelper.CustomMap targetCustomMap = (LocalFirestoreHelper.CustomMap)documentSnapshots.toObject(LocalFirestoreHelper.CustomMap.class);
        Assert.assertEquals(LocalFirestoreHelper.FOO_MAP, targetCustomMap.fooMap);
        Assert.assertEquals((Object)this.SINGLE_FIELD_OBJECT, targetCustomMap.fooMap.get("customMap"));
    }

    @Test
    public void testBuildingBundleWhenDocumentDoesNotExist() throws Exception {
        FirestoreBundle.Builder bundleBuilder = this.firestore.bundleBuilder("test-bundle");
        DocumentSnapshot snapshot = (DocumentSnapshot)this.randomDoc.get().get();
        bundleBuilder.add(snapshot);
        List<BundleElement> elements = FirestoreBundleTest.toBundleElements(bundleBuilder.build().toByteBuffer());
        Assert.assertEquals((long)2L, (long)elements.size());
        FirestoreBundleTest.verifyMetadata(elements.get(0).getMetadata(), snapshot.getReadTime().toProto(), 1, false);
        Assert.assertEquals((Object)BundledDocumentMetadata.newBuilder().setExists(false).setName(LocalFirestoreHelper.fullPath(this.randomDoc, (FirestoreOptions)this.firestore.getOptions())).setReadTime(snapshot.getReadTime().toProto()).build(), (Object)elements.get(1).getDocumentMetadata());
    }

    @Test
    public void testBuildingBundleWithLimitQuery() throws Exception {
        this.setDocument("doc1", Collections.singletonMap("counter", 1));
        this.setDocument("doc2", Collections.singletonMap("counter", 2));
        Query limitQuery = this.randomColl.orderBy("counter", Query.Direction.DESCENDING).limit(1);
        QuerySnapshot limitQuerySnap = (QuerySnapshot)limitQuery.get().get();
        FirestoreBundle.Builder bundleBuilder = this.firestore.bundleBuilder("test-bundle");
        bundleBuilder.add("limit", limitQuerySnap);
        List<BundleElement> elements = FirestoreBundleTest.toBundleElements(bundleBuilder.build().toByteBuffer());
        Assert.assertEquals((long)4L, (long)elements.size());
        FirestoreBundleTest.verifyMetadata(elements.get(0).getMetadata(), limitQuerySnap.getReadTime().toProto(), 1, false);
        NamedQuery namedLimitQuery = elements.get(1).getNamedQuery();
        FirestoreBundleTest.verifyNamedQuery(namedLimitQuery, "limit", limitQuerySnap.getReadTime().toProto(), limitQuery, BundledQuery.LimitType.FIRST);
        FirestoreBundleTest.verifyDocumentAndMeta(elements.get(2).getDocumentMetadata(), elements.get(3).getDocument(), LocalFirestoreHelper.fullPath(this.randomColl.document("doc2"), (FirestoreOptions)this.firestore.getOptions()), Lists.newArrayList((Object[])new String[]{"limit"}), (DocumentSnapshot)this.randomColl.document("doc2").get().get(), limitQuerySnap.getReadTime().toProto());
    }

    @Test
    public void testBuildingBundleWithLimitToLastQuery() throws Exception {
        this.setDocument("doc1", Collections.singletonMap("counter", 1));
        this.setDocument("doc2", Collections.singletonMap("counter", 2));
        Query limitToLastQuery = this.randomColl.orderBy("counter").limitToLast(1);
        QuerySnapshot limitToLastQuerySnap = (QuerySnapshot)limitToLastQuery.get().get();
        FirestoreBundle.Builder bundleBuilder = this.firestore.bundleBuilder("test-bundle");
        bundleBuilder.add("limitToLast", limitToLastQuerySnap);
        List<BundleElement> elements = FirestoreBundleTest.toBundleElements(bundleBuilder.build().toByteBuffer());
        Assert.assertEquals((long)4L, (long)elements.size());
        FirestoreBundleTest.verifyMetadata(elements.get(0).getMetadata(), limitToLastQuerySnap.getReadTime().toProto(), 1, false);
        NamedQuery namedLimitToLastQuery = elements.get(1).getNamedQuery();
        FirestoreBundleTest.verifyNamedQuery(namedLimitToLastQuery, "limitToLast", limitToLastQuerySnap.getReadTime().toProto(), this.randomColl.orderBy("counter").limit(1), BundledQuery.LimitType.LAST);
        FirestoreBundleTest.verifyDocumentAndMeta(elements.get(2).getDocumentMetadata(), elements.get(3).getDocument(), LocalFirestoreHelper.fullPath(this.randomColl.document("doc2"), (FirestoreOptions)this.firestore.getOptions()), Lists.newArrayList((Object[])new String[]{"limitToLast"}), (DocumentSnapshot)this.randomColl.document("doc2").get().get(), limitToLastQuerySnap.getReadTime().toProto());
    }

    private int countDocumentChildren(DocumentReference reference) {
        int count = 0;
        Iterable collections = reference.listCollections();
        for (CollectionReference collectionReference : collections) {
            count += this.countCollectionChildren(collectionReference);
        }
        return count;
    }

    private int countCollectionChildren(CollectionReference reference) {
        int count = 0;
        Iterable documents = reference.listDocuments();
        for (DocumentReference documentReference : documents) {
            count += this.countDocumentChildren(documentReference) + 1;
        }
        return count;
    }

    private void setupRecursiveDeleteTest() throws Exception {
        WriteBatch batch = this.firestore.batch();
        batch.set(this.randomColl.document("anna"), LocalFirestoreHelper.map("name", "anna", new Object[0]));
        batch.set(this.randomColl.document("bob"), LocalFirestoreHelper.map("name", "bob", new Object[0]));
        batch.set(this.randomColl.document("bob/parentsCol/charlie"), LocalFirestoreHelper.map("name", "charlie", new Object[0]));
        batch.set(this.randomColl.document("bob/parentsCol/daniel"), LocalFirestoreHelper.map("name", "daniel", new Object[0]));
        batch.set(this.randomColl.document("bob/parentsCol/daniel/childCol/ernie"), LocalFirestoreHelper.map("name", "ernie", new Object[0]));
        batch.set(this.randomColl.document("bob/parentsCol/daniel/childCol/francis"), LocalFirestoreHelper.map("name", "francis", new Object[0]));
        batch.commit().get();
    }

    @Test
    public void testRecursiveDeleteTopLevelCollection() throws Exception {
        this.setupRecursiveDeleteTest();
        this.firestore.recursiveDelete(this.randomColl).get();
        Assert.assertEquals((long)0L, (long)this.countCollectionChildren(this.randomColl));
    }

    @Test
    public void testRecursiveDeleteNestedCollection() throws Exception {
        this.setupRecursiveDeleteTest();
        this.firestore.recursiveDelete(this.randomColl.document("bob").collection("parentsCol")).get();
        Assert.assertEquals((long)2L, (long)this.countCollectionChildren(this.randomColl));
    }

    @Test
    public void testRecursiveDeleteNestedDocument() throws Exception {
        this.setupRecursiveDeleteTest();
        DocumentReference document = this.randomColl.document("bob/parentsCol/daniel");
        this.firestore.recursiveDelete(document).get();
        DocumentSnapshot snap = (DocumentSnapshot)document.get().get();
        Assert.assertFalse((boolean)snap.exists());
        Assert.assertEquals((long)1L, (long)this.countDocumentChildren(this.randomColl.document("bob")));
        Assert.assertEquals((long)3L, (long)this.countCollectionChildren(this.randomColl));
    }

    @Test
    public void testRecursiveDeleteLeafDocument() throws Exception {
        this.setupRecursiveDeleteTest();
        DocumentReference document = this.randomColl.document("bob/parentsCol/daniel/childCol/ernie");
        this.firestore.recursiveDelete(document).get();
        DocumentSnapshot snap = (DocumentSnapshot)document.get().get();
        Assert.assertFalse((boolean)snap.exists());
        Assert.assertEquals((long)5L, (long)this.countCollectionChildren(this.randomColl));
    }

    @Test
    public void testRecursiveDeleteDoesNotAffectOtherCollections() throws Exception {
        this.setupRecursiveDeleteTest();
        CollectionReference collectionB = this.firestore.collection("doggos");
        collectionB.document("doggo").set(LocalFirestoreHelper.map("name", "goodboi", new Object[0])).get();
        this.firestore.recursiveDelete(collectionB).get();
        Assert.assertEquals((long)6L, (long)this.countCollectionChildren(this.randomColl));
        Assert.assertEquals((long)0L, (long)this.countCollectionChildren(collectionB));
    }

    @Test
    public void testRecursiveDeleteWithCustomBulkWriterInstance() throws Exception {
        this.setupRecursiveDeleteTest();
        BulkWriter bulkWriter = this.firestore.bulkWriter();
        int[] callbackCount = new int[]{0};
        bulkWriter.addWriteResultListener((documentReference, result) -> {
            callbackCount[0] = callbackCount[0] + 1;
        });
        this.firestore.recursiveDelete(this.randomColl, bulkWriter).get();
        Assert.assertEquals((long)0L, (long)this.countCollectionChildren(this.randomColl));
        Assert.assertEquals((long)6L, (long)callbackCount[0]);
    }

    @Test
    public void testEnforcesTimeouts() {
        FirestoreOptions firestoreOptions = ((FirestoreOptions.Builder)FirestoreOptions.newBuilder().setRetrySettings(RetrySettings.newBuilder().setMaxRpcTimeoutDuration(Duration.ofMillis(1L)).setTotalTimeoutDuration(Duration.ofMillis(1L)).setInitialRpcTimeoutDuration(Duration.ofMillis(1L)).build())).build();
        this.firestore = (Firestore)firestoreOptions.getService();
        CollectionReference collection = this.firestore.collection("timeout");
        Assert.assertThrows(ExecutionException.class, () -> collection.get().get());
        Assert.assertThrows(ExecutionException.class, () -> collection.add(LocalFirestoreHelper.map()).get());
        Assert.assertThrows(ExecutionException.class, () -> {
            BulkWriter bulkWriter = this.firestore.bulkWriter();
            ApiFuture op = bulkWriter.set(collection.document(), LocalFirestoreHelper.map());
            bulkWriter.close();
            op.get();
        });
        Assert.assertThrows(ExecutionException.class, () -> collection.document().get().get());
        Assert.assertThrows(FirestoreException.class, () -> collection.listDocuments().iterator().hasNext());
        Assert.assertThrows(FirestoreException.class, () -> collection.document().listCollections().iterator().hasNext());
    }

    private static class StreamConsumer<T>
    implements ApiStreamObserver<T> {
        SettableApiFuture<List<T>> done = SettableApiFuture.create();
        List<T> results = Collections.synchronizedList(new ArrayList());

        private StreamConsumer() {
        }

        public void onNext(T element) {
            this.results.add(element);
        }

        public void onError(Throwable throwable) {
            this.done.setException(throwable);
        }

        public void onCompleted() {
            this.done.set(this.results);
        }

        public ApiFuture<List<T>> consume() {
            return this.done;
        }
    }
}

