/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore.it;

import com.google.cloud.firestore.BulkWriter;
import com.google.cloud.firestore.BulkWriterOptions;
import com.google.cloud.firestore.CollectionGroup;
import com.google.cloud.firestore.DocumentReference;
import com.google.cloud.firestore.FieldMask;
import com.google.cloud.firestore.FieldPath;
import com.google.cloud.firestore.Firestore;
import com.google.cloud.firestore.FirestoreOpenTelemetryOptions;
import com.google.cloud.firestore.FirestoreOptions;
import com.google.cloud.firestore.Precondition;
import com.google.cloud.firestore.Query;
import com.google.cloud.firestore.SetOptions;
import com.google.cloud.firestore.WriteBatch;
import com.google.common.base.Preconditions;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.OpenTelemetrySdkBuilder;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.testing.exporter.InMemorySpanExporter;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.data.EventData;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.export.SimpleSpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import io.opentelemetry.semconv.resource.attributes.ResourceAttributes;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public abstract class ITTracingTest {
    private static final Logger logger = Logger.getLogger(ITTracingTest.class.getName());
    private static final int TRACE_FORCE_FLUSH_MILLIS = 1000;
    private static final int TRACE_PROVIDER_SHUTDOWN_MILLIS = 1000;
    private static final int IN_MEMORY_SPAN_EXPORTER_DELAY_MILLIS = 50;
    private static final String SERVICE = "google.firestore.v1.Firestore/";
    private static final String BATCH_GET_DOCUMENTS_RPC_NAME = "BatchGetDocuments";
    private static final String COMMIT_RPC_NAME = "Commit";
    private static final String LIST_DOCUMENTS_RPC_NAME = "ListDocuments";
    private static final String LIST_COLLECTIONS_RPC_NAME = "ListCollectionIds";
    private static final String BATCH_WRITE_RPC_NAME = "BatchWrite";
    private static final String RUN_QUERY_RPC_NAME = "RunQuery";
    private static final String RUN_AGGREGATION_QUERY_RPC_NAME = "RunAggregationQuery";
    private static final String BEGIN_TRANSACTION_RPC_NAME = "BeginTransaction";
    private static final String ROLLBACK_RPC_NAME = "Rollback";
    private static OpenTelemetrySdk openTelemetrySdk;
    protected InMemorySpanExporter inMemorySpanExporter;
    protected Firestore firestore;
    Map<String, String> spanNameToSpanId = new HashMap<String, String>();
    Map<String, String> spanIdToParentSpanId = new HashMap<String, String>();
    Map<String, SpanData> spanNameToSpanData = new HashMap<String, SpanData>();
    @Rule
    public TestName testName = new TestName();

    protected abstract boolean isUsingGlobalOpenTelemetrySDK();

    @Before
    public void before() {
        this.inMemorySpanExporter = InMemorySpanExporter.create();
        Resource resource = Resource.getDefault().merge(Resource.builder().put(ResourceAttributes.SERVICE_NAME, (Object)"Sparky").build());
        SpanProcessor inMemorySpanProcessor = SimpleSpanProcessor.create((SpanExporter)this.inMemorySpanExporter);
        FirestoreOptions.Builder optionsBuilder = FirestoreOptions.newBuilder();
        FirestoreOpenTelemetryOptions.Builder otelOptionsBuilder = FirestoreOpenTelemetryOptions.newBuilder();
        OpenTelemetrySdkBuilder openTelemetrySdkBuilder = OpenTelemetrySdk.builder().setTracerProvider(SdkTracerProvider.builder().setResource(resource).addSpanProcessor(inMemorySpanProcessor).setSampler(Sampler.alwaysOn()).build());
        if (this.isUsingGlobalOpenTelemetrySDK()) {
            GlobalOpenTelemetry.resetForTest();
            openTelemetrySdk = openTelemetrySdkBuilder.buildAndRegisterGlobal();
            optionsBuilder.setOpenTelemetryOptions(otelOptionsBuilder.build());
        } else {
            openTelemetrySdk = openTelemetrySdkBuilder.build();
            optionsBuilder.setOpenTelemetryOptions(otelOptionsBuilder.setOpenTelemetry((OpenTelemetry)openTelemetrySdk).build());
        }
        String namedDb = System.getProperty("FIRESTORE_NAMED_DATABASE");
        if (namedDb != null) {
            logger.log(Level.INFO, String.format("Integration test using named database %s for test %s", namedDb, this.testName.getMethodName()));
            optionsBuilder = optionsBuilder.setDatabaseId(namedDb);
        } else {
            logger.log(Level.INFO, String.format("Integration test using default database for test %s", this.testName.getMethodName()));
        }
        this.firestore = (Firestore)optionsBuilder.build().getService();
        this.spanNameToSpanId.clear();
        this.spanIdToParentSpanId.clear();
        this.spanNameToSpanData.clear();
    }

    @After
    public void after() throws Exception {
        Preconditions.checkNotNull((Object)this.firestore, (Object)"Error instantiating Firestore. Check that the service account credentials were properly set.");
        this.firestore.shutdown();
        this.inMemorySpanExporter.reset();
    }

    @AfterClass
    public static void teardown() {
        CompletableResultCode completableResultCode = openTelemetrySdk.getSdkTracerProvider().shutdown();
        completableResultCode.join(1000L, TimeUnit.MILLISECONDS);
    }

    void waitForTracesToComplete() throws Exception {
        this.firestore.close();
        this.inMemorySpanExporter.flush().join(50L, TimeUnit.MILLISECONDS);
        TimeUnit.MILLISECONDS.sleep(50L);
        CompletableResultCode completableResultCode = openTelemetrySdk.getSdkTracerProvider().forceFlush();
        completableResultCode.join(1000L, TimeUnit.MILLISECONDS);
    }

    List<SpanData> prepareSpans() throws Exception {
        this.waitForTracesToComplete();
        List spans = this.inMemorySpanExporter.getFinishedSpanItems();
        this.buildSpanMaps(spans);
        this.printSpans();
        return spans;
    }

    void buildSpanMaps(List<SpanData> spans) {
        for (SpanData spanData : spans) {
            this.spanNameToSpanData.put(spanData.getName(), spanData);
            this.spanNameToSpanId.put(spanData.getName(), spanData.getSpanId());
            this.spanIdToParentSpanId.put(spanData.getSpanId(), spanData.getParentSpanId());
        }
    }

    @Nullable
    SpanData getSpanByName(String spanName) {
        return this.spanNameToSpanData.get(spanName);
    }

    @Nullable
    SpanData getGrpcSpanByName(String rpcName) {
        return this.getSpanByName(SERVICE + rpcName);
    }

    String grpcSpanName(String rpcName) {
        return SERVICE + rpcName;
    }

    void assertSameTrace(SpanData ... spans) {
        if (spans.length > 1) {
            String traceId = spans[0].getTraceId();
            for (SpanData spanData : spans) {
                Assert.assertEquals((Object)traceId, (Object)spanData.getTraceId());
            }
        }
    }

    void printSpans() {
        for (SpanData spanData : this.spanNameToSpanData.values()) {
            logger.log(Level.FINE, String.format("SPAN ID:%s, ParentID:%s, KIND:%s, TRACE ID:%s, NAME:%s, ATTRIBUTES:%s, EVENTS:%s\n", spanData.getSpanId(), spanData.getParentSpanId(), spanData.getKind(), spanData.getTraceId(), spanData.getName(), spanData.getAttributes().toString(), spanData.getEvents().toString()));
        }
    }

    void assertSpanHierarchy(String ... spanNamesHierarchy) {
        List<String> spanNames = Arrays.asList(spanNamesHierarchy);
        int i = 0;
        while (i + 1 < spanNames.size()) {
            String parentSpanName = spanNames.get(i);
            String childSpanName = spanNames.get(i + 1);
            SpanData parentSpan = this.getSpanByName(parentSpanName);
            SpanData childSpan = this.getSpanByName(childSpanName);
            Assert.assertNotNull((Object)parentSpan);
            Assert.assertNotNull((Object)childSpan);
            Assert.assertEquals((Object)childSpan.getParentSpanId(), (Object)parentSpan.getSpanId());
            this.assertSameTrace(childSpan, parentSpan);
            if (!parentSpanName.startsWith(SERVICE)) {
                this.assertHasExpectedAttributes(parentSpan, new String[0]);
            }
            if (!childSpanName.startsWith(SERVICE)) {
                this.assertHasExpectedAttributes(childSpan, new String[0]);
            }
            ++i;
        }
    }

    void assertHasExpectedAttributes(SpanData spanData, String ... additionalExpectedAttributes) {
        List<String> expectedAttributes = Arrays.asList("gcp.firestore.memory_utilization", "gcp.firestore.settings.host", "gcp.firestore.settings.project_id", "gcp.firestore.settings.database_id", "gcp.firestore.settings.channel.needs_credentials", "gcp.firestore.settings.channel.needs_endpoint", "gcp.firestore.settings.channel.needs_headers", "gcp.firestore.settings.channel.should_auto_close", "gcp.firestore.settings.channel.transport_name", "gcp.firestore.settings.retry_settings.max_rpc_timeout", "gcp.firestore.settings.retry_settings.retry_delay_multiplier", "gcp.firestore.settings.retry_settings.initial_retry_delay", "gcp.firestore.settings.credentials.authentication_type", "gcp.firestore.settings.retry_settings.max_attempts", "gcp.firestore.settings.retry_settings.max_retry_delay", "gcp.firestore.settings.retry_settings.rpc_timeout_multiplier", "gcp.firestore.settings.retry_settings.total_timeout", "gcp.firestore.settings.retry_settings.initial_rpc_timeout");
        expectedAttributes.addAll(Arrays.asList(additionalExpectedAttributes));
        Attributes spanAttributes = spanData.getAttributes();
        for (String expectedAttribute : expectedAttributes) {
            Assert.assertNotNull((Object)spanAttributes.get(AttributeKey.stringKey((String)expectedAttribute)));
        }
    }

    boolean hasEvent(SpanData spanData, String eventName, @Nullable Attributes expectedAttributes) {
        if (spanData == null) {
            return false;
        }
        logger.log(Level.INFO, String.format("Checking if span named '%s' (ID='%s') contains an event named '%s'", spanData.getName(), spanData.getSpanId(), eventName));
        List events = spanData.getEvents();
        for (EventData event : events) {
            if (!event.getName().equals(eventName)) continue;
            if (expectedAttributes == null) {
                return true;
            }
            Attributes eventAttributes = event.getAttributes();
            return expectedAttributes.equals(eventAttributes);
        }
        return false;
    }

    @Test
    public void aggregateQueryGet() throws Exception {
        this.firestore.collection("col").count().get().get();
        this.waitForTracesToComplete();
        List spans = this.inMemorySpanExporter.getFinishedSpanItems();
        this.buildSpanMaps(spans);
        Assert.assertEquals((long)2L, (long)spans.size());
        SpanData getSpan = this.getSpanByName("AggregationQuery.Get");
        SpanData grpcSpan = this.getGrpcSpanByName(RUN_AGGREGATION_QUERY_RPC_NAME);
        Assert.assertNotNull((Object)getSpan);
        Assert.assertNotNull((Object)grpcSpan);
        Assert.assertEquals((Object)grpcSpan.getParentSpanId(), (Object)getSpan.getSpanId());
        this.assertSameTrace(getSpan, grpcSpan);
        this.assertHasExpectedAttributes(getSpan, new String[0]);
        List events = getSpan.getEvents();
        Assert.assertTrue((events.size() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((((EventData)events.get(0)).getAttributes().size() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)((EventData)events.get(0)).getName(), (Object)"RunAggregationQuery Stream started.");
        Assert.assertEquals((long)((Long)((EventData)events.get(0)).getAttributes().get(AttributeKey.longKey((String)"attempt"))), (long)0L);
    }

    @Test
    public void bulkWriterCommit() throws Exception {
        ScheduledExecutorService bulkWriterExecutor = Executors.newSingleThreadScheduledExecutor();
        BulkWriter bulkWriter = this.firestore.bulkWriter(BulkWriterOptions.builder().setExecutor(bulkWriterExecutor).build());
        bulkWriter.set(this.firestore.collection("col").document("foo"), Collections.singletonMap("bulk-foo", "bulk-bar"));
        bulkWriter.close();
        bulkWriterExecutor.awaitTermination(100L, TimeUnit.MILLISECONDS);
        List<SpanData> spans = this.prepareSpans();
        Assert.assertEquals((long)2L, (long)spans.size());
        this.assertSpanHierarchy("BulkWriter.Commit", this.grpcSpanName(BATCH_WRITE_RPC_NAME));
    }

    @Test
    public void partitionQuery() throws Exception {
        CollectionGroup collectionGroup = this.firestore.collectionGroup("col");
        collectionGroup.getPartitions(3L).get();
        List<SpanData> spans = this.prepareSpans();
        Assert.assertEquals((long)2L, (long)spans.size());
        this.assertSpanHierarchy("PartitionQuery", this.grpcSpanName("PartitionQuery"));
    }

    @Test
    public void collectionListDocuments() throws Exception {
        this.firestore.collection("col").listDocuments();
        List<SpanData> spans = this.prepareSpans();
        Assert.assertEquals((long)2L, (long)spans.size());
        this.assertSpanHierarchy("CollectionReference.ListDocuments", this.grpcSpanName(LIST_DOCUMENTS_RPC_NAME));
    }

    @Test
    public void docRefCreate() throws Exception {
        this.firestore.collection("col").document().create(Collections.singletonMap("foo", "bar")).get();
        List<SpanData> spans = this.prepareSpans();
        Assert.assertEquals((long)3L, (long)spans.size());
        this.assertSpanHierarchy("DocumentReference.Create", "Batch.Commit", this.grpcSpanName(COMMIT_RPC_NAME));
    }

    @Test
    public void docRefCreate2() throws Exception {
        this.firestore.collection("col").document().create((Object)new Pojo(1)).get();
        List<SpanData> spans = this.prepareSpans();
        Assert.assertEquals((long)3L, (long)spans.size());
        this.assertSpanHierarchy("DocumentReference.Create", "Batch.Commit", this.grpcSpanName(COMMIT_RPC_NAME));
    }

    @Test
    public void docRefSet() throws Exception {
        this.firestore.collection("col").document("foo").set(Collections.singletonMap("foo", "bar")).get();
        List<SpanData> spans = this.prepareSpans();
        Assert.assertEquals((long)3L, (long)spans.size());
        this.assertSpanHierarchy("DocumentReference.Set", "Batch.Commit", this.grpcSpanName(COMMIT_RPC_NAME));
    }

    @Test
    public void docRefSet2() throws Exception {
        this.firestore.collection("col").document("foo").set(Collections.singletonMap("foo", "bar"), SetOptions.merge()).get();
        List<SpanData> spans = this.prepareSpans();
        Assert.assertEquals((long)3L, (long)spans.size());
        this.assertSpanHierarchy("DocumentReference.Set", "Batch.Commit", this.grpcSpanName(COMMIT_RPC_NAME));
    }

    @Test
    public void docRefSet3() throws Exception {
        this.firestore.collection("col").document("foo").set((Object)new Pojo(1)).get();
        List<SpanData> spans = this.prepareSpans();
        Assert.assertEquals((long)3L, (long)spans.size());
        this.assertSpanHierarchy("DocumentReference.Set", "Batch.Commit", this.grpcSpanName(COMMIT_RPC_NAME));
    }

    @Test
    public void docRefSet4() throws Exception {
        this.firestore.collection("col").document("foo").set((Object)new Pojo(1), SetOptions.merge()).get();
        List<SpanData> spans = this.prepareSpans();
        Assert.assertEquals((long)3L, (long)spans.size());
        this.assertSpanHierarchy("DocumentReference.Set", "Batch.Commit", this.grpcSpanName(COMMIT_RPC_NAME));
    }

    @Test
    public void docRefUpdate() throws Exception {
        this.firestore.collection("col").document("foo").update(Collections.singletonMap("foo", "bar")).get();
        List<SpanData> spans = this.prepareSpans();
        Assert.assertEquals((long)3L, (long)spans.size());
        this.assertSpanHierarchy("DocumentReference.Update", "Batch.Commit", this.grpcSpanName(COMMIT_RPC_NAME));
    }

    @Test
    public void docRefUpdate2() throws Exception {
        this.firestore.collection("col").document("foo").update(Collections.singletonMap("foo", "bar"), Precondition.NONE).get();
        List<SpanData> spans = this.prepareSpans();
        Assert.assertEquals((long)3L, (long)spans.size());
        this.assertSpanHierarchy("DocumentReference.Update", "Batch.Commit", this.grpcSpanName(COMMIT_RPC_NAME));
    }

    @Test
    public void docRefUpdate3() throws Exception {
        this.firestore.collection("col").document("foo").update("key", (Object)"value", new Object[]{"key2", "value2"}).get();
        List<SpanData> spans = this.prepareSpans();
        Assert.assertEquals((long)3L, (long)spans.size());
        this.assertSpanHierarchy("DocumentReference.Update", "Batch.Commit", this.grpcSpanName(COMMIT_RPC_NAME));
    }

    @Test
    public void docRefUpdate4() throws Exception {
        this.firestore.collection("col").document("foo").update(FieldPath.of((String[])new String[]{"key"}), (Object)"value", new Object[]{FieldPath.of((String[])new String[]{"key2"}), "value2"}).get();
        List<SpanData> spans = this.prepareSpans();
        Assert.assertEquals((long)3L, (long)spans.size());
        this.assertSpanHierarchy("DocumentReference.Update", "Batch.Commit", this.grpcSpanName(COMMIT_RPC_NAME));
    }

    @Test
    public void docRefUpdate5() throws Exception {
        this.firestore.collection("col").document("foo").update(Precondition.NONE, "key", (Object)"value", new Object[]{"key2", "value2"}).get();
        List<SpanData> spans = this.prepareSpans();
        Assert.assertEquals((long)3L, (long)spans.size());
        this.assertSpanHierarchy("DocumentReference.Update", "Batch.Commit", this.grpcSpanName(COMMIT_RPC_NAME));
    }

    @Test
    public void docRefUpdate6() throws Exception {
        this.firestore.collection("col").document("foo").update(Precondition.NONE, FieldPath.of((String[])new String[]{"key"}), (Object)"value", new Object[]{FieldPath.of((String[])new String[]{"key2"}), "value2"}).get();
        List<SpanData> spans = this.prepareSpans();
        Assert.assertEquals((long)3L, (long)spans.size());
        this.assertSpanHierarchy("DocumentReference.Update", "Batch.Commit", this.grpcSpanName(COMMIT_RPC_NAME));
    }

    @Test
    public void docRefDelete() throws Exception {
        this.firestore.collection("col").document("doc0").delete().get();
        List<SpanData> spans = this.prepareSpans();
        Assert.assertEquals((long)3L, (long)spans.size());
        this.assertSpanHierarchy("DocumentReference.Delete", "Batch.Commit", this.grpcSpanName(COMMIT_RPC_NAME));
    }

    @Test
    public void docRefDelete2() throws Exception {
        this.firestore.collection("col").document("doc0").delete(Precondition.NONE).get();
        List<SpanData> spans = this.prepareSpans();
        Assert.assertEquals((long)3L, (long)spans.size());
        this.assertSpanHierarchy("DocumentReference.Delete", "Batch.Commit", this.grpcSpanName(COMMIT_RPC_NAME));
    }

    @Test
    public void docRefGet() throws Exception {
        this.firestore.collection("col").document("doc0").get().get();
        List<SpanData> spans = this.prepareSpans();
        Assert.assertEquals((long)2L, (long)spans.size());
        this.assertSpanHierarchy("DocumentReference.Get", this.grpcSpanName(BATCH_GET_DOCUMENTS_RPC_NAME));
    }

    @Test
    public void docRefGet2() throws Exception {
        this.firestore.collection("col").document("doc0").get(FieldMask.of((String[])new String[]{"foo"})).get();
        List<SpanData> spans = this.prepareSpans();
        Assert.assertEquals((long)2L, (long)spans.size());
        this.assertSpanHierarchy("DocumentReference.Get", this.grpcSpanName(BATCH_GET_DOCUMENTS_RPC_NAME));
    }

    @Test
    public void docListCollections() throws Exception {
        this.firestore.collection("col").document("doc0").listCollections();
        List<SpanData> spans = this.prepareSpans();
        Assert.assertEquals((long)2L, (long)spans.size());
        this.assertSpanHierarchy("DocumentReference.ListCollections", this.grpcSpanName(LIST_COLLECTIONS_RPC_NAME));
    }

    @Test
    public void getAll() throws Exception {
        DocumentReference docRef0 = this.firestore.collection("col").document();
        DocumentReference docRef1 = this.firestore.collection("col").document();
        DocumentReference[] docs = new DocumentReference[]{docRef0, docRef1};
        this.firestore.getAll(docs).get();
        List<SpanData> spans = this.prepareSpans();
        Assert.assertEquals((long)1L, (long)spans.size());
        SpanData span = this.getSpanByName(this.grpcSpanName(BATCH_GET_DOCUMENTS_RPC_NAME));
        Assert.assertTrue((boolean)this.hasEvent(span, "BatchGetDocuments: First response received", null));
        Assert.assertTrue((boolean)this.hasEvent(span, "BatchGetDocuments: Completed with 2 responses.", Attributes.builder().put("response_count", 2L).build()));
    }

    @Test
    public void queryGet() throws Exception {
        this.firestore.collection("col").whereEqualTo("foo", (Object)"my_non_existent_value").get().get();
        List<SpanData> spans = this.prepareSpans();
        Assert.assertEquals((long)2L, (long)spans.size());
        this.assertSpanHierarchy("Query.Get", this.grpcSpanName(RUN_QUERY_RPC_NAME));
        SpanData span = this.getSpanByName("Query.Get");
        Assert.assertTrue((boolean)this.hasEvent(span, RUN_QUERY_RPC_NAME, Attributes.builder().put("retry_query_with_cursor", false).put("transactional", false).build()));
        Assert.assertTrue((boolean)this.hasEvent(span, "RunQuery: Completed", Attributes.builder().put("doc_count", 0L).build()));
    }

    @Test
    public void transaction() throws Exception {
        this.firestore.runTransaction(transaction -> {
            Query q = this.firestore.collection("col").whereGreaterThan("bla", (Object)"");
            DocumentReference d = this.firestore.collection("col").document("foo");
            DocumentReference[] docList = new DocumentReference[]{d, d};
            transaction.get(q).get();
            transaction.get(q.count());
            transaction.getAll(new DocumentReference[]{d, d}).get();
            transaction.set(this.firestore.collection("foo").document("bar"), Collections.singletonMap("foo", "bar"));
            transaction.set(this.firestore.collection("foo").document("bar2"), Collections.singletonMap("foo2", "bar2"));
            return 0;
        }).get();
        List<SpanData> spans = this.prepareSpans();
        Assert.assertEquals((long)11L, (long)spans.size());
        this.assertSpanHierarchy("Transaction.Run", "Transaction.Begin", this.grpcSpanName(BEGIN_TRANSACTION_RPC_NAME));
        this.assertSpanHierarchy("Transaction.Run", "Transaction.Get.Query", this.grpcSpanName(RUN_QUERY_RPC_NAME));
        this.assertSpanHierarchy("Transaction.Run", "Transaction.Get.AggregationQuery", this.grpcSpanName(RUN_AGGREGATION_QUERY_RPC_NAME));
        this.assertSpanHierarchy("Transaction.Run", "Transaction.Get.Documents", this.grpcSpanName(BATCH_GET_DOCUMENTS_RPC_NAME));
        this.assertSpanHierarchy("Transaction.Run", "Transaction.Commit", this.grpcSpanName(COMMIT_RPC_NAME));
        Attributes commitAttributes = this.getSpanByName("Transaction.Commit").getAttributes();
        Assert.assertEquals((long)2L, (long)((Long)commitAttributes.get(AttributeKey.longKey((String)"gcp.firestore.doc_count"))));
        Attributes runTransactionAttributes = this.getSpanByName("Transaction.Run").getAttributes();
        Assert.assertEquals((long)5L, (long)((Long)runTransactionAttributes.get(AttributeKey.longKey((String)"gcp.firestore.attempts_allowed"))));
        Assert.assertEquals((long)5L, (long)((Long)runTransactionAttributes.get(AttributeKey.longKey((String)"gcp.firestore.attempts_remaining"))));
        Assert.assertEquals((Object)"READ_WRITE", (Object)runTransactionAttributes.get(AttributeKey.stringKey((String)"gcp.firestore.transaction_type")));
    }

    @Test
    public void transactionRollback() throws Exception {
        String myErrorMessage = "My error message.";
        try {
            this.firestore.runTransaction(transaction -> {
                throw new Exception(myErrorMessage);
            }).get();
        }
        catch (Exception exception) {
            // empty catch block
        }
        List<SpanData> spans = this.prepareSpans();
        Assert.assertEquals((long)5L, (long)spans.size());
        this.assertSpanHierarchy("Transaction.Run", "Transaction.Begin", this.grpcSpanName(BEGIN_TRANSACTION_RPC_NAME));
        this.assertSpanHierarchy("Transaction.Run", "Transaction.Rollback", this.grpcSpanName(ROLLBACK_RPC_NAME));
        SpanData runTransactionSpanData = this.getSpanByName("Transaction.Run");
        Assert.assertEquals((Object)StatusCode.ERROR, (Object)runTransactionSpanData.getStatus().getStatusCode());
        Assert.assertEquals((long)1L, (long)runTransactionSpanData.getEvents().size());
        Assert.assertEquals((Object)myErrorMessage, (Object)((EventData)runTransactionSpanData.getEvents().get(0)).getAttributes().get(AttributeKey.stringKey((String)"exception.message")));
        Assert.assertEquals((Object)"java.lang.Exception", (Object)((EventData)runTransactionSpanData.getEvents().get(0)).getAttributes().get(AttributeKey.stringKey((String)"exception.type")));
        Assert.assertTrue((boolean)((String)((EventData)runTransactionSpanData.getEvents().get(0)).getAttributes().get(AttributeKey.stringKey((String)"exception.stacktrace"))).startsWith("java.lang.Exception: My error message."));
    }

    @Test
    public void writeBatch() throws Exception {
        WriteBatch batch = this.firestore.batch();
        DocumentReference docRef = this.firestore.collection("foo").document();
        batch.create(docRef, Collections.singletonMap("foo", "bar"));
        batch.update(docRef, Collections.singletonMap("foo", "bar"));
        batch.delete(docRef);
        batch.commit().get();
        List<SpanData> spans = this.prepareSpans();
        Assert.assertEquals((long)2L, (long)spans.size());
        this.assertSpanHierarchy("Batch.Commit", this.grpcSpanName(COMMIT_RPC_NAME));
        Assert.assertEquals((Object)false, (Object)((Boolean)this.getSpanByName("Batch.Commit").getAttributes().get(AttributeKey.booleanKey((String)"gcp.firestore.transactional"))));
        Assert.assertEquals((long)3L, (long)((Long)this.getSpanByName("Batch.Commit").getAttributes().get(AttributeKey.longKey((String)"gcp.firestore.doc_count"))));
    }

    public static class Pojo {
        public int bar;

        public Pojo() {
            this.bar = 0;
        }

        public Pojo(int bar) {
            this.bar = bar;
        }

        public int getBar() {
            return this.bar;
        }

        public void setBar(int bar) {
            this.bar = bar;
        }
    }
}

