/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore.it;

import com.google.api.core.ApiFuture;
import com.google.cloud.firestore.Firestore;
import com.google.cloud.firestore.FirestoreOptions;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;

public final class TestHelper {
    private TestHelper() {
    }

    static boolean isRunningAgainstFirestoreEmulator(Firestore firestore) {
        return ((FirestoreOptions)firestore.getOptions()).getHost().startsWith("localhost:");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void await(ApiFuture<?> future) throws InterruptedException {
        AtomicBoolean done = new AtomicBoolean(false);
        ExecutorService executor = Executors.newSingleThreadExecutor();
        future.addListener(() -> {
            AtomicBoolean atomicBoolean = done;
            synchronized (atomicBoolean) {
                done.set(true);
                done.notifyAll();
            }
        }, (Executor)executor);
        AtomicBoolean atomicBoolean = done;
        synchronized (atomicBoolean) {
            while (!done.get()) {
                done.wait();
            }
        }
        executor.shutdown();
    }
}

