/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore.spi.v1;

import com.google.api.gax.retrying.ExponentialRetryAlgorithm;
import com.google.api.gax.retrying.RetryAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.ScheduledRetryingExecutor;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.ServerStreamingCallSettings;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.cloud.firestore.FirestoreOptions;
import com.google.cloud.firestore.spi.v1.GrpcFirestoreRpc;
import com.google.cloud.firestore.v1.stub.FirestoreStubSettings;
import com.google.common.truth.Truth;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Set;
import org.junit.BeforeClass;
import org.junit.Test;

public class GrpcFirestoreRpcTest {
    private static FirestoreStubSettings defaultStubSettings;
    private final FirestoreOptions firestoreOptionsWithoutOverride = ((FirestoreOptions.Builder)FirestoreOptions.newBuilder().setProjectId("test-project")).build();

    @BeforeClass
    public static void beforeClass() throws IOException {
        defaultStubSettings = FirestoreStubSettings.newBuilder().build();
    }

    static <T> T getViaReflection(Object o, String fieldName) throws NoSuchFieldException, IllegalAccessException {
        return GrpcFirestoreRpcTest.getViaReflection(o.getClass(), fieldName, o);
    }

    static <T> T getViaReflection(Class clazz, String fieldName, Object o) throws NoSuchFieldException, IllegalAccessException {
        Field field = clazz.getDeclaredField(fieldName);
        field.setAccessible(true);
        return (T)field.get(o);
    }

    @Test
    public void retrySettingsOverride() throws Exception {
        RetrySettings retrySettings = RetrySettings.newBuilder().setMaxAttempts(2).build();
        FirestoreOptions firestoreOptions = ((FirestoreOptions.Builder)((FirestoreOptions.Builder)FirestoreOptions.newBuilder().setProjectId("test-project")).setRetrySettings(retrySettings)).build();
        GrpcFirestoreRpc grpcFirestoreRpc = new GrpcFirestoreRpc(firestoreOptions);
        CallableRetryData commit = GrpcFirestoreRpcTest.getRetryData(grpcFirestoreRpc.commitCallable());
        Truth.assertThat((Object)commit.retrySettings).isEqualTo((Object)retrySettings);
        Truth.assertThat(commit.retryableCodes).containsExactlyElementsIn((Iterable)defaultStubSettings.commitSettings().getRetryableCodes());
        CallableRetryData batchWrite = GrpcFirestoreRpcTest.getRetryData(grpcFirestoreRpc.batchWriteCallable());
        Truth.assertThat((Object)batchWrite.retrySettings).isEqualTo((Object)retrySettings);
        Truth.assertThat(batchWrite.retryableCodes).containsExactlyElementsIn((Iterable)defaultStubSettings.batchWriteSettings().getRetryableCodes());
        CallableRetryData batchGetDocuments = GrpcFirestoreRpcTest.getRetryData(grpcFirestoreRpc.batchGetDocumentsCallable());
        Truth.assertThat((Object)batchGetDocuments.retrySettings).isEqualTo((Object)retrySettings);
        Truth.assertThat(batchGetDocuments.retryableCodes).containsExactlyElementsIn((Iterable)defaultStubSettings.batchGetDocumentsSettings().getRetryableCodes());
        CallableRetryData runQuery = GrpcFirestoreRpcTest.getRetryData(grpcFirestoreRpc.runQueryCallable());
        Truth.assertThat((Object)runQuery.retrySettings).isEqualTo((Object)retrySettings);
        Truth.assertThat(runQuery.retryableCodes).containsExactlyElementsIn((Iterable)defaultStubSettings.runQuerySettings().getRetryableCodes());
        CallableRetryData runAggregationQuery = GrpcFirestoreRpcTest.getRetryData(grpcFirestoreRpc.runAggregationQueryCallable());
        Truth.assertThat((Object)runAggregationQuery.retrySettings).isEqualTo((Object)retrySettings);
        Truth.assertThat(runAggregationQuery.retryableCodes).containsExactlyElementsIn((Iterable)defaultStubSettings.runAggregationQuerySettings().getRetryableCodes());
        CallableRetryData beginTransaction = GrpcFirestoreRpcTest.getRetryData(grpcFirestoreRpc.beginTransactionCallable());
        Truth.assertThat((Object)beginTransaction.retrySettings).isEqualTo((Object)retrySettings);
        Truth.assertThat(beginTransaction.retryableCodes).containsExactlyElementsIn((Iterable)defaultStubSettings.beginTransactionSettings().getRetryableCodes());
        CallableRetryData rollback = GrpcFirestoreRpcTest.getRetryData(grpcFirestoreRpc.rollbackCallable());
        Truth.assertThat((Object)rollback.retrySettings).isEqualTo((Object)retrySettings);
        Truth.assertThat(rollback.retryableCodes).containsExactlyElementsIn((Iterable)defaultStubSettings.rollbackSettings().getRetryableCodes());
        CallableRetryData listCollectionIdsPaged = GrpcFirestoreRpcTest.getRetryData(grpcFirestoreRpc.listCollectionIdsPagedCallable());
        Truth.assertThat((Object)listCollectionIdsPaged.retrySettings).isEqualTo((Object)retrySettings);
        Truth.assertThat(listCollectionIdsPaged.retryableCodes).containsExactlyElementsIn((Iterable)defaultStubSettings.listCollectionIdsSettings().getRetryableCodes());
        CallableRetryData partitionQueryPaged = GrpcFirestoreRpcTest.getRetryData(grpcFirestoreRpc.partitionQueryPagedCallable());
        Truth.assertThat((Object)partitionQueryPaged.retrySettings).isEqualTo((Object)retrySettings);
        Truth.assertThat(partitionQueryPaged.retryableCodes).containsExactlyElementsIn((Iterable)defaultStubSettings.partitionQuerySettings().getRetryableCodes());
        CallableRetryData listDocumentsPaged = GrpcFirestoreRpcTest.getRetryData(grpcFirestoreRpc.listDocumentsPagedCallable());
        Truth.assertThat((Object)listDocumentsPaged.retrySettings).isEqualTo((Object)retrySettings);
        Truth.assertThat(listDocumentsPaged.retryableCodes).containsExactlyElementsIn((Iterable)defaultStubSettings.listDocumentsSettings().getRetryableCodes());
    }

    private static RetrySettings withMaxAttempt5(RetrySettings retrySettings) {
        return retrySettings.toBuilder().setMaxAttempts(5).build();
    }

    @Test
    public void commitCallableFollowsServiceConfig() throws Exception {
        GrpcFirestoreRpc grpcFirestoreRpc = new GrpcFirestoreRpc(this.firestoreOptionsWithoutOverride);
        CallableRetryData actual = GrpcFirestoreRpcTest.getRetryData(grpcFirestoreRpc.commitCallable());
        UnaryCallSettings expectedSettings = defaultStubSettings.commitSettings();
        Truth.assertThat((Object)actual.retrySettings).isEqualTo((Object)GrpcFirestoreRpcTest.withMaxAttempt5(expectedSettings.getRetrySettings()));
        Truth.assertThat(actual.retryableCodes).containsExactlyElementsIn((Iterable)expectedSettings.getRetryableCodes());
    }

    @Test
    public void batchWriteCallableFollowsServiceConfig() throws Exception {
        GrpcFirestoreRpc grpcFirestoreRpc = new GrpcFirestoreRpc(this.firestoreOptionsWithoutOverride);
        CallableRetryData actual = GrpcFirestoreRpcTest.getRetryData(grpcFirestoreRpc.batchWriteCallable());
        UnaryCallSettings expectedSettings = defaultStubSettings.batchWriteSettings();
        Truth.assertThat((Object)actual.retrySettings).isEqualTo((Object)GrpcFirestoreRpcTest.withMaxAttempt5(expectedSettings.getRetrySettings()));
        Truth.assertThat(actual.retryableCodes).containsExactlyElementsIn((Iterable)expectedSettings.getRetryableCodes());
    }

    @Test
    public void batchGetDocumentsCallableFollowsServiceConfig() throws Exception {
        GrpcFirestoreRpc grpcFirestoreRpc = new GrpcFirestoreRpc(this.firestoreOptionsWithoutOverride);
        CallableRetryData actual = GrpcFirestoreRpcTest.getRetryData(grpcFirestoreRpc.batchGetDocumentsCallable());
        ServerStreamingCallSettings expectedSettings = defaultStubSettings.batchGetDocumentsSettings();
        Truth.assertThat((Object)actual.retrySettings).isEqualTo((Object)GrpcFirestoreRpcTest.withMaxAttempt5(expectedSettings.getRetrySettings()));
        Truth.assertThat(actual.retryableCodes).containsExactlyElementsIn((Iterable)expectedSettings.getRetryableCodes());
    }

    @Test
    public void runQueryCallableFollowsServiceConfig() throws Exception {
        GrpcFirestoreRpc grpcFirestoreRpc = new GrpcFirestoreRpc(this.firestoreOptionsWithoutOverride);
        CallableRetryData actual = GrpcFirestoreRpcTest.getRetryData(grpcFirestoreRpc.runQueryCallable());
        ServerStreamingCallSettings expectedSettings = defaultStubSettings.runQuerySettings();
        Truth.assertThat((Object)actual.retrySettings).isEqualTo((Object)GrpcFirestoreRpcTest.withMaxAttempt5(expectedSettings.getRetrySettings()));
        Truth.assertThat(actual.retryableCodes).containsExactlyElementsIn((Iterable)expectedSettings.getRetryableCodes());
    }

    @Test
    public void runAggregationQueryCallableFollowsServiceConfig() throws Exception {
        GrpcFirestoreRpc grpcFirestoreRpc = new GrpcFirestoreRpc(this.firestoreOptionsWithoutOverride);
        CallableRetryData actual = GrpcFirestoreRpcTest.getRetryData(grpcFirestoreRpc.runAggregationQueryCallable());
        ServerStreamingCallSettings expectedSettings = defaultStubSettings.runAggregationQuerySettings();
        Truth.assertThat((Object)actual.retrySettings).isEqualTo((Object)GrpcFirestoreRpcTest.withMaxAttempt5(expectedSettings.getRetrySettings()));
        Truth.assertThat(actual.retryableCodes).containsExactlyElementsIn((Iterable)expectedSettings.getRetryableCodes());
    }

    @Test
    public void beginTransactionCallableFollowsServiceConfig() throws Exception {
        GrpcFirestoreRpc grpcFirestoreRpc = new GrpcFirestoreRpc(this.firestoreOptionsWithoutOverride);
        CallableRetryData actual = GrpcFirestoreRpcTest.getRetryData(grpcFirestoreRpc.beginTransactionCallable());
        UnaryCallSettings expectedSettings = defaultStubSettings.beginTransactionSettings();
        Truth.assertThat((Object)actual.retrySettings).isEqualTo((Object)GrpcFirestoreRpcTest.withMaxAttempt5(expectedSettings.getRetrySettings()));
        Truth.assertThat(actual.retryableCodes).containsExactlyElementsIn((Iterable)expectedSettings.getRetryableCodes());
    }

    @Test
    public void rollbackCallableFollowsServiceConfig() throws Exception {
        GrpcFirestoreRpc grpcFirestoreRpc = new GrpcFirestoreRpc(this.firestoreOptionsWithoutOverride);
        CallableRetryData actual = GrpcFirestoreRpcTest.getRetryData(grpcFirestoreRpc.rollbackCallable());
        UnaryCallSettings expectedSettings = defaultStubSettings.rollbackSettings();
        Truth.assertThat((Object)actual.retrySettings).isEqualTo((Object)GrpcFirestoreRpcTest.withMaxAttempt5(expectedSettings.getRetrySettings()));
        Truth.assertThat(actual.retryableCodes).containsExactlyElementsIn((Iterable)expectedSettings.getRetryableCodes());
    }

    @Test
    public void listCollectionIdsPagedCallableFollowsServiceConfig() throws Exception {
        GrpcFirestoreRpc grpcFirestoreRpc = new GrpcFirestoreRpc(this.firestoreOptionsWithoutOverride);
        CallableRetryData actual = GrpcFirestoreRpcTest.getRetryData(grpcFirestoreRpc.listCollectionIdsPagedCallable());
        PagedCallSettings expectedSettings = defaultStubSettings.listDocumentsSettings();
        Truth.assertThat((Object)actual.retrySettings).isEqualTo((Object)GrpcFirestoreRpcTest.withMaxAttempt5(expectedSettings.getRetrySettings()));
        Truth.assertThat(actual.retryableCodes).containsExactlyElementsIn((Iterable)expectedSettings.getRetryableCodes());
    }

    @Test
    public void partitionQueryPagedCallableFollowsServiceConfig() throws Exception {
        GrpcFirestoreRpc grpcFirestoreRpc = new GrpcFirestoreRpc(this.firestoreOptionsWithoutOverride);
        CallableRetryData actual = GrpcFirestoreRpcTest.getRetryData(grpcFirestoreRpc.partitionQueryPagedCallable());
        PagedCallSettings expectedSettings = defaultStubSettings.partitionQuerySettings();
        Truth.assertThat((Object)actual.retrySettings).isEqualTo((Object)GrpcFirestoreRpcTest.withMaxAttempt5(expectedSettings.getRetrySettings()));
        Truth.assertThat(actual.retryableCodes).containsExactlyElementsIn((Iterable)expectedSettings.getRetryableCodes());
    }

    @Test
    public void listDocumentsPagedCallableFollowsServiceConfig() throws Exception {
        GrpcFirestoreRpc grpcFirestoreRpc = new GrpcFirestoreRpc(this.firestoreOptionsWithoutOverride);
        CallableRetryData actual = GrpcFirestoreRpcTest.getRetryData(grpcFirestoreRpc.listDocumentsPagedCallable());
        PagedCallSettings expectedSettings = defaultStubSettings.listDocumentsSettings();
        Truth.assertThat((Object)actual.retrySettings).isEqualTo((Object)GrpcFirestoreRpcTest.withMaxAttempt5(expectedSettings.getRetrySettings()));
        Truth.assertThat(actual.retryableCodes).containsExactlyElementsIn((Iterable)expectedSettings.getRetryableCodes());
    }

    private static CallableRetryData getRetryData(Object callable) throws Exception {
        String aClassName;
        switch (aClassName = callable.getClass().getName()) {
            case "com.google.api.gax.tracing.TracedUnaryCallable": 
            case "com.google.api.gax.tracing.TracedServerStreamingCallable": {
                return GrpcFirestoreRpcTest.getRetryData(GrpcFirestoreRpcTest.getViaReflection(callable, "innerCallable"));
            }
            case "com.google.api.gax.rpc.UnaryCallable$1": 
            case "com.google.api.gax.rpc.ServerStreamingCallable$1": {
                return GrpcFirestoreRpcTest.getRetryData(GrpcFirestoreRpcTest.getViaReflection(callable, "this$0"));
            }
            case "com.google.api.gax.rpc.RetryingCallable": {
                return new CallableRetryData(GrpcFirestoreRpcTest.getRetrySettings(GrpcFirestoreRpcTest.getViaReflection(callable, "executor")), GrpcFirestoreRpcTest.getRetryableCodes(GrpcFirestoreRpcTest.getViaReflection(callable, "callable")));
            }
            case "com.google.api.gax.rpc.RetryingServerStreamingCallable": {
                return new CallableRetryData(GrpcFirestoreRpcTest.getRetrySettings(GrpcFirestoreRpcTest.getViaReflection(callable, "executor")), GrpcFirestoreRpcTest.getRetryableCodes(GrpcFirestoreRpcTest.getViaReflection(callable, "innerCallable")));
            }
            case "com.google.api.gax.rpc.PagedCallable": {
                return GrpcFirestoreRpcTest.getRetryData(GrpcFirestoreRpcTest.getViaReflection(callable, "callable"));
            }
        }
        throw new Exception("Unexpected class " + aClassName);
    }

    private static Set<StatusCode.Code> getRetryableCodes(Object o) throws NoSuchFieldException, IllegalAccessException {
        switch (o.getClass().getName()) {
            case "com.google.api.gax.rpc.ServerStreamingCallable$1": {
                return GrpcFirestoreRpcTest.getRetryableCodes(GrpcFirestoreRpcTest.getViaReflection(o, "this$0"));
            }
            case "com.google.api.gax.rpc.WatchdogServerStreamingCallable": {
                return GrpcFirestoreRpcTest.getRetryableCodes(GrpcFirestoreRpcTest.getViaReflection(o, "inner"));
            }
        }
        Object exceptionFactory = GrpcFirestoreRpcTest.getViaReflection(o, "exceptionFactory");
        return (Set)GrpcFirestoreRpcTest.getViaReflection(exceptionFactory, "retryableCodes");
    }

    private static RetrySettings getRetrySettings(Object o) throws Exception {
        String aClassName;
        switch (aClassName = o.getClass().getName()) {
            case "com.google.api.gax.retrying.ScheduledRetryingExecutor": {
                Object retryAlgorithm = GrpcFirestoreRpcTest.getViaReflection(ScheduledRetryingExecutor.class, "retryAlgorithm", o);
                Object exponentialRetryAlgorithm = GrpcFirestoreRpcTest.getViaReflection(RetryAlgorithm.class, "timedAlgorithmWithContext", retryAlgorithm);
                return (RetrySettings)GrpcFirestoreRpcTest.getViaReflection(ExponentialRetryAlgorithm.class, "globalSettings", exponentialRetryAlgorithm);
            }
        }
        throw new Exception("Unexpected class " + aClassName);
    }

    static class CallableRetryData {
        final RetrySettings retrySettings;
        final Set<StatusCode.Code> retryableCodes;

        CallableRetryData(RetrySettings retrySettings, Set<StatusCode.Code> retryableCodes) {
            this.retrySettings = retrySettings;
            this.retryableCodes = retryableCodes;
        }
    }
}

