/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore.telemetry;

import com.google.cloud.firestore.telemetry.DisabledTraceUtil;
import com.google.common.truth.Truth;
import org.junit.Test;

public class DisabledTraceUtilTest {
    @Test
    public void disabledTraceUtilDoesNotProvideChannelConfigurator() {
        DisabledTraceUtil traceUtil = new DisabledTraceUtil();
        Truth.assertThat((Object)traceUtil.getChannelConfigurator()).isNull();
    }

    @Test
    public void usesDisabledContext() {
        DisabledTraceUtil traceUtil = new DisabledTraceUtil();
        Truth.assertThat((Boolean)(traceUtil.currentContext() instanceof DisabledTraceUtil.Context)).isTrue();
    }

    @Test
    public void usesDisabledSpan() {
        DisabledTraceUtil traceUtil = new DisabledTraceUtil();
        Truth.assertThat((Boolean)(traceUtil.currentSpan() instanceof DisabledTraceUtil.Span)).isTrue();
        Truth.assertThat((Boolean)(traceUtil.startSpan("foo") instanceof DisabledTraceUtil.Span)).isTrue();
        Truth.assertThat((Boolean)(traceUtil.startSpan("foo", traceUtil.currentContext()) instanceof DisabledTraceUtil.Span)).isTrue();
    }

    @Test
    public void usesDisabledScope() {
        DisabledTraceUtil traceUtil = new DisabledTraceUtil();
        Truth.assertThat((Boolean)(traceUtil.currentContext().makeCurrent() instanceof DisabledTraceUtil.Scope)).isTrue();
        Truth.assertThat((Boolean)(traceUtil.currentSpan().makeCurrent() instanceof DisabledTraceUtil.Scope)).isTrue();
    }
}

