/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore.telemetry;

import com.google.cloud.firestore.FirestoreOpenTelemetryOptions;
import com.google.cloud.firestore.FirestoreOptions;
import com.google.cloud.firestore.telemetry.EnabledTraceUtil;
import com.google.common.truth.Truth;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.TracerProvider;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import java.time.Duration;
import org.junit.Before;
import org.junit.Test;

public class EnabledTraceUtilTest {
    @Before
    public void setUp() {
        GlobalOpenTelemetry.resetForTest();
    }

    EnabledTraceUtil defaultEnabledTraceUtil() {
        return new EnabledTraceUtil(FirestoreOptions.getDefaultInstance());
    }

    FirestoreOptions.Builder getBaseOptions() {
        return ((FirestoreOptions.Builder)FirestoreOptions.newBuilder().setProjectId("test-project")).setDatabaseId("(default)");
    }

    @Test
    public void usesOpenTelemetryFromOptions() {
        OpenTelemetrySdk myOpenTelemetrySdk = OpenTelemetrySdk.builder().build();
        FirestoreOptions firestoreOptions = this.getBaseOptions().setOpenTelemetryOptions(FirestoreOpenTelemetryOptions.newBuilder().setOpenTelemetry((OpenTelemetry)myOpenTelemetrySdk).build()).build();
        EnabledTraceUtil traceUtil = new EnabledTraceUtil(firestoreOptions);
        Truth.assertThat((Object)traceUtil.getOpenTelemetry()).isSameInstanceAs((Object)myOpenTelemetrySdk);
    }

    @Test
    public void usesGlobalOpenTelemetryIfOpenTelemetryInstanceNotProvided() {
        OpenTelemetrySdk.builder().buildAndRegisterGlobal();
        EnabledTraceUtil traceUtil = this.defaultEnabledTraceUtil();
        Truth.assertThat((Object)traceUtil.getOpenTelemetry()).isSameInstanceAs((Object)GlobalOpenTelemetry.get());
    }

    @Test
    public void usesOpenTelemetryFromOptionsEvenIfGlobalOpenTelemetryExists() {
        OpenTelemetrySdk.builder().buildAndRegisterGlobal();
        OpenTelemetrySdk myOpenTelemetrySdk = OpenTelemetrySdk.builder().build();
        FirestoreOptions firestoreOptions = this.getBaseOptions().setOpenTelemetryOptions(FirestoreOpenTelemetryOptions.newBuilder().setOpenTelemetry((OpenTelemetry)myOpenTelemetrySdk).build()).build();
        EnabledTraceUtil traceUtil = new EnabledTraceUtil(firestoreOptions);
        Truth.assertThat((Object)traceUtil.getOpenTelemetry()).isSameInstanceAs((Object)myOpenTelemetrySdk);
        Truth.assertThat((Object)traceUtil.getOpenTelemetry()).isNotSameInstanceAs((Object)GlobalOpenTelemetry.get());
    }

    @Test
    public void defaultOptionsDoesNotRegisterGrpcChannelConfigurator() {
        EnabledTraceUtil traceUtil = this.defaultEnabledTraceUtil();
        Truth.assertThat((Object)traceUtil.getOpenTelemetry().getTracerProvider()).isSameInstanceAs((Object)TracerProvider.noop());
        Truth.assertThat((Object)traceUtil.getChannelConfigurator()).isNull();
    }

    @Test
    public void globalOpenTelemetryRegistersGrpcChannelConfigurator() {
        OpenTelemetrySdk.builder().buildAndRegisterGlobal();
        EnabledTraceUtil traceUtil = this.defaultEnabledTraceUtil();
        Truth.assertThat((Object)traceUtil.getChannelConfigurator()).isNotNull();
    }

    @Test
    public void openTelemetryInstanceRegistersGrpcChannelConfigurator() {
        OpenTelemetrySdk myOpenTelemetrySdk = OpenTelemetrySdk.builder().build();
        FirestoreOptions firestoreOptions = this.getBaseOptions().setOpenTelemetryOptions(FirestoreOpenTelemetryOptions.newBuilder().setOpenTelemetry((OpenTelemetry)myOpenTelemetrySdk).build()).build();
        EnabledTraceUtil traceUtil = new EnabledTraceUtil(firestoreOptions);
        Truth.assertThat((Object)traceUtil.getChannelConfigurator()).isNotNull();
    }

    @Test
    public void usesEnabledContext() {
        Truth.assertThat((Boolean)(this.defaultEnabledTraceUtil().currentContext() instanceof EnabledTraceUtil.Context)).isTrue();
    }

    @Test
    public void usesEnabledSpan() {
        EnabledTraceUtil traceUtil = this.defaultEnabledTraceUtil();
        Truth.assertThat((Boolean)(traceUtil.currentSpan() instanceof EnabledTraceUtil.Span)).isTrue();
        Truth.assertThat((Boolean)(traceUtil.startSpan("foo") instanceof EnabledTraceUtil.Span)).isTrue();
        Truth.assertThat((Boolean)(traceUtil.startSpan("foo", traceUtil.currentContext()) instanceof EnabledTraceUtil.Span)).isTrue();
    }

    @Test
    public void usesEnabledScope() {
        EnabledTraceUtil traceUtil = this.defaultEnabledTraceUtil();
        Truth.assertThat((Boolean)(traceUtil.currentContext().makeCurrent() instanceof EnabledTraceUtil.Scope)).isTrue();
        Truth.assertThat((Boolean)(traceUtil.currentSpan().makeCurrent() instanceof EnabledTraceUtil.Scope)).isTrue();
    }

    @Test
    public void durationString() {
        EnabledTraceUtil traceUtil = this.defaultEnabledTraceUtil();
        Duration duration = Duration.ofSeconds(2L, 9L);
        Truth.assertThat((String)traceUtil.durationString(duration)).isEqualTo((Object)"2.000000009s");
        duration = Duration.ofSeconds(3L, 98L);
        Truth.assertThat((String)traceUtil.durationString(duration)).isEqualTo((Object)"3.000000098s");
        duration = Duration.ofSeconds(4L, 987L);
        Truth.assertThat((String)traceUtil.durationString(duration)).isEqualTo((Object)"4.000000987s");
        duration = Duration.ofSeconds(5L, 9876L);
        Truth.assertThat((String)traceUtil.durationString(duration)).isEqualTo((Object)"5.000009876s");
        duration = Duration.ofSeconds(6L, 98765L);
        Truth.assertThat((String)traceUtil.durationString(duration)).isEqualTo((Object)"6.000098765s");
        duration = Duration.ofSeconds(7L, 987654L);
        Truth.assertThat((String)traceUtil.durationString(duration)).isEqualTo((Object)"7.000987654s");
        duration = Duration.ofSeconds(8L, 9876543L);
        Truth.assertThat((String)traceUtil.durationString(duration)).isEqualTo((Object)"8.009876543s");
        duration = Duration.ofSeconds(9L, 98765432L);
        Truth.assertThat((String)traceUtil.durationString(duration)).isEqualTo((Object)"9.098765432s");
        duration = Duration.ofSeconds(10L, 987654321L);
        Truth.assertThat((String)traceUtil.durationString(duration)).isEqualTo((Object)"10.987654321s");
        duration = Duration.ofSeconds(1L, 0L);
        Truth.assertThat((String)traceUtil.durationString(duration)).isEqualTo((Object)"1.0s");
        duration = Duration.ofSeconds(1L, 1L);
        Truth.assertThat((String)traceUtil.durationString(duration)).isEqualTo((Object)"1.000000001s");
        duration = Duration.ofSeconds(1L, 10L);
        Truth.assertThat((String)traceUtil.durationString(duration)).isEqualTo((Object)"1.00000001s");
        duration = Duration.ofSeconds(1L, 100L);
        Truth.assertThat((String)traceUtil.durationString(duration)).isEqualTo((Object)"1.0000001s");
        duration = Duration.ofSeconds(1L, 1000L);
        Truth.assertThat((String)traceUtil.durationString(duration)).isEqualTo((Object)"1.000001s");
        duration = Duration.ofSeconds(1L, 10000L);
        Truth.assertThat((String)traceUtil.durationString(duration)).isEqualTo((Object)"1.00001s");
        duration = Duration.ofSeconds(1L, 100000L);
        Truth.assertThat((String)traceUtil.durationString(duration)).isEqualTo((Object)"1.0001s");
        duration = Duration.ofSeconds(1L, 1000000L);
        Truth.assertThat((String)traceUtil.durationString(duration)).isEqualTo((Object)"1.001s");
        duration = Duration.ofSeconds(1L, 10000000L);
        Truth.assertThat((String)traceUtil.durationString(duration)).isEqualTo((Object)"1.01s");
        duration = Duration.ofSeconds(1L, 100000000L);
        Truth.assertThat((String)traceUtil.durationString(duration)).isEqualTo((Object)"1.1s");
        duration = Duration.ofSeconds(1L, 100000001L);
        Truth.assertThat((String)traceUtil.durationString(duration)).isEqualTo((Object)"1.100000001s");
    }
}

