/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore.v1;

import com.google.api.client.http.HttpTransport;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.testing.MockHttpService;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.ApiExceptionFactory;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.testing.FakeStatusCode;
import com.google.cloud.firestore.v1.FirestoreClient;
import com.google.cloud.firestore.v1.FirestoreSettings;
import com.google.cloud.firestore.v1.stub.HttpJsonFirestoreStub;
import com.google.common.collect.Lists;
import com.google.firestore.v1.BatchWriteRequest;
import com.google.firestore.v1.BatchWriteResponse;
import com.google.firestore.v1.BeginTransactionResponse;
import com.google.firestore.v1.CommitResponse;
import com.google.firestore.v1.CreateDocumentRequest;
import com.google.firestore.v1.Cursor;
import com.google.firestore.v1.Document;
import com.google.firestore.v1.DocumentMask;
import com.google.firestore.v1.GetDocumentRequest;
import com.google.firestore.v1.ListCollectionIdsResponse;
import com.google.firestore.v1.ListDocumentsRequest;
import com.google.firestore.v1.ListDocumentsResponse;
import com.google.firestore.v1.PartitionQueryRequest;
import com.google.firestore.v1.PartitionQueryResponse;
import com.google.protobuf.ByteString;
import com.google.protobuf.Empty;
import com.google.protobuf.Timestamp;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class FirestoreClientHttpJsonTest {
    private static MockHttpService mockService;
    private static FirestoreClient client;

    @BeforeClass
    public static void startStaticServer() throws IOException {
        mockService = new MockHttpService(HttpJsonFirestoreStub.getMethodDescriptors(), FirestoreSettings.getDefaultEndpoint());
        FirestoreSettings settings = ((FirestoreSettings.Builder)((FirestoreSettings.Builder)FirestoreSettings.newHttpJsonBuilder().setTransportChannelProvider((TransportChannelProvider)FirestoreSettings.defaultHttpJsonTransportProviderBuilder().setHttpTransport((HttpTransport)mockService).build())).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        client = FirestoreClient.create((FirestoreSettings)settings);
    }

    @AfterClass
    public static void stopServer() {
        client.close();
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() throws Exception {
        mockService.reset();
    }

    @Test
    public void getDocumentTest() throws Exception {
        Document expectedResponse = Document.newBuilder().setName("name3373707").putAllFields(new HashMap()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        GetDocumentRequest request = GetDocumentRequest.newBuilder().setName("projects/project-615/databases/database-615/documents/document-615/document-615").setMask(DocumentMask.newBuilder().build()).build();
        Document actualResponse = client.getDocument(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getDocumentExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            GetDocumentRequest request = GetDocumentRequest.newBuilder().setName("projects/project-615/databases/database-615/documents/document-615/document-615").setMask(DocumentMask.newBuilder().build()).build();
            client.getDocument(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listDocumentsTest() throws Exception {
        Document responsesElement = Document.newBuilder().build();
        ListDocumentsResponse expectedResponse = ListDocumentsResponse.newBuilder().setNextPageToken("").addAllDocuments(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        ListDocumentsRequest request = ListDocumentsRequest.newBuilder().setParent("projects/project-6440/databases/database-6440/documents/document-6440/document-6440").setCollectionId("collectionId-3631").setPageSize(883849137).setPageToken("pageToken873572522").setOrderBy("orderBy-1207110587").setMask(DocumentMask.newBuilder().build()).setShowMissing(true).build();
        FirestoreClient.ListDocumentsPagedResponse pagedListResponse = client.listDocuments(request);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getDocumentsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listDocumentsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ListDocumentsRequest request = ListDocumentsRequest.newBuilder().setParent("projects/project-6440/databases/database-6440/documents/document-6440/document-6440").setCollectionId("collectionId-3631").setPageSize(883849137).setPageToken("pageToken873572522").setOrderBy("orderBy-1207110587").setMask(DocumentMask.newBuilder().build()).setShowMissing(true).build();
            client.listDocuments(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateDocumentTest() throws Exception {
        Document expectedResponse = Document.newBuilder().setName("name3373707").putAllFields(new HashMap()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        Document document = Document.newBuilder().setName("projects/project-615/databases/database-615/documents/document-615/document-615").putAllFields(new HashMap()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).build();
        DocumentMask updateMask = DocumentMask.newBuilder().build();
        Document actualResponse = client.updateDocument(document, updateMask);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void updateDocumentExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            Document document = Document.newBuilder().setName("projects/project-615/databases/database-615/documents/document-615/document-615").putAllFields(new HashMap()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).build();
            DocumentMask updateMask = DocumentMask.newBuilder().build();
            client.updateDocument(document, updateMask);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteDocumentTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-615/databases/database-615/documents/document-615/document-615";
        client.deleteDocument(name);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteDocumentExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-615/databases/database-615/documents/document-615/document-615";
            client.deleteDocument(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void batchGetDocumentsTest() throws Exception {
    }

    @Test
    public void batchGetDocumentsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
    }

    @Test
    public void beginTransactionTest() throws Exception {
        BeginTransactionResponse expectedResponse = BeginTransactionResponse.newBuilder().setTransaction(ByteString.EMPTY).build();
        mockService.addResponse((Object)expectedResponse);
        String database = "projects/project-4060/databases/database-4060";
        BeginTransactionResponse actualResponse = client.beginTransaction(database);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void beginTransactionExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String database = "projects/project-4060/databases/database-4060";
            client.beginTransaction(database);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void commitTest() throws Exception {
        CommitResponse expectedResponse = CommitResponse.newBuilder().addAllWriteResults(new ArrayList()).setCommitTime(Timestamp.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        String database = "projects/project-4060/databases/database-4060";
        ArrayList writes = new ArrayList();
        CommitResponse actualResponse = client.commit(database, writes);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void commitExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String database = "projects/project-4060/databases/database-4060";
            ArrayList writes = new ArrayList();
            client.commit(database, writes);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void rollbackTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockService.addResponse((Object)expectedResponse);
        String database = "projects/project-4060/databases/database-4060";
        ByteString transaction = ByteString.EMPTY;
        client.rollback(database, transaction);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void rollbackExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String database = "projects/project-4060/databases/database-4060";
            ByteString transaction = ByteString.EMPTY;
            client.rollback(database, transaction);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void runQueryTest() throws Exception {
    }

    @Test
    public void runQueryExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
    }

    @Test
    public void runAggregationQueryTest() throws Exception {
    }

    @Test
    public void runAggregationQueryExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
    }

    @Test
    public void partitionQueryTest() throws Exception {
        Cursor responsesElement = Cursor.newBuilder().build();
        PartitionQueryResponse expectedResponse = PartitionQueryResponse.newBuilder().setNextPageToken("").addAllPartitions(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        PartitionQueryRequest request = PartitionQueryRequest.newBuilder().setParent("projects/project-9316/databases/database-9316/documents").setPartitionCount(-1738969222L).setPageToken("pageToken873572522").setPageSize(883849137).build();
        FirestoreClient.PartitionQueryPagedResponse pagedListResponse = client.partitionQuery(request);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getPartitionsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void partitionQueryExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            PartitionQueryRequest request = PartitionQueryRequest.newBuilder().setParent("projects/project-9316/databases/database-9316/documents").setPartitionCount(-1738969222L).setPageToken("pageToken873572522").setPageSize(883849137).build();
            client.partitionQuery(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void writeUnsupportedMethodTest() throws Exception {
    }

    @Test
    public void listenUnsupportedMethodTest() throws Exception {
    }

    @Test
    public void listCollectionIdsTest() throws Exception {
        String responsesElement = "responsesElement-318365110";
        ListCollectionIdsResponse expectedResponse = ListCollectionIdsResponse.newBuilder().setNextPageToken("").addAllCollectionIds(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-9316/databases/database-9316/documents";
        FirestoreClient.ListCollectionIdsPagedResponse pagedListResponse = client.listCollectionIds(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals((Object)expectedResponse.getCollectionIdsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listCollectionIdsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-9316/databases/database-9316/documents";
            client.listCollectionIds(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void batchWriteTest() throws Exception {
        BatchWriteResponse expectedResponse = BatchWriteResponse.newBuilder().addAllWriteResults(new ArrayList()).addAllStatus(new ArrayList()).build();
        mockService.addResponse((Object)expectedResponse);
        BatchWriteRequest request = BatchWriteRequest.newBuilder().setDatabase("projects/project-4060/databases/database-4060").addAllWrites(new ArrayList()).putAllLabels(new HashMap()).build();
        BatchWriteResponse actualResponse = client.batchWrite(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void batchWriteExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            BatchWriteRequest request = BatchWriteRequest.newBuilder().setDatabase("projects/project-4060/databases/database-4060").addAllWrites(new ArrayList()).putAllLabels(new HashMap()).build();
            client.batchWrite(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createDocumentTest() throws Exception {
        Document expectedResponse = Document.newBuilder().setName("name3373707").putAllFields(new HashMap()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        CreateDocumentRequest request = CreateDocumentRequest.newBuilder().setParent("projects/project-2701/databases/database-2701/documents/document-2701").setCollectionId("collectionId-3631").setDocumentId("documentId-814940266").setDocument(Document.newBuilder().build()).setMask(DocumentMask.newBuilder().build()).build();
        Document actualResponse = client.createDocument(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createDocumentExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            CreateDocumentRequest request = CreateDocumentRequest.newBuilder().setParent("projects/project-2701/databases/database-2701/documents/document-2701").setCollectionId("collectionId-3631").setDocumentId("documentId-814940266").setDocument(Document.newBuilder().build()).setMask(DocumentMask.newBuilder().build()).build();
            client.createDocument(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

