/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore.v1;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.grpc.testing.MockStreamObserver;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ApiStreamObserver;
import com.google.api.gax.rpc.BidiStreamingCallable;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.firestore.v1.FirestoreClient;
import com.google.cloud.firestore.v1.FirestoreSettings;
import com.google.cloud.firestore.v1.MockFirestore;
import com.google.cloud.firestore.v1.MockLocations;
import com.google.common.collect.Lists;
import com.google.firestore.v1.AggregationResult;
import com.google.firestore.v1.BatchGetDocumentsRequest;
import com.google.firestore.v1.BatchGetDocumentsResponse;
import com.google.firestore.v1.BatchWriteRequest;
import com.google.firestore.v1.BatchWriteResponse;
import com.google.firestore.v1.BeginTransactionRequest;
import com.google.firestore.v1.BeginTransactionResponse;
import com.google.firestore.v1.CommitRequest;
import com.google.firestore.v1.CommitResponse;
import com.google.firestore.v1.CreateDocumentRequest;
import com.google.firestore.v1.Cursor;
import com.google.firestore.v1.DeleteDocumentRequest;
import com.google.firestore.v1.Document;
import com.google.firestore.v1.DocumentMask;
import com.google.firestore.v1.ExplainMetrics;
import com.google.firestore.v1.ExplainOptions;
import com.google.firestore.v1.GetDocumentRequest;
import com.google.firestore.v1.ListCollectionIdsRequest;
import com.google.firestore.v1.ListCollectionIdsResponse;
import com.google.firestore.v1.ListDocumentsRequest;
import com.google.firestore.v1.ListDocumentsResponse;
import com.google.firestore.v1.ListenRequest;
import com.google.firestore.v1.ListenResponse;
import com.google.firestore.v1.PartitionQueryRequest;
import com.google.firestore.v1.PartitionQueryResponse;
import com.google.firestore.v1.RollbackRequest;
import com.google.firestore.v1.RunAggregationQueryRequest;
import com.google.firestore.v1.RunAggregationQueryResponse;
import com.google.firestore.v1.RunQueryRequest;
import com.google.firestore.v1.RunQueryResponse;
import com.google.firestore.v1.UpdateDocumentRequest;
import com.google.firestore.v1.WriteRequest;
import com.google.firestore.v1.WriteResponse;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.ByteString;
import com.google.protobuf.Empty;
import com.google.protobuf.Timestamp;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class FirestoreClientTest {
    private static MockFirestore mockFirestore;
    private static MockLocations mockLocations;
    private static MockServiceHelper mockServiceHelper;
    private LocalChannelProvider channelProvider;
    private FirestoreClient client;

    @BeforeClass
    public static void startStaticServer() {
        mockFirestore = new MockFirestore();
        mockLocations = new MockLocations();
        mockServiceHelper = new MockServiceHelper(UUID.randomUUID().toString(), Arrays.asList(mockFirestore, mockLocations));
        mockServiceHelper.start();
    }

    @AfterClass
    public static void stopServer() {
        mockServiceHelper.stop();
    }

    @Before
    public void setUp() throws IOException {
        mockServiceHelper.reset();
        this.channelProvider = mockServiceHelper.createChannelProvider();
        FirestoreSettings settings = ((FirestoreSettings.Builder)((FirestoreSettings.Builder)FirestoreSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)this.channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        this.client = FirestoreClient.create((FirestoreSettings)settings);
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @Test
    public void getDocumentTest() throws Exception {
        Document expectedResponse = Document.newBuilder().setName("name3373707").putAllFields(new HashMap()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).build();
        mockFirestore.addResponse((AbstractMessage)expectedResponse);
        GetDocumentRequest request = GetDocumentRequest.newBuilder().setName("name3373707").setMask(DocumentMask.newBuilder().build()).build();
        Document actualResponse = this.client.getDocument(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockFirestore.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetDocumentRequest actualRequest = (GetDocumentRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getName(), (Object)actualRequest.getName());
        Assert.assertEquals((Object)request.getMask(), (Object)actualRequest.getMask());
        Assert.assertEquals((Object)request.getTransaction(), (Object)actualRequest.getTransaction());
        Assert.assertEquals((Object)request.getReadTime(), (Object)actualRequest.getReadTime());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getDocumentExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockFirestore.addException((Exception)exception);
        try {
            GetDocumentRequest request = GetDocumentRequest.newBuilder().setName("name3373707").setMask(DocumentMask.newBuilder().build()).build();
            this.client.getDocument(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listDocumentsTest() throws Exception {
        Document responsesElement = Document.newBuilder().build();
        ListDocumentsResponse expectedResponse = ListDocumentsResponse.newBuilder().setNextPageToken("").addAllDocuments(Arrays.asList(responsesElement)).build();
        mockFirestore.addResponse((AbstractMessage)expectedResponse);
        ListDocumentsRequest request = ListDocumentsRequest.newBuilder().setParent("parent-995424086").setCollectionId("collectionId1636075609").setPageSize(883849137).setPageToken("pageToken873572522").setOrderBy("orderBy-1207110587").setMask(DocumentMask.newBuilder().build()).setShowMissing(true).build();
        FirestoreClient.ListDocumentsPagedResponse pagedListResponse = this.client.listDocuments(request);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getDocumentsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockFirestore.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListDocumentsRequest actualRequest = (ListDocumentsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getParent(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)request.getCollectionId(), (Object)actualRequest.getCollectionId());
        Assert.assertEquals((long)request.getPageSize(), (long)actualRequest.getPageSize());
        Assert.assertEquals((Object)request.getPageToken(), (Object)actualRequest.getPageToken());
        Assert.assertEquals((Object)request.getOrderBy(), (Object)actualRequest.getOrderBy());
        Assert.assertEquals((Object)request.getMask(), (Object)actualRequest.getMask());
        Assert.assertEquals((Object)request.getTransaction(), (Object)actualRequest.getTransaction());
        Assert.assertEquals((Object)request.getReadTime(), (Object)actualRequest.getReadTime());
        Assert.assertEquals((Object)request.getShowMissing(), (Object)actualRequest.getShowMissing());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listDocumentsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockFirestore.addException((Exception)exception);
        try {
            ListDocumentsRequest request = ListDocumentsRequest.newBuilder().setParent("parent-995424086").setCollectionId("collectionId1636075609").setPageSize(883849137).setPageToken("pageToken873572522").setOrderBy("orderBy-1207110587").setMask(DocumentMask.newBuilder().build()).setShowMissing(true).build();
            this.client.listDocuments(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateDocumentTest() throws Exception {
        Document expectedResponse = Document.newBuilder().setName("name3373707").putAllFields(new HashMap()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).build();
        mockFirestore.addResponse((AbstractMessage)expectedResponse);
        Document document = Document.newBuilder().build();
        DocumentMask updateMask = DocumentMask.newBuilder().build();
        Document actualResponse = this.client.updateDocument(document, updateMask);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockFirestore.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateDocumentRequest actualRequest = (UpdateDocumentRequest)actualRequests.get(0);
        Assert.assertEquals((Object)document, (Object)actualRequest.getDocument());
        Assert.assertEquals((Object)updateMask, (Object)actualRequest.getUpdateMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateDocumentExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockFirestore.addException((Exception)exception);
        try {
            Document document = Document.newBuilder().build();
            DocumentMask updateMask = DocumentMask.newBuilder().build();
            this.client.updateDocument(document, updateMask);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteDocumentTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockFirestore.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        this.client.deleteDocument(name);
        List<AbstractMessage> actualRequests = mockFirestore.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteDocumentRequest actualRequest = (DeleteDocumentRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteDocumentExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockFirestore.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deleteDocument(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void batchGetDocumentsTest() throws Exception {
        BatchGetDocumentsResponse expectedResponse = BatchGetDocumentsResponse.newBuilder().setTransaction(ByteString.EMPTY).setReadTime(Timestamp.newBuilder().build()).build();
        mockFirestore.addResponse((AbstractMessage)expectedResponse);
        BatchGetDocumentsRequest request = BatchGetDocumentsRequest.newBuilder().setDatabase("database1789464955").addAllDocuments(new ArrayList()).setMask(DocumentMask.newBuilder().build()).build();
        MockStreamObserver responseObserver = new MockStreamObserver();
        ServerStreamingCallable callable = this.client.batchGetDocumentsCallable();
        callable.serverStreamingCall((Object)request, (ApiStreamObserver)responseObserver);
        List actualResponses = (List)responseObserver.future().get();
        Assert.assertEquals((long)1L, (long)actualResponses.size());
        Assert.assertEquals((Object)expectedResponse, actualResponses.get(0));
    }

    @Test
    public void batchGetDocumentsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockFirestore.addException((Exception)exception);
        BatchGetDocumentsRequest request = BatchGetDocumentsRequest.newBuilder().setDatabase("database1789464955").addAllDocuments(new ArrayList()).setMask(DocumentMask.newBuilder().build()).build();
        MockStreamObserver responseObserver = new MockStreamObserver();
        ServerStreamingCallable callable = this.client.batchGetDocumentsCallable();
        callable.serverStreamingCall((Object)request, (ApiStreamObserver)responseObserver);
        try {
            List actualResponses = (List)responseObserver.future().get();
            Assert.fail((String)"No exception thrown");
        }
        catch (ExecutionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof InvalidArgumentException));
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void beginTransactionTest() throws Exception {
        BeginTransactionResponse expectedResponse = BeginTransactionResponse.newBuilder().setTransaction(ByteString.EMPTY).build();
        mockFirestore.addResponse((AbstractMessage)expectedResponse);
        String database = "database1789464955";
        BeginTransactionResponse actualResponse = this.client.beginTransaction(database);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockFirestore.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        BeginTransactionRequest actualRequest = (BeginTransactionRequest)actualRequests.get(0);
        Assert.assertEquals((Object)database, (Object)actualRequest.getDatabase());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void beginTransactionExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockFirestore.addException((Exception)exception);
        try {
            String database = "database1789464955";
            this.client.beginTransaction(database);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void commitTest() throws Exception {
        CommitResponse expectedResponse = CommitResponse.newBuilder().addAllWriteResults(new ArrayList()).setCommitTime(Timestamp.newBuilder().build()).build();
        mockFirestore.addResponse((AbstractMessage)expectedResponse);
        String database = "database1789464955";
        ArrayList writes = new ArrayList();
        CommitResponse actualResponse = this.client.commit(database, writes);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockFirestore.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CommitRequest actualRequest = (CommitRequest)actualRequests.get(0);
        Assert.assertEquals((Object)database, (Object)actualRequest.getDatabase());
        Assert.assertEquals(writes, (Object)actualRequest.getWritesList());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void commitExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockFirestore.addException((Exception)exception);
        try {
            String database = "database1789464955";
            ArrayList writes = new ArrayList();
            this.client.commit(database, writes);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void rollbackTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockFirestore.addResponse((AbstractMessage)expectedResponse);
        String database = "database1789464955";
        ByteString transaction = ByteString.EMPTY;
        this.client.rollback(database, transaction);
        List<AbstractMessage> actualRequests = mockFirestore.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        RollbackRequest actualRequest = (RollbackRequest)actualRequests.get(0);
        Assert.assertEquals((Object)database, (Object)actualRequest.getDatabase());
        Assert.assertEquals((Object)transaction, (Object)actualRequest.getTransaction());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void rollbackExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockFirestore.addException((Exception)exception);
        try {
            String database = "database1789464955";
            ByteString transaction = ByteString.EMPTY;
            this.client.rollback(database, transaction);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void runQueryTest() throws Exception {
        RunQueryResponse expectedResponse = RunQueryResponse.newBuilder().setTransaction(ByteString.EMPTY).setDocument(Document.newBuilder().build()).setReadTime(Timestamp.newBuilder().build()).setSkippedResults(880286183).setExplainMetrics(ExplainMetrics.newBuilder().build()).build();
        mockFirestore.addResponse((AbstractMessage)expectedResponse);
        RunQueryRequest request = RunQueryRequest.newBuilder().setParent("parent-995424086").setExplainOptions(ExplainOptions.newBuilder().build()).build();
        MockStreamObserver responseObserver = new MockStreamObserver();
        ServerStreamingCallable callable = this.client.runQueryCallable();
        callable.serverStreamingCall((Object)request, (ApiStreamObserver)responseObserver);
        List actualResponses = (List)responseObserver.future().get();
        Assert.assertEquals((long)1L, (long)actualResponses.size());
        Assert.assertEquals((Object)expectedResponse, actualResponses.get(0));
    }

    @Test
    public void runQueryExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockFirestore.addException((Exception)exception);
        RunQueryRequest request = RunQueryRequest.newBuilder().setParent("parent-995424086").setExplainOptions(ExplainOptions.newBuilder().build()).build();
        MockStreamObserver responseObserver = new MockStreamObserver();
        ServerStreamingCallable callable = this.client.runQueryCallable();
        callable.serverStreamingCall((Object)request, (ApiStreamObserver)responseObserver);
        try {
            List actualResponses = (List)responseObserver.future().get();
            Assert.fail((String)"No exception thrown");
        }
        catch (ExecutionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof InvalidArgumentException));
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void runAggregationQueryTest() throws Exception {
        RunAggregationQueryResponse expectedResponse = RunAggregationQueryResponse.newBuilder().setResult(AggregationResult.newBuilder().build()).setTransaction(ByteString.EMPTY).setReadTime(Timestamp.newBuilder().build()).setExplainMetrics(ExplainMetrics.newBuilder().build()).build();
        mockFirestore.addResponse((AbstractMessage)expectedResponse);
        RunAggregationQueryRequest request = RunAggregationQueryRequest.newBuilder().setParent("parent-995424086").setExplainOptions(ExplainOptions.newBuilder().build()).build();
        MockStreamObserver responseObserver = new MockStreamObserver();
        ServerStreamingCallable callable = this.client.runAggregationQueryCallable();
        callable.serverStreamingCall((Object)request, (ApiStreamObserver)responseObserver);
        List actualResponses = (List)responseObserver.future().get();
        Assert.assertEquals((long)1L, (long)actualResponses.size());
        Assert.assertEquals((Object)expectedResponse, actualResponses.get(0));
    }

    @Test
    public void runAggregationQueryExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockFirestore.addException((Exception)exception);
        RunAggregationQueryRequest request = RunAggregationQueryRequest.newBuilder().setParent("parent-995424086").setExplainOptions(ExplainOptions.newBuilder().build()).build();
        MockStreamObserver responseObserver = new MockStreamObserver();
        ServerStreamingCallable callable = this.client.runAggregationQueryCallable();
        callable.serverStreamingCall((Object)request, (ApiStreamObserver)responseObserver);
        try {
            List actualResponses = (List)responseObserver.future().get();
            Assert.fail((String)"No exception thrown");
        }
        catch (ExecutionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof InvalidArgumentException));
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void partitionQueryTest() throws Exception {
        Cursor responsesElement = Cursor.newBuilder().build();
        PartitionQueryResponse expectedResponse = PartitionQueryResponse.newBuilder().setNextPageToken("").addAllPartitions(Arrays.asList(responsesElement)).build();
        mockFirestore.addResponse((AbstractMessage)expectedResponse);
        PartitionQueryRequest request = PartitionQueryRequest.newBuilder().setParent("parent-995424086").setPartitionCount(-1738969222L).setPageToken("pageToken873572522").setPageSize(883849137).build();
        FirestoreClient.PartitionQueryPagedResponse pagedListResponse = this.client.partitionQuery(request);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getPartitionsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockFirestore.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        PartitionQueryRequest actualRequest = (PartitionQueryRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getParent(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)request.getStructuredQuery(), (Object)actualRequest.getStructuredQuery());
        Assert.assertEquals((long)request.getPartitionCount(), (long)actualRequest.getPartitionCount());
        Assert.assertEquals((Object)request.getPageToken(), (Object)actualRequest.getPageToken());
        Assert.assertEquals((long)request.getPageSize(), (long)actualRequest.getPageSize());
        Assert.assertEquals((Object)request.getReadTime(), (Object)actualRequest.getReadTime());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void partitionQueryExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockFirestore.addException((Exception)exception);
        try {
            PartitionQueryRequest request = PartitionQueryRequest.newBuilder().setParent("parent-995424086").setPartitionCount(-1738969222L).setPageToken("pageToken873572522").setPageSize(883849137).build();
            this.client.partitionQuery(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void writeTest() throws Exception {
        WriteResponse expectedResponse = WriteResponse.newBuilder().setStreamId("streamId1790933179").setStreamToken(ByteString.EMPTY).addAllWriteResults(new ArrayList()).setCommitTime(Timestamp.newBuilder().build()).build();
        mockFirestore.addResponse((AbstractMessage)expectedResponse);
        WriteRequest request = WriteRequest.newBuilder().setDatabase("database1789464955").setStreamId("streamId1790933179").addAllWrites(new ArrayList()).setStreamToken(ByteString.EMPTY).putAllLabels(new HashMap()).build();
        MockStreamObserver responseObserver = new MockStreamObserver();
        BidiStreamingCallable callable = this.client.writeCallable();
        ApiStreamObserver requestObserver = callable.bidiStreamingCall((ApiStreamObserver)responseObserver);
        requestObserver.onNext((Object)request);
        requestObserver.onCompleted();
        List actualResponses = (List)responseObserver.future().get();
        Assert.assertEquals((long)1L, (long)actualResponses.size());
        Assert.assertEquals((Object)expectedResponse, actualResponses.get(0));
    }

    @Test
    public void writeExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockFirestore.addException((Exception)exception);
        WriteRequest request = WriteRequest.newBuilder().setDatabase("database1789464955").setStreamId("streamId1790933179").addAllWrites(new ArrayList()).setStreamToken(ByteString.EMPTY).putAllLabels(new HashMap()).build();
        MockStreamObserver responseObserver = new MockStreamObserver();
        BidiStreamingCallable callable = this.client.writeCallable();
        ApiStreamObserver requestObserver = callable.bidiStreamingCall((ApiStreamObserver)responseObserver);
        requestObserver.onNext((Object)request);
        try {
            List actualResponses = (List)responseObserver.future().get();
            Assert.fail((String)"No exception thrown");
        }
        catch (ExecutionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof InvalidArgumentException));
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void listenTest() throws Exception {
        ListenResponse expectedResponse = ListenResponse.newBuilder().build();
        mockFirestore.addResponse((AbstractMessage)expectedResponse);
        ListenRequest request = ListenRequest.newBuilder().setDatabase("database1789464955").putAllLabels(new HashMap()).build();
        MockStreamObserver responseObserver = new MockStreamObserver();
        BidiStreamingCallable callable = this.client.listenCallable();
        ApiStreamObserver requestObserver = callable.bidiStreamingCall((ApiStreamObserver)responseObserver);
        requestObserver.onNext((Object)request);
        requestObserver.onCompleted();
        List actualResponses = (List)responseObserver.future().get();
        Assert.assertEquals((long)1L, (long)actualResponses.size());
        Assert.assertEquals((Object)expectedResponse, actualResponses.get(0));
    }

    @Test
    public void listenExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockFirestore.addException((Exception)exception);
        ListenRequest request = ListenRequest.newBuilder().setDatabase("database1789464955").putAllLabels(new HashMap()).build();
        MockStreamObserver responseObserver = new MockStreamObserver();
        BidiStreamingCallable callable = this.client.listenCallable();
        ApiStreamObserver requestObserver = callable.bidiStreamingCall((ApiStreamObserver)responseObserver);
        requestObserver.onNext((Object)request);
        try {
            List actualResponses = (List)responseObserver.future().get();
            Assert.fail((String)"No exception thrown");
        }
        catch (ExecutionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof InvalidArgumentException));
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void listCollectionIdsTest() throws Exception {
        String responsesElement = "responsesElement-318365110";
        ListCollectionIdsResponse expectedResponse = ListCollectionIdsResponse.newBuilder().setNextPageToken("").addAllCollectionIds(Arrays.asList(responsesElement)).build();
        mockFirestore.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        FirestoreClient.ListCollectionIdsPagedResponse pagedListResponse = this.client.listCollectionIds(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals((Object)expectedResponse.getCollectionIdsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockFirestore.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListCollectionIdsRequest actualRequest = (ListCollectionIdsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listCollectionIdsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockFirestore.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listCollectionIds(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void batchWriteTest() throws Exception {
        BatchWriteResponse expectedResponse = BatchWriteResponse.newBuilder().addAllWriteResults(new ArrayList()).addAllStatus(new ArrayList()).build();
        mockFirestore.addResponse((AbstractMessage)expectedResponse);
        BatchWriteRequest request = BatchWriteRequest.newBuilder().setDatabase("database1789464955").addAllWrites(new ArrayList()).putAllLabels(new HashMap()).build();
        BatchWriteResponse actualResponse = this.client.batchWrite(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockFirestore.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        BatchWriteRequest actualRequest = (BatchWriteRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getDatabase(), (Object)actualRequest.getDatabase());
        Assert.assertEquals((Object)request.getWritesList(), (Object)actualRequest.getWritesList());
        Assert.assertEquals((Object)request.getLabelsMap(), (Object)actualRequest.getLabelsMap());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void batchWriteExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockFirestore.addException((Exception)exception);
        try {
            BatchWriteRequest request = BatchWriteRequest.newBuilder().setDatabase("database1789464955").addAllWrites(new ArrayList()).putAllLabels(new HashMap()).build();
            this.client.batchWrite(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createDocumentTest() throws Exception {
        Document expectedResponse = Document.newBuilder().setName("name3373707").putAllFields(new HashMap()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).build();
        mockFirestore.addResponse((AbstractMessage)expectedResponse);
        CreateDocumentRequest request = CreateDocumentRequest.newBuilder().setParent("parent-995424086").setCollectionId("collectionId1636075609").setDocumentId("documentId-814940266").setDocument(Document.newBuilder().build()).setMask(DocumentMask.newBuilder().build()).build();
        Document actualResponse = this.client.createDocument(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockFirestore.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateDocumentRequest actualRequest = (CreateDocumentRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getParent(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)request.getCollectionId(), (Object)actualRequest.getCollectionId());
        Assert.assertEquals((Object)request.getDocumentId(), (Object)actualRequest.getDocumentId());
        Assert.assertEquals((Object)request.getDocument(), (Object)actualRequest.getDocument());
        Assert.assertEquals((Object)request.getMask(), (Object)actualRequest.getMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createDocumentExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockFirestore.addException((Exception)exception);
        try {
            CreateDocumentRequest request = CreateDocumentRequest.newBuilder().setParent("parent-995424086").setCollectionId("collectionId1636075609").setDocumentId("documentId-814940266").setDocument(Document.newBuilder().build()).setMask(DocumentMask.newBuilder().build()).build();
            this.client.createDocument(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

