/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.gaming.v1beta;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.gaming.v1beta.CreateGameServerConfigRequest;
import com.google.cloud.gaming.v1beta.DeleteGameServerConfigRequest;
import com.google.cloud.gaming.v1beta.GameServerConfig;
import com.google.cloud.gaming.v1beta.GameServerConfigName;
import com.google.cloud.gaming.v1beta.GameServerConfigsServiceSettings;
import com.google.cloud.gaming.v1beta.GameServerDeploymentName;
import com.google.cloud.gaming.v1beta.GetGameServerConfigRequest;
import com.google.cloud.gaming.v1beta.ListGameServerConfigsRequest;
import com.google.cloud.gaming.v1beta.ListGameServerConfigsResponse;
import com.google.cloud.gaming.v1beta.OperationMetadata;
import com.google.cloud.gaming.v1beta.stub.GameServerConfigsServiceStub;
import com.google.cloud.gaming.v1beta.stub.GameServerConfigsServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GameServerConfigsServiceClient
implements BackgroundResource {
    private final GameServerConfigsServiceSettings settings;
    private final GameServerConfigsServiceStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final GameServerConfigsServiceClient create() throws IOException {
        return GameServerConfigsServiceClient.create(GameServerConfigsServiceSettings.newBuilder().build());
    }

    public static final GameServerConfigsServiceClient create(GameServerConfigsServiceSettings settings) throws IOException {
        return new GameServerConfigsServiceClient(settings);
    }

    public static final GameServerConfigsServiceClient create(GameServerConfigsServiceStub stub) {
        return new GameServerConfigsServiceClient(stub);
    }

    protected GameServerConfigsServiceClient(GameServerConfigsServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((GameServerConfigsServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected GameServerConfigsServiceClient(GameServerConfigsServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final GameServerConfigsServiceSettings getSettings() {
        return this.settings;
    }

    public GameServerConfigsServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final ListGameServerConfigsPagedResponse listGameServerConfigs(GameServerDeploymentName parent) {
        ListGameServerConfigsRequest request = ListGameServerConfigsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listGameServerConfigs(request);
    }

    public final ListGameServerConfigsPagedResponse listGameServerConfigs(String parent) {
        ListGameServerConfigsRequest request = ListGameServerConfigsRequest.newBuilder().setParent(parent).build();
        return this.listGameServerConfigs(request);
    }

    public final ListGameServerConfigsPagedResponse listGameServerConfigs(ListGameServerConfigsRequest request) {
        return (ListGameServerConfigsPagedResponse)((Object)this.listGameServerConfigsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListGameServerConfigsRequest, ListGameServerConfigsPagedResponse> listGameServerConfigsPagedCallable() {
        return this.stub.listGameServerConfigsPagedCallable();
    }

    public final UnaryCallable<ListGameServerConfigsRequest, ListGameServerConfigsResponse> listGameServerConfigsCallable() {
        return this.stub.listGameServerConfigsCallable();
    }

    public final GameServerConfig getGameServerConfig(GameServerConfigName name) {
        GetGameServerConfigRequest request = GetGameServerConfigRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getGameServerConfig(request);
    }

    public final GameServerConfig getGameServerConfig(String name) {
        GetGameServerConfigRequest request = GetGameServerConfigRequest.newBuilder().setName(name).build();
        return this.getGameServerConfig(request);
    }

    public final GameServerConfig getGameServerConfig(GetGameServerConfigRequest request) {
        return (GameServerConfig)this.getGameServerConfigCallable().call((Object)request);
    }

    public final UnaryCallable<GetGameServerConfigRequest, GameServerConfig> getGameServerConfigCallable() {
        return this.stub.getGameServerConfigCallable();
    }

    public final OperationFuture<GameServerConfig, OperationMetadata> createGameServerConfigAsync(GameServerDeploymentName parent, GameServerConfig gameServerConfig) {
        CreateGameServerConfigRequest request = CreateGameServerConfigRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setGameServerConfig(gameServerConfig).build();
        return this.createGameServerConfigAsync(request);
    }

    public final OperationFuture<GameServerConfig, OperationMetadata> createGameServerConfigAsync(String parent, GameServerConfig gameServerConfig) {
        CreateGameServerConfigRequest request = CreateGameServerConfigRequest.newBuilder().setParent(parent).setGameServerConfig(gameServerConfig).build();
        return this.createGameServerConfigAsync(request);
    }

    public final OperationFuture<GameServerConfig, OperationMetadata> createGameServerConfigAsync(CreateGameServerConfigRequest request) {
        return this.createGameServerConfigOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateGameServerConfigRequest, GameServerConfig, OperationMetadata> createGameServerConfigOperationCallable() {
        return this.stub.createGameServerConfigOperationCallable();
    }

    public final UnaryCallable<CreateGameServerConfigRequest, Operation> createGameServerConfigCallable() {
        return this.stub.createGameServerConfigCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteGameServerConfigAsync(GameServerConfigName name) {
        DeleteGameServerConfigRequest request = DeleteGameServerConfigRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteGameServerConfigAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteGameServerConfigAsync(String name) {
        DeleteGameServerConfigRequest request = DeleteGameServerConfigRequest.newBuilder().setName(name).build();
        return this.deleteGameServerConfigAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteGameServerConfigAsync(DeleteGameServerConfigRequest request) {
        return this.deleteGameServerConfigOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteGameServerConfigRequest, Empty, OperationMetadata> deleteGameServerConfigOperationCallable() {
        return this.stub.deleteGameServerConfigOperationCallable();
    }

    public final UnaryCallable<DeleteGameServerConfigRequest, Operation> deleteGameServerConfigCallable() {
        return this.stub.deleteGameServerConfigCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListGameServerConfigsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListGameServerConfigsRequest, ListGameServerConfigsResponse, GameServerConfig, ListGameServerConfigsPage, ListGameServerConfigsFixedSizeCollection> {
        private ListGameServerConfigsFixedSizeCollection(List<ListGameServerConfigsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListGameServerConfigsFixedSizeCollection createEmptyCollection() {
            return new ListGameServerConfigsFixedSizeCollection(null, 0);
        }

        protected ListGameServerConfigsFixedSizeCollection createCollection(List<ListGameServerConfigsPage> pages, int collectionSize) {
            return new ListGameServerConfigsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListGameServerConfigsPage
    extends AbstractPage<ListGameServerConfigsRequest, ListGameServerConfigsResponse, GameServerConfig, ListGameServerConfigsPage> {
        private ListGameServerConfigsPage(PageContext<ListGameServerConfigsRequest, ListGameServerConfigsResponse, GameServerConfig> context, ListGameServerConfigsResponse response) {
            super(context, (Object)response);
        }

        private static ListGameServerConfigsPage createEmptyPage() {
            return new ListGameServerConfigsPage(null, null);
        }

        protected ListGameServerConfigsPage createPage(PageContext<ListGameServerConfigsRequest, ListGameServerConfigsResponse, GameServerConfig> context, ListGameServerConfigsResponse response) {
            return new ListGameServerConfigsPage(context, response);
        }

        public ApiFuture<ListGameServerConfigsPage> createPageAsync(PageContext<ListGameServerConfigsRequest, ListGameServerConfigsResponse, GameServerConfig> context, ApiFuture<ListGameServerConfigsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListGameServerConfigsPagedResponse
    extends AbstractPagedListResponse<ListGameServerConfigsRequest, ListGameServerConfigsResponse, GameServerConfig, ListGameServerConfigsPage, ListGameServerConfigsFixedSizeCollection> {
        public static ApiFuture<ListGameServerConfigsPagedResponse> createAsync(PageContext<ListGameServerConfigsRequest, ListGameServerConfigsResponse, GameServerConfig> context, ApiFuture<ListGameServerConfigsResponse> futureResponse) {
            ApiFuture<ListGameServerConfigsPage> futurePage = ListGameServerConfigsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListGameServerConfigsPagedResponse((ListGameServerConfigsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListGameServerConfigsPagedResponse(ListGameServerConfigsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListGameServerConfigsFixedSizeCollection.createEmptyCollection());
        }
    }
}

