/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.gaming.v1beta;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.gaming.v1beta.CreateGameServerClusterRequest;
import com.google.cloud.gaming.v1beta.DeleteGameServerClusterRequest;
import com.google.cloud.gaming.v1beta.GameServerCluster;
import com.google.cloud.gaming.v1beta.GameServerClusterName;
import com.google.cloud.gaming.v1beta.GameServerClustersServiceSettings;
import com.google.cloud.gaming.v1beta.GetGameServerClusterRequest;
import com.google.cloud.gaming.v1beta.ListGameServerClustersRequest;
import com.google.cloud.gaming.v1beta.ListGameServerClustersResponse;
import com.google.cloud.gaming.v1beta.OperationMetadata;
import com.google.cloud.gaming.v1beta.PreviewCreateGameServerClusterRequest;
import com.google.cloud.gaming.v1beta.PreviewCreateGameServerClusterResponse;
import com.google.cloud.gaming.v1beta.PreviewDeleteGameServerClusterRequest;
import com.google.cloud.gaming.v1beta.PreviewDeleteGameServerClusterResponse;
import com.google.cloud.gaming.v1beta.PreviewUpdateGameServerClusterRequest;
import com.google.cloud.gaming.v1beta.PreviewUpdateGameServerClusterResponse;
import com.google.cloud.gaming.v1beta.RealmName;
import com.google.cloud.gaming.v1beta.UpdateGameServerClusterRequest;
import com.google.cloud.gaming.v1beta.stub.GameServerClustersServiceStub;
import com.google.cloud.gaming.v1beta.stub.GameServerClustersServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GameServerClustersServiceClient
implements BackgroundResource {
    private final GameServerClustersServiceSettings settings;
    private final GameServerClustersServiceStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final GameServerClustersServiceClient create() throws IOException {
        return GameServerClustersServiceClient.create(GameServerClustersServiceSettings.newBuilder().build());
    }

    public static final GameServerClustersServiceClient create(GameServerClustersServiceSettings settings) throws IOException {
        return new GameServerClustersServiceClient(settings);
    }

    public static final GameServerClustersServiceClient create(GameServerClustersServiceStub stub) {
        return new GameServerClustersServiceClient(stub);
    }

    protected GameServerClustersServiceClient(GameServerClustersServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((GameServerClustersServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected GameServerClustersServiceClient(GameServerClustersServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final GameServerClustersServiceSettings getSettings() {
        return this.settings;
    }

    public GameServerClustersServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final ListGameServerClustersPagedResponse listGameServerClusters(RealmName parent) {
        ListGameServerClustersRequest request = ListGameServerClustersRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listGameServerClusters(request);
    }

    public final ListGameServerClustersPagedResponse listGameServerClusters(String parent) {
        ListGameServerClustersRequest request = ListGameServerClustersRequest.newBuilder().setParent(parent).build();
        return this.listGameServerClusters(request);
    }

    public final ListGameServerClustersPagedResponse listGameServerClusters(ListGameServerClustersRequest request) {
        return (ListGameServerClustersPagedResponse)((Object)this.listGameServerClustersPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListGameServerClustersRequest, ListGameServerClustersPagedResponse> listGameServerClustersPagedCallable() {
        return this.stub.listGameServerClustersPagedCallable();
    }

    public final UnaryCallable<ListGameServerClustersRequest, ListGameServerClustersResponse> listGameServerClustersCallable() {
        return this.stub.listGameServerClustersCallable();
    }

    public final GameServerCluster getGameServerCluster(GameServerClusterName name) {
        GetGameServerClusterRequest request = GetGameServerClusterRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getGameServerCluster(request);
    }

    public final GameServerCluster getGameServerCluster(String name) {
        GetGameServerClusterRequest request = GetGameServerClusterRequest.newBuilder().setName(name).build();
        return this.getGameServerCluster(request);
    }

    public final GameServerCluster getGameServerCluster(GetGameServerClusterRequest request) {
        return (GameServerCluster)this.getGameServerClusterCallable().call((Object)request);
    }

    public final UnaryCallable<GetGameServerClusterRequest, GameServerCluster> getGameServerClusterCallable() {
        return this.stub.getGameServerClusterCallable();
    }

    public final OperationFuture<GameServerCluster, OperationMetadata> createGameServerClusterAsync(RealmName parent, GameServerCluster gameServerCluster, String gameServerClusterId) {
        CreateGameServerClusterRequest request = CreateGameServerClusterRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setGameServerCluster(gameServerCluster).setGameServerClusterId(gameServerClusterId).build();
        return this.createGameServerClusterAsync(request);
    }

    public final OperationFuture<GameServerCluster, OperationMetadata> createGameServerClusterAsync(String parent, GameServerCluster gameServerCluster, String gameServerClusterId) {
        CreateGameServerClusterRequest request = CreateGameServerClusterRequest.newBuilder().setParent(parent).setGameServerCluster(gameServerCluster).setGameServerClusterId(gameServerClusterId).build();
        return this.createGameServerClusterAsync(request);
    }

    public final OperationFuture<GameServerCluster, OperationMetadata> createGameServerClusterAsync(CreateGameServerClusterRequest request) {
        return this.createGameServerClusterOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateGameServerClusterRequest, GameServerCluster, OperationMetadata> createGameServerClusterOperationCallable() {
        return this.stub.createGameServerClusterOperationCallable();
    }

    public final UnaryCallable<CreateGameServerClusterRequest, Operation> createGameServerClusterCallable() {
        return this.stub.createGameServerClusterCallable();
    }

    public final PreviewCreateGameServerClusterResponse previewCreateGameServerCluster(PreviewCreateGameServerClusterRequest request) {
        return (PreviewCreateGameServerClusterResponse)this.previewCreateGameServerClusterCallable().call((Object)request);
    }

    public final UnaryCallable<PreviewCreateGameServerClusterRequest, PreviewCreateGameServerClusterResponse> previewCreateGameServerClusterCallable() {
        return this.stub.previewCreateGameServerClusterCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteGameServerClusterAsync(GameServerClusterName name) {
        DeleteGameServerClusterRequest request = DeleteGameServerClusterRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteGameServerClusterAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteGameServerClusterAsync(String name) {
        DeleteGameServerClusterRequest request = DeleteGameServerClusterRequest.newBuilder().setName(name).build();
        return this.deleteGameServerClusterAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteGameServerClusterAsync(DeleteGameServerClusterRequest request) {
        return this.deleteGameServerClusterOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteGameServerClusterRequest, Empty, OperationMetadata> deleteGameServerClusterOperationCallable() {
        return this.stub.deleteGameServerClusterOperationCallable();
    }

    public final UnaryCallable<DeleteGameServerClusterRequest, Operation> deleteGameServerClusterCallable() {
        return this.stub.deleteGameServerClusterCallable();
    }

    public final PreviewDeleteGameServerClusterResponse previewDeleteGameServerCluster(PreviewDeleteGameServerClusterRequest request) {
        return (PreviewDeleteGameServerClusterResponse)this.previewDeleteGameServerClusterCallable().call((Object)request);
    }

    public final UnaryCallable<PreviewDeleteGameServerClusterRequest, PreviewDeleteGameServerClusterResponse> previewDeleteGameServerClusterCallable() {
        return this.stub.previewDeleteGameServerClusterCallable();
    }

    public final OperationFuture<GameServerCluster, OperationMetadata> updateGameServerClusterAsync(GameServerCluster gameServerCluster, FieldMask updateMask) {
        UpdateGameServerClusterRequest request = UpdateGameServerClusterRequest.newBuilder().setGameServerCluster(gameServerCluster).setUpdateMask(updateMask).build();
        return this.updateGameServerClusterAsync(request);
    }

    public final OperationFuture<GameServerCluster, OperationMetadata> updateGameServerClusterAsync(UpdateGameServerClusterRequest request) {
        return this.updateGameServerClusterOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateGameServerClusterRequest, GameServerCluster, OperationMetadata> updateGameServerClusterOperationCallable() {
        return this.stub.updateGameServerClusterOperationCallable();
    }

    public final UnaryCallable<UpdateGameServerClusterRequest, Operation> updateGameServerClusterCallable() {
        return this.stub.updateGameServerClusterCallable();
    }

    public final PreviewUpdateGameServerClusterResponse previewUpdateGameServerCluster(PreviewUpdateGameServerClusterRequest request) {
        return (PreviewUpdateGameServerClusterResponse)this.previewUpdateGameServerClusterCallable().call((Object)request);
    }

    public final UnaryCallable<PreviewUpdateGameServerClusterRequest, PreviewUpdateGameServerClusterResponse> previewUpdateGameServerClusterCallable() {
        return this.stub.previewUpdateGameServerClusterCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListGameServerClustersFixedSizeCollection
    extends AbstractFixedSizeCollection<ListGameServerClustersRequest, ListGameServerClustersResponse, GameServerCluster, ListGameServerClustersPage, ListGameServerClustersFixedSizeCollection> {
        private ListGameServerClustersFixedSizeCollection(List<ListGameServerClustersPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListGameServerClustersFixedSizeCollection createEmptyCollection() {
            return new ListGameServerClustersFixedSizeCollection(null, 0);
        }

        protected ListGameServerClustersFixedSizeCollection createCollection(List<ListGameServerClustersPage> pages, int collectionSize) {
            return new ListGameServerClustersFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListGameServerClustersPage
    extends AbstractPage<ListGameServerClustersRequest, ListGameServerClustersResponse, GameServerCluster, ListGameServerClustersPage> {
        private ListGameServerClustersPage(PageContext<ListGameServerClustersRequest, ListGameServerClustersResponse, GameServerCluster> context, ListGameServerClustersResponse response) {
            super(context, (Object)response);
        }

        private static ListGameServerClustersPage createEmptyPage() {
            return new ListGameServerClustersPage(null, null);
        }

        protected ListGameServerClustersPage createPage(PageContext<ListGameServerClustersRequest, ListGameServerClustersResponse, GameServerCluster> context, ListGameServerClustersResponse response) {
            return new ListGameServerClustersPage(context, response);
        }

        public ApiFuture<ListGameServerClustersPage> createPageAsync(PageContext<ListGameServerClustersRequest, ListGameServerClustersResponse, GameServerCluster> context, ApiFuture<ListGameServerClustersResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListGameServerClustersPagedResponse
    extends AbstractPagedListResponse<ListGameServerClustersRequest, ListGameServerClustersResponse, GameServerCluster, ListGameServerClustersPage, ListGameServerClustersFixedSizeCollection> {
        public static ApiFuture<ListGameServerClustersPagedResponse> createAsync(PageContext<ListGameServerClustersRequest, ListGameServerClustersResponse, GameServerCluster> context, ApiFuture<ListGameServerClustersResponse> futureResponse) {
            ApiFuture<ListGameServerClustersPage> futurePage = ListGameServerClustersPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListGameServerClustersPagedResponse((ListGameServerClustersPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListGameServerClustersPagedResponse(ListGameServerClustersPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListGameServerClustersFixedSizeCollection.createEmptyCollection());
        }
    }
}

