/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.gaming.v1beta.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.gaming.v1beta.CreateGameServerConfigRequest;
import com.google.cloud.gaming.v1beta.DeleteGameServerConfigRequest;
import com.google.cloud.gaming.v1beta.GameServerConfig;
import com.google.cloud.gaming.v1beta.GameServerConfigsServiceClient;
import com.google.cloud.gaming.v1beta.GetGameServerConfigRequest;
import com.google.cloud.gaming.v1beta.ListGameServerConfigsRequest;
import com.google.cloud.gaming.v1beta.ListGameServerConfigsResponse;
import com.google.cloud.gaming.v1beta.OperationMetadata;
import com.google.cloud.gaming.v1beta.stub.GameServerConfigsServiceStub;
import com.google.cloud.gaming.v1beta.stub.GameServerConfigsServiceStubSettings;
import com.google.cloud.gaming.v1beta.stub.GrpcGameServerConfigsServiceCallableFactory;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GrpcGameServerConfigsServiceStub
extends GameServerConfigsServiceStub {
    private static final MethodDescriptor<ListGameServerConfigsRequest, ListGameServerConfigsResponse> listGameServerConfigsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.gaming.v1beta.GameServerConfigsService/ListGameServerConfigs").setRequestMarshaller(ProtoUtils.marshaller((Message)ListGameServerConfigsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListGameServerConfigsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetGameServerConfigRequest, GameServerConfig> getGameServerConfigMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.gaming.v1beta.GameServerConfigsService/GetGameServerConfig").setRequestMarshaller(ProtoUtils.marshaller((Message)GetGameServerConfigRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)GameServerConfig.getDefaultInstance())).build();
    private static final MethodDescriptor<CreateGameServerConfigRequest, Operation> createGameServerConfigMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.gaming.v1beta.GameServerConfigsService/CreateGameServerConfig").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateGameServerConfigRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteGameServerConfigRequest, Operation> deleteGameServerConfigMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.gaming.v1beta.GameServerConfigsService/DeleteGameServerConfig").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteGameServerConfigRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private final UnaryCallable<ListGameServerConfigsRequest, ListGameServerConfigsResponse> listGameServerConfigsCallable;
    private final UnaryCallable<ListGameServerConfigsRequest, GameServerConfigsServiceClient.ListGameServerConfigsPagedResponse> listGameServerConfigsPagedCallable;
    private final UnaryCallable<GetGameServerConfigRequest, GameServerConfig> getGameServerConfigCallable;
    private final UnaryCallable<CreateGameServerConfigRequest, Operation> createGameServerConfigCallable;
    private final OperationCallable<CreateGameServerConfigRequest, GameServerConfig, OperationMetadata> createGameServerConfigOperationCallable;
    private final UnaryCallable<DeleteGameServerConfigRequest, Operation> deleteGameServerConfigCallable;
    private final OperationCallable<DeleteGameServerConfigRequest, Empty, OperationMetadata> deleteGameServerConfigOperationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcGameServerConfigsServiceStub create(GameServerConfigsServiceStubSettings settings) throws IOException {
        return new GrpcGameServerConfigsServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcGameServerConfigsServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcGameServerConfigsServiceStub(GameServerConfigsServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcGameServerConfigsServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcGameServerConfigsServiceStub(GameServerConfigsServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcGameServerConfigsServiceStub(GameServerConfigsServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcGameServerConfigsServiceCallableFactory());
    }

    protected GrpcGameServerConfigsServiceStub(GameServerConfigsServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings listGameServerConfigsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listGameServerConfigsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getGameServerConfigTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getGameServerConfigMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings createGameServerConfigTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createGameServerConfigMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteGameServerConfigTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteGameServerConfigMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.listGameServerConfigsCallable = callableFactory.createUnaryCallable(listGameServerConfigsTransportSettings, settings.listGameServerConfigsSettings(), clientContext);
        this.listGameServerConfigsPagedCallable = callableFactory.createPagedCallable(listGameServerConfigsTransportSettings, settings.listGameServerConfigsSettings(), clientContext);
        this.getGameServerConfigCallable = callableFactory.createUnaryCallable(getGameServerConfigTransportSettings, settings.getGameServerConfigSettings(), clientContext);
        this.createGameServerConfigCallable = callableFactory.createUnaryCallable(createGameServerConfigTransportSettings, settings.createGameServerConfigSettings(), clientContext);
        this.createGameServerConfigOperationCallable = callableFactory.createOperationCallable(createGameServerConfigTransportSettings, settings.createGameServerConfigOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.deleteGameServerConfigCallable = callableFactory.createUnaryCallable(deleteGameServerConfigTransportSettings, settings.deleteGameServerConfigSettings(), clientContext);
        this.deleteGameServerConfigOperationCallable = callableFactory.createOperationCallable(deleteGameServerConfigTransportSettings, settings.deleteGameServerConfigOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<ListGameServerConfigsRequest, ListGameServerConfigsResponse> listGameServerConfigsCallable() {
        return this.listGameServerConfigsCallable;
    }

    @Override
    public UnaryCallable<ListGameServerConfigsRequest, GameServerConfigsServiceClient.ListGameServerConfigsPagedResponse> listGameServerConfigsPagedCallable() {
        return this.listGameServerConfigsPagedCallable;
    }

    @Override
    public UnaryCallable<GetGameServerConfigRequest, GameServerConfig> getGameServerConfigCallable() {
        return this.getGameServerConfigCallable;
    }

    @Override
    public UnaryCallable<CreateGameServerConfigRequest, Operation> createGameServerConfigCallable() {
        return this.createGameServerConfigCallable;
    }

    @Override
    public OperationCallable<CreateGameServerConfigRequest, GameServerConfig, OperationMetadata> createGameServerConfigOperationCallable() {
        return this.createGameServerConfigOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteGameServerConfigRequest, Operation> deleteGameServerConfigCallable() {
        return this.deleteGameServerConfigCallable;
    }

    @Override
    public OperationCallable<DeleteGameServerConfigRequest, Empty, OperationMetadata> deleteGameServerConfigOperationCallable() {
        return this.deleteGameServerConfigOperationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

