/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.gaming.v1beta.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.gaming.v1beta.CreateRealmRequest;
import com.google.cloud.gaming.v1beta.DeleteRealmRequest;
import com.google.cloud.gaming.v1beta.GetRealmRequest;
import com.google.cloud.gaming.v1beta.ListRealmsRequest;
import com.google.cloud.gaming.v1beta.ListRealmsResponse;
import com.google.cloud.gaming.v1beta.OperationMetadata;
import com.google.cloud.gaming.v1beta.PreviewRealmUpdateRequest;
import com.google.cloud.gaming.v1beta.PreviewRealmUpdateResponse;
import com.google.cloud.gaming.v1beta.Realm;
import com.google.cloud.gaming.v1beta.RealmsServiceClient;
import com.google.cloud.gaming.v1beta.UpdateRealmRequest;
import com.google.cloud.gaming.v1beta.stub.GrpcRealmsServiceCallableFactory;
import com.google.cloud.gaming.v1beta.stub.RealmsServiceStub;
import com.google.cloud.gaming.v1beta.stub.RealmsServiceStubSettings;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GrpcRealmsServiceStub
extends RealmsServiceStub {
    private static final MethodDescriptor<ListRealmsRequest, ListRealmsResponse> listRealmsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.gaming.v1beta.RealmsService/ListRealms").setRequestMarshaller(ProtoUtils.marshaller((Message)ListRealmsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListRealmsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetRealmRequest, Realm> getRealmMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.gaming.v1beta.RealmsService/GetRealm").setRequestMarshaller(ProtoUtils.marshaller((Message)GetRealmRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Realm.getDefaultInstance())).build();
    private static final MethodDescriptor<CreateRealmRequest, Operation> createRealmMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.gaming.v1beta.RealmsService/CreateRealm").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateRealmRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteRealmRequest, Operation> deleteRealmMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.gaming.v1beta.RealmsService/DeleteRealm").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteRealmRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateRealmRequest, Operation> updateRealmMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.gaming.v1beta.RealmsService/UpdateRealm").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateRealmRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<PreviewRealmUpdateRequest, PreviewRealmUpdateResponse> previewRealmUpdateMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.gaming.v1beta.RealmsService/PreviewRealmUpdate").setRequestMarshaller(ProtoUtils.marshaller((Message)PreviewRealmUpdateRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)PreviewRealmUpdateResponse.getDefaultInstance())).build();
    private final UnaryCallable<ListRealmsRequest, ListRealmsResponse> listRealmsCallable;
    private final UnaryCallable<ListRealmsRequest, RealmsServiceClient.ListRealmsPagedResponse> listRealmsPagedCallable;
    private final UnaryCallable<GetRealmRequest, Realm> getRealmCallable;
    private final UnaryCallable<CreateRealmRequest, Operation> createRealmCallable;
    private final OperationCallable<CreateRealmRequest, Realm, OperationMetadata> createRealmOperationCallable;
    private final UnaryCallable<DeleteRealmRequest, Operation> deleteRealmCallable;
    private final OperationCallable<DeleteRealmRequest, Empty, OperationMetadata> deleteRealmOperationCallable;
    private final UnaryCallable<UpdateRealmRequest, Operation> updateRealmCallable;
    private final OperationCallable<UpdateRealmRequest, Realm, OperationMetadata> updateRealmOperationCallable;
    private final UnaryCallable<PreviewRealmUpdateRequest, PreviewRealmUpdateResponse> previewRealmUpdateCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcRealmsServiceStub create(RealmsServiceStubSettings settings) throws IOException {
        return new GrpcRealmsServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcRealmsServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcRealmsServiceStub(RealmsServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcRealmsServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcRealmsServiceStub(RealmsServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcRealmsServiceStub(RealmsServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcRealmsServiceCallableFactory());
    }

    protected GrpcRealmsServiceStub(RealmsServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings listRealmsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listRealmsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getRealmTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getRealmMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings createRealmTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createRealmMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteRealmTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteRealmMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings updateRealmTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateRealmMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("realm.name", String.valueOf(request.getRealm().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings previewRealmUpdateTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(previewRealmUpdateMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("realm.name", String.valueOf(request.getRealm().getName()));
            return builder.build();
        }).build();
        this.listRealmsCallable = callableFactory.createUnaryCallable(listRealmsTransportSettings, settings.listRealmsSettings(), clientContext);
        this.listRealmsPagedCallable = callableFactory.createPagedCallable(listRealmsTransportSettings, settings.listRealmsSettings(), clientContext);
        this.getRealmCallable = callableFactory.createUnaryCallable(getRealmTransportSettings, settings.getRealmSettings(), clientContext);
        this.createRealmCallable = callableFactory.createUnaryCallable(createRealmTransportSettings, settings.createRealmSettings(), clientContext);
        this.createRealmOperationCallable = callableFactory.createOperationCallable(createRealmTransportSettings, settings.createRealmOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.deleteRealmCallable = callableFactory.createUnaryCallable(deleteRealmTransportSettings, settings.deleteRealmSettings(), clientContext);
        this.deleteRealmOperationCallable = callableFactory.createOperationCallable(deleteRealmTransportSettings, settings.deleteRealmOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.updateRealmCallable = callableFactory.createUnaryCallable(updateRealmTransportSettings, settings.updateRealmSettings(), clientContext);
        this.updateRealmOperationCallable = callableFactory.createOperationCallable(updateRealmTransportSettings, settings.updateRealmOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.previewRealmUpdateCallable = callableFactory.createUnaryCallable(previewRealmUpdateTransportSettings, settings.previewRealmUpdateSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<ListRealmsRequest, ListRealmsResponse> listRealmsCallable() {
        return this.listRealmsCallable;
    }

    @Override
    public UnaryCallable<ListRealmsRequest, RealmsServiceClient.ListRealmsPagedResponse> listRealmsPagedCallable() {
        return this.listRealmsPagedCallable;
    }

    @Override
    public UnaryCallable<GetRealmRequest, Realm> getRealmCallable() {
        return this.getRealmCallable;
    }

    @Override
    public UnaryCallable<CreateRealmRequest, Operation> createRealmCallable() {
        return this.createRealmCallable;
    }

    @Override
    public OperationCallable<CreateRealmRequest, Realm, OperationMetadata> createRealmOperationCallable() {
        return this.createRealmOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteRealmRequest, Operation> deleteRealmCallable() {
        return this.deleteRealmCallable;
    }

    @Override
    public OperationCallable<DeleteRealmRequest, Empty, OperationMetadata> deleteRealmOperationCallable() {
        return this.deleteRealmOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateRealmRequest, Operation> updateRealmCallable() {
        return this.updateRealmCallable;
    }

    @Override
    public OperationCallable<UpdateRealmRequest, Realm, OperationMetadata> updateRealmOperationCallable() {
        return this.updateRealmOperationCallable;
    }

    @Override
    public UnaryCallable<PreviewRealmUpdateRequest, PreviewRealmUpdateResponse> previewRealmUpdateCallable() {
        return this.previewRealmUpdateCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

