/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud;

import com.google.cloud.Component;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.io.FileUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="download")
public class DownloadComponentsMojo
extends AbstractMojo {
    private static final long STALE_MS = TimeUnit.HOURS.toMillis(2L);
    @Parameter(defaultValue="https://dl.google.com/dl/cloudsdk/channels/rapid/", required=true)
    private URL baseUrl;
    @Parameter(required=true)
    private List<String> componentNames;
    @Parameter(defaultValue="${project.build.outputDirectory}/gcloud", required=true)
    private File destinationDir;
    @Parameter(defaultValue="false", required=true, property="gcloud.download.force")
    private boolean forceRefresh;
    @Parameter(defaultValue="false", required=true, property="gcloud.download.skip")
    private boolean shouldSkipDownload;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession session;
    private ExecutorService executor;

    public void execute() throws MojoExecutionException {
        this.executor = Executors.newCachedThreadPool();
        try {
            this.executeInner();
        }
        finally {
            this.executor.shutdown();
            this.executor = null;
        }
    }

    private void executeInner() throws MojoExecutionException {
        Map<String, String> checksums;
        List<Component> components;
        if (this.shouldSkipDownload) {
            this.getLog().info((CharSequence)"Skipping download because shouldSkipDownload=true");
            return;
        }
        if (this.session.isOffline() && this.forceRefresh) {
            throw new MojoExecutionException("Can't force refresh when offline");
        }
        if (!this.destinationDir.mkdirs()) {
            this.getLog().info((CharSequence)"Failed to create destination directory. Perhaps the directory already exists?");
        }
        try {
            this.updateCachedManifest();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to update the cached manifest", e);
        }
        try {
            components = this.parseManifest();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to parse the manifest", e);
        }
        try {
            checksums = this.parseLocalChecksums();
        }
        catch (Exception e) {
            this.getLog().warn((CharSequence)"Failed to parse local checksums, ignoring", (Throwable)e);
            checksums = new HashMap<String, String>();
        }
        ArrayList futures = Lists.newArrayList();
        for (Component component : components) {
            if (!this.forceRefresh && component.getChecksum().equals(checksums.get(component.getId()))) continue;
            futures.add(this.downloadComponentAsync(component));
        }
        for (Future future : futures) {
            try {
                future.get();
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof MojoExecutionException) {
                    throw (MojoExecutionException)e.getCause();
                }
                throw new MojoExecutionException("Unexpected execution error downloading component", e.getCause());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new MojoExecutionException("Interrupted while downloading component");
            }
        }
        if (futures.size() > 0) {
            this.getLog().info((CharSequence)"Finished downloading all components");
        }
        try {
            this.writeLocalChecksums(components);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to update the local checksum cache", (Exception)e);
        }
    }

    private URL getManifestUrl() throws MalformedURLException {
        return new URL(this.baseUrl, "components-2.json");
    }

    private File getManifestCache() {
        return new File(this.destinationDir, "components-2.json");
    }

    private File getComponentPath(Component component) {
        return new File(this.destinationDir, component.getId());
    }

    private File getChecksumFile() {
        return new File(this.destinationDir, "checksums.json");
    }

    private void updateCachedManifest() throws IOException {
        boolean isStale;
        URL manifestUrl = this.getManifestUrl();
        File localCache = this.getManifestCache();
        boolean bl = isStale = !localCache.exists() || new Date().getTime() - localCache.lastModified() < STALE_MS;
        if (this.forceRefresh && this.session.isOffline()) {
            throw new IllegalStateException("Can't force manifest refresh while offline");
        }
        if (this.session.isOffline() && localCache.exists() && isStale) {
            this.getLog().info((CharSequence)"Using stale manifest because offline mode is enabled");
            return;
        }
        if (!this.forceRefresh && !isStale) {
            this.getLog().debug((CharSequence)"Manifest is up to date, skipping manifest download");
            return;
        }
        if (this.session.isOffline()) {
            throw new IllegalStateException("Can't download manifest in offline mode");
        }
        this.getLog().debug((CharSequence)"Downloading fresh manifest");
        File tempFile = File.createTempFile(localCache.getName(), "");
        try (BufferedInputStream in = new BufferedInputStream(manifestUrl.openStream());
             FileOutputStream fileOutputStream = new FileOutputStream(tempFile);){
            int bytesRead;
            byte[] dataBuffer = new byte[1024];
            while ((bytesRead = in.read(dataBuffer, 0, 1024)) != -1) {
                fileOutputStream.write(dataBuffer, 0, bytesRead);
            }
        }
        Files.move(tempFile.toPath(), localCache.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    private List<Component> parseManifest() throws IOException {
        JsonElement json;
        try (FileReader reader = new FileReader(this.getManifestCache());){
            json = JsonParser.parseReader((Reader)reader);
        }
        JsonArray jsonComponents = json.getAsJsonObject().get("components").getAsJsonArray();
        ArrayList<Component> results = new ArrayList<Component>();
        for (JsonElement jsonComponent : jsonComponents) {
            JsonObject componentObj = jsonComponent.getAsJsonObject();
            String id = componentObj.get("id").getAsString();
            if (!this.componentNames.contains(id)) continue;
            results.add(Component.fromJson(this.baseUrl, componentObj));
        }
        return results;
    }

    private Map<String, String> parseLocalChecksums() throws IOException {
        JsonObject json = new JsonObject();
        if (this.getChecksumFile().exists()) {
            try (FileReader reader = new FileReader(this.getChecksumFile());){
                json = JsonParser.parseReader((Reader)reader);
            }
        }
        HashMap<String, String> results = new HashMap<String, String>();
        JsonObject checksumMap = json.getAsJsonObject();
        for (String componentName : this.componentNames) {
            JsonElement checksumJson = checksumMap.get(componentName);
            if (checksumJson == null) continue;
            results.put(componentName, checksumJson.getAsString());
        }
        return results;
    }

    private Future<Void> downloadComponentAsync(final Component component) {
        return this.executor.submit(new Callable<Void>(){

            @Override
            public Void call() throws MojoExecutionException {
                try {
                    DownloadComponentsMojo.this.downloadComponent(component);
                }
                catch (Exception e) {
                    throw new MojoExecutionException("Failed to download " + component.getId(), e);
                }
                return null;
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void downloadComponent(Component component) throws IOException, NoSuchAlgorithmException {
        Throwable throwable;
        this.getLog().info((CharSequence)("Downloading " + component.getId()));
        if (!"tar".equals(component.getFileType())) {
            throw new UnsupportedOperationException("Only tarballs are supported, got: " + component.getFileType());
        }
        File tmpArchive = File.createTempFile(component.getId(), "");
        tmpArchive.deleteOnExit();
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        try (InputStream is = component.getSource().openStream();){
            throwable = null;
            try (FileOutputStream os = new FileOutputStream(tmpArchive);){
                int bytesRead;
                byte[] dataBuffer = new byte[1024];
                while ((bytesRead = is.read(dataBuffer, 0, 1024)) != -1) {
                    digest.update(dataBuffer, 0, bytesRead);
                    os.write(dataBuffer, 0, bytesRead);
                }
            }
            catch (Throwable dataBuffer) {
                throwable = dataBuffer;
                throw dataBuffer;
            }
        }
        String checksum = DownloadComponentsMojo.byteArrayToHex(digest.digest());
        if (!checksum.equals(component.getChecksum())) {
            throw new RuntimeException(String.format("Checksum mismatch for %s %s != %s", component.getId(), component.getChecksum(), checksum));
        }
        File tmpPath = Files.createTempDirectory(component.getId(), new FileAttribute[0]).toFile();
        throwable = null;
        try (TarArchiveInputStream stream = new TarArchiveInputStream((InputStream)new GzipCompressorInputStream((InputStream)new FileInputStream(tmpArchive)));){
            ArchiveEntry entry;
            while ((entry = stream.getNextEntry()) != null) {
                FileOutputStream outputFileStream;
                block52: {
                    File dest = new File(tmpPath, entry.getName());
                    if (entry.isDirectory()) {
                        if (dest.mkdirs()) continue;
                        this.getLog().warn((CharSequence)("Failed to expand the directory " + dest));
                        continue;
                    }
                    if (!dest.getParentFile().exists() && !dest.getParentFile().mkdirs()) {
                        this.getLog().warn((CharSequence)("Failed to create intermediate directories: " + dest));
                    }
                    outputFileStream = new FileOutputStream(dest);
                    Throwable throwable2 = null;
                    try {
                        IOUtils.copy((InputStream)stream, (OutputStream)outputFileStream);
                        if (outputFileStream == null) continue;
                        if (throwable2 == null) break block52;
                    }
                    catch (Throwable throwable3) {
                        try {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (outputFileStream == null) throw throwable4;
                            if (throwable2 == null) {
                                ((OutputStream)outputFileStream).close();
                                throw throwable4;
                            }
                            try {
                                ((OutputStream)outputFileStream).close();
                                throw throwable4;
                            }
                            catch (Throwable throwable5) {
                                throwable2.addSuppressed(throwable5);
                                throw throwable4;
                            }
                        }
                    }
                    try {
                        ((OutputStream)outputFileStream).close();
                        continue;
                    }
                    catch (Throwable throwable6) {
                        throwable2.addSuppressed(throwable6);
                        continue;
                    }
                }
                ((OutputStream)outputFileStream).close();
            }
        }
        catch (Throwable throwable7) {
            throwable = throwable7;
            throw throwable7;
        }
        File localPath = this.getComponentPath(component);
        DownloadComponentsMojo.deleteRecursively(localPath);
        FileUtils.moveDirectory((File)tmpPath, (File)localPath);
    }

    private static void deleteRecursively(File directory) {
        File[] contents = directory.listFiles();
        if (contents != null) {
            for (File file : contents) {
                DownloadComponentsMojo.deleteRecursively(file);
            }
        }
        directory.delete();
    }

    private static String byteArrayToHex(byte[] a) {
        StringBuilder sb = new StringBuilder(a.length * 2);
        for (byte b : a) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }

    private void writeLocalChecksums(List<Component> components) throws IOException {
        Throwable throwable;
        JsonObject results = new JsonObject();
        try {
            throwable = null;
            try (FileReader reader = new FileReader(this.getChecksumFile());){
                results = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (FileNotFoundException reader) {
            // empty catch block
        }
        for (Component component : components) {
            results.add(component.getId(), (JsonElement)new JsonPrimitive(component.getChecksum()));
        }
        throwable = null;
        try (FileWriter writer = new FileWriter(this.getChecksumFile());){
            new Gson().toJson((JsonElement)results, (Appendable)writer);
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
    }
}

