/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.gkehub.v1.stub;

import com.google.api.HttpRule;
import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonOperationSnapshot;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.httpjson.longrunning.stub.HttpJsonOperationsStub;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.gkehub.v1.CreateFeatureRequest;
import com.google.cloud.gkehub.v1.CreateMembershipRequest;
import com.google.cloud.gkehub.v1.DeleteFeatureRequest;
import com.google.cloud.gkehub.v1.DeleteMembershipRequest;
import com.google.cloud.gkehub.v1.Feature;
import com.google.cloud.gkehub.v1.GenerateConnectManifestRequest;
import com.google.cloud.gkehub.v1.GenerateConnectManifestResponse;
import com.google.cloud.gkehub.v1.GetFeatureRequest;
import com.google.cloud.gkehub.v1.GetMembershipRequest;
import com.google.cloud.gkehub.v1.GkeHubClient;
import com.google.cloud.gkehub.v1.ListFeaturesRequest;
import com.google.cloud.gkehub.v1.ListFeaturesResponse;
import com.google.cloud.gkehub.v1.ListMembershipsRequest;
import com.google.cloud.gkehub.v1.ListMembershipsResponse;
import com.google.cloud.gkehub.v1.Membership;
import com.google.cloud.gkehub.v1.OperationMetadata;
import com.google.cloud.gkehub.v1.UpdateFeatureRequest;
import com.google.cloud.gkehub.v1.UpdateMembershipRequest;
import com.google.cloud.gkehub.v1.stub.GkeHubStub;
import com.google.cloud.gkehub.v1.stub.GkeHubStubSettings;
import com.google.cloud.gkehub.v1.stub.HttpJsonGkeHubCallableFactory;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonGkeHubStub
extends GkeHubStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().add(Empty.getDescriptor()).add(OperationMetadata.getDescriptor()).add(Feature.getDescriptor()).add(Membership.getDescriptor()).build();
    private static final ApiMethodDescriptor<ListMembershipsRequest, ListMembershipsResponse> listMembershipsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.gkehub.v1.GkeHub/ListMemberships").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}/memberships", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListMembershipsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListFeaturesRequest, ListFeaturesResponse> listFeaturesMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.gkehub.v1.GkeHub/ListFeatures").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}/features", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListFeaturesResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetMembershipRequest, Membership> getMembershipMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.gkehub.v1.GkeHub/GetMembership").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/memberships/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Membership.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetFeatureRequest, Feature> getFeatureMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.gkehub.v1.GkeHub/GetFeature").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/features/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Feature.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CreateMembershipRequest, Operation> createMembershipMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.gkehub.v1.GkeHub/CreateMembership").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}/memberships", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "membershipId", (Object)request.getMembershipId());
        serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("resource", (Message)request.getResource(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<CreateFeatureRequest, Operation> createFeatureMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.gkehub.v1.GkeHub/CreateFeature").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}/features", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "featureId", (Object)request.getFeatureId());
        serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("resource", (Message)request.getResource(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<DeleteMembershipRequest, Operation> deleteMembershipMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.gkehub.v1.GkeHub/DeleteMembership").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/memberships/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<DeleteFeatureRequest, Operation> deleteFeatureMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.gkehub.v1.GkeHub/DeleteFeature").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/features/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "force", (Object)request.getForce());
        serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<UpdateMembershipRequest, Operation> updateMembershipMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.gkehub.v1.GkeHub/UpdateMembership").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/memberships/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("resource", (Message)request.getResource(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<UpdateFeatureRequest, Operation> updateFeatureMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.gkehub.v1.GkeHub/UpdateFeature").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/features/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("resource", (Message)request.getResource(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<GenerateConnectManifestRequest, GenerateConnectManifestResponse> generateConnectManifestMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.gkehub.v1.GkeHub/GenerateConnectManifest").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/memberships/*}:generateConnectManifest", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "imagePullSecretContent", (Object)request.getImagePullSecretContent());
        serializer.putQueryParam(fields, "isUpgrade", (Object)request.getIsUpgrade());
        serializer.putQueryParam(fields, "namespace", (Object)request.getNamespace());
        serializer.putQueryParam(fields, "proxy", (Object)request.getProxy());
        serializer.putQueryParam(fields, "registry", (Object)request.getRegistry());
        serializer.putQueryParam(fields, "version", (Object)request.getVersion());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)GenerateConnectManifestResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<ListMembershipsRequest, ListMembershipsResponse> listMembershipsCallable;
    private final UnaryCallable<ListMembershipsRequest, GkeHubClient.ListMembershipsPagedResponse> listMembershipsPagedCallable;
    private final UnaryCallable<ListFeaturesRequest, ListFeaturesResponse> listFeaturesCallable;
    private final UnaryCallable<ListFeaturesRequest, GkeHubClient.ListFeaturesPagedResponse> listFeaturesPagedCallable;
    private final UnaryCallable<GetMembershipRequest, Membership> getMembershipCallable;
    private final UnaryCallable<GetFeatureRequest, Feature> getFeatureCallable;
    private final UnaryCallable<CreateMembershipRequest, Operation> createMembershipCallable;
    private final OperationCallable<CreateMembershipRequest, Membership, OperationMetadata> createMembershipOperationCallable;
    private final UnaryCallable<CreateFeatureRequest, Operation> createFeatureCallable;
    private final OperationCallable<CreateFeatureRequest, Feature, OperationMetadata> createFeatureOperationCallable;
    private final UnaryCallable<DeleteMembershipRequest, Operation> deleteMembershipCallable;
    private final OperationCallable<DeleteMembershipRequest, Empty, OperationMetadata> deleteMembershipOperationCallable;
    private final UnaryCallable<DeleteFeatureRequest, Operation> deleteFeatureCallable;
    private final OperationCallable<DeleteFeatureRequest, Empty, OperationMetadata> deleteFeatureOperationCallable;
    private final UnaryCallable<UpdateMembershipRequest, Operation> updateMembershipCallable;
    private final OperationCallable<UpdateMembershipRequest, Membership, OperationMetadata> updateMembershipOperationCallable;
    private final UnaryCallable<UpdateFeatureRequest, Operation> updateFeatureCallable;
    private final OperationCallable<UpdateFeatureRequest, Feature, OperationMetadata> updateFeatureOperationCallable;
    private final UnaryCallable<GenerateConnectManifestRequest, GenerateConnectManifestResponse> generateConnectManifestCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonOperationsStub httpJsonOperationsStub;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonGkeHubStub create(GkeHubStubSettings settings) throws IOException {
        return new HttpJsonGkeHubStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonGkeHubStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonGkeHubStub(GkeHubStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonGkeHubStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonGkeHubStub(GkeHubStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonGkeHubStub(GkeHubStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonGkeHubCallableFactory());
    }

    protected HttpJsonGkeHubStub(GkeHubStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.httpJsonOperationsStub = HttpJsonOperationsStub.create((ClientContext)clientContext, (HttpJsonStubCallableFactory)callableFactory, (TypeRegistry)typeRegistry, (Map)ImmutableMap.builder().put((Object)"google.longrunning.Operations.CancelOperation", (Object)HttpRule.newBuilder().setPost("/v1/{name=projects/*/locations/*/operations/*}:cancel").build()).put((Object)"google.longrunning.Operations.DeleteOperation", (Object)HttpRule.newBuilder().setDelete("/v1/{name=projects/*/locations/*/operations/*}").build()).put((Object)"google.longrunning.Operations.GetOperation", (Object)HttpRule.newBuilder().setGet("/v1/{name=projects/*/locations/*/operations/*}").build()).put((Object)"google.longrunning.Operations.ListOperations", (Object)HttpRule.newBuilder().setGet("/v1/{name=projects/*/locations/*}/operations").build()).build());
        HttpJsonCallSettings listMembershipsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listMembershipsMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings listFeaturesTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listFeaturesMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getMembershipTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getMembershipMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getFeatureTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getFeatureMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings createMembershipTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createMembershipMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings createFeatureTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createFeatureMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings deleteMembershipTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteMembershipMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings deleteFeatureTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteFeatureMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings updateMembershipTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateMembershipMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings updateFeatureTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateFeatureMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings generateConnectManifestTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(generateConnectManifestMethodDescriptor).setTypeRegistry(typeRegistry).build();
        this.listMembershipsCallable = callableFactory.createUnaryCallable(listMembershipsTransportSettings, settings.listMembershipsSettings(), clientContext);
        this.listMembershipsPagedCallable = callableFactory.createPagedCallable(listMembershipsTransportSettings, settings.listMembershipsSettings(), clientContext);
        this.listFeaturesCallable = callableFactory.createUnaryCallable(listFeaturesTransportSettings, settings.listFeaturesSettings(), clientContext);
        this.listFeaturesPagedCallable = callableFactory.createPagedCallable(listFeaturesTransportSettings, settings.listFeaturesSettings(), clientContext);
        this.getMembershipCallable = callableFactory.createUnaryCallable(getMembershipTransportSettings, settings.getMembershipSettings(), clientContext);
        this.getFeatureCallable = callableFactory.createUnaryCallable(getFeatureTransportSettings, settings.getFeatureSettings(), clientContext);
        this.createMembershipCallable = callableFactory.createUnaryCallable(createMembershipTransportSettings, settings.createMembershipSettings(), clientContext);
        this.createMembershipOperationCallable = callableFactory.createOperationCallable(createMembershipTransportSettings, settings.createMembershipOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.createFeatureCallable = callableFactory.createUnaryCallable(createFeatureTransportSettings, settings.createFeatureSettings(), clientContext);
        this.createFeatureOperationCallable = callableFactory.createOperationCallable(createFeatureTransportSettings, settings.createFeatureOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.deleteMembershipCallable = callableFactory.createUnaryCallable(deleteMembershipTransportSettings, settings.deleteMembershipSettings(), clientContext);
        this.deleteMembershipOperationCallable = callableFactory.createOperationCallable(deleteMembershipTransportSettings, settings.deleteMembershipOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.deleteFeatureCallable = callableFactory.createUnaryCallable(deleteFeatureTransportSettings, settings.deleteFeatureSettings(), clientContext);
        this.deleteFeatureOperationCallable = callableFactory.createOperationCallable(deleteFeatureTransportSettings, settings.deleteFeatureOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.updateMembershipCallable = callableFactory.createUnaryCallable(updateMembershipTransportSettings, settings.updateMembershipSettings(), clientContext);
        this.updateMembershipOperationCallable = callableFactory.createOperationCallable(updateMembershipTransportSettings, settings.updateMembershipOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.updateFeatureCallable = callableFactory.createUnaryCallable(updateFeatureTransportSettings, settings.updateFeatureSettings(), clientContext);
        this.updateFeatureOperationCallable = callableFactory.createOperationCallable(updateFeatureTransportSettings, settings.updateFeatureOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.generateConnectManifestCallable = callableFactory.createUnaryCallable(generateConnectManifestTransportSettings, settings.generateConnectManifestSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(listMembershipsMethodDescriptor);
        methodDescriptors.add(listFeaturesMethodDescriptor);
        methodDescriptors.add(getMembershipMethodDescriptor);
        methodDescriptors.add(getFeatureMethodDescriptor);
        methodDescriptors.add(createMembershipMethodDescriptor);
        methodDescriptors.add(createFeatureMethodDescriptor);
        methodDescriptors.add(deleteMembershipMethodDescriptor);
        methodDescriptors.add(deleteFeatureMethodDescriptor);
        methodDescriptors.add(updateMembershipMethodDescriptor);
        methodDescriptors.add(updateFeatureMethodDescriptor);
        methodDescriptors.add(generateConnectManifestMethodDescriptor);
        return methodDescriptors;
    }

    public HttpJsonOperationsStub getHttpJsonOperationsStub() {
        return this.httpJsonOperationsStub;
    }

    @Override
    public UnaryCallable<ListMembershipsRequest, ListMembershipsResponse> listMembershipsCallable() {
        return this.listMembershipsCallable;
    }

    @Override
    public UnaryCallable<ListMembershipsRequest, GkeHubClient.ListMembershipsPagedResponse> listMembershipsPagedCallable() {
        return this.listMembershipsPagedCallable;
    }

    @Override
    public UnaryCallable<ListFeaturesRequest, ListFeaturesResponse> listFeaturesCallable() {
        return this.listFeaturesCallable;
    }

    @Override
    public UnaryCallable<ListFeaturesRequest, GkeHubClient.ListFeaturesPagedResponse> listFeaturesPagedCallable() {
        return this.listFeaturesPagedCallable;
    }

    @Override
    public UnaryCallable<GetMembershipRequest, Membership> getMembershipCallable() {
        return this.getMembershipCallable;
    }

    @Override
    public UnaryCallable<GetFeatureRequest, Feature> getFeatureCallable() {
        return this.getFeatureCallable;
    }

    @Override
    public UnaryCallable<CreateMembershipRequest, Operation> createMembershipCallable() {
        return this.createMembershipCallable;
    }

    @Override
    public OperationCallable<CreateMembershipRequest, Membership, OperationMetadata> createMembershipOperationCallable() {
        return this.createMembershipOperationCallable;
    }

    @Override
    public UnaryCallable<CreateFeatureRequest, Operation> createFeatureCallable() {
        return this.createFeatureCallable;
    }

    @Override
    public OperationCallable<CreateFeatureRequest, Feature, OperationMetadata> createFeatureOperationCallable() {
        return this.createFeatureOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteMembershipRequest, Operation> deleteMembershipCallable() {
        return this.deleteMembershipCallable;
    }

    @Override
    public OperationCallable<DeleteMembershipRequest, Empty, OperationMetadata> deleteMembershipOperationCallable() {
        return this.deleteMembershipOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteFeatureRequest, Operation> deleteFeatureCallable() {
        return this.deleteFeatureCallable;
    }

    @Override
    public OperationCallable<DeleteFeatureRequest, Empty, OperationMetadata> deleteFeatureOperationCallable() {
        return this.deleteFeatureOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateMembershipRequest, Operation> updateMembershipCallable() {
        return this.updateMembershipCallable;
    }

    @Override
    public OperationCallable<UpdateMembershipRequest, Membership, OperationMetadata> updateMembershipOperationCallable() {
        return this.updateMembershipOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateFeatureRequest, Operation> updateFeatureCallable() {
        return this.updateFeatureCallable;
    }

    @Override
    public OperationCallable<UpdateFeatureRequest, Feature, OperationMetadata> updateFeatureOperationCallable() {
        return this.updateFeatureOperationCallable;
    }

    @Override
    public UnaryCallable<GenerateConnectManifestRequest, GenerateConnectManifestResponse> generateConnectManifestCallable() {
        return this.generateConnectManifestCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

