/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.gkehub.v1alpha;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.gkehub.v1alpha.CreateFeatureRequest;
import com.google.cloud.gkehub.v1alpha.DeleteFeatureRequest;
import com.google.cloud.gkehub.v1alpha.Feature;
import com.google.cloud.gkehub.v1alpha.GetFeatureRequest;
import com.google.cloud.gkehub.v1alpha.GkeHubSettings;
import com.google.cloud.gkehub.v1alpha.ListFeaturesRequest;
import com.google.cloud.gkehub.v1alpha.ListFeaturesResponse;
import com.google.cloud.gkehub.v1alpha.OperationMetadata;
import com.google.cloud.gkehub.v1alpha.UpdateFeatureRequest;
import com.google.cloud.gkehub.v1alpha.stub.GkeHubStub;
import com.google.cloud.gkehub.v1alpha.stub.GkeHubStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GkeHubClient
implements BackgroundResource {
    private final GkeHubSettings settings;
    private final GkeHubStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final GkeHubClient create() throws IOException {
        return GkeHubClient.create(GkeHubSettings.newBuilder().build());
    }

    public static final GkeHubClient create(GkeHubSettings settings) throws IOException {
        return new GkeHubClient(settings);
    }

    public static final GkeHubClient create(GkeHubStub stub) {
        return new GkeHubClient(stub);
    }

    protected GkeHubClient(GkeHubSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((GkeHubStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected GkeHubClient(GkeHubStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final GkeHubSettings getSettings() {
        return this.settings;
    }

    public GkeHubStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final ListFeaturesPagedResponse listFeatures(String parent) {
        ListFeaturesRequest request = ListFeaturesRequest.newBuilder().setParent(parent).build();
        return this.listFeatures(request);
    }

    public final ListFeaturesPagedResponse listFeatures(ListFeaturesRequest request) {
        return (ListFeaturesPagedResponse)((Object)this.listFeaturesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListFeaturesRequest, ListFeaturesPagedResponse> listFeaturesPagedCallable() {
        return this.stub.listFeaturesPagedCallable();
    }

    public final UnaryCallable<ListFeaturesRequest, ListFeaturesResponse> listFeaturesCallable() {
        return this.stub.listFeaturesCallable();
    }

    public final Feature getFeature(String name) {
        GetFeatureRequest request = GetFeatureRequest.newBuilder().setName(name).build();
        return this.getFeature(request);
    }

    public final Feature getFeature(GetFeatureRequest request) {
        return (Feature)this.getFeatureCallable().call((Object)request);
    }

    public final UnaryCallable<GetFeatureRequest, Feature> getFeatureCallable() {
        return this.stub.getFeatureCallable();
    }

    public final OperationFuture<Feature, OperationMetadata> createFeatureAsync(String parent, Feature resource, String featureId) {
        CreateFeatureRequest request = CreateFeatureRequest.newBuilder().setParent(parent).setResource(resource).setFeatureId(featureId).build();
        return this.createFeatureAsync(request);
    }

    public final OperationFuture<Feature, OperationMetadata> createFeatureAsync(CreateFeatureRequest request) {
        return this.createFeatureOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateFeatureRequest, Feature, OperationMetadata> createFeatureOperationCallable() {
        return this.stub.createFeatureOperationCallable();
    }

    public final UnaryCallable<CreateFeatureRequest, Operation> createFeatureCallable() {
        return this.stub.createFeatureCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteFeatureAsync(String name) {
        DeleteFeatureRequest request = DeleteFeatureRequest.newBuilder().setName(name).build();
        return this.deleteFeatureAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteFeatureAsync(DeleteFeatureRequest request) {
        return this.deleteFeatureOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteFeatureRequest, Empty, OperationMetadata> deleteFeatureOperationCallable() {
        return this.stub.deleteFeatureOperationCallable();
    }

    public final UnaryCallable<DeleteFeatureRequest, Operation> deleteFeatureCallable() {
        return this.stub.deleteFeatureCallable();
    }

    public final OperationFuture<Feature, OperationMetadata> updateFeatureAsync(String name, Feature resource, FieldMask updateMask) {
        UpdateFeatureRequest request = UpdateFeatureRequest.newBuilder().setName(name).setResource(resource).setUpdateMask(updateMask).build();
        return this.updateFeatureAsync(request);
    }

    public final OperationFuture<Feature, OperationMetadata> updateFeatureAsync(UpdateFeatureRequest request) {
        return this.updateFeatureOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateFeatureRequest, Feature, OperationMetadata> updateFeatureOperationCallable() {
        return this.stub.updateFeatureOperationCallable();
    }

    public final UnaryCallable<UpdateFeatureRequest, Operation> updateFeatureCallable() {
        return this.stub.updateFeatureCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFeaturesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListFeaturesRequest, ListFeaturesResponse, Feature, ListFeaturesPage, ListFeaturesFixedSizeCollection> {
        private ListFeaturesFixedSizeCollection(List<ListFeaturesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFeaturesFixedSizeCollection createEmptyCollection() {
            return new ListFeaturesFixedSizeCollection(null, 0);
        }

        protected ListFeaturesFixedSizeCollection createCollection(List<ListFeaturesPage> pages, int collectionSize) {
            return new ListFeaturesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListFeaturesPage
    extends AbstractPage<ListFeaturesRequest, ListFeaturesResponse, Feature, ListFeaturesPage> {
        private ListFeaturesPage(PageContext<ListFeaturesRequest, ListFeaturesResponse, Feature> context, ListFeaturesResponse response) {
            super(context, (Object)response);
        }

        private static ListFeaturesPage createEmptyPage() {
            return new ListFeaturesPage(null, null);
        }

        protected ListFeaturesPage createPage(PageContext<ListFeaturesRequest, ListFeaturesResponse, Feature> context, ListFeaturesResponse response) {
            return new ListFeaturesPage(context, response);
        }

        public ApiFuture<ListFeaturesPage> createPageAsync(PageContext<ListFeaturesRequest, ListFeaturesResponse, Feature> context, ApiFuture<ListFeaturesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListFeaturesPagedResponse
    extends AbstractPagedListResponse<ListFeaturesRequest, ListFeaturesResponse, Feature, ListFeaturesPage, ListFeaturesFixedSizeCollection> {
        public static ApiFuture<ListFeaturesPagedResponse> createAsync(PageContext<ListFeaturesRequest, ListFeaturesResponse, Feature> context, ApiFuture<ListFeaturesResponse> futureResponse) {
            ApiFuture<ListFeaturesPage> futurePage = ListFeaturesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListFeaturesPagedResponse((ListFeaturesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListFeaturesPagedResponse(ListFeaturesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFeaturesFixedSizeCollection.createEmptyCollection());
        }
    }
}

