/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.gkehub.v1beta1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.gkehub.v1beta1.CreateMembershipRequest;
import com.google.cloud.gkehub.v1beta1.DeleteMembershipRequest;
import com.google.cloud.gkehub.v1beta1.GenerateConnectManifestRequest;
import com.google.cloud.gkehub.v1beta1.GenerateConnectManifestResponse;
import com.google.cloud.gkehub.v1beta1.GenerateExclusivityManifestRequest;
import com.google.cloud.gkehub.v1beta1.GenerateExclusivityManifestResponse;
import com.google.cloud.gkehub.v1beta1.GetMembershipRequest;
import com.google.cloud.gkehub.v1beta1.GkeHubMembershipServiceSettings;
import com.google.cloud.gkehub.v1beta1.ListMembershipsRequest;
import com.google.cloud.gkehub.v1beta1.ListMembershipsResponse;
import com.google.cloud.gkehub.v1beta1.LocationName;
import com.google.cloud.gkehub.v1beta1.Membership;
import com.google.cloud.gkehub.v1beta1.MembershipName;
import com.google.cloud.gkehub.v1beta1.OperationMetadata;
import com.google.cloud.gkehub.v1beta1.UpdateMembershipRequest;
import com.google.cloud.gkehub.v1beta1.ValidateExclusivityRequest;
import com.google.cloud.gkehub.v1beta1.ValidateExclusivityResponse;
import com.google.cloud.gkehub.v1beta1.stub.GkeHubMembershipServiceStub;
import com.google.cloud.gkehub.v1beta1.stub.GkeHubMembershipServiceStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GkeHubMembershipServiceClient
implements BackgroundResource {
    private final GkeHubMembershipServiceSettings settings;
    private final GkeHubMembershipServiceStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final GkeHubMembershipServiceClient create() throws IOException {
        return GkeHubMembershipServiceClient.create(GkeHubMembershipServiceSettings.newBuilder().build());
    }

    public static final GkeHubMembershipServiceClient create(GkeHubMembershipServiceSettings settings) throws IOException {
        return new GkeHubMembershipServiceClient(settings);
    }

    public static final GkeHubMembershipServiceClient create(GkeHubMembershipServiceStub stub) {
        return new GkeHubMembershipServiceClient(stub);
    }

    protected GkeHubMembershipServiceClient(GkeHubMembershipServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((GkeHubMembershipServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected GkeHubMembershipServiceClient(GkeHubMembershipServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final GkeHubMembershipServiceSettings getSettings() {
        return this.settings;
    }

    public GkeHubMembershipServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final ListMembershipsPagedResponse listMemberships(LocationName parent) {
        ListMembershipsRequest request = ListMembershipsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listMemberships(request);
    }

    public final ListMembershipsPagedResponse listMemberships(String parent) {
        ListMembershipsRequest request = ListMembershipsRequest.newBuilder().setParent(parent).build();
        return this.listMemberships(request);
    }

    public final ListMembershipsPagedResponse listMemberships(ListMembershipsRequest request) {
        return (ListMembershipsPagedResponse)((Object)this.listMembershipsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListMembershipsRequest, ListMembershipsPagedResponse> listMembershipsPagedCallable() {
        return this.stub.listMembershipsPagedCallable();
    }

    public final UnaryCallable<ListMembershipsRequest, ListMembershipsResponse> listMembershipsCallable() {
        return this.stub.listMembershipsCallable();
    }

    public final Membership getMembership(MembershipName name) {
        GetMembershipRequest request = GetMembershipRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getMembership(request);
    }

    public final Membership getMembership(String name) {
        GetMembershipRequest request = GetMembershipRequest.newBuilder().setName(name).build();
        return this.getMembership(request);
    }

    public final Membership getMembership(GetMembershipRequest request) {
        return (Membership)this.getMembershipCallable().call((Object)request);
    }

    public final UnaryCallable<GetMembershipRequest, Membership> getMembershipCallable() {
        return this.stub.getMembershipCallable();
    }

    public final OperationFuture<Membership, OperationMetadata> createMembershipAsync(LocationName parent, Membership resource, String membershipId) {
        CreateMembershipRequest request = CreateMembershipRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setResource(resource).setMembershipId(membershipId).build();
        return this.createMembershipAsync(request);
    }

    public final OperationFuture<Membership, OperationMetadata> createMembershipAsync(String parent, Membership resource, String membershipId) {
        CreateMembershipRequest request = CreateMembershipRequest.newBuilder().setParent(parent).setResource(resource).setMembershipId(membershipId).build();
        return this.createMembershipAsync(request);
    }

    public final OperationFuture<Membership, OperationMetadata> createMembershipAsync(CreateMembershipRequest request) {
        return this.createMembershipOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateMembershipRequest, Membership, OperationMetadata> createMembershipOperationCallable() {
        return this.stub.createMembershipOperationCallable();
    }

    public final UnaryCallable<CreateMembershipRequest, Operation> createMembershipCallable() {
        return this.stub.createMembershipCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteMembershipAsync(MembershipName name) {
        DeleteMembershipRequest request = DeleteMembershipRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteMembershipAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteMembershipAsync(String name) {
        DeleteMembershipRequest request = DeleteMembershipRequest.newBuilder().setName(name).build();
        return this.deleteMembershipAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteMembershipAsync(DeleteMembershipRequest request) {
        return this.deleteMembershipOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteMembershipRequest, Empty, OperationMetadata> deleteMembershipOperationCallable() {
        return this.stub.deleteMembershipOperationCallable();
    }

    public final UnaryCallable<DeleteMembershipRequest, Operation> deleteMembershipCallable() {
        return this.stub.deleteMembershipCallable();
    }

    public final OperationFuture<Membership, OperationMetadata> updateMembershipAsync(MembershipName name, Membership resource, FieldMask updateMask) {
        UpdateMembershipRequest request = UpdateMembershipRequest.newBuilder().setName(name == null ? null : name.toString()).setResource(resource).setUpdateMask(updateMask).build();
        return this.updateMembershipAsync(request);
    }

    public final OperationFuture<Membership, OperationMetadata> updateMembershipAsync(String name, Membership resource, FieldMask updateMask) {
        UpdateMembershipRequest request = UpdateMembershipRequest.newBuilder().setName(name).setResource(resource).setUpdateMask(updateMask).build();
        return this.updateMembershipAsync(request);
    }

    public final OperationFuture<Membership, OperationMetadata> updateMembershipAsync(UpdateMembershipRequest request) {
        return this.updateMembershipOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateMembershipRequest, Membership, OperationMetadata> updateMembershipOperationCallable() {
        return this.stub.updateMembershipOperationCallable();
    }

    public final UnaryCallable<UpdateMembershipRequest, Operation> updateMembershipCallable() {
        return this.stub.updateMembershipCallable();
    }

    public final GenerateConnectManifestResponse generateConnectManifest(GenerateConnectManifestRequest request) {
        return (GenerateConnectManifestResponse)this.generateConnectManifestCallable().call((Object)request);
    }

    public final UnaryCallable<GenerateConnectManifestRequest, GenerateConnectManifestResponse> generateConnectManifestCallable() {
        return this.stub.generateConnectManifestCallable();
    }

    public final ValidateExclusivityResponse validateExclusivity(ValidateExclusivityRequest request) {
        return (ValidateExclusivityResponse)this.validateExclusivityCallable().call((Object)request);
    }

    public final UnaryCallable<ValidateExclusivityRequest, ValidateExclusivityResponse> validateExclusivityCallable() {
        return this.stub.validateExclusivityCallable();
    }

    public final GenerateExclusivityManifestResponse generateExclusivityManifest(GenerateExclusivityManifestRequest request) {
        return (GenerateExclusivityManifestResponse)this.generateExclusivityManifestCallable().call((Object)request);
    }

    public final UnaryCallable<GenerateExclusivityManifestRequest, GenerateExclusivityManifestResponse> generateExclusivityManifestCallable() {
        return this.stub.generateExclusivityManifestCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListMembershipsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListMembershipsRequest, ListMembershipsResponse, Membership, ListMembershipsPage, ListMembershipsFixedSizeCollection> {
        private ListMembershipsFixedSizeCollection(List<ListMembershipsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListMembershipsFixedSizeCollection createEmptyCollection() {
            return new ListMembershipsFixedSizeCollection(null, 0);
        }

        protected ListMembershipsFixedSizeCollection createCollection(List<ListMembershipsPage> pages, int collectionSize) {
            return new ListMembershipsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListMembershipsPage
    extends AbstractPage<ListMembershipsRequest, ListMembershipsResponse, Membership, ListMembershipsPage> {
        private ListMembershipsPage(PageContext<ListMembershipsRequest, ListMembershipsResponse, Membership> context, ListMembershipsResponse response) {
            super(context, (Object)response);
        }

        private static ListMembershipsPage createEmptyPage() {
            return new ListMembershipsPage(null, null);
        }

        protected ListMembershipsPage createPage(PageContext<ListMembershipsRequest, ListMembershipsResponse, Membership> context, ListMembershipsResponse response) {
            return new ListMembershipsPage(context, response);
        }

        public ApiFuture<ListMembershipsPage> createPageAsync(PageContext<ListMembershipsRequest, ListMembershipsResponse, Membership> context, ApiFuture<ListMembershipsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListMembershipsPagedResponse
    extends AbstractPagedListResponse<ListMembershipsRequest, ListMembershipsResponse, Membership, ListMembershipsPage, ListMembershipsFixedSizeCollection> {
        public static ApiFuture<ListMembershipsPagedResponse> createAsync(PageContext<ListMembershipsRequest, ListMembershipsResponse, Membership> context, ApiFuture<ListMembershipsResponse> futureResponse) {
            ApiFuture<ListMembershipsPage> futurePage = ListMembershipsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListMembershipsPagedResponse((ListMembershipsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListMembershipsPagedResponse(ListMembershipsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListMembershipsFixedSizeCollection.createEmptyCollection());
        }
    }
}

