/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.iam.credentials.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.cloud.iam.credentials.v1.GenerateAccessTokenRequest;
import com.google.cloud.iam.credentials.v1.GenerateAccessTokenResponse;
import com.google.cloud.iam.credentials.v1.GenerateIdTokenRequest;
import com.google.cloud.iam.credentials.v1.GenerateIdTokenResponse;
import com.google.cloud.iam.credentials.v1.SignBlobRequest;
import com.google.cloud.iam.credentials.v1.SignBlobResponse;
import com.google.cloud.iam.credentials.v1.SignJwtRequest;
import com.google.cloud.iam.credentials.v1.SignJwtResponse;
import com.google.cloud.iam.credentials.v1.stub.GrpcIamCredentialsStub;
import com.google.cloud.iam.credentials.v1.stub.HttpJsonIamCredentialsStub;
import com.google.cloud.iam.credentials.v1.stub.IamCredentialsStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class IamCredentialsStubSettings
extends StubSettings<IamCredentialsStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<GenerateAccessTokenRequest, GenerateAccessTokenResponse> generateAccessTokenSettings;
    private final UnaryCallSettings<GenerateIdTokenRequest, GenerateIdTokenResponse> generateIdTokenSettings;
    private final UnaryCallSettings<SignBlobRequest, SignBlobResponse> signBlobSettings;
    private final UnaryCallSettings<SignJwtRequest, SignJwtResponse> signJwtSettings;

    public UnaryCallSettings<GenerateAccessTokenRequest, GenerateAccessTokenResponse> generateAccessTokenSettings() {
        return this.generateAccessTokenSettings;
    }

    public UnaryCallSettings<GenerateIdTokenRequest, GenerateIdTokenResponse> generateIdTokenSettings() {
        return this.generateIdTokenSettings;
    }

    public UnaryCallSettings<SignBlobRequest, SignBlobResponse> signBlobSettings() {
        return this.signBlobSettings;
    }

    public UnaryCallSettings<SignJwtRequest, SignJwtResponse> signJwtSettings() {
        return this.signJwtSettings;
    }

    public IamCredentialsStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcIamCredentialsStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonIamCredentialsStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "iamcredentials";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "iamcredentials.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "iamcredentials.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return IamCredentialsStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(IamCredentialsStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(IamCredentialsStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return IamCredentialsStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected IamCredentialsStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.generateAccessTokenSettings = settingsBuilder.generateAccessTokenSettings().build();
        this.generateIdTokenSettings = settingsBuilder.generateIdTokenSettings().build();
        this.signBlobSettings = settingsBuilder.signBlobSettings().build();
        this.signJwtSettings = settingsBuilder.signJwtSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<IamCredentialsStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<GenerateAccessTokenRequest, GenerateAccessTokenResponse> generateAccessTokenSettings;
        private final UnaryCallSettings.Builder<GenerateIdTokenRequest, GenerateIdTokenResponse> generateIdTokenSettings;
        private final UnaryCallSettings.Builder<SignBlobRequest, SignBlobResponse> signBlobSettings;
        private final UnaryCallSettings.Builder<SignJwtRequest, SignJwtResponse> signJwtSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.generateAccessTokenSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.generateIdTokenSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.signBlobSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.signJwtSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.generateAccessTokenSettings, this.generateIdTokenSettings, this.signBlobSettings, this.signJwtSettings);
            Builder.initDefaults(this);
        }

        protected Builder(IamCredentialsStubSettings settings) {
            super((StubSettings)settings);
            this.generateAccessTokenSettings = settings.generateAccessTokenSettings.toBuilder();
            this.generateIdTokenSettings = settings.generateIdTokenSettings.toBuilder();
            this.signBlobSettings = settings.signBlobSettings.toBuilder();
            this.signJwtSettings = settings.signJwtSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.generateAccessTokenSettings, this.generateIdTokenSettings, this.signBlobSettings, this.signJwtSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(IamCredentialsStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)IamCredentialsStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)IamCredentialsStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(IamCredentialsStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(IamCredentialsStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)IamCredentialsStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)IamCredentialsStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)IamCredentialsStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(IamCredentialsStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(IamCredentialsStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.generateAccessTokenSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.generateIdTokenSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.signBlobSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.signJwtSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<GenerateAccessTokenRequest, GenerateAccessTokenResponse> generateAccessTokenSettings() {
            return this.generateAccessTokenSettings;
        }

        public UnaryCallSettings.Builder<GenerateIdTokenRequest, GenerateIdTokenResponse> generateIdTokenSettings() {
            return this.generateIdTokenSettings;
        }

        public UnaryCallSettings.Builder<SignBlobRequest, SignBlobResponse> signBlobSettings() {
            return this.signBlobSettings;
        }

        public UnaryCallSettings.Builder<SignJwtRequest, SignJwtResponse> signJwtSettings() {
            return this.signJwtSettings;
        }

        public IamCredentialsStubSettings build() throws IOException {
            return new IamCredentialsStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE, StatusCode.Code.DEADLINE_EXCEEDED})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

