/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.google.cloud.kms.v1;

import static com.google.cloud.kms.v1.EkmServiceClient.ListEkmConnectionsPagedResponse;
import static com.google.cloud.kms.v1.EkmServiceClient.ListLocationsPagedResponse;

import com.google.api.core.ApiFunction;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.ClientSettings;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.cloud.kms.v1.stub.EkmServiceStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import java.io.IOException;
import java.util.List;
import javax.annotation.Generated;

// AUTO-GENERATED DOCUMENTATION AND CLASS.
/**
 * Settings class to configure an instance of {@link EkmServiceClient}.
 *
 * <p>The default instance has everything set to sensible defaults:
 *
 * <ul>
 *   <li>The default service address (cloudkms.googleapis.com) and default port (443) are used.
 *   <li>Credentials are acquired automatically through Application Default Credentials.
 *   <li>Retries are configured for idempotent methods but not for non-idempotent methods.
 * </ul>
 *
 * <p>The builder of this class is recursive, so contained classes are themselves builders. When
 * build() is called, the tree of builders is called to create the complete settings object.
 *
 * <p>For example, to set the total timeout of getEkmConnection to 30 seconds:
 *
 * <pre>{@code
 * // This snippet has been automatically generated and should be regarded as a code template only.
 * // It will require modifications to work:
 * // - It may require correct/in-range values for request initialization.
 * // - It may require specifying regional endpoints when creating the service client as shown in
 * // https://cloud.google.com/java/docs/setup#configure_endpoints_for_the_client_library
 * EkmServiceSettings.Builder ekmServiceSettingsBuilder = EkmServiceSettings.newBuilder();
 * ekmServiceSettingsBuilder
 *     .getEkmConnectionSettings()
 *     .setRetrySettings(
 *         ekmServiceSettingsBuilder
 *             .getEkmConnectionSettings()
 *             .getRetrySettings()
 *             .toBuilder()
 *             .setTotalTimeout(Duration.ofSeconds(30))
 *             .build());
 * EkmServiceSettings ekmServiceSettings = ekmServiceSettingsBuilder.build();
 * }</pre>
 */
@Generated("by gapic-generator-java")
public class EkmServiceSettings extends ClientSettings<EkmServiceSettings> {

  /** Returns the object with the settings used for calls to listEkmConnections. */
  public PagedCallSettings<
          ListEkmConnectionsRequest, ListEkmConnectionsResponse, ListEkmConnectionsPagedResponse>
      listEkmConnectionsSettings() {
    return ((EkmServiceStubSettings) getStubSettings()).listEkmConnectionsSettings();
  }

  /** Returns the object with the settings used for calls to getEkmConnection. */
  public UnaryCallSettings<GetEkmConnectionRequest, EkmConnection> getEkmConnectionSettings() {
    return ((EkmServiceStubSettings) getStubSettings()).getEkmConnectionSettings();
  }

  /** Returns the object with the settings used for calls to createEkmConnection. */
  public UnaryCallSettings<CreateEkmConnectionRequest, EkmConnection>
      createEkmConnectionSettings() {
    return ((EkmServiceStubSettings) getStubSettings()).createEkmConnectionSettings();
  }

  /** Returns the object with the settings used for calls to updateEkmConnection. */
  public UnaryCallSettings<UpdateEkmConnectionRequest, EkmConnection>
      updateEkmConnectionSettings() {
    return ((EkmServiceStubSettings) getStubSettings()).updateEkmConnectionSettings();
  }

  /** Returns the object with the settings used for calls to getEkmConfig. */
  public UnaryCallSettings<GetEkmConfigRequest, EkmConfig> getEkmConfigSettings() {
    return ((EkmServiceStubSettings) getStubSettings()).getEkmConfigSettings();
  }

  /** Returns the object with the settings used for calls to updateEkmConfig. */
  public UnaryCallSettings<UpdateEkmConfigRequest, EkmConfig> updateEkmConfigSettings() {
    return ((EkmServiceStubSettings) getStubSettings()).updateEkmConfigSettings();
  }

  /** Returns the object with the settings used for calls to verifyConnectivity. */
  public UnaryCallSettings<VerifyConnectivityRequest, VerifyConnectivityResponse>
      verifyConnectivitySettings() {
    return ((EkmServiceStubSettings) getStubSettings()).verifyConnectivitySettings();
  }

  /** Returns the object with the settings used for calls to listLocations. */
  public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, ListLocationsPagedResponse>
      listLocationsSettings() {
    return ((EkmServiceStubSettings) getStubSettings()).listLocationsSettings();
  }

  /** Returns the object with the settings used for calls to getLocation. */
  public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
    return ((EkmServiceStubSettings) getStubSettings()).getLocationSettings();
  }

  /** Returns the object with the settings used for calls to setIamPolicy. */
  public UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings() {
    return ((EkmServiceStubSettings) getStubSettings()).setIamPolicySettings();
  }

  /** Returns the object with the settings used for calls to getIamPolicy. */
  public UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings() {
    return ((EkmServiceStubSettings) getStubSettings()).getIamPolicySettings();
  }

  /** Returns the object with the settings used for calls to testIamPermissions. */
  public UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse>
      testIamPermissionsSettings() {
    return ((EkmServiceStubSettings) getStubSettings()).testIamPermissionsSettings();
  }

  public static final EkmServiceSettings create(EkmServiceStubSettings stub) throws IOException {
    return new EkmServiceSettings.Builder(stub.toBuilder()).build();
  }

  /** Returns a builder for the default ExecutorProvider for this service. */
  public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
    return EkmServiceStubSettings.defaultExecutorProviderBuilder();
  }

  /** Returns the default service endpoint. */
  public static String getDefaultEndpoint() {
    return EkmServiceStubSettings.getDefaultEndpoint();
  }

  /** Returns the default service scopes. */
  public static List<String> getDefaultServiceScopes() {
    return EkmServiceStubSettings.getDefaultServiceScopes();
  }

  /** Returns a builder for the default credentials for this service. */
  public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
    return EkmServiceStubSettings.defaultCredentialsProviderBuilder();
  }

  /** Returns a builder for the default gRPC ChannelProvider for this service. */
  public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
    return EkmServiceStubSettings.defaultGrpcTransportProviderBuilder();
  }

  /** Returns a builder for the default REST ChannelProvider for this service. */
  @BetaApi
  public static InstantiatingHttpJsonChannelProvider.Builder
      defaultHttpJsonTransportProviderBuilder() {
    return EkmServiceStubSettings.defaultHttpJsonTransportProviderBuilder();
  }

  public static TransportChannelProvider defaultTransportChannelProvider() {
    return EkmServiceStubSettings.defaultTransportChannelProvider();
  }

  public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
    return EkmServiceStubSettings.defaultApiClientHeaderProviderBuilder();
  }

  /** Returns a new gRPC builder for this class. */
  public static Builder newBuilder() {
    return Builder.createDefault();
  }

  /** Returns a new REST builder for this class. */
  @BetaApi
  public static Builder newHttpJsonBuilder() {
    return Builder.createHttpJsonDefault();
  }

  /** Returns a new builder for this class. */
  public static Builder newBuilder(ClientContext clientContext) {
    return new Builder(clientContext);
  }

  /** Returns a builder containing all the values of this settings class. */
  public Builder toBuilder() {
    return new Builder(this);
  }

  protected EkmServiceSettings(Builder settingsBuilder) throws IOException {
    super(settingsBuilder);
  }

  /** Builder for EkmServiceSettings. */
  public static class Builder extends ClientSettings.Builder<EkmServiceSettings, Builder> {

    protected Builder() throws IOException {
      this(((ClientContext) null));
    }

    protected Builder(ClientContext clientContext) {
      super(EkmServiceStubSettings.newBuilder(clientContext));
    }

    protected Builder(EkmServiceSettings settings) {
      super(settings.getStubSettings().toBuilder());
    }

    protected Builder(EkmServiceStubSettings.Builder stubSettings) {
      super(stubSettings);
    }

    private static Builder createDefault() {
      return new Builder(EkmServiceStubSettings.newBuilder());
    }

    @BetaApi
    private static Builder createHttpJsonDefault() {
      return new Builder(EkmServiceStubSettings.newHttpJsonBuilder());
    }

    public EkmServiceStubSettings.Builder getStubSettingsBuilder() {
      return ((EkmServiceStubSettings.Builder) getStubSettings());
    }

    /**
     * Applies the given settings updater function to all of the unary API methods in this service.
     *
     * <p>Note: This method does not support applying settings to streaming methods.
     */
    public Builder applyToAllUnaryMethods(
        ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
      super.applyToAllUnaryMethods(
          getStubSettingsBuilder().unaryMethodSettingsBuilders(), settingsUpdater);
      return this;
    }

    /** Returns the builder for the settings used for calls to listEkmConnections. */
    public PagedCallSettings.Builder<
            ListEkmConnectionsRequest, ListEkmConnectionsResponse, ListEkmConnectionsPagedResponse>
        listEkmConnectionsSettings() {
      return getStubSettingsBuilder().listEkmConnectionsSettings();
    }

    /** Returns the builder for the settings used for calls to getEkmConnection. */
    public UnaryCallSettings.Builder<GetEkmConnectionRequest, EkmConnection>
        getEkmConnectionSettings() {
      return getStubSettingsBuilder().getEkmConnectionSettings();
    }

    /** Returns the builder for the settings used for calls to createEkmConnection. */
    public UnaryCallSettings.Builder<CreateEkmConnectionRequest, EkmConnection>
        createEkmConnectionSettings() {
      return getStubSettingsBuilder().createEkmConnectionSettings();
    }

    /** Returns the builder for the settings used for calls to updateEkmConnection. */
    public UnaryCallSettings.Builder<UpdateEkmConnectionRequest, EkmConnection>
        updateEkmConnectionSettings() {
      return getStubSettingsBuilder().updateEkmConnectionSettings();
    }

    /** Returns the builder for the settings used for calls to getEkmConfig. */
    public UnaryCallSettings.Builder<GetEkmConfigRequest, EkmConfig> getEkmConfigSettings() {
      return getStubSettingsBuilder().getEkmConfigSettings();
    }

    /** Returns the builder for the settings used for calls to updateEkmConfig. */
    public UnaryCallSettings.Builder<UpdateEkmConfigRequest, EkmConfig> updateEkmConfigSettings() {
      return getStubSettingsBuilder().updateEkmConfigSettings();
    }

    /** Returns the builder for the settings used for calls to verifyConnectivity. */
    public UnaryCallSettings.Builder<VerifyConnectivityRequest, VerifyConnectivityResponse>
        verifyConnectivitySettings() {
      return getStubSettingsBuilder().verifyConnectivitySettings();
    }

    /** Returns the builder for the settings used for calls to listLocations. */
    public PagedCallSettings.Builder<
            ListLocationsRequest, ListLocationsResponse, ListLocationsPagedResponse>
        listLocationsSettings() {
      return getStubSettingsBuilder().listLocationsSettings();
    }

    /** Returns the builder for the settings used for calls to getLocation. */
    public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
      return getStubSettingsBuilder().getLocationSettings();
    }

    /** Returns the builder for the settings used for calls to setIamPolicy. */
    public UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings() {
      return getStubSettingsBuilder().setIamPolicySettings();
    }

    /** Returns the builder for the settings used for calls to getIamPolicy. */
    public UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings() {
      return getStubSettingsBuilder().getIamPolicySettings();
    }

    /** Returns the builder for the settings used for calls to testIamPermissions. */
    public UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse>
        testIamPermissionsSettings() {
      return getStubSettingsBuilder().testIamPermissionsSettings();
    }

    @Override
    public EkmServiceSettings build() throws IOException {
      return new EkmServiceSettings(this);
    }
  }
}
