/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.kms.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.kms.v1.AutokeySettings;
import com.google.cloud.kms.v1.CreateKeyHandleMetadata;
import com.google.cloud.kms.v1.CreateKeyHandleRequest;
import com.google.cloud.kms.v1.GetKeyHandleRequest;
import com.google.cloud.kms.v1.KeyHandle;
import com.google.cloud.kms.v1.KeyHandleName;
import com.google.cloud.kms.v1.ListKeyHandlesRequest;
import com.google.cloud.kms.v1.ListKeyHandlesResponse;
import com.google.cloud.kms.v1.LocationName;
import com.google.cloud.kms.v1.stub.AutokeyStub;
import com.google.cloud.kms.v1.stub.AutokeyStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class AutokeyClient
implements BackgroundResource {
    private final AutokeySettings settings;
    private final AutokeyStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final AutokeyClient create() throws IOException {
        return AutokeyClient.create(AutokeySettings.newBuilder().build());
    }

    public static final AutokeyClient create(AutokeySettings settings) throws IOException {
        return new AutokeyClient(settings);
    }

    public static final AutokeyClient create(AutokeyStub stub) {
        return new AutokeyClient(stub);
    }

    protected AutokeyClient(AutokeySettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((AutokeyStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected AutokeyClient(AutokeyStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final AutokeySettings getSettings() {
        return this.settings;
    }

    public AutokeyStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final OperationFuture<KeyHandle, CreateKeyHandleMetadata> createKeyHandleAsync(LocationName parent, KeyHandle keyHandle, String keyHandleId) {
        CreateKeyHandleRequest request = CreateKeyHandleRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setKeyHandle(keyHandle).setKeyHandleId(keyHandleId).build();
        return this.createKeyHandleAsync(request);
    }

    public final OperationFuture<KeyHandle, CreateKeyHandleMetadata> createKeyHandleAsync(String parent, KeyHandle keyHandle, String keyHandleId) {
        CreateKeyHandleRequest request = CreateKeyHandleRequest.newBuilder().setParent(parent).setKeyHandle(keyHandle).setKeyHandleId(keyHandleId).build();
        return this.createKeyHandleAsync(request);
    }

    public final OperationFuture<KeyHandle, CreateKeyHandleMetadata> createKeyHandleAsync(CreateKeyHandleRequest request) {
        return this.createKeyHandleOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateKeyHandleRequest, KeyHandle, CreateKeyHandleMetadata> createKeyHandleOperationCallable() {
        return this.stub.createKeyHandleOperationCallable();
    }

    public final UnaryCallable<CreateKeyHandleRequest, Operation> createKeyHandleCallable() {
        return this.stub.createKeyHandleCallable();
    }

    public final KeyHandle getKeyHandle(KeyHandleName name) {
        GetKeyHandleRequest request = GetKeyHandleRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getKeyHandle(request);
    }

    public final KeyHandle getKeyHandle(String name) {
        GetKeyHandleRequest request = GetKeyHandleRequest.newBuilder().setName(name).build();
        return this.getKeyHandle(request);
    }

    public final KeyHandle getKeyHandle(GetKeyHandleRequest request) {
        return (KeyHandle)this.getKeyHandleCallable().call((Object)request);
    }

    public final UnaryCallable<GetKeyHandleRequest, KeyHandle> getKeyHandleCallable() {
        return this.stub.getKeyHandleCallable();
    }

    public final ListKeyHandlesPagedResponse listKeyHandles(LocationName parent) {
        ListKeyHandlesRequest request = ListKeyHandlesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listKeyHandles(request);
    }

    public final ListKeyHandlesPagedResponse listKeyHandles(String parent) {
        ListKeyHandlesRequest request = ListKeyHandlesRequest.newBuilder().setParent(parent).build();
        return this.listKeyHandles(request);
    }

    public final ListKeyHandlesPagedResponse listKeyHandles(ListKeyHandlesRequest request) {
        return (ListKeyHandlesPagedResponse)((Object)this.listKeyHandlesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListKeyHandlesRequest, ListKeyHandlesPagedResponse> listKeyHandlesPagedCallable() {
        return this.stub.listKeyHandlesPagedCallable();
    }

    public final UnaryCallable<ListKeyHandlesRequest, ListKeyHandlesResponse> listKeyHandlesCallable() {
        return this.stub.listKeyHandlesCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListKeyHandlesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListKeyHandlesRequest, ListKeyHandlesResponse, KeyHandle, ListKeyHandlesPage, ListKeyHandlesFixedSizeCollection> {
        private ListKeyHandlesFixedSizeCollection(List<ListKeyHandlesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListKeyHandlesFixedSizeCollection createEmptyCollection() {
            return new ListKeyHandlesFixedSizeCollection(null, 0);
        }

        protected ListKeyHandlesFixedSizeCollection createCollection(List<ListKeyHandlesPage> pages, int collectionSize) {
            return new ListKeyHandlesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListKeyHandlesPage
    extends AbstractPage<ListKeyHandlesRequest, ListKeyHandlesResponse, KeyHandle, ListKeyHandlesPage> {
        private ListKeyHandlesPage(PageContext<ListKeyHandlesRequest, ListKeyHandlesResponse, KeyHandle> context, ListKeyHandlesResponse response) {
            super(context, (Object)response);
        }

        private static ListKeyHandlesPage createEmptyPage() {
            return new ListKeyHandlesPage(null, null);
        }

        protected ListKeyHandlesPage createPage(PageContext<ListKeyHandlesRequest, ListKeyHandlesResponse, KeyHandle> context, ListKeyHandlesResponse response) {
            return new ListKeyHandlesPage(context, response);
        }

        public ApiFuture<ListKeyHandlesPage> createPageAsync(PageContext<ListKeyHandlesRequest, ListKeyHandlesResponse, KeyHandle> context, ApiFuture<ListKeyHandlesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListKeyHandlesPagedResponse
    extends AbstractPagedListResponse<ListKeyHandlesRequest, ListKeyHandlesResponse, KeyHandle, ListKeyHandlesPage, ListKeyHandlesFixedSizeCollection> {
        public static ApiFuture<ListKeyHandlesPagedResponse> createAsync(PageContext<ListKeyHandlesRequest, ListKeyHandlesResponse, KeyHandle> context, ApiFuture<ListKeyHandlesResponse> futureResponse) {
            ApiFuture<ListKeyHandlesPage> futurePage = ListKeyHandlesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListKeyHandlesPagedResponse((ListKeyHandlesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListKeyHandlesPagedResponse(ListKeyHandlesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListKeyHandlesFixedSizeCollection.createEmptyCollection());
        }
    }
}

