/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.language.spi.v1;

import com.google.api.gax.grpc.ChannelAndExecutor;
import com.google.api.gax.grpc.UnaryCallable;
import com.google.cloud.language.spi.v1.LanguageServiceSettings;
import com.google.cloud.language.v1.AnalyzeEntitiesRequest;
import com.google.cloud.language.v1.AnalyzeEntitiesResponse;
import com.google.cloud.language.v1.AnalyzeSentimentRequest;
import com.google.cloud.language.v1.AnalyzeSentimentResponse;
import com.google.cloud.language.v1.AnalyzeSyntaxRequest;
import com.google.cloud.language.v1.AnalyzeSyntaxResponse;
import com.google.cloud.language.v1.AnnotateTextRequest;
import com.google.cloud.language.v1.AnnotateTextResponse;
import com.google.cloud.language.v1.Document;
import com.google.cloud.language.v1.EncodingType;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;

public class LanguageServiceClient
implements AutoCloseable {
    private final LanguageServiceSettings settings;
    private final ScheduledExecutorService executor;
    private final ManagedChannel channel;
    private final List<AutoCloseable> closeables = new ArrayList<AutoCloseable>();
    private final UnaryCallable<AnalyzeSentimentRequest, AnalyzeSentimentResponse> analyzeSentimentCallable;
    private final UnaryCallable<AnalyzeEntitiesRequest, AnalyzeEntitiesResponse> analyzeEntitiesCallable;
    private final UnaryCallable<AnalyzeSyntaxRequest, AnalyzeSyntaxResponse> analyzeSyntaxCallable;
    private final UnaryCallable<AnnotateTextRequest, AnnotateTextResponse> annotateTextCallable;

    public static final LanguageServiceClient create() throws IOException {
        return LanguageServiceClient.create(LanguageServiceSettings.defaultBuilder().build());
    }

    public static final LanguageServiceClient create(LanguageServiceSettings settings) throws IOException {
        return new LanguageServiceClient(settings);
    }

    protected LanguageServiceClient(LanguageServiceSettings settings) throws IOException {
        this.settings = settings;
        ChannelAndExecutor channelAndExecutor = settings.getChannelAndExecutor();
        this.executor = channelAndExecutor.getExecutor();
        this.channel = channelAndExecutor.getChannel();
        this.analyzeSentimentCallable = UnaryCallable.create(settings.analyzeSentimentSettings(), (Channel)this.channel, (ScheduledExecutorService)this.executor);
        this.analyzeEntitiesCallable = UnaryCallable.create(settings.analyzeEntitiesSettings(), (Channel)this.channel, (ScheduledExecutorService)this.executor);
        this.analyzeSyntaxCallable = UnaryCallable.create(settings.analyzeSyntaxSettings(), (Channel)this.channel, (ScheduledExecutorService)this.executor);
        this.annotateTextCallable = UnaryCallable.create(settings.annotateTextSettings(), (Channel)this.channel, (ScheduledExecutorService)this.executor);
        if (settings.getChannelProvider().shouldAutoClose()) {
            this.closeables.add(new Closeable(){

                @Override
                public void close() throws IOException {
                    LanguageServiceClient.this.channel.shutdown();
                }
            });
        }
        if (settings.getExecutorProvider().shouldAutoClose()) {
            this.closeables.add(new Closeable(){

                @Override
                public void close() throws IOException {
                    LanguageServiceClient.this.executor.shutdown();
                }
            });
        }
    }

    public final LanguageServiceSettings getSettings() {
        return this.settings;
    }

    public final AnalyzeSentimentResponse analyzeSentiment(Document document) {
        AnalyzeSentimentRequest request = AnalyzeSentimentRequest.newBuilder().setDocument(document).build();
        return this.analyzeSentiment(request);
    }

    private final AnalyzeSentimentResponse analyzeSentiment(AnalyzeSentimentRequest request) {
        return (AnalyzeSentimentResponse)this.analyzeSentimentCallable().call((Object)request);
    }

    public final UnaryCallable<AnalyzeSentimentRequest, AnalyzeSentimentResponse> analyzeSentimentCallable() {
        return this.analyzeSentimentCallable;
    }

    public final AnalyzeEntitiesResponse analyzeEntities(Document document, EncodingType encodingType) {
        AnalyzeEntitiesRequest request = AnalyzeEntitiesRequest.newBuilder().setDocument(document).setEncodingType(encodingType).build();
        return this.analyzeEntities(request);
    }

    public final AnalyzeEntitiesResponse analyzeEntities(AnalyzeEntitiesRequest request) {
        return (AnalyzeEntitiesResponse)this.analyzeEntitiesCallable().call((Object)request);
    }

    public final UnaryCallable<AnalyzeEntitiesRequest, AnalyzeEntitiesResponse> analyzeEntitiesCallable() {
        return this.analyzeEntitiesCallable;
    }

    public final AnalyzeSyntaxResponse analyzeSyntax(Document document, EncodingType encodingType) {
        AnalyzeSyntaxRequest request = AnalyzeSyntaxRequest.newBuilder().setDocument(document).setEncodingType(encodingType).build();
        return this.analyzeSyntax(request);
    }

    public final AnalyzeSyntaxResponse analyzeSyntax(AnalyzeSyntaxRequest request) {
        return (AnalyzeSyntaxResponse)this.analyzeSyntaxCallable().call((Object)request);
    }

    public final UnaryCallable<AnalyzeSyntaxRequest, AnalyzeSyntaxResponse> analyzeSyntaxCallable() {
        return this.analyzeSyntaxCallable;
    }

    public final AnnotateTextResponse annotateText(Document document, AnnotateTextRequest.Features features, EncodingType encodingType) {
        AnnotateTextRequest request = AnnotateTextRequest.newBuilder().setDocument(document).setFeatures(features).setEncodingType(encodingType).build();
        return this.annotateText(request);
    }

    public final AnnotateTextResponse annotateText(AnnotateTextRequest request) {
        return (AnnotateTextResponse)this.annotateTextCallable().call((Object)request);
    }

    public final UnaryCallable<AnnotateTextRequest, AnnotateTextResponse> annotateTextCallable() {
        return this.annotateTextCallable;
    }

    @Override
    public final void close() throws Exception {
        for (AutoCloseable closeable : this.closeables) {
            closeable.close();
        }
    }
}

