/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.language.v2.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.cloud.language.v2.AnalyzeEntitiesRequest;
import com.google.cloud.language.v2.AnalyzeEntitiesResponse;
import com.google.cloud.language.v2.AnalyzeSentimentRequest;
import com.google.cloud.language.v2.AnalyzeSentimentResponse;
import com.google.cloud.language.v2.AnnotateTextRequest;
import com.google.cloud.language.v2.AnnotateTextResponse;
import com.google.cloud.language.v2.ClassifyTextRequest;
import com.google.cloud.language.v2.ClassifyTextResponse;
import com.google.cloud.language.v2.ModerateTextRequest;
import com.google.cloud.language.v2.ModerateTextResponse;
import com.google.cloud.language.v2.stub.GrpcLanguageServiceStub;
import com.google.cloud.language.v2.stub.HttpJsonLanguageServiceStub;
import com.google.cloud.language.v2.stub.LanguageServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class LanguageServiceStubSettings
extends StubSettings<LanguageServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-language").add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<AnalyzeSentimentRequest, AnalyzeSentimentResponse> analyzeSentimentSettings;
    private final UnaryCallSettings<AnalyzeEntitiesRequest, AnalyzeEntitiesResponse> analyzeEntitiesSettings;
    private final UnaryCallSettings<ClassifyTextRequest, ClassifyTextResponse> classifyTextSettings;
    private final UnaryCallSettings<ModerateTextRequest, ModerateTextResponse> moderateTextSettings;
    private final UnaryCallSettings<AnnotateTextRequest, AnnotateTextResponse> annotateTextSettings;

    public UnaryCallSettings<AnalyzeSentimentRequest, AnalyzeSentimentResponse> analyzeSentimentSettings() {
        return this.analyzeSentimentSettings;
    }

    public UnaryCallSettings<AnalyzeEntitiesRequest, AnalyzeEntitiesResponse> analyzeEntitiesSettings() {
        return this.analyzeEntitiesSettings;
    }

    public UnaryCallSettings<ClassifyTextRequest, ClassifyTextResponse> classifyTextSettings() {
        return this.classifyTextSettings;
    }

    public UnaryCallSettings<ModerateTextRequest, ModerateTextResponse> moderateTextSettings() {
        return this.moderateTextSettings;
    }

    public UnaryCallSettings<AnnotateTextRequest, AnnotateTextResponse> annotateTextSettings() {
        return this.annotateTextSettings;
    }

    public LanguageServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcLanguageServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonLanguageServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "language";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "language.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "language.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return LanguageServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(LanguageServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(LanguageServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return LanguageServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected LanguageServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.analyzeSentimentSettings = settingsBuilder.analyzeSentimentSettings().build();
        this.analyzeEntitiesSettings = settingsBuilder.analyzeEntitiesSettings().build();
        this.classifyTextSettings = settingsBuilder.classifyTextSettings().build();
        this.moderateTextSettings = settingsBuilder.moderateTextSettings().build();
        this.annotateTextSettings = settingsBuilder.annotateTextSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<LanguageServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<AnalyzeSentimentRequest, AnalyzeSentimentResponse> analyzeSentimentSettings;
        private final UnaryCallSettings.Builder<AnalyzeEntitiesRequest, AnalyzeEntitiesResponse> analyzeEntitiesSettings;
        private final UnaryCallSettings.Builder<ClassifyTextRequest, ClassifyTextResponse> classifyTextSettings;
        private final UnaryCallSettings.Builder<ModerateTextRequest, ModerateTextResponse> moderateTextSettings;
        private final UnaryCallSettings.Builder<AnnotateTextRequest, AnnotateTextResponse> annotateTextSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.analyzeSentimentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.analyzeEntitiesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.classifyTextSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.moderateTextSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.annotateTextSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.analyzeSentimentSettings, this.analyzeEntitiesSettings, this.classifyTextSettings, this.moderateTextSettings, this.annotateTextSettings);
            Builder.initDefaults(this);
        }

        protected Builder(LanguageServiceStubSettings settings) {
            super((StubSettings)settings);
            this.analyzeSentimentSettings = settings.analyzeSentimentSettings.toBuilder();
            this.analyzeEntitiesSettings = settings.analyzeEntitiesSettings.toBuilder();
            this.classifyTextSettings = settings.classifyTextSettings.toBuilder();
            this.moderateTextSettings = settings.moderateTextSettings.toBuilder();
            this.annotateTextSettings = settings.annotateTextSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.analyzeSentimentSettings, this.analyzeEntitiesSettings, this.classifyTextSettings, this.moderateTextSettings, this.annotateTextSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(LanguageServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)LanguageServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)LanguageServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(LanguageServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)LanguageServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)LanguageServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)LanguageServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(LanguageServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.analyzeSentimentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.analyzeEntitiesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.classifyTextSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.moderateTextSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.annotateTextSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<AnalyzeSentimentRequest, AnalyzeSentimentResponse> analyzeSentimentSettings() {
            return this.analyzeSentimentSettings;
        }

        public UnaryCallSettings.Builder<AnalyzeEntitiesRequest, AnalyzeEntitiesResponse> analyzeEntitiesSettings() {
            return this.analyzeEntitiesSettings;
        }

        public UnaryCallSettings.Builder<ClassifyTextRequest, ClassifyTextResponse> classifyTextSettings() {
            return this.classifyTextSettings;
        }

        public UnaryCallSettings.Builder<ModerateTextRequest, ModerateTextResponse> moderateTextSettings() {
            return this.moderateTextSettings;
        }

        public UnaryCallSettings.Builder<AnnotateTextRequest, AnnotateTextResponse> annotateTextSettings() {
            return this.annotateTextSettings;
        }

        public LanguageServiceStubSettings build() throws IOException {
            return new LanguageServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelayDuration(Duration.ofMillis(60000L)).setInitialRpcTimeoutDuration(Duration.ofMillis(600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(600000L)).setTotalTimeoutDuration(Duration.ofMillis(600000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

