/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.logging.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import ch.qos.logback.core.util.Loader;
import com.google.api.core.InternalApi;
import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.MonitoredResource;
import com.google.cloud.logging.LogEntry;
import com.google.cloud.logging.Logging;
import com.google.cloud.logging.LoggingEnhancer;
import com.google.cloud.logging.LoggingOptions;
import com.google.cloud.logging.MonitoredResourceUtil;
import com.google.cloud.logging.Payload;
import com.google.cloud.logging.Severity;
import com.google.cloud.logging.logback.LoggingEventEnhancer;
import com.google.common.base.Strings;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LoggingAppender
extends UnsynchronizedAppenderBase<ILoggingEvent> {
    private static final String LEVEL_NAME_KEY = "levelName";
    private static final String LEVEL_VALUE_KEY = "levelValue";
    private volatile Logging logging;
    private LoggingOptions loggingOptions;
    private List<LoggingEnhancer> loggingEnhancers;
    private List<LoggingEventEnhancer> loggingEventEnhancers;
    private Logging.WriteOption[] defaultWriteOptions;
    private Level flushLevel;
    private String log;
    private String resourceType;
    private String credentialsFile;
    private Set<String> enhancerClassNames = new HashSet<String>();
    private Set<String> loggingEventEnhancerClassNames = new HashSet<String>();

    public void setFlushLevel(Level flushLevel) {
        this.flushLevel = flushLevel;
    }

    public void setLog(String log) {
        this.log = log;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public void setCredentialsFile(String credentialsFile) {
        this.credentialsFile = credentialsFile;
    }

    public void addEnhancer(String enhancerClassName) {
        this.enhancerClassNames.add(enhancerClassName);
    }

    public void addLoggingEventEnhancer(String enhancerClassName) {
        this.loggingEventEnhancerClassNames.add(enhancerClassName);
    }

    Level getFlushLevel() {
        return this.flushLevel != null ? this.flushLevel : Level.ERROR;
    }

    String getLogName() {
        return this.log != null ? this.log : "java.log";
    }

    MonitoredResource getMonitoredResource(String projectId) {
        return MonitoredResourceUtil.getResource((String)projectId, (String)this.resourceType);
    }

    List<LoggingEnhancer> getLoggingEnhancers() {
        return this.getEnhancers(this.enhancerClassNames);
    }

    List<LoggingEventEnhancer> getLoggingEventEnhancers() {
        return this.getEnhancers(this.loggingEventEnhancerClassNames);
    }

    <T> List<T> getEnhancers(Set<String> classNames) {
        ArrayList<T> loggingEnhancers = new ArrayList<T>();
        if (classNames != null) {
            for (String enhancerClassName : classNames) {
                T enhancer;
                if (enhancerClassName == null || (enhancer = this.getEnhancer(enhancerClassName)) == null) continue;
                loggingEnhancers.add(enhancer);
            }
        }
        return loggingEnhancers;
    }

    private <T> T getEnhancer(String enhancerClassName) {
        try {
            Class clz = Loader.loadClass((String)enhancerClassName.trim());
            return clz.newInstance();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public synchronized void start() {
        if (this.isStarted()) {
            return;
        }
        MonitoredResource resource = this.getMonitoredResource(this.getProjectId());
        this.defaultWriteOptions = new Logging.WriteOption[]{Logging.WriteOption.logName((String)this.getLogName()), Logging.WriteOption.resource((MonitoredResource)resource)};
        this.getLogging().setFlushSeverity(LoggingAppender.severityFor(this.getFlushLevel()));
        this.loggingEnhancers = new ArrayList<LoggingEnhancer>();
        List resourceEnhancers = MonitoredResourceUtil.getResourceEnhancers();
        this.loggingEnhancers.addAll(resourceEnhancers);
        this.loggingEnhancers.addAll(this.getLoggingEnhancers());
        this.loggingEventEnhancers = new ArrayList<LoggingEventEnhancer>();
        this.loggingEventEnhancers.addAll(this.getLoggingEventEnhancers());
        super.start();
    }

    String getProjectId() {
        return this.getLoggingOptions().getProjectId();
    }

    protected void append(ILoggingEvent e) {
        LogEntry logEntry = this.logEntryFor(e);
        this.getLogging().write(Collections.singleton(logEntry), this.defaultWriteOptions);
    }

    public synchronized void stop() {
        if (this.logging != null) {
            try {
                this.logging.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.logging = null;
        super.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Logging getLogging() {
        if (this.logging == null) {
            LoggingAppender loggingAppender = this;
            synchronized (loggingAppender) {
                if (this.logging == null) {
                    this.logging = (Logging)this.getLoggingOptions().getService();
                }
            }
        }
        return this.logging;
    }

    LoggingOptions getLoggingOptions() {
        if (this.loggingOptions == null) {
            if (Strings.isNullOrEmpty((String)this.credentialsFile)) {
                this.loggingOptions = LoggingOptions.getDefaultInstance();
            } else {
                try {
                    this.loggingOptions = ((LoggingOptions.Builder)LoggingOptions.newBuilder().setCredentials((Credentials)GoogleCredentials.fromStream((InputStream)new FileInputStream(this.credentialsFile)))).build();
                }
                catch (IOException e) {
                    throw new RuntimeException(String.format("Could not read credentials file %s. Please verify that the file exists and is a valid Google credentials file.", this.credentialsFile), e);
                }
            }
        }
        return this.loggingOptions;
    }

    private LogEntry logEntryFor(ILoggingEvent e) {
        StringBuilder payload = new StringBuilder(e.getFormattedMessage()).append('\n');
        LoggingAppender.writeStack(e.getThrowableProxy(), "", payload);
        Level level = e.getLevel();
        LogEntry.Builder builder = LogEntry.newBuilder((Payload)Payload.StringPayload.of((String)payload.toString().trim())).setTimestamp(e.getTimeStamp()).setSeverity(LoggingAppender.severityFor(level));
        builder.addLabel(LEVEL_NAME_KEY, level.toString()).addLabel(LEVEL_VALUE_KEY, String.valueOf(level.toInt()));
        for (Map.Entry entry : e.getMDCPropertyMap().entrySet()) {
            if (null == entry.getKey() || null == entry.getValue()) continue;
            builder.addLabel((String)entry.getKey(), (String)entry.getValue());
        }
        if (this.loggingEnhancers != null) {
            for (LoggingEnhancer loggingEnhancer : this.loggingEnhancers) {
                loggingEnhancer.enhanceLogEntry(builder);
            }
        }
        if (this.loggingEventEnhancers != null) {
            for (LoggingEventEnhancer loggingEventEnhancer : this.loggingEventEnhancers) {
                loggingEventEnhancer.enhanceLogEntry(builder, e);
            }
        }
        return builder.build();
    }

    @InternalApi(value="Visible for testing")
    static void writeStack(IThrowableProxy throwProxy, String prefix, StringBuilder payload) {
        if (throwProxy == null) {
            return;
        }
        payload.append(prefix).append(throwProxy.getClassName()).append(": ").append(throwProxy.getMessage()).append('\n');
        StackTraceElementProxy[] trace = throwProxy.getStackTraceElementProxyArray();
        if (trace == null) {
            trace = new StackTraceElementProxy[]{};
        }
        int commonFrames = throwProxy.getCommonFrames();
        int printFrames = trace.length - commonFrames;
        for (int i = 0; i < printFrames; ++i) {
            payload.append("    ").append(trace[i]).append('\n');
        }
        if (commonFrames != 0) {
            payload.append("    ... ").append(commonFrames).append(" common frames elided\n");
        }
        LoggingAppender.writeStack(throwProxy.getCause(), "caused by: ", payload);
    }

    private static Severity severityFor(Level level) {
        switch (level.toInt()) {
            case 5000: {
                return Severity.DEBUG;
            }
            case 10000: {
                return Severity.DEBUG;
            }
            case 20000: {
                return Severity.INFO;
            }
            case 30000: {
                return Severity.WARNING;
            }
            case 40000: {
                return Severity.ERROR;
            }
        }
        return Severity.DEFAULT;
    }
}

