/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.logging.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import ch.qos.logback.core.util.Loader;
import com.google.api.core.InternalApi;
import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.MonitoredResource;
import com.google.cloud.logging.Instrumentation;
import com.google.cloud.logging.LogEntry;
import com.google.cloud.logging.Logging;
import com.google.cloud.logging.LoggingEnhancer;
import com.google.cloud.logging.LoggingOptions;
import com.google.cloud.logging.MonitoredResourceUtil;
import com.google.cloud.logging.Payload;
import com.google.cloud.logging.Severity;
import com.google.cloud.logging.Synchronicity;
import com.google.cloud.logging.logback.LogbackBatchingSettings;
import com.google.cloud.logging.logback.LoggingEventEnhancer;
import com.google.cloud.logging.logback.MDCEventEnhancer;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class LoggingAppender
extends UnsynchronizedAppenderBase<ILoggingEvent> {
    private static final String LEVEL_NAME_KEY = "levelName";
    private static final String LEVEL_VALUE_KEY = "levelValue";
    private static final String LOGGER_NAME_KEY = "loggerName";
    private static final String TYPE = "type.googleapis.com/google.devtools.clouderrorreporting.v1beta1.ReportedErrorEvent";
    private static final List<LoggingEventEnhancer> DEFAULT_LOGGING_EVENT_ENHANCERS = ImmutableList.of((Object)new MDCEventEnhancer());
    public static final String JAVA_LOGBACK_LIBRARY_NAME = "java-logback";
    public static final String DEFAULT_INSTRUMENTATION_VERSION = "0.130.27-alpha";
    private static boolean instrumentationAdded = false;
    private static final Object instrumentationLock = new Object();
    private volatile Logging logging;
    private LoggingOptions loggingOptions;
    private MonitoredResource monitoredResource;
    private List<LoggingEnhancer> loggingEnhancers;
    private List<LoggingEventEnhancer> loggingEventEnhancers;
    private Logging.WriteOption[] defaultWriteOptions;
    private Level flushLevel;
    private String log;
    private String resourceType;
    private String credentialsFile;
    private String logDestinationProjectId;
    private boolean autoPopulateMetadata = true;
    private boolean redirectToStdout = false;
    private boolean partialSuccess = true;
    private Synchronicity writeSyncFlag = Synchronicity.ASYNC;
    private final Set<String> enhancerClassNames = new HashSet<String>();
    private final Set<String> loggingEventEnhancerClassNames = new HashSet<String>();
    private LogbackBatchingSettings logbackBatchingSettings = null;

    public void setFlushLevel(Level flushLevel) {
        this.flushLevel = flushLevel;
    }

    public void setLog(String log) {
        this.log = log;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public void setCredentialsFile(String credentialsFile) {
        this.credentialsFile = credentialsFile;
    }

    public void setLogDestinationProjectId(String projectId) {
        this.logDestinationProjectId = projectId;
    }

    public void setWriteSynchronicity(Synchronicity flag) {
        this.writeSyncFlag = flag;
    }

    public void setAutoPopulateMetadata(boolean flag) {
        this.autoPopulateMetadata = flag;
    }

    public void setRedirectToStdout(boolean flag) {
        this.redirectToStdout = flag;
    }

    public void setLogbackBatchingSettings(LogbackBatchingSettings batchingSettings) {
        this.logbackBatchingSettings = batchingSettings;
    }

    public void setPartialSuccess(boolean flag) {
        this.partialSuccess = flag;
    }

    public void addEnhancer(String enhancerClassName) {
        this.enhancerClassNames.add(enhancerClassName);
    }

    public void addLoggingEventEnhancer(String enhancerClassName) {
        this.loggingEventEnhancerClassNames.add(enhancerClassName);
    }

    @Deprecated
    public Synchronicity getWriteSynchronicity() {
        return this.writeSyncFlag != null ? this.writeSyncFlag : Synchronicity.ASYNC;
    }

    private void setupMonitoredResource() {
        if (this.monitoredResource == null && this.autoPopulateMetadata) {
            this.monitoredResource = MonitoredResourceUtil.getResource((String)this.getProjectId(), (String)this.resourceType);
        }
    }

    @InternalApi(value="Visible for testing")
    void setupMonitoredResource(MonitoredResource monitoredResource) {
        this.monitoredResource = monitoredResource;
    }

    private Level getFlushLevel() {
        return this.flushLevel != null ? this.flushLevel : Level.ERROR;
    }

    private String getLogName() {
        return this.log != null ? this.log : "java.log";
    }

    private List<LoggingEnhancer> getLoggingEnhancers() {
        return this.getEnhancers(this.enhancerClassNames, LoggingEnhancer.class);
    }

    private List<LoggingEventEnhancer> getLoggingEventEnhancers() {
        if (this.loggingEventEnhancerClassNames.isEmpty()) {
            return DEFAULT_LOGGING_EVENT_ENHANCERS;
        }
        return this.getEnhancers(this.loggingEventEnhancerClassNames, LoggingEventEnhancer.class);
    }

    private <T> List<T> getEnhancers(Set<String> classNames, Class<T> classOfT) {
        ArrayList<T> enhancers = new ArrayList<T>();
        if (classNames != null) {
            for (String className : classNames) {
                if (className == null) continue;
                try {
                    T enhancer = Loader.loadClass((String)className.trim()).asSubclass(classOfT).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    enhancers.add(enhancer);
                }
                catch (Exception exception) {}
            }
        }
        return enhancers;
    }

    public synchronized void start() {
        if (this.isStarted()) {
            return;
        }
        this.setupMonitoredResource();
        this.defaultWriteOptions = new Logging.WriteOption[]{Logging.WriteOption.logName((String)this.getLogName()), Logging.WriteOption.resource((MonitoredResource)this.monitoredResource), Logging.WriteOption.partialSuccess((boolean)this.partialSuccess)};
        Level flushLevel = this.getFlushLevel();
        if (flushLevel != Level.OFF) {
            this.getLogging().setFlushSeverity(LoggingAppender.severityFor(flushLevel));
        }
        this.loggingEnhancers = new ArrayList<LoggingEnhancer>();
        List resourceEnhancers = MonitoredResourceUtil.getResourceEnhancers();
        this.loggingEnhancers.addAll(resourceEnhancers);
        this.loggingEnhancers.addAll(this.getLoggingEnhancers());
        this.loggingEventEnhancers = new ArrayList<LoggingEventEnhancer>();
        this.loggingEventEnhancers.addAll(this.getLoggingEventEnhancers());
        super.start();
    }

    String getProjectId() {
        return this.getLoggingOptions().getProjectId();
    }

    protected void append(ILoggingEvent e) {
        ArrayList<LogEntry> entriesList = new ArrayList<LogEntry>();
        entriesList.add(this.logEntryFor(e));
        if (!LoggingAppender.setInstrumentationStatus(true)) {
            entriesList.add(Instrumentation.createDiagnosticEntry((String)JAVA_LOGBACK_LIBRARY_NAME, (String)DEFAULT_INSTRUMENTATION_VERSION));
        }
        Iterable<Object> entries = entriesList;
        if (this.autoPopulateMetadata) {
            entries = this.getLogging().populateMetadata(entries, this.monitoredResource, new String[]{"com.google.cloud.logging", "jdk", "sun", "java", "ch.qos.logback"});
        }
        if (this.redirectToStdout) {
            for (LogEntry entry : entries) {
                System.out.println(entry.toStructuredJsonString());
            }
        } else {
            this.getLogging().write(entries, this.defaultWriteOptions);
        }
    }

    public synchronized void stop() {
        if (this.logging != null) {
            try {
                this.logging.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.logging = null;
        super.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Logging getLogging() {
        if (this.logging == null) {
            LoggingAppender loggingAppender = this;
            synchronized (loggingAppender) {
                if (this.logging == null) {
                    this.logging = (Logging)this.getLoggingOptions().getService();
                    this.logging.setWriteSynchronicity(this.writeSyncFlag);
                }
            }
        }
        return this.logging;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void flush() {
        if (!this.isStarted()) {
            return;
        }
        LoggingAppender loggingAppender = this;
        synchronized (loggingAppender) {
            this.getLogging().flush();
        }
    }

    protected LoggingOptions getLoggingOptions() {
        if (this.loggingOptions == null) {
            LoggingOptions.Builder builder = LoggingOptions.newBuilder();
            builder.setProjectId(this.logDestinationProjectId);
            if (!Strings.isNullOrEmpty((String)this.credentialsFile)) {
                try {
                    builder.setCredentials((Credentials)GoogleCredentials.fromStream((InputStream)new FileInputStream(this.credentialsFile)));
                }
                catch (IOException e) {
                    throw new RuntimeException(String.format("Could not read credentials file %s. Please verify that the file exists and is a valid Google credentials file.", this.credentialsFile), e);
                }
            }
            builder.setAutoPopulateMetadata(false);
            builder.setBatchingSettings(this.logbackBatchingSettings != null ? this.logbackBatchingSettings.build() : null);
            this.loggingOptions = builder.build();
        }
        return this.loggingOptions;
    }

    private LogEntry logEntryFor(ILoggingEvent e) {
        StringBuilder payload = new StringBuilder().append(e.getFormattedMessage()).append('\n');
        LoggingAppender.writeStack(e.getThrowableProxy(), "", payload);
        Level level = e.getLevel();
        Severity severity = LoggingAppender.severityFor(level);
        HashMap<String, String> jsonContent = new HashMap<String, String>();
        jsonContent.put("message", payload.toString().trim());
        if (severity == Severity.ERROR) {
            jsonContent.put("@type", TYPE);
        }
        LogEntry.Builder builder = LogEntry.newBuilder((Payload)Payload.JsonPayload.of(jsonContent)).setTimestamp(Instant.ofEpochMilli(e.getTimeStamp())).setSeverity(severity);
        builder.addLabel(LEVEL_NAME_KEY, level.toString()).addLabel(LEVEL_VALUE_KEY, String.valueOf(level.toInt())).addLabel(LOGGER_NAME_KEY, e.getLoggerName());
        if (this.loggingEnhancers != null) {
            for (LoggingEnhancer loggingEnhancer : this.loggingEnhancers) {
                loggingEnhancer.enhanceLogEntry(builder);
            }
        }
        if (this.loggingEventEnhancers != null) {
            for (LoggingEventEnhancer loggingEventEnhancer : this.loggingEventEnhancers) {
                loggingEventEnhancer.enhanceLogEntry(builder, e);
            }
        }
        return builder.build();
    }

    @InternalApi(value="Visible for testing")
    static void writeStack(IThrowableProxy throwProxy, String prefix, StringBuilder payload) {
        if (throwProxy == null) {
            return;
        }
        payload.append(prefix).append(throwProxy.getClassName()).append(": ").append(throwProxy.getMessage()).append('\n');
        StackTraceElementProxy[] trace = throwProxy.getStackTraceElementProxyArray();
        if (trace == null) {
            trace = new StackTraceElementProxy[]{};
        }
        int commonFrames = throwProxy.getCommonFrames();
        int printFrames = trace.length - commonFrames;
        for (int i = 0; i < printFrames; ++i) {
            payload.append("    ").append(trace[i]).append('\n');
        }
        if (commonFrames != 0) {
            payload.append("    ... ").append(commonFrames).append(" common frames elided\n");
        }
        LoggingAppender.writeStack(throwProxy.getCause(), "caused by: ", payload);
    }

    private static Severity severityFor(Level level) {
        switch (level.toInt()) {
            case 5000: {
                return Severity.DEBUG;
            }
            case 10000: {
                return Severity.DEBUG;
            }
            case 20000: {
                return Severity.INFO;
            }
            case 30000: {
                return Severity.WARNING;
            }
            case 40000: {
                return Severity.ERROR;
            }
        }
        return Severity.DEFAULT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean setInstrumentationStatus(boolean value) {
        if (instrumentationAdded == value) {
            return instrumentationAdded;
        }
        Object object = instrumentationLock;
        synchronized (object) {
            boolean current = instrumentationAdded;
            instrumentationAdded = value;
            return current;
        }
    }
}

