/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.logging;

import com.google.cloud.GrpcTransportOptions;
import com.google.cloud.ServiceDefaults;
import com.google.cloud.ServiceOptions;
import com.google.cloud.TransportOptions;
import com.google.cloud.logging.Logging;
import com.google.cloud.logging.LoggingException;
import com.google.cloud.logging.LoggingFactory;
import com.google.cloud.logging.LoggingImpl;
import com.google.cloud.logging.spi.DefaultLoggingRpc;
import com.google.cloud.logging.spi.LoggingRpc;
import com.google.cloud.logging.spi.LoggingRpcFactory;
import com.google.cloud.logging.spi.v2.LoggingSettings;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Set;

public class LoggingOptions
extends ServiceOptions<Logging, LoggingRpc, LoggingOptions> {
    private static final String API_SHORT_NAME = "Logging";
    private static final String LOGGING_SCOPE = "https://www.googleapis.com/auth/logging.admin";
    private static final Set<String> SCOPES = ImmutableSet.of((Object)"https://www.googleapis.com/auth/logging.admin");
    private static final String DEFAULT_HOST = LoggingSettings.getDefaultServiceAddress() + ':' + LoggingSettings.getDefaultServicePort();
    private static final long serialVersionUID = 5753499510627426717L;

    public static LoggingOptions getDefaultInstance() {
        return LoggingOptions.newBuilder().build();
    }

    protected String getDefaultHost() {
        return DEFAULT_HOST;
    }

    protected LoggingOptions(Builder builder) {
        super(LoggingFactory.class, LoggingRpcFactory.class, (ServiceOptions.Builder)builder, (ServiceDefaults)new LoggingDefaults());
    }

    public static GrpcTransportOptions getDefaultGrpcTransportOptions() {
        return GrpcTransportOptions.newBuilder().build();
    }

    protected Set<String> getScopes() {
        return SCOPES;
    }

    public boolean equals(Object obj) {
        return obj instanceof LoggingOptions && this.baseEquals((LoggingOptions)((Object)obj));
    }

    public int hashCode() {
        return this.baseHashCode();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    private static class LoggingDefaults
    implements ServiceDefaults<Logging, LoggingRpc, LoggingOptions> {
        private LoggingDefaults() {
        }

        public LoggingFactory getDefaultServiceFactory() {
            return DefaultLoggingFactory.INSTANCE;
        }

        public LoggingRpcFactory getDefaultRpcFactory() {
            return DefaultLoggingRpcFactory.INSTANCE;
        }

        public TransportOptions getDefaultTransportOptions() {
            return LoggingOptions.getDefaultGrpcTransportOptions();
        }
    }

    public static class Builder
    extends ServiceOptions.Builder<Logging, LoggingRpc, LoggingOptions, Builder> {
        private Builder() {
        }

        private Builder(LoggingOptions options) {
            super((ServiceOptions)options);
        }

        public Builder setTransportOptions(TransportOptions transportOptions) {
            if (!(transportOptions instanceof GrpcTransportOptions)) {
                throw new IllegalArgumentException("Only grpc transport is allowed for Logging.");
            }
            return (Builder)super.setTransportOptions(transportOptions);
        }

        public LoggingOptions build() {
            return new LoggingOptions(this);
        }
    }

    public static class DefaultLoggingRpcFactory
    implements LoggingRpcFactory {
        private static final LoggingRpcFactory INSTANCE = new DefaultLoggingRpcFactory();

        public LoggingRpc create(LoggingOptions options) {
            try {
                return new DefaultLoggingRpc(options);
            }
            catch (IOException e) {
                throw new LoggingException(e, true);
            }
        }
    }

    public static class DefaultLoggingFactory
    implements LoggingFactory {
        private static final LoggingFactory INSTANCE = new DefaultLoggingFactory();

        public Logging create(LoggingOptions options) {
            return new LoggingImpl(options);
        }
    }
}

