/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.logging.spi.v2;

import com.google.api.MonitoredResourceDescriptor;
import com.google.api.gax.bundling.BundlingSettings;
import com.google.api.gax.bundling.RequestBuilder;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.FlowControlSettings;
import com.google.api.gax.core.FlowController;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.RetrySettings;
import com.google.api.gax.grpc.BundledRequestIssuer;
import com.google.api.gax.grpc.BundlingCallSettings;
import com.google.api.gax.grpc.BundlingDescriptor;
import com.google.api.gax.grpc.CallContext;
import com.google.api.gax.grpc.ChannelProvider;
import com.google.api.gax.grpc.ClientSettings;
import com.google.api.gax.grpc.ExecutorProvider;
import com.google.api.gax.grpc.InstantiatingChannelProvider;
import com.google.api.gax.grpc.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.PagedCallSettings;
import com.google.api.gax.grpc.PagedListDescriptor;
import com.google.api.gax.grpc.PagedListResponseFactory;
import com.google.api.gax.grpc.SimpleCallSettings;
import com.google.api.gax.grpc.UnaryCallSettings;
import com.google.api.gax.grpc.UnaryCallable;
import com.google.cloud.logging.spi.v2.PagedResponseWrappers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.logging.v2.DeleteLogRequest;
import com.google.logging.v2.ListLogEntriesRequest;
import com.google.logging.v2.ListLogEntriesResponse;
import com.google.logging.v2.ListLogsRequest;
import com.google.logging.v2.ListLogsResponse;
import com.google.logging.v2.ListMonitoredResourceDescriptorsRequest;
import com.google.logging.v2.ListMonitoredResourceDescriptorsResponse;
import com.google.logging.v2.LogEntry;
import com.google.logging.v2.LoggingServiceV2Grpc;
import com.google.logging.v2.WriteLogEntriesRequest;
import com.google.logging.v2.WriteLogEntriesResponse;
import com.google.protobuf.Empty;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import org.joda.time.Duration;

public class LoggingSettings
extends ClientSettings {
    private static final String DEFAULT_SERVICE_ADDRESS = "logging.googleapis.com";
    private static final int DEFAULT_SERVICE_PORT = 443;
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/cloud-platform.read-only").add((Object)"https://www.googleapis.com/auth/logging.admin").add((Object)"https://www.googleapis.com/auth/logging.read").add((Object)"https://www.googleapis.com/auth/logging.write").build();
    private static final String DEFAULT_GAPIC_NAME = "gapic";
    private static final String DEFAULT_GAPIC_VERSION = "";
    private final SimpleCallSettings<DeleteLogRequest, Empty> deleteLogSettings;
    private final BundlingCallSettings<WriteLogEntriesRequest, WriteLogEntriesResponse> writeLogEntriesSettings;
    private final PagedCallSettings<ListLogEntriesRequest, ListLogEntriesResponse, PagedResponseWrappers.ListLogEntriesPagedResponse> listLogEntriesSettings;
    private final PagedCallSettings<ListMonitoredResourceDescriptorsRequest, ListMonitoredResourceDescriptorsResponse, PagedResponseWrappers.ListMonitoredResourceDescriptorsPagedResponse> listMonitoredResourceDescriptorsSettings;
    private final PagedCallSettings<ListLogsRequest, ListLogsResponse, PagedResponseWrappers.ListLogsPagedResponse> listLogsSettings;
    private static final PagedListDescriptor<ListLogEntriesRequest, ListLogEntriesResponse, LogEntry> LIST_LOG_ENTRIES_PAGE_STR_DESC = new PagedListDescriptor<ListLogEntriesRequest, ListLogEntriesResponse, LogEntry>(){

        public Object emptyToken() {
            return LoggingSettings.DEFAULT_GAPIC_VERSION;
        }

        public ListLogEntriesRequest injectToken(ListLogEntriesRequest payload, Object token) {
            return ListLogEntriesRequest.newBuilder((ListLogEntriesRequest)payload).setPageToken((String)token).build();
        }

        public ListLogEntriesRequest injectPageSize(ListLogEntriesRequest payload, int pageSize) {
            return ListLogEntriesRequest.newBuilder((ListLogEntriesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLogEntriesRequest payload) {
            return payload.getPageSize();
        }

        public Object extractNextToken(ListLogEntriesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<LogEntry> extractResources(ListLogEntriesResponse payload) {
            return payload.getEntriesList();
        }
    };
    private static final PagedListDescriptor<ListMonitoredResourceDescriptorsRequest, ListMonitoredResourceDescriptorsResponse, MonitoredResourceDescriptor> LIST_MONITORED_RESOURCE_DESCRIPTORS_PAGE_STR_DESC = new PagedListDescriptor<ListMonitoredResourceDescriptorsRequest, ListMonitoredResourceDescriptorsResponse, MonitoredResourceDescriptor>(){

        public Object emptyToken() {
            return LoggingSettings.DEFAULT_GAPIC_VERSION;
        }

        public ListMonitoredResourceDescriptorsRequest injectToken(ListMonitoredResourceDescriptorsRequest payload, Object token) {
            return ListMonitoredResourceDescriptorsRequest.newBuilder((ListMonitoredResourceDescriptorsRequest)payload).setPageToken((String)token).build();
        }

        public ListMonitoredResourceDescriptorsRequest injectPageSize(ListMonitoredResourceDescriptorsRequest payload, int pageSize) {
            return ListMonitoredResourceDescriptorsRequest.newBuilder((ListMonitoredResourceDescriptorsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListMonitoredResourceDescriptorsRequest payload) {
            return payload.getPageSize();
        }

        public Object extractNextToken(ListMonitoredResourceDescriptorsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<MonitoredResourceDescriptor> extractResources(ListMonitoredResourceDescriptorsResponse payload) {
            return payload.getResourceDescriptorsList();
        }
    };
    private static final PagedListDescriptor<ListLogsRequest, ListLogsResponse, String> LIST_LOGS_PAGE_STR_DESC = new PagedListDescriptor<ListLogsRequest, ListLogsResponse, String>(){

        public Object emptyToken() {
            return LoggingSettings.DEFAULT_GAPIC_VERSION;
        }

        public ListLogsRequest injectToken(ListLogsRequest payload, Object token) {
            return ListLogsRequest.newBuilder((ListLogsRequest)payload).setPageToken((String)token).build();
        }

        public ListLogsRequest injectPageSize(ListLogsRequest payload, int pageSize) {
            return ListLogsRequest.newBuilder((ListLogsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLogsRequest payload) {
            return payload.getPageSize();
        }

        public Object extractNextToken(ListLogsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<String> extractResources(ListLogsResponse payload) {
            return payload.getLogNamesList();
        }
    };
    private static final PagedListResponseFactory<ListLogEntriesRequest, ListLogEntriesResponse, PagedResponseWrappers.ListLogEntriesPagedResponse> LIST_LOG_ENTRIES_PAGE_STR_FACT = new PagedListResponseFactory<ListLogEntriesRequest, ListLogEntriesResponse, PagedResponseWrappers.ListLogEntriesPagedResponse>(){

        public PagedResponseWrappers.ListLogEntriesPagedResponse createPagedListResponse(UnaryCallable<ListLogEntriesRequest, ListLogEntriesResponse> callable, ListLogEntriesRequest request, CallContext context) {
            return new PagedResponseWrappers.ListLogEntriesPagedResponse(callable, (PagedListDescriptor<ListLogEntriesRequest, ListLogEntriesResponse, LogEntry>)LIST_LOG_ENTRIES_PAGE_STR_DESC, request, context);
        }
    };
    private static final PagedListResponseFactory<ListMonitoredResourceDescriptorsRequest, ListMonitoredResourceDescriptorsResponse, PagedResponseWrappers.ListMonitoredResourceDescriptorsPagedResponse> LIST_MONITORED_RESOURCE_DESCRIPTORS_PAGE_STR_FACT = new PagedListResponseFactory<ListMonitoredResourceDescriptorsRequest, ListMonitoredResourceDescriptorsResponse, PagedResponseWrappers.ListMonitoredResourceDescriptorsPagedResponse>(){

        public PagedResponseWrappers.ListMonitoredResourceDescriptorsPagedResponse createPagedListResponse(UnaryCallable<ListMonitoredResourceDescriptorsRequest, ListMonitoredResourceDescriptorsResponse> callable, ListMonitoredResourceDescriptorsRequest request, CallContext context) {
            return new PagedResponseWrappers.ListMonitoredResourceDescriptorsPagedResponse(callable, (PagedListDescriptor<ListMonitoredResourceDescriptorsRequest, ListMonitoredResourceDescriptorsResponse, MonitoredResourceDescriptor>)LIST_MONITORED_RESOURCE_DESCRIPTORS_PAGE_STR_DESC, request, context);
        }
    };
    private static final PagedListResponseFactory<ListLogsRequest, ListLogsResponse, PagedResponseWrappers.ListLogsPagedResponse> LIST_LOGS_PAGE_STR_FACT = new PagedListResponseFactory<ListLogsRequest, ListLogsResponse, PagedResponseWrappers.ListLogsPagedResponse>(){

        public PagedResponseWrappers.ListLogsPagedResponse createPagedListResponse(UnaryCallable<ListLogsRequest, ListLogsResponse> callable, ListLogsRequest request, CallContext context) {
            return new PagedResponseWrappers.ListLogsPagedResponse(callable, (PagedListDescriptor<ListLogsRequest, ListLogsResponse, String>)LIST_LOGS_PAGE_STR_DESC, request, context);
        }
    };
    private static final BundlingDescriptor<WriteLogEntriesRequest, WriteLogEntriesResponse> WRITE_LOG_ENTRIES_BUNDLING_DESC = new BundlingDescriptor<WriteLogEntriesRequest, WriteLogEntriesResponse>(){

        public String getBundlePartitionKey(WriteLogEntriesRequest request) {
            return request.getLogName() + "|" + request.getResource() + "|" + request.getLabels() + "|";
        }

        public RequestBuilder<WriteLogEntriesRequest> getRequestBuilder() {
            return new RequestBuilder<WriteLogEntriesRequest>(){
                private WriteLogEntriesRequest.Builder builder;

                public void appendRequest(WriteLogEntriesRequest request) {
                    if (this.builder == null) {
                        this.builder = request.toBuilder();
                    } else {
                        this.builder.addAllEntries((Iterable)request.getEntriesList());
                    }
                }

                public WriteLogEntriesRequest build() {
                    return this.builder.build();
                }
            };
        }

        public void splitResponse(WriteLogEntriesResponse bundleResponse, Collection<? extends BundledRequestIssuer<WriteLogEntriesResponse>> bundle) {
            boolean bundleMessageIndex = false;
            for (BundledRequestIssuer<WriteLogEntriesResponse> bundledRequestIssuer : bundle) {
                WriteLogEntriesResponse response = WriteLogEntriesResponse.newBuilder().build();
                bundledRequestIssuer.setResponse((Object)response);
            }
        }

        public void splitException(Throwable throwable, Collection<? extends BundledRequestIssuer<WriteLogEntriesResponse>> bundle) {
            for (BundledRequestIssuer<WriteLogEntriesResponse> bundledRequestIssuer : bundle) {
                bundledRequestIssuer.setException(throwable);
            }
        }

        public long countElements(WriteLogEntriesRequest request) {
            return request.getEntriesCount();
        }

        public long countBytes(WriteLogEntriesRequest request) {
            return request.getSerializedSize();
        }
    };

    public SimpleCallSettings<DeleteLogRequest, Empty> deleteLogSettings() {
        return this.deleteLogSettings;
    }

    public BundlingCallSettings<WriteLogEntriesRequest, WriteLogEntriesResponse> writeLogEntriesSettings() {
        return this.writeLogEntriesSettings;
    }

    public PagedCallSettings<ListLogEntriesRequest, ListLogEntriesResponse, PagedResponseWrappers.ListLogEntriesPagedResponse> listLogEntriesSettings() {
        return this.listLogEntriesSettings;
    }

    public PagedCallSettings<ListMonitoredResourceDescriptorsRequest, ListMonitoredResourceDescriptorsResponse, PagedResponseWrappers.ListMonitoredResourceDescriptorsPagedResponse> listMonitoredResourceDescriptorsSettings() {
        return this.listMonitoredResourceDescriptorsSettings;
    }

    public PagedCallSettings<ListLogsRequest, ListLogsResponse, PagedResponseWrappers.ListLogsPagedResponse> listLogsSettings() {
        return this.listLogsSettings;
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultServiceAddress() {
        return DEFAULT_SERVICE_ADDRESS;
    }

    public static int getDefaultServicePort() {
        return 443;
    }

    public static ImmutableList<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingChannelProvider.Builder defaultChannelProviderBuilder() {
        return InstantiatingChannelProvider.newBuilder().setServiceAddress(DEFAULT_SERVICE_ADDRESS).setPort(443).setGeneratorHeader(DEFAULT_GAPIC_NAME, LoggingSettings.getGapicVersion()).setCredentialsProvider((CredentialsProvider)LoggingSettings.defaultCredentialsProviderBuilder().build());
    }

    private static String getGapicVersion() {
        String packageVersion = LoggingSettings.class.getPackage().getImplementationVersion();
        return packageVersion != null ? packageVersion : DEFAULT_GAPIC_VERSION;
    }

    public static Builder defaultBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private LoggingSettings(Builder settingsBuilder) throws IOException {
        super(settingsBuilder.getExecutorProvider(), settingsBuilder.getChannelProvider());
        this.deleteLogSettings = settingsBuilder.deleteLogSettings().build();
        this.writeLogEntriesSettings = settingsBuilder.writeLogEntriesSettings().build();
        this.listLogEntriesSettings = settingsBuilder.listLogEntriesSettings().build();
        this.listMonitoredResourceDescriptorsSettings = settingsBuilder.listMonitoredResourceDescriptorsSettings().build();
        this.listLogsSettings = settingsBuilder.listLogsSettings().build();
    }

    public static class Builder
    extends ClientSettings.Builder {
        private final ImmutableList<UnaryCallSettings.Builder> unaryMethodSettingsBuilders;
        private final SimpleCallSettings.Builder<DeleteLogRequest, Empty> deleteLogSettings;
        private final BundlingCallSettings.Builder<WriteLogEntriesRequest, WriteLogEntriesResponse> writeLogEntriesSettings;
        private final PagedCallSettings.Builder<ListLogEntriesRequest, ListLogEntriesResponse, PagedResponseWrappers.ListLogEntriesPagedResponse> listLogEntriesSettings;
        private final PagedCallSettings.Builder<ListMonitoredResourceDescriptorsRequest, ListMonitoredResourceDescriptorsResponse, PagedResponseWrappers.ListMonitoredResourceDescriptorsPagedResponse> listMonitoredResourceDescriptorsSettings;
        private final PagedCallSettings.Builder<ListLogsRequest, ListLogsResponse, PagedResponseWrappers.ListLogsPagedResponse> listLogsSettings;
        private static final ImmutableMap<String, ImmutableSet<Status.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings.Builder> RETRY_PARAM_DEFINITIONS;

        private Builder() {
            super(LoggingSettings.defaultChannelProviderBuilder().build());
            this.deleteLogSettings = SimpleCallSettings.newBuilder((MethodDescriptor)LoggingServiceV2Grpc.METHOD_DELETE_LOG);
            this.writeLogEntriesSettings = BundlingCallSettings.newBuilder((MethodDescriptor)LoggingServiceV2Grpc.METHOD_WRITE_LOG_ENTRIES, (BundlingDescriptor)WRITE_LOG_ENTRIES_BUNDLING_DESC).setBundlingSettingsBuilder(BundlingSettings.newBuilder());
            this.listLogEntriesSettings = PagedCallSettings.newBuilder((MethodDescriptor)LoggingServiceV2Grpc.METHOD_LIST_LOG_ENTRIES, (PagedListResponseFactory)LIST_LOG_ENTRIES_PAGE_STR_FACT);
            this.listMonitoredResourceDescriptorsSettings = PagedCallSettings.newBuilder((MethodDescriptor)LoggingServiceV2Grpc.METHOD_LIST_MONITORED_RESOURCE_DESCRIPTORS, (PagedListResponseFactory)LIST_MONITORED_RESOURCE_DESCRIPTORS_PAGE_STR_FACT);
            this.listLogsSettings = PagedCallSettings.newBuilder((MethodDescriptor)LoggingServiceV2Grpc.METHOD_LIST_LOGS, (PagedListResponseFactory)LIST_LOGS_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.deleteLogSettings, this.writeLogEntriesSettings, this.listLogEntriesSettings, this.listMonitoredResourceDescriptorsSettings, this.listLogsSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder();
            builder.deleteLogSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.writeLogEntriesSettings().getBundlingSettingsBuilder().setElementCountThreshold(Integer.valueOf(1000)).setRequestByteThreshold(Integer.valueOf(0x100000)).setDelayThreshold(Duration.millis((long)50L)).setFlowControlSettings(FlowControlSettings.newBuilder().setMaxOutstandingElementCount(Integer.valueOf(100000)).setMaxOutstandingRequestBytes(Integer.valueOf(0xA00000)).setLimitExceededBehavior(FlowController.LimitExceededBehavior.ThrowException).build());
            builder.writeLogEntriesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listLogEntriesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"list"));
            builder.listMonitoredResourceDescriptorsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listLogsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        private Builder(LoggingSettings settings) {
            super((ClientSettings)settings);
            this.deleteLogSettings = settings.deleteLogSettings.toBuilder();
            this.writeLogEntriesSettings = settings.writeLogEntriesSettings.toBuilder();
            this.listLogEntriesSettings = settings.listLogEntriesSettings.toBuilder();
            this.listMonitoredResourceDescriptorsSettings = settings.listMonitoredResourceDescriptorsSettings.toBuilder();
            this.listLogsSettings = settings.listLogsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.deleteLogSettings, this.writeLogEntriesSettings, this.listLogEntriesSettings, this.listMonitoredResourceDescriptorsSettings, this.listLogsSettings);
        }

        public Builder setExecutorProvider(ExecutorProvider executorProvider) {
            super.setExecutorProvider(executorProvider);
            return this;
        }

        public Builder setChannelProvider(ChannelProvider channelProvider) {
            super.setChannelProvider(channelProvider);
            return this;
        }

        public Builder applyToAllUnaryMethods(UnaryCallSettings.Builder unaryCallSettings) throws Exception {
            super.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, unaryCallSettings);
            return this;
        }

        public SimpleCallSettings.Builder<DeleteLogRequest, Empty> deleteLogSettings() {
            return this.deleteLogSettings;
        }

        public BundlingCallSettings.Builder<WriteLogEntriesRequest, WriteLogEntriesResponse> writeLogEntriesSettings() {
            return this.writeLogEntriesSettings;
        }

        public PagedCallSettings.Builder<ListLogEntriesRequest, ListLogEntriesResponse, PagedResponseWrappers.ListLogEntriesPagedResponse> listLogEntriesSettings() {
            return this.listLogEntriesSettings;
        }

        public PagedCallSettings.Builder<ListMonitoredResourceDescriptorsRequest, ListMonitoredResourceDescriptorsResponse, PagedResponseWrappers.ListMonitoredResourceDescriptorsPagedResponse> listMonitoredResourceDescriptorsSettings() {
            return this.listMonitoredResourceDescriptorsSettings;
        }

        public PagedCallSettings.Builder<ListLogsRequest, ListLogsResponse, PagedResponseWrappers.ListLogsPagedResponse> listLogsSettings() {
            return this.listLogsSettings;
        }

        public LoggingSettings build() throws IOException {
            return new LoggingSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)Sets.immutableEnumSet((Iterable)Lists.newArrayList((Object[])new Status.Code[]{Status.Code.DEADLINE_EXCEEDED, Status.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)Sets.immutableEnumSet((Iterable)Lists.newArrayList((Object[])new Status.Code[]{Status.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings.Builder settingsBuilder = null;
            settingsBuilder = RetrySettings.newBuilder().setInitialRetryDelay(Duration.millis((long)100L)).setRetryDelayMultiplier(1.2).setMaxRetryDelay(Duration.millis((long)1000L)).setInitialRpcTimeout(Duration.millis((long)2000L)).setRpcTimeoutMultiplier(1.5).setMaxRpcTimeout(Duration.millis((long)30000L)).setTotalTimeout(Duration.millis((long)45000L));
            definitions.put((Object)"default", (Object)settingsBuilder);
            settingsBuilder = RetrySettings.newBuilder().setInitialRetryDelay(Duration.millis((long)100L)).setRetryDelayMultiplier(1.2).setMaxRetryDelay(Duration.millis((long)1000L)).setInitialRpcTimeout(Duration.millis((long)7000L)).setRpcTimeoutMultiplier(1.5).setMaxRpcTimeout(Duration.millis((long)30000L)).setTotalTimeout(Duration.millis((long)45000L));
            definitions.put((Object)"list", (Object)settingsBuilder);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

