/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.logging;

import com.google.api.gax.core.ApiFuture;
import com.google.api.gax.core.ApiFutureCallback;
import com.google.api.gax.core.ApiFutures;
import com.google.cloud.MonitoredResource;
import com.google.cloud.logging.LogEntry;
import com.google.cloud.logging.Logging;
import com.google.cloud.logging.LoggingLevel;
import com.google.cloud.logging.LoggingOptions;
import com.google.cloud.logging.Payload;
import com.google.cloud.logging.Severity;
import com.google.cloud.logging.Synchronicity;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class LoggingHandler
extends Handler {
    private static final String HANDLERS_PROPERTY = "handlers";
    private static final String ROOT_LOGGER_NAME = "";
    private static final String[] NO_HANDLERS = new String[0];
    private static final String LEVEL_NAME_KEY = "levelName";
    private static final String LEVEL_VALUE_KEY = "levelValue";
    private static final ThreadLocal<Boolean> inPublishCall = new ThreadLocal();
    private final LoggingOptions options;
    private final Logging.WriteOption[] writeOptions;
    private volatile Logging logging;
    private Level flushLevel;
    private long flushSize;
    private Synchronicity synchronicity;
    private final List<Enhancer> enhancers;
    private final Level baseLevel;
    private final Object writeLock = new Object();
    private final Set<ApiFuture<Void>> pendingWrites = Collections.newSetFromMap(new IdentityHashMap());

    public LoggingHandler() {
        this(null, null, null);
    }

    public LoggingHandler(String log) {
        this(log, null, null);
    }

    public LoggingHandler(String log, LoggingOptions options) {
        this(log, options, null);
    }

    public LoggingHandler(String log, LoggingOptions options, MonitoredResource monitoredResource) {
        this(log, options, monitoredResource, null);
    }

    public LoggingHandler(String log, LoggingOptions options, MonitoredResource monitoredResource, List<Enhancer> enhancers) {
        try {
            LogConfigHelper helper = new LogConfigHelper();
            String className = this.getClass().getName();
            this.options = options != null ? options : LoggingOptions.getDefaultInstance();
            this.flushLevel = helper.getLevelProperty(className + ".flushLevel", LoggingLevel.ERROR);
            this.flushSize = helper.getLongProperty(className + ".flushSize", 1L);
            Level level = helper.getLevelProperty(className + ".level", Level.INFO);
            this.setLevel(level);
            this.baseLevel = level.equals(Level.ALL) ? Level.FINEST : level;
            this.synchronicity = helper.getSynchronicityProperty(className + ".synchronicity", Synchronicity.ASYNC);
            this.setFilter(helper.getFilterProperty(className + ".filter", null));
            this.setFormatter(helper.getFormatterProperty(className + ".formatter", new SimpleFormatter()));
            String logName = (String)MoreObjects.firstNonNull((Object)log, (Object)helper.getProperty(className + ".log", "java.log"));
            this.enhancers = enhancers != null ? enhancers : helper.getEnhancerProperty(className + ".enhancers");
            String resourceType = helper.getProperty(className + ".resourceType", "global");
            MonitoredResource resource = monitoredResource != null ? monitoredResource : this.getDefaultResource(resourceType);
            this.writeOptions = new Logging.WriteOption[]{Logging.WriteOption.logName(logName), Logging.WriteOption.resource(resource), Logging.WriteOption.labels((Map<String, String>)ImmutableMap.of((Object)LEVEL_NAME_KEY, (Object)this.baseLevel.getName(), (Object)LEVEL_VALUE_KEY, (Object)String.valueOf(this.baseLevel.intValue())))};
        }
        catch (Exception ex) {
            this.reportError(null, ex, 4);
            throw ex;
        }
    }

    private static List<LoggingHandler> getLoggingHandlers(Logger logger) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Handler handler : logger.getHandlers()) {
            if (!(handler instanceof LoggingHandler)) continue;
            builder.add((Object)((LoggingHandler)handler));
        }
        return builder.build();
    }

    private static boolean hasLoggingHandler(Logger logger) {
        String[] handlers;
        for (Handler handler : logger.getHandlers()) {
            if (!(handler instanceof LoggingHandler)) continue;
            return true;
        }
        String loggerName = logger.getName();
        String propertyName = loggerName.equals(ROOT_LOGGER_NAME) ? HANDLERS_PROPERTY : loggerName + "." + HANDLERS_PROPERTY;
        String handlersProperty = LogManager.getLogManager().getProperty(propertyName);
        for (String handlerName : handlers = handlersProperty != null ? handlersProperty.split(",") : NO_HANDLERS) {
            if (!handlerName.contains(LoggingHandler.class.getPackage().getName())) continue;
            return true;
        }
        return false;
    }

    private MonitoredResource getDefaultResource(String resourceType) {
        MonitoredResource.Builder builder = MonitoredResource.newBuilder((String)resourceType);
        builder.addLabel("project_id", this.options.getProjectId());
        for (Enhancer enhancer : this.enhancers) {
            enhancer.enhanceMonitoredResource(builder);
        }
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Logging getLogging() {
        if (this.logging == null) {
            LoggingHandler loggingHandler = this;
            synchronized (loggingHandler) {
                if (this.logging == null) {
                    this.logging = (Logging)this.options.getService();
                }
            }
        }
        return this.logging;
    }

    @Override
    public void publish(LogRecord record) {
        if (!this.isLoggable(record)) {
            return;
        }
        if ("io.netty.handler.codec.http2.Http2FrameLogger".equals(record.getSourceClassName())) {
            return;
        }
        if (inPublishCall.get() != null) {
            return;
        }
        inPublishCall.set(true);
        try {
            LogEntry entry = this.entryFor(record);
            if (entry != null) {
                this.write(entry, this.writeOptions);
            }
            if (record.getLevel().intValue() >= this.flushLevel.intValue()) {
                this.flush();
            }
        }
        finally {
            inPublishCall.remove();
        }
    }

    private LogEntry entryFor(LogRecord record) {
        try {
            String payload = this.getFormatter().format(record);
            Level level = record.getLevel();
            LogEntry.Builder builder = LogEntry.newBuilder(Payload.StringPayload.of(payload)).setTimestamp(record.getMillis()).setSeverity(LoggingHandler.severityFor(level));
            if (!this.baseLevel.equals(level)) {
                builder.addLabel(LEVEL_NAME_KEY, level.getName()).addLabel(LEVEL_VALUE_KEY, String.valueOf(level.intValue()));
            }
            for (Enhancer enhancer : this.enhancers) {
                enhancer.enhanceLogEntry(builder, record);
            }
            this.enhanceLogEntry(builder, record);
            return builder.build();
        }
        catch (Exception ex) {
            this.reportError(null, ex, 5);
            return null;
        }
    }

    @Deprecated
    protected void enhanceLogEntry(LogEntry.Builder builder, LogRecord record) {
    }

    private static Severity severityFor(Level level) {
        if (level instanceof LoggingLevel) {
            return ((LoggingLevel)level).getSeverity();
        }
        switch (level.intValue()) {
            case 300: {
                return Severity.DEBUG;
            }
            case 400: {
                return Severity.DEBUG;
            }
            case 500: {
                return Severity.DEBUG;
            }
            case 700: {
                return Severity.INFO;
            }
            case 800: {
                return Severity.INFO;
            }
            case 900: {
                return Severity.WARNING;
            }
            case 1000: {
                return Severity.ERROR;
            }
        }
        return Severity.DEFAULT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void write(LogEntry entry, Logging.WriteOption ... options) {
        List<LogEntry> entryList = Collections.singletonList(entry);
        switch (this.synchronicity) {
            case SYNC: {
                try {
                    this.getLogging().write(entryList, options);
                }
                catch (Exception ex) {
                    this.reportError(null, ex, 2);
                }
                break;
            }
            default: {
                final ApiFuture<Void> writeFuture = this.getLogging().writeAsync(entryList, options);
                Object object = this.writeLock;
                synchronized (object) {
                    this.pendingWrites.add(writeFuture);
                }
                ApiFutures.addCallback(writeFuture, (ApiFutureCallback)new ApiFutureCallback<Void>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    private void removeFromPending() {
                        Object object = LoggingHandler.this.writeLock;
                        synchronized (object) {
                            LoggingHandler.this.pendingWrites.remove(writeFuture);
                        }
                    }

                    public void onSuccess(Void v) {
                        this.removeFromPending();
                    }

                    public void onFailure(Throwable t) {
                        try {
                            if (t instanceof Exception) {
                                LoggingHandler.this.reportError(null, (Exception)t, 2);
                            } else {
                                LoggingHandler.this.reportError(null, new Exception(t), 2);
                            }
                        }
                        finally {
                            this.removeFromPending();
                        }
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        ArrayList<ApiFuture<Void>> writesToFlush = new ArrayList<ApiFuture<Void>>();
        Iterator iterator = this.writeLock;
        synchronized (iterator) {
            writesToFlush.addAll(this.pendingWrites);
        }
        for (ApiFuture apiFuture : writesToFlush) {
            try {
                Uninterruptibles.getUninterruptibly((Future)apiFuture);
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public synchronized void close() throws SecurityException {
        if (this.logging != null) {
            try {
                this.logging.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.logging = null;
    }

    public synchronized Level setFlushLevel(Level flushLevel) {
        this.flushLevel = flushLevel;
        return flushLevel;
    }

    public Level getFlushLevel() {
        return this.flushLevel;
    }

    public synchronized long setFlushSize(long flushSize) {
        this.flushSize = flushSize;
        return flushSize;
    }

    public long getFlushSize() {
        return this.flushSize;
    }

    public synchronized Synchronicity setSynchronicity(Synchronicity synchronicity) {
        this.synchronicity = synchronicity;
        return synchronicity;
    }

    public Synchronicity getSynchronicity() {
        return this.synchronicity;
    }

    public static void addHandler(Logger logger, LoggingHandler handler) {
        logger.addHandler(handler);
    }

    public static interface Enhancer {
        public void enhanceMonitoredResource(MonitoredResource.Builder var1);

        public void enhanceLogEntry(LogEntry.Builder var1, LogRecord var2);
    }

    private static class LogConfigHelper {
        private final LogManager manager = LogManager.getLogManager();

        private LogConfigHelper() {
        }

        String getProperty(String name, String defaultValue) {
            return (String)MoreObjects.firstNonNull((Object)this.manager.getProperty(name), (Object)defaultValue);
        }

        long getLongProperty(String name, long defaultValue) {
            try {
                return Long.parseLong(this.manager.getProperty(name));
            }
            catch (NumberFormatException numberFormatException) {
                return defaultValue;
            }
        }

        Level getLevelProperty(String name, Level defaultValue) {
            String stringLevel = this.manager.getProperty(name);
            if (stringLevel == null) {
                return defaultValue;
            }
            try {
                return Level.parse(stringLevel);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return defaultValue;
            }
        }

        Filter getFilterProperty(String name, Filter defaultValue) {
            String stringFilter = this.manager.getProperty(name);
            try {
                if (stringFilter != null) {
                    Class<?> clz = ClassLoader.getSystemClassLoader().loadClass(stringFilter);
                    return (Filter)clz.newInstance();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return defaultValue;
        }

        Formatter getFormatterProperty(String name, Formatter defaultValue) {
            String stringFilter = this.manager.getProperty(name);
            try {
                if (stringFilter != null) {
                    Class<?> clz = ClassLoader.getSystemClassLoader().loadClass(stringFilter);
                    return (Formatter)clz.newInstance();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return defaultValue;
        }

        List<Enhancer> getEnhancerProperty(String name) {
            String list = this.manager.getProperty(name);
            try {
                ArrayList<Enhancer> enhancers = new ArrayList<Enhancer>();
                if (list != null) {
                    String[] items;
                    for (String e_name : items = list.split(",")) {
                        Class<?> clz = ClassLoader.getSystemClassLoader().loadClass(e_name);
                        enhancers.add((Enhancer)clz.newInstance());
                    }
                }
                return enhancers;
            }
            catch (Exception exception) {
                return Collections.emptyList();
            }
        }

        Synchronicity getSynchronicityProperty(String name, Synchronicity defaultValue) {
            String synchronicity = this.manager.getProperty(name);
            try {
                return Synchronicity.valueOf(synchronicity);
            }
            catch (Exception exception) {
                return defaultValue;
            }
        }
    }
}

