/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.logging.spi.v2;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.PropertiesProvider;
import com.google.api.gax.core.RetrySettings;
import com.google.api.gax.grpc.CallContext;
import com.google.api.gax.grpc.ChannelProvider;
import com.google.api.gax.grpc.ClientSettings;
import com.google.api.gax.grpc.ExecutorProvider;
import com.google.api.gax.grpc.InstantiatingChannelProvider;
import com.google.api.gax.grpc.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.PagedCallSettings;
import com.google.api.gax.grpc.PagedListDescriptor;
import com.google.api.gax.grpc.PagedListResponseFactory;
import com.google.api.gax.grpc.SimpleCallSettings;
import com.google.api.gax.grpc.UnaryCallSettings;
import com.google.api.gax.grpc.UnaryCallable;
import com.google.cloud.logging.spi.v2.PagedResponseWrappers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.logging.v2.ConfigServiceV2Grpc;
import com.google.logging.v2.CreateSinkRequest;
import com.google.logging.v2.DeleteSinkRequest;
import com.google.logging.v2.GetSinkRequest;
import com.google.logging.v2.ListSinksRequest;
import com.google.logging.v2.ListSinksResponse;
import com.google.logging.v2.LogSink;
import com.google.logging.v2.UpdateSinkRequest;
import com.google.protobuf.Empty;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import java.io.IOException;
import java.util.Set;
import org.joda.time.Duration;

public class ConfigSettings
extends ClientSettings {
    private static final String DEFAULT_SERVICE_ADDRESS = "logging.googleapis.com";
    private static final int DEFAULT_SERVICE_PORT = 443;
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/cloud-platform.read-only").add((Object)"https://www.googleapis.com/auth/logging.admin").add((Object)"https://www.googleapis.com/auth/logging.read").add((Object)"https://www.googleapis.com/auth/logging.write").build();
    private static final String DEFAULT_GAPIC_NAME = "gapic";
    private static final String DEFAULT_GAPIC_VERSION = "";
    private static final String PROPERTIES_FILE = "/project.properties";
    private static final String META_VERSION_KEY = "artifact.version";
    private static String gapicVersion;
    private final PagedCallSettings<ListSinksRequest, ListSinksResponse, PagedResponseWrappers.ListSinksPagedResponse> listSinksSettings;
    private final SimpleCallSettings<GetSinkRequest, LogSink> getSinkSettings;
    private final SimpleCallSettings<CreateSinkRequest, LogSink> createSinkSettings;
    private final SimpleCallSettings<UpdateSinkRequest, LogSink> updateSinkSettings;
    private final SimpleCallSettings<DeleteSinkRequest, Empty> deleteSinkSettings;
    private static final PagedListDescriptor<ListSinksRequest, ListSinksResponse, LogSink> LIST_SINKS_PAGE_STR_DESC;
    private static final PagedListResponseFactory<ListSinksRequest, ListSinksResponse, PagedResponseWrappers.ListSinksPagedResponse> LIST_SINKS_PAGE_STR_FACT;

    public PagedCallSettings<ListSinksRequest, ListSinksResponse, PagedResponseWrappers.ListSinksPagedResponse> listSinksSettings() {
        return this.listSinksSettings;
    }

    public SimpleCallSettings<GetSinkRequest, LogSink> getSinkSettings() {
        return this.getSinkSettings;
    }

    public SimpleCallSettings<CreateSinkRequest, LogSink> createSinkSettings() {
        return this.createSinkSettings;
    }

    public SimpleCallSettings<UpdateSinkRequest, LogSink> updateSinkSettings() {
        return this.updateSinkSettings;
    }

    public SimpleCallSettings<DeleteSinkRequest, Empty> deleteSinkSettings() {
        return this.deleteSinkSettings;
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultServiceAddress() {
        return DEFAULT_SERVICE_ADDRESS;
    }

    public static int getDefaultServicePort() {
        return 443;
    }

    public static ImmutableList<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingChannelProvider.Builder defaultChannelProviderBuilder() {
        return InstantiatingChannelProvider.newBuilder().setServiceAddress(DEFAULT_SERVICE_ADDRESS).setPort(443).setGeneratorHeader(DEFAULT_GAPIC_NAME, ConfigSettings.getGapicVersion()).setCredentialsProvider((CredentialsProvider)ConfigSettings.defaultCredentialsProviderBuilder().build());
    }

    private static String getGapicVersion() {
        if (gapicVersion == null) {
            gapicVersion = PropertiesProvider.loadProperty(ConfigSettings.class, (String)PROPERTIES_FILE, (String)META_VERSION_KEY);
            gapicVersion = gapicVersion == null ? DEFAULT_GAPIC_VERSION : gapicVersion;
        }
        return gapicVersion;
    }

    public static Builder defaultBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ConfigSettings(Builder settingsBuilder) throws IOException {
        super(settingsBuilder.getExecutorProvider(), settingsBuilder.getChannelProvider());
        this.listSinksSettings = settingsBuilder.listSinksSettings().build();
        this.getSinkSettings = settingsBuilder.getSinkSettings().build();
        this.createSinkSettings = settingsBuilder.createSinkSettings().build();
        this.updateSinkSettings = settingsBuilder.updateSinkSettings().build();
        this.deleteSinkSettings = settingsBuilder.deleteSinkSettings().build();
    }

    static {
        LIST_SINKS_PAGE_STR_DESC = new PagedListDescriptor<ListSinksRequest, ListSinksResponse, LogSink>(){

            public Object emptyToken() {
                return ConfigSettings.DEFAULT_GAPIC_VERSION;
            }

            public ListSinksRequest injectToken(ListSinksRequest payload, Object token) {
                return ListSinksRequest.newBuilder((ListSinksRequest)payload).setPageToken((String)token).build();
            }

            public ListSinksRequest injectPageSize(ListSinksRequest payload, int pageSize) {
                return ListSinksRequest.newBuilder((ListSinksRequest)payload).setPageSize(pageSize).build();
            }

            public Integer extractPageSize(ListSinksRequest payload) {
                return payload.getPageSize();
            }

            public Object extractNextToken(ListSinksResponse payload) {
                return payload.getNextPageToken();
            }

            public Iterable<LogSink> extractResources(ListSinksResponse payload) {
                return payload.getSinksList();
            }
        };
        LIST_SINKS_PAGE_STR_FACT = new PagedListResponseFactory<ListSinksRequest, ListSinksResponse, PagedResponseWrappers.ListSinksPagedResponse>(){

            public PagedResponseWrappers.ListSinksPagedResponse createPagedListResponse(UnaryCallable<ListSinksRequest, ListSinksResponse> callable, ListSinksRequest request, CallContext context) {
                return new PagedResponseWrappers.ListSinksPagedResponse(callable, (PagedListDescriptor<ListSinksRequest, ListSinksResponse, LogSink>)LIST_SINKS_PAGE_STR_DESC, request, context);
            }
        };
    }

    public static class Builder
    extends ClientSettings.Builder {
        private final ImmutableList<UnaryCallSettings.Builder> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListSinksRequest, ListSinksResponse, PagedResponseWrappers.ListSinksPagedResponse> listSinksSettings;
        private final SimpleCallSettings.Builder<GetSinkRequest, LogSink> getSinkSettings;
        private final SimpleCallSettings.Builder<CreateSinkRequest, LogSink> createSinkSettings;
        private final SimpleCallSettings.Builder<UpdateSinkRequest, LogSink> updateSinkSettings;
        private final SimpleCallSettings.Builder<DeleteSinkRequest, Empty> deleteSinkSettings;
        private static final ImmutableMap<String, ImmutableSet<Status.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings.Builder> RETRY_PARAM_DEFINITIONS;

        private Builder() {
            super(ConfigSettings.defaultChannelProviderBuilder().build());
            this.listSinksSettings = PagedCallSettings.newBuilder((MethodDescriptor)ConfigServiceV2Grpc.METHOD_LIST_SINKS, (PagedListResponseFactory)LIST_SINKS_PAGE_STR_FACT);
            this.getSinkSettings = SimpleCallSettings.newBuilder((MethodDescriptor)ConfigServiceV2Grpc.METHOD_GET_SINK);
            this.createSinkSettings = SimpleCallSettings.newBuilder((MethodDescriptor)ConfigServiceV2Grpc.METHOD_CREATE_SINK);
            this.updateSinkSettings = SimpleCallSettings.newBuilder((MethodDescriptor)ConfigServiceV2Grpc.METHOD_UPDATE_SINK);
            this.deleteSinkSettings = SimpleCallSettings.newBuilder((MethodDescriptor)ConfigServiceV2Grpc.METHOD_DELETE_SINK);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listSinksSettings, this.getSinkSettings, this.createSinkSettings, this.updateSinkSettings, this.deleteSinkSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder();
            builder.listSinksSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getSinkSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.createSinkSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.updateSinkSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.deleteSinkSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        private Builder(ConfigSettings settings) {
            super((ClientSettings)settings);
            this.listSinksSettings = settings.listSinksSettings.toBuilder();
            this.getSinkSettings = settings.getSinkSettings.toBuilder();
            this.createSinkSettings = settings.createSinkSettings.toBuilder();
            this.updateSinkSettings = settings.updateSinkSettings.toBuilder();
            this.deleteSinkSettings = settings.deleteSinkSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listSinksSettings, this.getSinkSettings, this.createSinkSettings, this.updateSinkSettings, this.deleteSinkSettings);
        }

        public Builder setExecutorProvider(ExecutorProvider executorProvider) {
            super.setExecutorProvider(executorProvider);
            return this;
        }

        public Builder setChannelProvider(ChannelProvider channelProvider) {
            super.setChannelProvider(channelProvider);
            return this;
        }

        public Builder applyToAllUnaryMethods(UnaryCallSettings.Builder unaryCallSettings) throws Exception {
            super.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, unaryCallSettings);
            return this;
        }

        public PagedCallSettings.Builder<ListSinksRequest, ListSinksResponse, PagedResponseWrappers.ListSinksPagedResponse> listSinksSettings() {
            return this.listSinksSettings;
        }

        public SimpleCallSettings.Builder<GetSinkRequest, LogSink> getSinkSettings() {
            return this.getSinkSettings;
        }

        public SimpleCallSettings.Builder<CreateSinkRequest, LogSink> createSinkSettings() {
            return this.createSinkSettings;
        }

        public SimpleCallSettings.Builder<UpdateSinkRequest, LogSink> updateSinkSettings() {
            return this.updateSinkSettings;
        }

        public SimpleCallSettings.Builder<DeleteSinkRequest, Empty> deleteSinkSettings() {
            return this.deleteSinkSettings;
        }

        public ConfigSettings build() throws IOException {
            return new ConfigSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)Sets.immutableEnumSet((Iterable)Lists.newArrayList((Object[])new Status.Code[]{Status.Code.DEADLINE_EXCEEDED, Status.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)Sets.immutableEnumSet((Iterable)Lists.newArrayList((Object[])new Status.Code[]{Status.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings.Builder settingsBuilder = null;
            settingsBuilder = RetrySettings.newBuilder().setInitialRetryDelay(Duration.millis((long)100L)).setRetryDelayMultiplier(1.2).setMaxRetryDelay(Duration.millis((long)1000L)).setInitialRpcTimeout(Duration.millis((long)2000L)).setRpcTimeoutMultiplier(1.5).setMaxRpcTimeout(Duration.millis((long)30000L)).setTotalTimeout(Duration.millis((long)45000L));
            definitions.put((Object)"default", (Object)settingsBuilder);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

