/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.logging.spi.v2.testing;

import com.google.logging.v2.DeleteLogRequest;
import com.google.logging.v2.ListLogEntriesRequest;
import com.google.logging.v2.ListLogEntriesResponse;
import com.google.logging.v2.ListMonitoredResourceDescriptorsRequest;
import com.google.logging.v2.ListMonitoredResourceDescriptorsResponse;
import com.google.logging.v2.LogEntry;
import com.google.logging.v2.LoggingServiceV2Grpc;
import com.google.logging.v2.WriteLogEntriesRequest;
import com.google.logging.v2.WriteLogEntriesResponse;
import com.google.protobuf.ByteString;
import com.google.protobuf.Empty;
import io.grpc.stub.StreamObserver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LocalLoggingImpl
extends LoggingServiceV2Grpc.LoggingServiceV2ImplBase {
    private Map<String, List<LogEntry>> logs = new HashMap<String, List<LogEntry>>();

    public void deleteLog(DeleteLogRequest request, StreamObserver<Empty> responseObserver) {
        this.logs.remove(request.getLogName());
        responseObserver.onNext((Object)Empty.getDefaultInstance());
        responseObserver.onCompleted();
    }

    public void writeLogEntries(WriteLogEntriesRequest request, StreamObserver<WriteLogEntriesResponse> responseObserver) {
        List<LogEntry> entries = this.logs.get(request.getLogName());
        if (entries == null) {
            entries = new ArrayList<LogEntry>();
            this.logs.put(request.getLogName(), entries);
        }
        entries.addAll(request.getEntriesList());
        responseObserver.onNext((Object)WriteLogEntriesResponse.newBuilder().build());
        responseObserver.onCompleted();
    }

    public void listLogEntries(ListLogEntriesRequest request, StreamObserver<ListLogEntriesResponse> responseObserver) {
        ArrayList entries = new ArrayList();
        for (ByteString proj : request.getProjectIdsList().asByteStringList()) {
            String prefix = "projects/" + proj.toStringUtf8() + "/";
            for (Map.Entry<String, List<LogEntry>> entry : this.logs.entrySet()) {
                if (!entry.getKey().startsWith(prefix)) continue;
                entries.addAll(entry.getValue());
            }
        }
        responseObserver.onNext((Object)ListLogEntriesResponse.newBuilder().addAllEntries(entries).build());
        responseObserver.onCompleted();
    }

    public void listMonitoredResourceDescriptors(ListMonitoredResourceDescriptorsRequest request, StreamObserver<ListMonitoredResourceDescriptorsResponse> responseObserver) {
        throw new UnsupportedOperationException();
    }

    public void reset() {
        this.logs.clear();
    }
}

