/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.logging.spi.v2;

import com.google.api.MonitoredResourceDescriptor;
import com.google.api.gax.batching.BatchingSettings;
import com.google.api.gax.batching.PartitionKey;
import com.google.api.gax.batching.RequestBuilder;
import com.google.api.gax.core.ApiFuture;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.FlowControlSettings;
import com.google.api.gax.core.FlowController;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.PropertiesProvider;
import com.google.api.gax.core.RetrySettings;
import com.google.api.gax.grpc.BatchedRequestIssuer;
import com.google.api.gax.grpc.BatchingCallSettings;
import com.google.api.gax.grpc.BatchingDescriptor;
import com.google.api.gax.grpc.CallContext;
import com.google.api.gax.grpc.ChannelProvider;
import com.google.api.gax.grpc.ClientSettings;
import com.google.api.gax.grpc.ExecutorProvider;
import com.google.api.gax.grpc.InstantiatingChannelProvider;
import com.google.api.gax.grpc.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.PageContext;
import com.google.api.gax.grpc.PagedCallSettings;
import com.google.api.gax.grpc.PagedListDescriptor;
import com.google.api.gax.grpc.PagedListResponseFactory;
import com.google.api.gax.grpc.SimpleCallSettings;
import com.google.api.gax.grpc.UnaryCallSettings;
import com.google.api.gax.grpc.UnaryCallable;
import com.google.cloud.logging.spi.v2.PagedResponseWrappers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.logging.v2.DeleteLogRequest;
import com.google.logging.v2.ListLogEntriesRequest;
import com.google.logging.v2.ListLogEntriesResponse;
import com.google.logging.v2.ListLogsRequest;
import com.google.logging.v2.ListLogsResponse;
import com.google.logging.v2.ListMonitoredResourceDescriptorsRequest;
import com.google.logging.v2.ListMonitoredResourceDescriptorsResponse;
import com.google.logging.v2.LogEntry;
import com.google.logging.v2.LoggingServiceV2Grpc;
import com.google.logging.v2.WriteLogEntriesRequest;
import com.google.logging.v2.WriteLogEntriesResponse;
import com.google.protobuf.Empty;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import org.joda.time.Duration;

public class LoggingSettings
extends ClientSettings {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/cloud-platform.read-only").add((Object)"https://www.googleapis.com/auth/logging.admin").add((Object)"https://www.googleapis.com/auth/logging.read").add((Object)"https://www.googleapis.com/auth/logging.write").build();
    private static final String DEFAULT_GAPIC_NAME = "gapic";
    private static final String DEFAULT_GAPIC_VERSION = "";
    private static final String PROPERTIES_FILE = "/com/google/cloud/logging/project.properties";
    private static final String META_VERSION_KEY = "artifact.version";
    private static String gapicVersion;
    private final SimpleCallSettings<DeleteLogRequest, Empty> deleteLogSettings;
    private final BatchingCallSettings<WriteLogEntriesRequest, WriteLogEntriesResponse> writeLogEntriesSettings;
    private final PagedCallSettings<ListLogEntriesRequest, ListLogEntriesResponse, PagedResponseWrappers.ListLogEntriesPagedResponse> listLogEntriesSettings;
    private final PagedCallSettings<ListMonitoredResourceDescriptorsRequest, ListMonitoredResourceDescriptorsResponse, PagedResponseWrappers.ListMonitoredResourceDescriptorsPagedResponse> listMonitoredResourceDescriptorsSettings;
    private final PagedCallSettings<ListLogsRequest, ListLogsResponse, PagedResponseWrappers.ListLogsPagedResponse> listLogsSettings;
    private static final PagedListDescriptor<ListLogEntriesRequest, ListLogEntriesResponse, LogEntry> LIST_LOG_ENTRIES_PAGE_STR_DESC;
    private static final PagedListDescriptor<ListMonitoredResourceDescriptorsRequest, ListMonitoredResourceDescriptorsResponse, MonitoredResourceDescriptor> LIST_MONITORED_RESOURCE_DESCRIPTORS_PAGE_STR_DESC;
    private static final PagedListDescriptor<ListLogsRequest, ListLogsResponse, String> LIST_LOGS_PAGE_STR_DESC;
    private static final PagedListResponseFactory<ListLogEntriesRequest, ListLogEntriesResponse, PagedResponseWrappers.ListLogEntriesPagedResponse> LIST_LOG_ENTRIES_PAGE_STR_FACT;
    private static final PagedListResponseFactory<ListMonitoredResourceDescriptorsRequest, ListMonitoredResourceDescriptorsResponse, PagedResponseWrappers.ListMonitoredResourceDescriptorsPagedResponse> LIST_MONITORED_RESOURCE_DESCRIPTORS_PAGE_STR_FACT;
    private static final PagedListResponseFactory<ListLogsRequest, ListLogsResponse, PagedResponseWrappers.ListLogsPagedResponse> LIST_LOGS_PAGE_STR_FACT;
    private static final BatchingDescriptor<WriteLogEntriesRequest, WriteLogEntriesResponse> WRITE_LOG_ENTRIES_BATCHING_DESC;

    public SimpleCallSettings<DeleteLogRequest, Empty> deleteLogSettings() {
        return this.deleteLogSettings;
    }

    public BatchingCallSettings<WriteLogEntriesRequest, WriteLogEntriesResponse> writeLogEntriesSettings() {
        return this.writeLogEntriesSettings;
    }

    public PagedCallSettings<ListLogEntriesRequest, ListLogEntriesResponse, PagedResponseWrappers.ListLogEntriesPagedResponse> listLogEntriesSettings() {
        return this.listLogEntriesSettings;
    }

    public PagedCallSettings<ListMonitoredResourceDescriptorsRequest, ListMonitoredResourceDescriptorsResponse, PagedResponseWrappers.ListMonitoredResourceDescriptorsPagedResponse> listMonitoredResourceDescriptorsSettings() {
        return this.listMonitoredResourceDescriptorsSettings;
    }

    public PagedCallSettings<ListLogsRequest, ListLogsResponse, PagedResponseWrappers.ListLogsPagedResponse> listLogsSettings() {
        return this.listLogsSettings;
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "logging.googleapis.com:443";
    }

    public static ImmutableList<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingChannelProvider.Builder defaultChannelProviderBuilder() {
        return InstantiatingChannelProvider.newBuilder().setEndpoint(LoggingSettings.getDefaultEndpoint()).setGeneratorHeader(DEFAULT_GAPIC_NAME, LoggingSettings.getGapicVersion()).setCredentialsProvider((CredentialsProvider)LoggingSettings.defaultCredentialsProviderBuilder().build());
    }

    private static String getGapicVersion() {
        if (gapicVersion == null) {
            gapicVersion = PropertiesProvider.loadProperty(LoggingSettings.class, (String)PROPERTIES_FILE, (String)META_VERSION_KEY);
            gapicVersion = gapicVersion == null ? DEFAULT_GAPIC_VERSION : gapicVersion;
        }
        return gapicVersion;
    }

    public static Builder defaultBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private LoggingSettings(Builder settingsBuilder) throws IOException {
        super(settingsBuilder.getExecutorProvider(), settingsBuilder.getChannelProvider());
        this.deleteLogSettings = settingsBuilder.deleteLogSettings().build();
        this.writeLogEntriesSettings = settingsBuilder.writeLogEntriesSettings().build();
        this.listLogEntriesSettings = settingsBuilder.listLogEntriesSettings().build();
        this.listMonitoredResourceDescriptorsSettings = settingsBuilder.listMonitoredResourceDescriptorsSettings().build();
        this.listLogsSettings = settingsBuilder.listLogsSettings().build();
    }

    static {
        LIST_LOG_ENTRIES_PAGE_STR_DESC = new PagedListDescriptor<ListLogEntriesRequest, ListLogEntriesResponse, LogEntry>(){

            public String emptyToken() {
                return LoggingSettings.DEFAULT_GAPIC_VERSION;
            }

            public ListLogEntriesRequest injectToken(ListLogEntriesRequest payload, String token) {
                return ListLogEntriesRequest.newBuilder((ListLogEntriesRequest)payload).setPageToken(token).build();
            }

            public ListLogEntriesRequest injectPageSize(ListLogEntriesRequest payload, int pageSize) {
                return ListLogEntriesRequest.newBuilder((ListLogEntriesRequest)payload).setPageSize(pageSize).build();
            }

            public Integer extractPageSize(ListLogEntriesRequest payload) {
                return payload.getPageSize();
            }

            public String extractNextToken(ListLogEntriesResponse payload) {
                return payload.getNextPageToken();
            }

            public Iterable<LogEntry> extractResources(ListLogEntriesResponse payload) {
                return payload.getEntriesList();
            }
        };
        LIST_MONITORED_RESOURCE_DESCRIPTORS_PAGE_STR_DESC = new PagedListDescriptor<ListMonitoredResourceDescriptorsRequest, ListMonitoredResourceDescriptorsResponse, MonitoredResourceDescriptor>(){

            public String emptyToken() {
                return LoggingSettings.DEFAULT_GAPIC_VERSION;
            }

            public ListMonitoredResourceDescriptorsRequest injectToken(ListMonitoredResourceDescriptorsRequest payload, String token) {
                return ListMonitoredResourceDescriptorsRequest.newBuilder((ListMonitoredResourceDescriptorsRequest)payload).setPageToken(token).build();
            }

            public ListMonitoredResourceDescriptorsRequest injectPageSize(ListMonitoredResourceDescriptorsRequest payload, int pageSize) {
                return ListMonitoredResourceDescriptorsRequest.newBuilder((ListMonitoredResourceDescriptorsRequest)payload).setPageSize(pageSize).build();
            }

            public Integer extractPageSize(ListMonitoredResourceDescriptorsRequest payload) {
                return payload.getPageSize();
            }

            public String extractNextToken(ListMonitoredResourceDescriptorsResponse payload) {
                return payload.getNextPageToken();
            }

            public Iterable<MonitoredResourceDescriptor> extractResources(ListMonitoredResourceDescriptorsResponse payload) {
                return payload.getResourceDescriptorsList();
            }
        };
        LIST_LOGS_PAGE_STR_DESC = new PagedListDescriptor<ListLogsRequest, ListLogsResponse, String>(){

            public String emptyToken() {
                return LoggingSettings.DEFAULT_GAPIC_VERSION;
            }

            public ListLogsRequest injectToken(ListLogsRequest payload, String token) {
                return ListLogsRequest.newBuilder((ListLogsRequest)payload).setPageToken(token).build();
            }

            public ListLogsRequest injectPageSize(ListLogsRequest payload, int pageSize) {
                return ListLogsRequest.newBuilder((ListLogsRequest)payload).setPageSize(pageSize).build();
            }

            public Integer extractPageSize(ListLogsRequest payload) {
                return payload.getPageSize();
            }

            public String extractNextToken(ListLogsResponse payload) {
                return payload.getNextPageToken();
            }

            public Iterable<String> extractResources(ListLogsResponse payload) {
                return payload.getLogNamesList();
            }
        };
        LIST_LOG_ENTRIES_PAGE_STR_FACT = new PagedListResponseFactory<ListLogEntriesRequest, ListLogEntriesResponse, PagedResponseWrappers.ListLogEntriesPagedResponse>(){

            public ApiFuture<PagedResponseWrappers.ListLogEntriesPagedResponse> getFuturePagedResponse(UnaryCallable<ListLogEntriesRequest, ListLogEntriesResponse> callable, ListLogEntriesRequest request, CallContext context, ApiFuture<ListLogEntriesResponse> futureResponse) {
                PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOG_ENTRIES_PAGE_STR_DESC, (Object)request, (CallContext)context);
                return PagedResponseWrappers.ListLogEntriesPagedResponse.createAsync((PageContext<ListLogEntriesRequest, ListLogEntriesResponse, LogEntry>)pageContext, futureResponse);
            }
        };
        LIST_MONITORED_RESOURCE_DESCRIPTORS_PAGE_STR_FACT = new PagedListResponseFactory<ListMonitoredResourceDescriptorsRequest, ListMonitoredResourceDescriptorsResponse, PagedResponseWrappers.ListMonitoredResourceDescriptorsPagedResponse>(){

            public ApiFuture<PagedResponseWrappers.ListMonitoredResourceDescriptorsPagedResponse> getFuturePagedResponse(UnaryCallable<ListMonitoredResourceDescriptorsRequest, ListMonitoredResourceDescriptorsResponse> callable, ListMonitoredResourceDescriptorsRequest request, CallContext context, ApiFuture<ListMonitoredResourceDescriptorsResponse> futureResponse) {
                PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_MONITORED_RESOURCE_DESCRIPTORS_PAGE_STR_DESC, (Object)request, (CallContext)context);
                return PagedResponseWrappers.ListMonitoredResourceDescriptorsPagedResponse.createAsync((PageContext<ListMonitoredResourceDescriptorsRequest, ListMonitoredResourceDescriptorsResponse, MonitoredResourceDescriptor>)pageContext, futureResponse);
            }
        };
        LIST_LOGS_PAGE_STR_FACT = new PagedListResponseFactory<ListLogsRequest, ListLogsResponse, PagedResponseWrappers.ListLogsPagedResponse>(){

            public ApiFuture<PagedResponseWrappers.ListLogsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLogsRequest, ListLogsResponse> callable, ListLogsRequest request, CallContext context, ApiFuture<ListLogsResponse> futureResponse) {
                PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOGS_PAGE_STR_DESC, (Object)request, (CallContext)context);
                return PagedResponseWrappers.ListLogsPagedResponse.createAsync((PageContext<ListLogsRequest, ListLogsResponse, String>)pageContext, futureResponse);
            }
        };
        WRITE_LOG_ENTRIES_BATCHING_DESC = new BatchingDescriptor<WriteLogEntriesRequest, WriteLogEntriesResponse>(){

            public PartitionKey getBatchPartitionKey(WriteLogEntriesRequest request) {
                return new PartitionKey(new Object[]{request.getLogName(), request.getResource(), request.getLabels()});
            }

            public RequestBuilder<WriteLogEntriesRequest> getRequestBuilder() {
                return new RequestBuilder<WriteLogEntriesRequest>(){
                    private WriteLogEntriesRequest.Builder builder;

                    public void appendRequest(WriteLogEntriesRequest request) {
                        if (this.builder == null) {
                            this.builder = request.toBuilder();
                        } else {
                            this.builder.addAllEntries((Iterable)request.getEntriesList());
                        }
                    }

                    public WriteLogEntriesRequest build() {
                        return this.builder.build();
                    }
                };
            }

            public void splitResponse(WriteLogEntriesResponse batchResponse, Collection<? extends BatchedRequestIssuer<WriteLogEntriesResponse>> batch) {
                boolean batchMessageIndex = false;
                for (BatchedRequestIssuer<WriteLogEntriesResponse> batchedRequestIssuer : batch) {
                    WriteLogEntriesResponse response = WriteLogEntriesResponse.newBuilder().build();
                    batchedRequestIssuer.setResponse((Object)response);
                }
            }

            public void splitException(Throwable throwable, Collection<? extends BatchedRequestIssuer<WriteLogEntriesResponse>> batch) {
                for (BatchedRequestIssuer<WriteLogEntriesResponse> batchedRequestIssuer : batch) {
                    batchedRequestIssuer.setException(throwable);
                }
            }

            public long countElements(WriteLogEntriesRequest request) {
                return request.getEntriesCount();
            }

            public long countBytes(WriteLogEntriesRequest request) {
                return request.getSerializedSize();
            }
        };
    }

    public static class Builder
    extends ClientSettings.Builder {
        private final ImmutableList<UnaryCallSettings.Builder> unaryMethodSettingsBuilders;
        private final SimpleCallSettings.Builder<DeleteLogRequest, Empty> deleteLogSettings;
        private final BatchingCallSettings.Builder<WriteLogEntriesRequest, WriteLogEntriesResponse> writeLogEntriesSettings;
        private final PagedCallSettings.Builder<ListLogEntriesRequest, ListLogEntriesResponse, PagedResponseWrappers.ListLogEntriesPagedResponse> listLogEntriesSettings;
        private final PagedCallSettings.Builder<ListMonitoredResourceDescriptorsRequest, ListMonitoredResourceDescriptorsResponse, PagedResponseWrappers.ListMonitoredResourceDescriptorsPagedResponse> listMonitoredResourceDescriptorsSettings;
        private final PagedCallSettings.Builder<ListLogsRequest, ListLogsResponse, PagedResponseWrappers.ListLogsPagedResponse> listLogsSettings;
        private static final ImmutableMap<String, ImmutableSet<Status.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings.Builder> RETRY_PARAM_DEFINITIONS;

        private Builder() {
            super(LoggingSettings.defaultChannelProviderBuilder().build());
            this.deleteLogSettings = SimpleCallSettings.newBuilder((MethodDescriptor)LoggingServiceV2Grpc.METHOD_DELETE_LOG);
            this.writeLogEntriesSettings = BatchingCallSettings.newBuilder((MethodDescriptor)LoggingServiceV2Grpc.METHOD_WRITE_LOG_ENTRIES, (BatchingDescriptor)WRITE_LOG_ENTRIES_BATCHING_DESC).setBatchingSettingsBuilder(BatchingSettings.newBuilder());
            this.listLogEntriesSettings = PagedCallSettings.newBuilder((MethodDescriptor)LoggingServiceV2Grpc.METHOD_LIST_LOG_ENTRIES, (PagedListResponseFactory)LIST_LOG_ENTRIES_PAGE_STR_FACT);
            this.listMonitoredResourceDescriptorsSettings = PagedCallSettings.newBuilder((MethodDescriptor)LoggingServiceV2Grpc.METHOD_LIST_MONITORED_RESOURCE_DESCRIPTORS, (PagedListResponseFactory)LIST_MONITORED_RESOURCE_DESCRIPTORS_PAGE_STR_FACT);
            this.listLogsSettings = PagedCallSettings.newBuilder((MethodDescriptor)LoggingServiceV2Grpc.METHOD_LIST_LOGS, (PagedListResponseFactory)LIST_LOGS_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.deleteLogSettings, this.writeLogEntriesSettings, this.listLogEntriesSettings, this.listMonitoredResourceDescriptorsSettings, this.listLogsSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder();
            builder.deleteLogSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.writeLogEntriesSettings().getBatchingSettingsBuilder().setElementCountThreshold(Integer.valueOf(1000)).setRequestByteThreshold(Integer.valueOf(0x100000)).setDelayThreshold(Duration.millis((long)50L)).setFlowControlSettings(FlowControlSettings.newBuilder().setMaxOutstandingElementCount(Integer.valueOf(100000)).setMaxOutstandingRequestBytes(Integer.valueOf(0xA00000)).setLimitExceededBehavior(FlowController.LimitExceededBehavior.ThrowException).build());
            builder.writeLogEntriesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listLogEntriesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"list"));
            builder.listMonitoredResourceDescriptorsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listLogsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        private Builder(LoggingSettings settings) {
            super((ClientSettings)settings);
            this.deleteLogSettings = settings.deleteLogSettings.toBuilder();
            this.writeLogEntriesSettings = settings.writeLogEntriesSettings.toBuilder();
            this.listLogEntriesSettings = settings.listLogEntriesSettings.toBuilder();
            this.listMonitoredResourceDescriptorsSettings = settings.listMonitoredResourceDescriptorsSettings.toBuilder();
            this.listLogsSettings = settings.listLogsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.deleteLogSettings, this.writeLogEntriesSettings, this.listLogEntriesSettings, this.listMonitoredResourceDescriptorsSettings, this.listLogsSettings);
        }

        public Builder setExecutorProvider(ExecutorProvider executorProvider) {
            super.setExecutorProvider(executorProvider);
            return this;
        }

        public Builder setChannelProvider(ChannelProvider channelProvider) {
            super.setChannelProvider(channelProvider);
            return this;
        }

        public Builder applyToAllUnaryMethods(UnaryCallSettings.Builder unaryCallSettings) throws Exception {
            super.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, unaryCallSettings);
            return this;
        }

        public SimpleCallSettings.Builder<DeleteLogRequest, Empty> deleteLogSettings() {
            return this.deleteLogSettings;
        }

        public BatchingCallSettings.Builder<WriteLogEntriesRequest, WriteLogEntriesResponse> writeLogEntriesSettings() {
            return this.writeLogEntriesSettings;
        }

        public PagedCallSettings.Builder<ListLogEntriesRequest, ListLogEntriesResponse, PagedResponseWrappers.ListLogEntriesPagedResponse> listLogEntriesSettings() {
            return this.listLogEntriesSettings;
        }

        public PagedCallSettings.Builder<ListMonitoredResourceDescriptorsRequest, ListMonitoredResourceDescriptorsResponse, PagedResponseWrappers.ListMonitoredResourceDescriptorsPagedResponse> listMonitoredResourceDescriptorsSettings() {
            return this.listMonitoredResourceDescriptorsSettings;
        }

        public PagedCallSettings.Builder<ListLogsRequest, ListLogsResponse, PagedResponseWrappers.ListLogsPagedResponse> listLogsSettings() {
            return this.listLogsSettings;
        }

        public LoggingSettings build() throws IOException {
            return new LoggingSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)Sets.immutableEnumSet((Iterable)Lists.newArrayList((Object[])new Status.Code[]{Status.Code.DEADLINE_EXCEEDED, Status.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)Sets.immutableEnumSet((Iterable)Lists.newArrayList((Object[])new Status.Code[]{Status.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings.Builder settingsBuilder = null;
            settingsBuilder = RetrySettings.newBuilder().setInitialRetryDelay(Duration.millis((long)100L)).setRetryDelayMultiplier(1.2).setMaxRetryDelay(Duration.millis((long)1000L)).setInitialRpcTimeout(Duration.millis((long)2000L)).setRpcTimeoutMultiplier(1.5).setMaxRpcTimeout(Duration.millis((long)30000L)).setTotalTimeout(Duration.millis((long)45000L));
            definitions.put((Object)"default", (Object)settingsBuilder);
            settingsBuilder = RetrySettings.newBuilder().setInitialRetryDelay(Duration.millis((long)100L)).setRetryDelayMultiplier(1.2).setMaxRetryDelay(Duration.millis((long)1000L)).setInitialRpcTimeout(Duration.millis((long)7000L)).setRpcTimeoutMultiplier(1.5).setMaxRpcTimeout(Duration.millis((long)30000L)).setTotalTimeout(Duration.millis((long)45000L));
            definitions.put((Object)"list", (Object)settingsBuilder);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

