/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.logging;

import com.google.cloud.logging.Logging;
import com.google.cloud.logging.LoggingOptions;
import com.google.cloud.logging.MetricInfo;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.logging.v2.LogMetric;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Objects;
import java.util.concurrent.Future;

public class Metric
extends MetricInfo {
    private static final long serialVersionUID = -1549310461066853001L;
    private final LoggingOptions options;
    private transient Logging logging;

    Metric(Logging logging, MetricInfo.BuilderImpl builder) {
        super(builder);
        this.logging = (Logging)Preconditions.checkNotNull((Object)logging);
        this.options = (LoggingOptions)logging.options();
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Override
    public final int hashCode() {
        return Objects.hash(new Object[]{this.options, super.hashCode()});
    }

    @Override
    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(Metric.class)) {
            return false;
        }
        Metric other = (Metric)obj;
        return this.baseEquals(other) && Objects.equals((Object)this.options, (Object)other.options);
    }

    public Logging logging() {
        return this.logging;
    }

    public boolean delete() {
        return this.logging.deleteMetric(this.name());
    }

    public Future<Boolean> deleteAsync() {
        return this.logging.deleteMetricAsync(this.name());
    }

    public Metric reload() {
        return this.logging.getMetric(this.name());
    }

    public Future<Metric> reloadAsync() {
        return this.logging.getMetricAsync(this.name());
    }

    public Metric update(MetricInfo metricInfo) {
        return this.logging.update(metricInfo);
    }

    public Future<Metric> updateAsync(MetricInfo metricInfo) {
        return this.logging.updateAsync(metricInfo);
    }

    private void readObject(ObjectInputStream input) throws IOException, ClassNotFoundException {
        input.defaultReadObject();
        this.logging = (Logging)this.options.service();
    }

    static Metric fromPb(Logging logging, LogMetric metricPb) {
        MetricInfo metricInfo = MetricInfo.fromPb(metricPb);
        return new Metric(logging, new MetricInfo.BuilderImpl(metricInfo));
    }

    static Function<LogMetric, Metric> fromPbFunction(final Logging logging) {
        return new Function<LogMetric, Metric>(){

            public Metric apply(LogMetric metricPb) {
                return metricPb != null ? Metric.fromPb(logging, metricPb) : null;
            }
        };
    }

    public static final class Builder
    extends MetricInfo.Builder {
        private final Logging logging;
        private final MetricInfo.BuilderImpl delegate;

        private Builder(Metric metric) {
            this.logging = metric.logging;
            this.delegate = new MetricInfo.BuilderImpl(metric);
        }

        @Override
        public Builder name(String name) {
            this.delegate.name(name);
            return this;
        }

        @Override
        public Builder description(String description) {
            this.delegate.description(description);
            return this;
        }

        @Override
        public Builder filter(String filter) {
            this.delegate.filter(filter);
            return this;
        }

        @Override
        public Metric build() {
            return new Metric(this.logging, this.delegate);
        }
    }
}

