/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.logging.spi;

import com.google.api.gax.core.ConnectionSettings;
import com.google.api.gax.grpc.ApiCallSettings;
import com.google.api.gax.grpc.ApiException;
import com.google.cloud.AuthCredentials;
import com.google.cloud.GrpcServiceOptions;
import com.google.cloud.logging.LoggingException;
import com.google.cloud.logging.LoggingOptions;
import com.google.cloud.logging.spi.LoggingRpc;
import com.google.cloud.logging.spi.v2.ConfigServiceV2Api;
import com.google.cloud.logging.spi.v2.ConfigServiceV2Settings;
import com.google.cloud.logging.spi.v2.LoggingServiceV2Api;
import com.google.cloud.logging.spi.v2.LoggingServiceV2Settings;
import com.google.cloud.logging.spi.v2.MetricsServiceV2Api;
import com.google.cloud.logging.spi.v2.MetricsServiceV2Settings;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.logging.v2.CreateLogMetricRequest;
import com.google.logging.v2.CreateSinkRequest;
import com.google.logging.v2.DeleteLogMetricRequest;
import com.google.logging.v2.DeleteLogRequest;
import com.google.logging.v2.DeleteSinkRequest;
import com.google.logging.v2.GetLogMetricRequest;
import com.google.logging.v2.GetSinkRequest;
import com.google.logging.v2.ListLogEntriesRequest;
import com.google.logging.v2.ListLogEntriesResponse;
import com.google.logging.v2.ListLogMetricsRequest;
import com.google.logging.v2.ListLogMetricsResponse;
import com.google.logging.v2.ListMonitoredResourceDescriptorsRequest;
import com.google.logging.v2.ListMonitoredResourceDescriptorsResponse;
import com.google.logging.v2.ListSinksRequest;
import com.google.logging.v2.ListSinksResponse;
import com.google.logging.v2.LogMetric;
import com.google.logging.v2.LogSink;
import com.google.logging.v2.UpdateLogMetricRequest;
import com.google.logging.v2.UpdateSinkRequest;
import com.google.logging.v2.WriteLogEntriesRequest;
import com.google.logging.v2.WriteLogEntriesResponse;
import com.google.protobuf.Empty;
import io.grpc.ManagedChannel;
import io.grpc.Status;
import io.grpc.internal.ManagedChannelImpl;
import io.grpc.netty.NegotiationType;
import io.grpc.netty.NettyChannelBuilder;
import java.io.IOException;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;

public class DefaultLoggingRpc
implements LoggingRpc {
    private final ConfigServiceV2Api configApi;
    private final LoggingServiceV2Api loggingApi;
    private final MetricsServiceV2Api metricsApi;
    private final ScheduledExecutorService executor;
    private final GrpcServiceOptions.ExecutorFactory<ScheduledExecutorService> executorFactory;
    private boolean closed;

    public DefaultLoggingRpc(LoggingOptions options) throws IOException {
        InternalLoggingOptions internalOptions = new InternalLoggingOptions(options);
        this.executorFactory = internalOptions.executorFactory();
        this.executor = (ScheduledExecutorService)this.executorFactory.get();
        String libraryName = options.libraryName();
        String libraryVersion = (String)MoreObjects.firstNonNull((Object)options.libraryVersion(), (Object)"");
        try {
            ConfigServiceV2Settings.Builder confBuilder = ConfigServiceV2Settings.defaultBuilder().provideExecutorWith(this.executor, false).setClientLibHeader(libraryName, libraryVersion);
            LoggingServiceV2Settings.Builder logBuilder = LoggingServiceV2Settings.defaultBuilder().provideExecutorWith(this.executor, false).setClientLibHeader(libraryName, libraryVersion);
            MetricsServiceV2Settings.Builder metricsBuilder = MetricsServiceV2Settings.defaultBuilder().provideExecutorWith(this.executor, false).setClientLibHeader(libraryName, libraryVersion);
            if (options.host().contains("localhost") || options.authCredentials().equals(AuthCredentials.noAuth())) {
                ManagedChannelImpl channel = NettyChannelBuilder.forTarget((String)options.host()).negotiationType(NegotiationType.PLAINTEXT).build();
                confBuilder.provideChannelWith((ManagedChannel)channel, true);
                logBuilder.provideChannelWith((ManagedChannel)channel, true);
                metricsBuilder.provideChannelWith((ManagedChannel)channel, true);
            } else {
                ConnectionSettings connectionSettings = internalOptions.connectionSettings().build();
                confBuilder.provideChannelWith(connectionSettings);
                logBuilder.provideChannelWith(connectionSettings);
                metricsBuilder.provideChannelWith(connectionSettings);
            }
            ApiCallSettings.Builder callSettingsBuilder = internalOptions.apiCallSettings();
            confBuilder.applyToAllApiMethods(callSettingsBuilder);
            logBuilder.applyToAllApiMethods(callSettingsBuilder);
            metricsBuilder.applyToAllApiMethods(callSettingsBuilder);
            this.configApi = ConfigServiceV2Api.create(confBuilder.build());
            this.loggingApi = LoggingServiceV2Api.create(logBuilder.build());
            this.metricsApi = MetricsServiceV2Api.create(metricsBuilder.build());
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }

    private static <V> Future<V> translate(ListenableFuture<V> from, final boolean idempotent, int ... returnNullOn) {
        final HashSet returnNullOnSet = Sets.newHashSetWithExpectedSize((int)returnNullOn.length);
        for (int value : returnNullOn) {
            returnNullOnSet.add(value);
        }
        return Futures.catching(from, ApiException.class, (Function)new Function<ApiException, V>(){

            public V apply(ApiException exception) {
                if (returnNullOnSet.contains(exception.getStatusCode().value())) {
                    return null;
                }
                throw new LoggingException(exception, idempotent);
            }
        });
    }

    @Override
    public Future<LogSink> create(CreateSinkRequest request) {
        return DefaultLoggingRpc.translate(this.configApi.createSinkCallable().futureCall((Object)request), true, new int[0]);
    }

    @Override
    public Future<LogSink> update(UpdateSinkRequest request) {
        return DefaultLoggingRpc.translate(this.configApi.updateSinkCallable().futureCall((Object)request), true, new int[0]);
    }

    @Override
    public Future<LogSink> get(GetSinkRequest request) {
        return DefaultLoggingRpc.translate(this.configApi.getSinkCallable().futureCall((Object)request), true, Status.Code.NOT_FOUND.value());
    }

    @Override
    public Future<ListSinksResponse> list(ListSinksRequest request) {
        return DefaultLoggingRpc.translate(this.configApi.listSinksCallable().futureCall((Object)request), true, new int[0]);
    }

    @Override
    public Future<Empty> delete(DeleteSinkRequest request) {
        return DefaultLoggingRpc.translate(this.configApi.deleteSinkCallable().futureCall((Object)request), true, new int[0]);
    }

    @Override
    public Future<Empty> delete(DeleteLogRequest request) {
        return DefaultLoggingRpc.translate(this.loggingApi.deleteLogCallable().futureCall((Object)request), true, Status.Code.NOT_FOUND.value());
    }

    @Override
    public Future<WriteLogEntriesResponse> write(WriteLogEntriesRequest request) {
        return DefaultLoggingRpc.translate(this.loggingApi.writeLogEntriesCallable().futureCall((Object)request), false, new int[0]);
    }

    @Override
    public Future<ListLogEntriesResponse> list(ListLogEntriesRequest request) {
        return DefaultLoggingRpc.translate(this.loggingApi.listLogEntriesCallable().futureCall((Object)request), true, new int[0]);
    }

    @Override
    public Future<ListMonitoredResourceDescriptorsResponse> list(ListMonitoredResourceDescriptorsRequest request) {
        return DefaultLoggingRpc.translate(this.loggingApi.listMonitoredResourceDescriptorsCallable().futureCall((Object)request), true, new int[0]);
    }

    @Override
    public Future<LogMetric> create(CreateLogMetricRequest request) {
        return DefaultLoggingRpc.translate(this.metricsApi.createLogMetricCallable().futureCall((Object)request), true, new int[0]);
    }

    @Override
    public Future<LogMetric> update(UpdateLogMetricRequest request) {
        return DefaultLoggingRpc.translate(this.metricsApi.updateLogMetricCallable().futureCall((Object)request), true, new int[0]);
    }

    @Override
    public Future<LogMetric> get(GetLogMetricRequest request) {
        return DefaultLoggingRpc.translate(this.metricsApi.getLogMetricCallable().futureCall((Object)request), true, Status.Code.NOT_FOUND.value());
    }

    @Override
    public Future<ListLogMetricsResponse> list(ListLogMetricsRequest request) {
        return DefaultLoggingRpc.translate(this.metricsApi.listLogMetricsCallable().futureCall((Object)request), true, new int[0]);
    }

    @Override
    public Future<Empty> delete(DeleteLogMetricRequest request) {
        return DefaultLoggingRpc.translate(this.metricsApi.deleteLogMetricCallable().futureCall((Object)request), true, Status.Code.NOT_FOUND.value());
    }

    @Override
    public void close() throws Exception {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.configApi.close();
        this.loggingApi.close();
        this.metricsApi.close();
        this.executorFactory.release((ExecutorService)this.executor);
    }

    private static final class InternalLoggingOptions
    extends LoggingOptions {
        private static final long serialVersionUID = -2107638980310672033L;

        private InternalLoggingOptions(LoggingOptions options) {
            super(options.toBuilder());
        }

        @Override
        protected GrpcServiceOptions.ExecutorFactory<ScheduledExecutorService> executorFactory() {
            return super.executorFactory();
        }

        protected ApiCallSettings.Builder apiCallSettings() {
            return super.apiCallSettings();
        }

        protected ConnectionSettings.Builder connectionSettings() {
            return super.connectionSettings();
        }
    }
}

