/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.logging.spi.v2;

import com.google.api.gax.core.ConnectionSettings;
import com.google.api.gax.core.RetrySettings;
import com.google.api.gax.grpc.ApiCallSettings;
import com.google.api.gax.grpc.PageStreamingCallSettings;
import com.google.api.gax.grpc.PageStreamingDescriptor;
import com.google.api.gax.grpc.ServiceApiSettings;
import com.google.api.gax.grpc.SimpleCallSettings;
import com.google.auth.Credentials;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.logging.v2.ConfigServiceV2Grpc;
import com.google.logging.v2.CreateSinkRequest;
import com.google.logging.v2.DeleteSinkRequest;
import com.google.logging.v2.GetSinkRequest;
import com.google.logging.v2.ListSinksRequest;
import com.google.logging.v2.ListSinksResponse;
import com.google.logging.v2.LogSink;
import com.google.logging.v2.UpdateSinkRequest;
import com.google.protobuf.Empty;
import io.grpc.ManagedChannel;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import org.joda.time.Duration;

public class ConfigServiceV2Settings
extends ServiceApiSettings {
    private static final String DEFAULT_SERVICE_ADDRESS = "logging.googleapis.com";
    private static final int DEFAULT_SERVICE_PORT = 443;
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/cloud-platform.read-only").add((Object)"https://www.googleapis.com/auth/logging.admin").add((Object)"https://www.googleapis.com/auth/logging.read").add((Object)"https://www.googleapis.com/auth/logging.write").build();
    public static final ConnectionSettings DEFAULT_CONNECTION_SETTINGS = ConnectionSettings.newBuilder().setServiceAddress("logging.googleapis.com").setPort(443).provideCredentialsWith(DEFAULT_SERVICE_SCOPES).build();
    private final PageStreamingCallSettings<ListSinksRequest, ListSinksResponse, LogSink> listSinksSettings;
    private final SimpleCallSettings<GetSinkRequest, LogSink> getSinkSettings;
    private final SimpleCallSettings<CreateSinkRequest, LogSink> createSinkSettings;
    private final SimpleCallSettings<UpdateSinkRequest, LogSink> updateSinkSettings;
    private final SimpleCallSettings<DeleteSinkRequest, Empty> deleteSinkSettings;
    private static PageStreamingDescriptor<ListSinksRequest, ListSinksResponse, LogSink> LIST_SINKS_PAGE_STR_DESC = new PageStreamingDescriptor<ListSinksRequest, ListSinksResponse, LogSink>(){

        public Object emptyToken() {
            return "";
        }

        public ListSinksRequest injectToken(ListSinksRequest payload, Object token) {
            return ListSinksRequest.newBuilder((ListSinksRequest)payload).setPageToken((String)token).build();
        }

        public Object extractNextToken(ListSinksResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<LogSink> extractResources(ListSinksResponse payload) {
            return payload.getSinksList();
        }
    };

    public PageStreamingCallSettings<ListSinksRequest, ListSinksResponse, LogSink> listSinksSettings() {
        return this.listSinksSettings;
    }

    public SimpleCallSettings<GetSinkRequest, LogSink> getSinkSettings() {
        return this.getSinkSettings;
    }

    public SimpleCallSettings<CreateSinkRequest, LogSink> createSinkSettings() {
        return this.createSinkSettings;
    }

    public SimpleCallSettings<UpdateSinkRequest, LogSink> updateSinkSettings() {
        return this.updateSinkSettings;
    }

    public SimpleCallSettings<DeleteSinkRequest, Empty> deleteSinkSettings() {
        return this.deleteSinkSettings;
    }

    public static String getDefaultServiceAddress() {
        return DEFAULT_SERVICE_ADDRESS;
    }

    public static int getDefaultServicePort() {
        return 443;
    }

    public static ImmutableList<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static Builder defaultBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ConfigServiceV2Settings(Builder settingsBuilder) throws IOException {
        super(settingsBuilder.getChannelProvider(), settingsBuilder.getExecutorProvider(), settingsBuilder.getGeneratorName(), settingsBuilder.getGeneratorVersion(), settingsBuilder.getClientLibName(), settingsBuilder.getClientLibVersion());
        this.listSinksSettings = settingsBuilder.listSinksSettings().build();
        this.getSinkSettings = settingsBuilder.getSinkSettings().build();
        this.createSinkSettings = settingsBuilder.createSinkSettings().build();
        this.updateSinkSettings = settingsBuilder.updateSinkSettings().build();
        this.deleteSinkSettings = settingsBuilder.deleteSinkSettings().build();
    }

    public static class Builder
    extends ServiceApiSettings.Builder {
        private final ImmutableList<ApiCallSettings.Builder> methodSettingsBuilders;
        private PageStreamingCallSettings.Builder<ListSinksRequest, ListSinksResponse, LogSink> listSinksSettings;
        private SimpleCallSettings.Builder<GetSinkRequest, LogSink> getSinkSettings;
        private SimpleCallSettings.Builder<CreateSinkRequest, LogSink> createSinkSettings;
        private SimpleCallSettings.Builder<UpdateSinkRequest, LogSink> updateSinkSettings;
        private SimpleCallSettings.Builder<DeleteSinkRequest, Empty> deleteSinkSettings;
        private static final ImmutableMap<String, ImmutableSet<Status.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings.Builder> RETRY_PARAM_DEFINITIONS;

        private Builder() {
            super(DEFAULT_CONNECTION_SETTINGS);
            this.listSinksSettings = PageStreamingCallSettings.newBuilder((MethodDescriptor)ConfigServiceV2Grpc.METHOD_LIST_SINKS, (PageStreamingDescriptor)LIST_SINKS_PAGE_STR_DESC);
            this.getSinkSettings = SimpleCallSettings.newBuilder((MethodDescriptor)ConfigServiceV2Grpc.METHOD_GET_SINK);
            this.createSinkSettings = SimpleCallSettings.newBuilder((MethodDescriptor)ConfigServiceV2Grpc.METHOD_CREATE_SINK);
            this.updateSinkSettings = SimpleCallSettings.newBuilder((MethodDescriptor)ConfigServiceV2Grpc.METHOD_UPDATE_SINK);
            this.deleteSinkSettings = SimpleCallSettings.newBuilder((MethodDescriptor)ConfigServiceV2Grpc.METHOD_DELETE_SINK);
            this.methodSettingsBuilders = ImmutableList.of(this.listSinksSettings, this.getSinkSettings, this.createSinkSettings, this.updateSinkSettings, this.deleteSinkSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder();
            builder.listSinksSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getSinkSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.createSinkSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.updateSinkSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.deleteSinkSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        private Builder(ConfigServiceV2Settings settings) {
            super((ServiceApiSettings)settings);
            this.listSinksSettings = settings.listSinksSettings.toBuilder();
            this.getSinkSettings = settings.getSinkSettings.toBuilder();
            this.createSinkSettings = settings.createSinkSettings.toBuilder();
            this.updateSinkSettings = settings.updateSinkSettings.toBuilder();
            this.deleteSinkSettings = settings.deleteSinkSettings.toBuilder();
            this.methodSettingsBuilders = ImmutableList.of(this.listSinksSettings, this.getSinkSettings, this.createSinkSettings, this.updateSinkSettings, this.deleteSinkSettings);
        }

        protected ConnectionSettings getDefaultConnectionSettings() {
            return DEFAULT_CONNECTION_SETTINGS;
        }

        public Builder provideExecutorWith(ScheduledExecutorService executor, boolean shouldAutoClose) {
            super.provideExecutorWith(executor, shouldAutoClose);
            return this;
        }

        public Builder provideChannelWith(ManagedChannel channel, boolean shouldAutoClose) {
            super.provideChannelWith(channel, shouldAutoClose);
            return this;
        }

        public Builder provideChannelWith(ConnectionSettings settings) {
            super.provideChannelWith(settings);
            return this;
        }

        public Builder provideChannelWith(Credentials credentials) {
            super.provideChannelWith(credentials);
            return this;
        }

        public Builder provideChannelWith(List<String> scopes) {
            super.provideChannelWith(scopes);
            return this;
        }

        public Builder setGeneratorHeader(String name, String version) {
            super.setGeneratorHeader(name, version);
            return this;
        }

        public Builder setClientLibHeader(String name, String version) {
            super.setClientLibHeader(name, version);
            return this;
        }

        public Builder applyToAllApiMethods(ApiCallSettings.Builder apiCallSettings) throws Exception {
            super.applyToAllApiMethods(this.methodSettingsBuilders, apiCallSettings);
            return this;
        }

        public PageStreamingCallSettings.Builder<ListSinksRequest, ListSinksResponse, LogSink> listSinksSettings() {
            return this.listSinksSettings;
        }

        public SimpleCallSettings.Builder<GetSinkRequest, LogSink> getSinkSettings() {
            return this.getSinkSettings;
        }

        public SimpleCallSettings.Builder<CreateSinkRequest, LogSink> createSinkSettings() {
            return this.createSinkSettings;
        }

        public SimpleCallSettings.Builder<UpdateSinkRequest, LogSink> updateSinkSettings() {
            return this.updateSinkSettings;
        }

        public SimpleCallSettings.Builder<DeleteSinkRequest, Empty> deleteSinkSettings() {
            return this.deleteSinkSettings;
        }

        public ConfigServiceV2Settings build() throws IOException {
            return new ConfigServiceV2Settings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)Sets.immutableEnumSet((Iterable)Lists.newArrayList((Object[])new Status.Code[]{Status.Code.DEADLINE_EXCEEDED, Status.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)Sets.immutableEnumSet((Iterable)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings.Builder settingsBuilder = null;
            settingsBuilder = RetrySettings.newBuilder().setInitialRetryDelay(Duration.millis((long)100L)).setRetryDelayMultiplier(1.2).setMaxRetryDelay(Duration.millis((long)1000L)).setInitialRpcTimeout(Duration.millis((long)2000L)).setRpcTimeoutMultiplier(1.5).setMaxRpcTimeout(Duration.millis((long)30000L)).setTotalTimeout(Duration.millis((long)45000L));
            definitions.put((Object)"default", (Object)settingsBuilder);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

