/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.logging;

import com.google.cloud.logging.Logging;
import com.google.cloud.logging.LoggingOptions;
import com.google.cloud.logging.SinkInfo;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.logging.v2.LogSink;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Objects;
import java.util.concurrent.Future;

public class Sink
extends SinkInfo {
    private static final long serialVersionUID = -1549310461066853001L;
    private final LoggingOptions options;
    private transient Logging logging;

    Sink(Logging logging, SinkInfo.BuilderImpl builder) {
        super(builder);
        this.logging = (Logging)Preconditions.checkNotNull((Object)logging);
        this.options = (LoggingOptions)logging.options();
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Override
    public final int hashCode() {
        return Objects.hash(new Object[]{this.options, super.hashCode()});
    }

    @Override
    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(Sink.class)) {
            return false;
        }
        Sink other = (Sink)obj;
        return this.baseEquals(other) && Objects.equals((Object)this.options, (Object)other.options);
    }

    public Logging logging() {
        return this.logging;
    }

    public boolean delete() {
        return this.logging.deleteSink(this.name());
    }

    public Future<Boolean> deleteAsync() {
        return this.logging.deleteSinkAsync(this.name());
    }

    public Sink reload() {
        return this.logging.getSink(this.name());
    }

    public Future<Sink> reloadAsync() {
        return this.logging.getSinkAsync(this.name());
    }

    public Sink update() {
        return this.logging.update(this);
    }

    public Future<Sink> updateAsync() {
        return this.logging.updateAsync(this);
    }

    private void readObject(ObjectInputStream input) throws IOException, ClassNotFoundException {
        input.defaultReadObject();
        this.logging = (Logging)this.options.service();
    }

    static Sink fromPb(Logging logging, LogSink sinkPb) {
        SinkInfo sinkInfo = SinkInfo.fromPb(sinkPb);
        return new Sink(logging, new SinkInfo.BuilderImpl(sinkInfo));
    }

    static Function<LogSink, Sink> fromPbFunction(final Logging logging) {
        return new Function<LogSink, Sink>(){

            public Sink apply(LogSink sinkPb) {
                return sinkPb != null ? Sink.fromPb(logging, sinkPb) : null;
            }
        };
    }

    public static final class Builder
    extends SinkInfo.Builder {
        private final Logging logging;
        private final SinkInfo.BuilderImpl delegate;

        private Builder(Sink sink) {
            this.logging = sink.logging;
            this.delegate = new SinkInfo.BuilderImpl(sink);
        }

        @Override
        public Builder name(String name) {
            this.delegate.name(name);
            return this;
        }

        @Override
        public Builder destination(SinkInfo.Destination destination) {
            this.delegate.destination(destination);
            return this;
        }

        @Override
        public Builder filter(String filter) {
            this.delegate.filter(filter);
            return this;
        }

        @Override
        public Builder versionFormat(SinkInfo.VersionFormat versionFormat) {
            this.delegate.versionFormat(versionFormat);
            return this;
        }

        @Override
        public Sink build() {
            return new Sink(this.logging, this.delegate);
        }
    }
}

