/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.logging.spi.v2;

import com.google.api.gax.grpc.UnaryCallable;
import com.google.api.gax.protobuf.PathTemplate;
import com.google.cloud.logging.spi.v2.ConfigServiceV2Settings;
import com.google.cloud.logging.spi.v2.PagedResponseWrappers;
import com.google.logging.v2.CreateSinkRequest;
import com.google.logging.v2.DeleteSinkRequest;
import com.google.logging.v2.GetSinkRequest;
import com.google.logging.v2.ListSinksRequest;
import com.google.logging.v2.ListSinksResponse;
import com.google.logging.v2.LogSink;
import com.google.logging.v2.UpdateSinkRequest;
import com.google.protobuf.Empty;
import io.grpc.ManagedChannel;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;

public class ConfigServiceV2Api
implements AutoCloseable {
    private final ConfigServiceV2Settings settings;
    private final ManagedChannel channel;
    private final ScheduledExecutorService executor;
    private final List<AutoCloseable> closeables = new ArrayList<AutoCloseable>();
    private final UnaryCallable<ListSinksRequest, ListSinksResponse> listSinksCallable;
    private final UnaryCallable<ListSinksRequest, PagedResponseWrappers.ListSinksPagedResponse> listSinksPagedCallable;
    private final UnaryCallable<GetSinkRequest, LogSink> getSinkCallable;
    private final UnaryCallable<CreateSinkRequest, LogSink> createSinkCallable;
    private final UnaryCallable<UpdateSinkRequest, LogSink> updateSinkCallable;
    private final UnaryCallable<DeleteSinkRequest, Empty> deleteSinkCallable;
    private static final PathTemplate PARENT_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}");
    private static final PathTemplate SINK_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/sinks/{sink}");

    public static final String formatParentName(String project) {
        return PARENT_PATH_TEMPLATE.instantiate(new String[]{"project", project});
    }

    public static final String formatSinkName(String project, String sink) {
        return SINK_PATH_TEMPLATE.instantiate(new String[]{"project", project, "sink", sink});
    }

    public static final String parseProjectFromParentName(String parentName) {
        return PARENT_PATH_TEMPLATE.parse(parentName).get((Object)"project");
    }

    public static final String parseProjectFromSinkName(String sinkName) {
        return SINK_PATH_TEMPLATE.parse(sinkName).get((Object)"project");
    }

    public static final String parseSinkFromSinkName(String sinkName) {
        return SINK_PATH_TEMPLATE.parse(sinkName).get((Object)"sink");
    }

    public static final ConfigServiceV2Api create() throws IOException {
        return ConfigServiceV2Api.create(ConfigServiceV2Settings.defaultBuilder().build());
    }

    public static final ConfigServiceV2Api create(ConfigServiceV2Settings settings) throws IOException {
        return new ConfigServiceV2Api(settings);
    }

    protected ConfigServiceV2Api(ConfigServiceV2Settings settings) throws IOException {
        this.settings = settings;
        this.executor = settings.getExecutorProvider().getOrBuildExecutor();
        this.channel = settings.getChannelProvider().getOrBuildChannel((Executor)this.executor);
        this.listSinksCallable = UnaryCallable.create(settings.listSinksSettings(), (ManagedChannel)this.channel, (ScheduledExecutorService)this.executor);
        this.listSinksPagedCallable = UnaryCallable.createPagedVariant(settings.listSinksSettings(), (ManagedChannel)this.channel, (ScheduledExecutorService)this.executor);
        this.getSinkCallable = UnaryCallable.create(settings.getSinkSettings(), (ManagedChannel)this.channel, (ScheduledExecutorService)this.executor);
        this.createSinkCallable = UnaryCallable.create(settings.createSinkSettings(), (ManagedChannel)this.channel, (ScheduledExecutorService)this.executor);
        this.updateSinkCallable = UnaryCallable.create(settings.updateSinkSettings(), (ManagedChannel)this.channel, (ScheduledExecutorService)this.executor);
        this.deleteSinkCallable = UnaryCallable.create(settings.deleteSinkSettings(), (ManagedChannel)this.channel, (ScheduledExecutorService)this.executor);
        if (settings.getChannelProvider().shouldAutoClose()) {
            this.closeables.add(new Closeable(){

                @Override
                public void close() throws IOException {
                    ConfigServiceV2Api.this.channel.shutdown();
                }
            });
        }
        if (settings.getExecutorProvider().shouldAutoClose()) {
            this.closeables.add(new Closeable(){

                @Override
                public void close() throws IOException {
                    ConfigServiceV2Api.this.executor.shutdown();
                }
            });
        }
    }

    public final ConfigServiceV2Settings getSettings() {
        return this.settings;
    }

    public final PagedResponseWrappers.ListSinksPagedResponse listSinks(String parent) {
        PARENT_PATH_TEMPLATE.validate(parent, "listSinks");
        ListSinksRequest request = ListSinksRequest.newBuilder().setParent(parent).build();
        return this.listSinks(request);
    }

    public final PagedResponseWrappers.ListSinksPagedResponse listSinks(ListSinksRequest request) {
        return (PagedResponseWrappers.ListSinksPagedResponse)((Object)this.listSinksPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListSinksRequest, PagedResponseWrappers.ListSinksPagedResponse> listSinksPagedCallable() {
        return this.listSinksPagedCallable;
    }

    public final UnaryCallable<ListSinksRequest, ListSinksResponse> listSinksCallable() {
        return this.listSinksCallable;
    }

    public final LogSink getSink(String sinkName) {
        SINK_PATH_TEMPLATE.validate(sinkName, "getSink");
        GetSinkRequest request = GetSinkRequest.newBuilder().setSinkName(sinkName).build();
        return this.getSink(request);
    }

    private final LogSink getSink(GetSinkRequest request) {
        return (LogSink)this.getSinkCallable().call((Object)request);
    }

    public final UnaryCallable<GetSinkRequest, LogSink> getSinkCallable() {
        return this.getSinkCallable;
    }

    public final LogSink createSink(String parent, LogSink sink) {
        PARENT_PATH_TEMPLATE.validate(parent, "createSink");
        CreateSinkRequest request = CreateSinkRequest.newBuilder().setParent(parent).setSink(sink).build();
        return this.createSink(request);
    }

    public final LogSink createSink(CreateSinkRequest request) {
        return (LogSink)this.createSinkCallable().call((Object)request);
    }

    public final UnaryCallable<CreateSinkRequest, LogSink> createSinkCallable() {
        return this.createSinkCallable;
    }

    public final LogSink updateSink(String sinkName, LogSink sink) {
        SINK_PATH_TEMPLATE.validate(sinkName, "updateSink");
        UpdateSinkRequest request = UpdateSinkRequest.newBuilder().setSinkName(sinkName).setSink(sink).build();
        return this.updateSink(request);
    }

    public final LogSink updateSink(UpdateSinkRequest request) {
        return (LogSink)this.updateSinkCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateSinkRequest, LogSink> updateSinkCallable() {
        return this.updateSinkCallable;
    }

    public final void deleteSink(String sinkName) {
        SINK_PATH_TEMPLATE.validate(sinkName, "deleteSink");
        DeleteSinkRequest request = DeleteSinkRequest.newBuilder().setSinkName(sinkName).build();
        this.deleteSink(request);
    }

    private final void deleteSink(DeleteSinkRequest request) {
        this.deleteSinkCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteSinkRequest, Empty> deleteSinkCallable() {
        return this.deleteSinkCallable;
    }

    @Override
    public final void close() throws Exception {
        for (AutoCloseable closeable : this.closeables) {
            closeable.close();
        }
    }
}

