/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.logging.spi.v2;

import com.google.api.MonitoredResource;
import com.google.api.gax.grpc.UnaryCallable;
import com.google.api.gax.protobuf.PathTemplate;
import com.google.cloud.logging.spi.v2.LoggingServiceV2Settings;
import com.google.cloud.logging.spi.v2.PagedResponseWrappers;
import com.google.logging.v2.DeleteLogRequest;
import com.google.logging.v2.ListLogEntriesRequest;
import com.google.logging.v2.ListLogEntriesResponse;
import com.google.logging.v2.ListMonitoredResourceDescriptorsRequest;
import com.google.logging.v2.ListMonitoredResourceDescriptorsResponse;
import com.google.logging.v2.LogEntry;
import com.google.logging.v2.WriteLogEntriesRequest;
import com.google.logging.v2.WriteLogEntriesResponse;
import com.google.protobuf.Empty;
import io.grpc.ManagedChannel;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;

public class LoggingServiceV2Api
implements AutoCloseable {
    private final LoggingServiceV2Settings settings;
    private final ManagedChannel channel;
    private final ScheduledExecutorService executor;
    private final List<AutoCloseable> closeables = new ArrayList<AutoCloseable>();
    private final UnaryCallable<DeleteLogRequest, Empty> deleteLogCallable;
    private final UnaryCallable<WriteLogEntriesRequest, WriteLogEntriesResponse> writeLogEntriesCallable;
    private final UnaryCallable<ListLogEntriesRequest, ListLogEntriesResponse> listLogEntriesCallable;
    private final UnaryCallable<ListLogEntriesRequest, PagedResponseWrappers.ListLogEntriesPagedResponse> listLogEntriesPagedCallable;
    private final UnaryCallable<ListMonitoredResourceDescriptorsRequest, ListMonitoredResourceDescriptorsResponse> listMonitoredResourceDescriptorsCallable;
    private final UnaryCallable<ListMonitoredResourceDescriptorsRequest, PagedResponseWrappers.ListMonitoredResourceDescriptorsPagedResponse> listMonitoredResourceDescriptorsPagedCallable;
    private static final PathTemplate PARENT_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}");
    private static final PathTemplate LOG_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/logs/{log}");

    public static final String formatParentName(String project) {
        return PARENT_PATH_TEMPLATE.instantiate(new String[]{"project", project});
    }

    public static final String formatLogName(String project, String log) {
        return LOG_PATH_TEMPLATE.instantiate(new String[]{"project", project, "log", log});
    }

    public static final String parseProjectFromParentName(String parentName) {
        return PARENT_PATH_TEMPLATE.parse(parentName).get((Object)"project");
    }

    public static final String parseProjectFromLogName(String logName) {
        return LOG_PATH_TEMPLATE.parse(logName).get((Object)"project");
    }

    public static final String parseLogFromLogName(String logName) {
        return LOG_PATH_TEMPLATE.parse(logName).get((Object)"log");
    }

    public static final LoggingServiceV2Api create() throws IOException {
        return LoggingServiceV2Api.create(LoggingServiceV2Settings.defaultBuilder().build());
    }

    public static final LoggingServiceV2Api create(LoggingServiceV2Settings settings) throws IOException {
        return new LoggingServiceV2Api(settings);
    }

    protected LoggingServiceV2Api(LoggingServiceV2Settings settings) throws IOException {
        this.settings = settings;
        this.executor = settings.getExecutorProvider().getOrBuildExecutor();
        this.channel = settings.getChannelProvider().getOrBuildChannel((Executor)this.executor);
        this.deleteLogCallable = UnaryCallable.create(settings.deleteLogSettings(), (ManagedChannel)this.channel, (ScheduledExecutorService)this.executor);
        this.writeLogEntriesCallable = UnaryCallable.create(settings.writeLogEntriesSettings(), (ManagedChannel)this.channel, (ScheduledExecutorService)this.executor);
        this.listLogEntriesCallable = UnaryCallable.create(settings.listLogEntriesSettings(), (ManagedChannel)this.channel, (ScheduledExecutorService)this.executor);
        this.listLogEntriesPagedCallable = UnaryCallable.createPagedVariant(settings.listLogEntriesSettings(), (ManagedChannel)this.channel, (ScheduledExecutorService)this.executor);
        this.listMonitoredResourceDescriptorsCallable = UnaryCallable.create(settings.listMonitoredResourceDescriptorsSettings(), (ManagedChannel)this.channel, (ScheduledExecutorService)this.executor);
        this.listMonitoredResourceDescriptorsPagedCallable = UnaryCallable.createPagedVariant(settings.listMonitoredResourceDescriptorsSettings(), (ManagedChannel)this.channel, (ScheduledExecutorService)this.executor);
        if (settings.getChannelProvider().shouldAutoClose()) {
            this.closeables.add(new Closeable(){

                @Override
                public void close() throws IOException {
                    LoggingServiceV2Api.this.channel.shutdown();
                }
            });
        }
        if (settings.getExecutorProvider().shouldAutoClose()) {
            this.closeables.add(new Closeable(){

                @Override
                public void close() throws IOException {
                    LoggingServiceV2Api.this.executor.shutdown();
                }
            });
        }
    }

    public final LoggingServiceV2Settings getSettings() {
        return this.settings;
    }

    public final void deleteLog(String logName) {
        LOG_PATH_TEMPLATE.validate(logName, "deleteLog");
        DeleteLogRequest request = DeleteLogRequest.newBuilder().setLogName(logName).build();
        this.deleteLog(request);
    }

    private final void deleteLog(DeleteLogRequest request) {
        this.deleteLogCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteLogRequest, Empty> deleteLogCallable() {
        return this.deleteLogCallable;
    }

    public final WriteLogEntriesResponse writeLogEntries(String logName, MonitoredResource resource, Map<String, String> labels, List<LogEntry> entries) {
        if (!logName.isEmpty()) {
            LOG_PATH_TEMPLATE.validate(logName, "writeLogEntries");
        }
        WriteLogEntriesRequest request = WriteLogEntriesRequest.newBuilder().setLogName(logName).setResource(resource).putAllLabels(labels).addAllEntries(entries).build();
        return this.writeLogEntries(request);
    }

    public final WriteLogEntriesResponse writeLogEntries(WriteLogEntriesRequest request) {
        return (WriteLogEntriesResponse)this.writeLogEntriesCallable().call((Object)request);
    }

    public final UnaryCallable<WriteLogEntriesRequest, WriteLogEntriesResponse> writeLogEntriesCallable() {
        return this.writeLogEntriesCallable;
    }

    public final PagedResponseWrappers.ListLogEntriesPagedResponse listLogEntries(List<String> projectIds, String filter, String orderBy) {
        ListLogEntriesRequest request = ListLogEntriesRequest.newBuilder().addAllProjectIds(projectIds).setFilter(filter).setOrderBy(orderBy).build();
        return this.listLogEntries(request);
    }

    public final PagedResponseWrappers.ListLogEntriesPagedResponse listLogEntries(ListLogEntriesRequest request) {
        return (PagedResponseWrappers.ListLogEntriesPagedResponse)((Object)this.listLogEntriesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLogEntriesRequest, PagedResponseWrappers.ListLogEntriesPagedResponse> listLogEntriesPagedCallable() {
        return this.listLogEntriesPagedCallable;
    }

    public final UnaryCallable<ListLogEntriesRequest, ListLogEntriesResponse> listLogEntriesCallable() {
        return this.listLogEntriesCallable;
    }

    public final PagedResponseWrappers.ListMonitoredResourceDescriptorsPagedResponse listMonitoredResourceDescriptors(ListMonitoredResourceDescriptorsRequest request) {
        return (PagedResponseWrappers.ListMonitoredResourceDescriptorsPagedResponse)((Object)this.listMonitoredResourceDescriptorsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListMonitoredResourceDescriptorsRequest, PagedResponseWrappers.ListMonitoredResourceDescriptorsPagedResponse> listMonitoredResourceDescriptorsPagedCallable() {
        return this.listMonitoredResourceDescriptorsPagedCallable;
    }

    public final UnaryCallable<ListMonitoredResourceDescriptorsRequest, ListMonitoredResourceDescriptorsResponse> listMonitoredResourceDescriptorsCallable() {
        return this.listMonitoredResourceDescriptorsCallable;
    }

    @Override
    public final void close() throws Exception {
        for (AutoCloseable closeable : this.closeables) {
            closeable.close();
        }
    }
}

