/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.logging.spi.v2;

import com.google.api.MonitoredResourceDescriptor;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.RetrySettings;
import com.google.api.gax.grpc.CallContext;
import com.google.api.gax.grpc.ChannelProvider;
import com.google.api.gax.grpc.ClientSettings;
import com.google.api.gax.grpc.ExecutorProvider;
import com.google.api.gax.grpc.InstantiatingChannelProvider;
import com.google.api.gax.grpc.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.PagedCallSettings;
import com.google.api.gax.grpc.PagedListDescriptor;
import com.google.api.gax.grpc.PagedListResponseFactory;
import com.google.api.gax.grpc.SimpleCallSettings;
import com.google.api.gax.grpc.UnaryCallSettings;
import com.google.api.gax.grpc.UnaryCallable;
import com.google.cloud.logging.spi.v2.PagedResponseWrappers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.logging.v2.DeleteLogRequest;
import com.google.logging.v2.ListLogEntriesRequest;
import com.google.logging.v2.ListLogEntriesResponse;
import com.google.logging.v2.ListMonitoredResourceDescriptorsRequest;
import com.google.logging.v2.ListMonitoredResourceDescriptorsResponse;
import com.google.logging.v2.LogEntry;
import com.google.logging.v2.LoggingServiceV2Grpc;
import com.google.logging.v2.WriteLogEntriesRequest;
import com.google.logging.v2.WriteLogEntriesResponse;
import com.google.protobuf.Empty;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import java.io.IOException;
import java.util.Set;
import org.joda.time.Duration;

public class LoggingServiceV2Settings
extends ClientSettings {
    private static final String DEFAULT_SERVICE_ADDRESS = "logging.googleapis.com";
    private static final int DEFAULT_SERVICE_PORT = 443;
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/cloud-platform.read-only").add((Object)"https://www.googleapis.com/auth/logging.admin").add((Object)"https://www.googleapis.com/auth/logging.read").add((Object)"https://www.googleapis.com/auth/logging.write").build();
    private final SimpleCallSettings<DeleteLogRequest, Empty> deleteLogSettings;
    private final SimpleCallSettings<WriteLogEntriesRequest, WriteLogEntriesResponse> writeLogEntriesSettings;
    private final PagedCallSettings<ListLogEntriesRequest, ListLogEntriesResponse, PagedResponseWrappers.ListLogEntriesPagedResponse> listLogEntriesSettings;
    private final PagedCallSettings<ListMonitoredResourceDescriptorsRequest, ListMonitoredResourceDescriptorsResponse, PagedResponseWrappers.ListMonitoredResourceDescriptorsPagedResponse> listMonitoredResourceDescriptorsSettings;
    private static final PagedListDescriptor<ListLogEntriesRequest, ListLogEntriesResponse, LogEntry> LIST_LOG_ENTRIES_PAGE_STR_DESC = new PagedListDescriptor<ListLogEntriesRequest, ListLogEntriesResponse, LogEntry>(){

        public Object emptyToken() {
            return "";
        }

        public ListLogEntriesRequest injectToken(ListLogEntriesRequest payload, Object token) {
            return ListLogEntriesRequest.newBuilder((ListLogEntriesRequest)payload).setPageToken((String)token).build();
        }

        public ListLogEntriesRequest injectPageSize(ListLogEntriesRequest payload, int pageSize) {
            return ListLogEntriesRequest.newBuilder((ListLogEntriesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLogEntriesRequest payload) {
            return payload.getPageSize();
        }

        public Object extractNextToken(ListLogEntriesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<LogEntry> extractResources(ListLogEntriesResponse payload) {
            return payload.getEntriesList();
        }
    };
    private static final PagedListDescriptor<ListMonitoredResourceDescriptorsRequest, ListMonitoredResourceDescriptorsResponse, MonitoredResourceDescriptor> LIST_MONITORED_RESOURCE_DESCRIPTORS_PAGE_STR_DESC = new PagedListDescriptor<ListMonitoredResourceDescriptorsRequest, ListMonitoredResourceDescriptorsResponse, MonitoredResourceDescriptor>(){

        public Object emptyToken() {
            return "";
        }

        public ListMonitoredResourceDescriptorsRequest injectToken(ListMonitoredResourceDescriptorsRequest payload, Object token) {
            return ListMonitoredResourceDescriptorsRequest.newBuilder((ListMonitoredResourceDescriptorsRequest)payload).setPageToken((String)token).build();
        }

        public ListMonitoredResourceDescriptorsRequest injectPageSize(ListMonitoredResourceDescriptorsRequest payload, int pageSize) {
            return ListMonitoredResourceDescriptorsRequest.newBuilder((ListMonitoredResourceDescriptorsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListMonitoredResourceDescriptorsRequest payload) {
            return payload.getPageSize();
        }

        public Object extractNextToken(ListMonitoredResourceDescriptorsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<MonitoredResourceDescriptor> extractResources(ListMonitoredResourceDescriptorsResponse payload) {
            return payload.getResourceDescriptorsList();
        }
    };
    private static final PagedListResponseFactory<ListLogEntriesRequest, ListLogEntriesResponse, PagedResponseWrappers.ListLogEntriesPagedResponse> LIST_LOG_ENTRIES_PAGE_STR_FACT = new PagedListResponseFactory<ListLogEntriesRequest, ListLogEntriesResponse, PagedResponseWrappers.ListLogEntriesPagedResponse>(){

        public PagedResponseWrappers.ListLogEntriesPagedResponse createPagedListResponse(UnaryCallable<ListLogEntriesRequest, ListLogEntriesResponse> callable, ListLogEntriesRequest request, CallContext context) {
            return new PagedResponseWrappers.ListLogEntriesPagedResponse(callable, (PagedListDescriptor<ListLogEntriesRequest, ListLogEntriesResponse, LogEntry>)LIST_LOG_ENTRIES_PAGE_STR_DESC, request, context);
        }
    };
    private static final PagedListResponseFactory<ListMonitoredResourceDescriptorsRequest, ListMonitoredResourceDescriptorsResponse, PagedResponseWrappers.ListMonitoredResourceDescriptorsPagedResponse> LIST_MONITORED_RESOURCE_DESCRIPTORS_PAGE_STR_FACT = new PagedListResponseFactory<ListMonitoredResourceDescriptorsRequest, ListMonitoredResourceDescriptorsResponse, PagedResponseWrappers.ListMonitoredResourceDescriptorsPagedResponse>(){

        public PagedResponseWrappers.ListMonitoredResourceDescriptorsPagedResponse createPagedListResponse(UnaryCallable<ListMonitoredResourceDescriptorsRequest, ListMonitoredResourceDescriptorsResponse> callable, ListMonitoredResourceDescriptorsRequest request, CallContext context) {
            return new PagedResponseWrappers.ListMonitoredResourceDescriptorsPagedResponse(callable, (PagedListDescriptor<ListMonitoredResourceDescriptorsRequest, ListMonitoredResourceDescriptorsResponse, MonitoredResourceDescriptor>)LIST_MONITORED_RESOURCE_DESCRIPTORS_PAGE_STR_DESC, request, context);
        }
    };

    public SimpleCallSettings<DeleteLogRequest, Empty> deleteLogSettings() {
        return this.deleteLogSettings;
    }

    public SimpleCallSettings<WriteLogEntriesRequest, WriteLogEntriesResponse> writeLogEntriesSettings() {
        return this.writeLogEntriesSettings;
    }

    public PagedCallSettings<ListLogEntriesRequest, ListLogEntriesResponse, PagedResponseWrappers.ListLogEntriesPagedResponse> listLogEntriesSettings() {
        return this.listLogEntriesSettings;
    }

    public PagedCallSettings<ListMonitoredResourceDescriptorsRequest, ListMonitoredResourceDescriptorsResponse, PagedResponseWrappers.ListMonitoredResourceDescriptorsPagedResponse> listMonitoredResourceDescriptorsSettings() {
        return this.listMonitoredResourceDescriptorsSettings;
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultServiceAddress() {
        return DEFAULT_SERVICE_ADDRESS;
    }

    public static int getDefaultServicePort() {
        return 443;
    }

    public static ImmutableList<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingChannelProvider.Builder defaultChannelProviderBuilder() {
        return InstantiatingChannelProvider.newBuilder().setServiceAddress(DEFAULT_SERVICE_ADDRESS).setPort(443).setCredentialsProvider((CredentialsProvider)LoggingServiceV2Settings.defaultCredentialsProviderBuilder().build());
    }

    public static Builder defaultBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private LoggingServiceV2Settings(Builder settingsBuilder) throws IOException {
        super(settingsBuilder.getExecutorProvider(), settingsBuilder.getChannelProvider());
        this.deleteLogSettings = settingsBuilder.deleteLogSettings().build();
        this.writeLogEntriesSettings = settingsBuilder.writeLogEntriesSettings().build();
        this.listLogEntriesSettings = settingsBuilder.listLogEntriesSettings().build();
        this.listMonitoredResourceDescriptorsSettings = settingsBuilder.listMonitoredResourceDescriptorsSettings().build();
    }

    public static class Builder
    extends ClientSettings.Builder {
        private final ImmutableList<UnaryCallSettings.Builder> unaryMethodSettingsBuilders;
        private final SimpleCallSettings.Builder<DeleteLogRequest, Empty> deleteLogSettings;
        private final SimpleCallSettings.Builder<WriteLogEntriesRequest, WriteLogEntriesResponse> writeLogEntriesSettings;
        private final PagedCallSettings.Builder<ListLogEntriesRequest, ListLogEntriesResponse, PagedResponseWrappers.ListLogEntriesPagedResponse> listLogEntriesSettings;
        private final PagedCallSettings.Builder<ListMonitoredResourceDescriptorsRequest, ListMonitoredResourceDescriptorsResponse, PagedResponseWrappers.ListMonitoredResourceDescriptorsPagedResponse> listMonitoredResourceDescriptorsSettings;
        private static final ImmutableMap<String, ImmutableSet<Status.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings.Builder> RETRY_PARAM_DEFINITIONS;

        private Builder() {
            super(LoggingServiceV2Settings.defaultChannelProviderBuilder().build());
            this.deleteLogSettings = SimpleCallSettings.newBuilder((MethodDescriptor)LoggingServiceV2Grpc.METHOD_DELETE_LOG);
            this.writeLogEntriesSettings = SimpleCallSettings.newBuilder((MethodDescriptor)LoggingServiceV2Grpc.METHOD_WRITE_LOG_ENTRIES);
            this.listLogEntriesSettings = PagedCallSettings.newBuilder((MethodDescriptor)LoggingServiceV2Grpc.METHOD_LIST_LOG_ENTRIES, (PagedListResponseFactory)LIST_LOG_ENTRIES_PAGE_STR_FACT);
            this.listMonitoredResourceDescriptorsSettings = PagedCallSettings.newBuilder((MethodDescriptor)LoggingServiceV2Grpc.METHOD_LIST_MONITORED_RESOURCE_DESCRIPTORS, (PagedListResponseFactory)LIST_MONITORED_RESOURCE_DESCRIPTORS_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.deleteLogSettings, this.writeLogEntriesSettings, this.listLogEntriesSettings, this.listMonitoredResourceDescriptorsSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder();
            builder.deleteLogSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.writeLogEntriesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listLogEntriesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"list"));
            builder.listMonitoredResourceDescriptorsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        private Builder(LoggingServiceV2Settings settings) {
            super((ClientSettings)settings);
            this.deleteLogSettings = settings.deleteLogSettings.toBuilder();
            this.writeLogEntriesSettings = settings.writeLogEntriesSettings.toBuilder();
            this.listLogEntriesSettings = settings.listLogEntriesSettings.toBuilder();
            this.listMonitoredResourceDescriptorsSettings = settings.listMonitoredResourceDescriptorsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.deleteLogSettings, this.writeLogEntriesSettings, this.listLogEntriesSettings, this.listMonitoredResourceDescriptorsSettings);
        }

        public Builder setExecutorProvider(ExecutorProvider executorProvider) {
            super.setExecutorProvider(executorProvider);
            return this;
        }

        public Builder setChannelProvider(ChannelProvider channelProvider) {
            super.setChannelProvider(channelProvider);
            return this;
        }

        public Builder applyToAllUnaryMethods(UnaryCallSettings.Builder unaryCallSettings) throws Exception {
            super.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, unaryCallSettings);
            return this;
        }

        public SimpleCallSettings.Builder<DeleteLogRequest, Empty> deleteLogSettings() {
            return this.deleteLogSettings;
        }

        public SimpleCallSettings.Builder<WriteLogEntriesRequest, WriteLogEntriesResponse> writeLogEntriesSettings() {
            return this.writeLogEntriesSettings;
        }

        public PagedCallSettings.Builder<ListLogEntriesRequest, ListLogEntriesResponse, PagedResponseWrappers.ListLogEntriesPagedResponse> listLogEntriesSettings() {
            return this.listLogEntriesSettings;
        }

        public PagedCallSettings.Builder<ListMonitoredResourceDescriptorsRequest, ListMonitoredResourceDescriptorsResponse, PagedResponseWrappers.ListMonitoredResourceDescriptorsPagedResponse> listMonitoredResourceDescriptorsSettings() {
            return this.listMonitoredResourceDescriptorsSettings;
        }

        public LoggingServiceV2Settings build() throws IOException {
            return new LoggingServiceV2Settings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)Sets.immutableEnumSet((Iterable)Lists.newArrayList((Object[])new Status.Code[]{Status.Code.DEADLINE_EXCEEDED, Status.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)Sets.immutableEnumSet((Iterable)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings.Builder settingsBuilder = null;
            settingsBuilder = RetrySettings.newBuilder().setInitialRetryDelay(Duration.millis((long)100L)).setRetryDelayMultiplier(1.2).setMaxRetryDelay(Duration.millis((long)1000L)).setInitialRpcTimeout(Duration.millis((long)2000L)).setRpcTimeoutMultiplier(1.5).setMaxRpcTimeout(Duration.millis((long)30000L)).setTotalTimeout(Duration.millis((long)45000L));
            definitions.put((Object)"default", (Object)settingsBuilder);
            settingsBuilder = RetrySettings.newBuilder().setInitialRetryDelay(Duration.millis((long)100L)).setRetryDelayMultiplier(1.2).setMaxRetryDelay(Duration.millis((long)1000L)).setInitialRpcTimeout(Duration.millis((long)7000L)).setRpcTimeoutMultiplier(1.5).setMaxRpcTimeout(Duration.millis((long)30000L)).setTotalTimeout(Duration.millis((long)45000L));
            definitions.put((Object)"list", (Object)settingsBuilder);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

