/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.logging.spi.v2;

import com.google.api.gax.grpc.ChannelAndExecutor;
import com.google.api.gax.grpc.UnaryCallable;
import com.google.api.gax.protobuf.PathTemplate;
import com.google.cloud.logging.spi.v2.MetricsServiceV2Settings;
import com.google.cloud.logging.spi.v2.PagedResponseWrappers;
import com.google.logging.v2.CreateLogMetricRequest;
import com.google.logging.v2.DeleteLogMetricRequest;
import com.google.logging.v2.GetLogMetricRequest;
import com.google.logging.v2.ListLogMetricsRequest;
import com.google.logging.v2.ListLogMetricsResponse;
import com.google.logging.v2.LogMetric;
import com.google.logging.v2.UpdateLogMetricRequest;
import com.google.protobuf.Empty;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;

public class MetricsServiceV2Client
implements AutoCloseable {
    private final MetricsServiceV2Settings settings;
    private final ScheduledExecutorService executor;
    private final ManagedChannel channel;
    private final List<AutoCloseable> closeables = new ArrayList<AutoCloseable>();
    private final UnaryCallable<ListLogMetricsRequest, ListLogMetricsResponse> listLogMetricsCallable;
    private final UnaryCallable<ListLogMetricsRequest, PagedResponseWrappers.ListLogMetricsPagedResponse> listLogMetricsPagedCallable;
    private final UnaryCallable<GetLogMetricRequest, LogMetric> getLogMetricCallable;
    private final UnaryCallable<CreateLogMetricRequest, LogMetric> createLogMetricCallable;
    private final UnaryCallable<UpdateLogMetricRequest, LogMetric> updateLogMetricCallable;
    private final UnaryCallable<DeleteLogMetricRequest, Empty> deleteLogMetricCallable;
    private static final PathTemplate PARENT_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}");
    private static final PathTemplate METRIC_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/metrics/{metric}");

    public static final String formatParentName(String project) {
        return PARENT_PATH_TEMPLATE.instantiate(new String[]{"project", project});
    }

    public static final String formatMetricName(String project, String metric) {
        return METRIC_PATH_TEMPLATE.instantiate(new String[]{"project", project, "metric", metric});
    }

    public static final String parseProjectFromParentName(String parentName) {
        return PARENT_PATH_TEMPLATE.parse(parentName).get((Object)"project");
    }

    public static final String parseProjectFromMetricName(String metricName) {
        return METRIC_PATH_TEMPLATE.parse(metricName).get((Object)"project");
    }

    public static final String parseMetricFromMetricName(String metricName) {
        return METRIC_PATH_TEMPLATE.parse(metricName).get((Object)"metric");
    }

    public static final MetricsServiceV2Client create() throws IOException {
        return MetricsServiceV2Client.create(MetricsServiceV2Settings.defaultBuilder().build());
    }

    public static final MetricsServiceV2Client create(MetricsServiceV2Settings settings) throws IOException {
        return new MetricsServiceV2Client(settings);
    }

    protected MetricsServiceV2Client(MetricsServiceV2Settings settings) throws IOException {
        this.settings = settings;
        ChannelAndExecutor channelAndExecutor = settings.getChannelAndExecutor();
        this.executor = channelAndExecutor.getExecutor();
        this.channel = channelAndExecutor.getChannel();
        this.listLogMetricsCallable = UnaryCallable.create(settings.listLogMetricsSettings(), (Channel)this.channel, (ScheduledExecutorService)this.executor);
        this.listLogMetricsPagedCallable = UnaryCallable.createPagedVariant(settings.listLogMetricsSettings(), (Channel)this.channel, (ScheduledExecutorService)this.executor);
        this.getLogMetricCallable = UnaryCallable.create(settings.getLogMetricSettings(), (Channel)this.channel, (ScheduledExecutorService)this.executor);
        this.createLogMetricCallable = UnaryCallable.create(settings.createLogMetricSettings(), (Channel)this.channel, (ScheduledExecutorService)this.executor);
        this.updateLogMetricCallable = UnaryCallable.create(settings.updateLogMetricSettings(), (Channel)this.channel, (ScheduledExecutorService)this.executor);
        this.deleteLogMetricCallable = UnaryCallable.create(settings.deleteLogMetricSettings(), (Channel)this.channel, (ScheduledExecutorService)this.executor);
        if (settings.getChannelProvider().shouldAutoClose()) {
            this.closeables.add(new Closeable(){

                @Override
                public void close() throws IOException {
                    MetricsServiceV2Client.this.channel.shutdown();
                }
            });
        }
        if (settings.getExecutorProvider().shouldAutoClose()) {
            this.closeables.add(new Closeable(){

                @Override
                public void close() throws IOException {
                    MetricsServiceV2Client.this.executor.shutdown();
                }
            });
        }
    }

    public final MetricsServiceV2Settings getSettings() {
        return this.settings;
    }

    public final PagedResponseWrappers.ListLogMetricsPagedResponse listLogMetrics(String parent) {
        ListLogMetricsRequest request = ListLogMetricsRequest.newBuilder().setParent(parent).build();
        return this.listLogMetrics(request);
    }

    public final PagedResponseWrappers.ListLogMetricsPagedResponse listLogMetrics(ListLogMetricsRequest request) {
        return (PagedResponseWrappers.ListLogMetricsPagedResponse)((Object)this.listLogMetricsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLogMetricsRequest, PagedResponseWrappers.ListLogMetricsPagedResponse> listLogMetricsPagedCallable() {
        return this.listLogMetricsPagedCallable;
    }

    public final UnaryCallable<ListLogMetricsRequest, ListLogMetricsResponse> listLogMetricsCallable() {
        return this.listLogMetricsCallable;
    }

    public final LogMetric getLogMetric(String metricName) {
        METRIC_PATH_TEMPLATE.validate(metricName, "getLogMetric");
        GetLogMetricRequest request = GetLogMetricRequest.newBuilder().setMetricName(metricName).build();
        return this.getLogMetric(request);
    }

    private final LogMetric getLogMetric(GetLogMetricRequest request) {
        return (LogMetric)this.getLogMetricCallable().call((Object)request);
    }

    public final UnaryCallable<GetLogMetricRequest, LogMetric> getLogMetricCallable() {
        return this.getLogMetricCallable;
    }

    public final LogMetric createLogMetric(String parent, LogMetric metric) {
        CreateLogMetricRequest request = CreateLogMetricRequest.newBuilder().setParent(parent).setMetric(metric).build();
        return this.createLogMetric(request);
    }

    public final LogMetric createLogMetric(CreateLogMetricRequest request) {
        return (LogMetric)this.createLogMetricCallable().call((Object)request);
    }

    public final UnaryCallable<CreateLogMetricRequest, LogMetric> createLogMetricCallable() {
        return this.createLogMetricCallable;
    }

    public final LogMetric updateLogMetric(String metricName, LogMetric metric) {
        METRIC_PATH_TEMPLATE.validate(metricName, "updateLogMetric");
        UpdateLogMetricRequest request = UpdateLogMetricRequest.newBuilder().setMetricName(metricName).setMetric(metric).build();
        return this.updateLogMetric(request);
    }

    public final LogMetric updateLogMetric(UpdateLogMetricRequest request) {
        return (LogMetric)this.updateLogMetricCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateLogMetricRequest, LogMetric> updateLogMetricCallable() {
        return this.updateLogMetricCallable;
    }

    public final void deleteLogMetric(String metricName) {
        METRIC_PATH_TEMPLATE.validate(metricName, "deleteLogMetric");
        DeleteLogMetricRequest request = DeleteLogMetricRequest.newBuilder().setMetricName(metricName).build();
        this.deleteLogMetric(request);
    }

    private final void deleteLogMetric(DeleteLogMetricRequest request) {
        this.deleteLogMetricCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteLogMetricRequest, Empty> deleteLogMetricCallable() {
        return this.deleteLogMetricCallable;
    }

    @Override
    public final void close() throws Exception {
        for (AutoCloseable closeable : this.closeables) {
            closeable.close();
        }
    }
}

