/*
 * Copyright 2016 Google Inc. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.google.cloud.logging;

import com.google.api.gax.grpc.ApiException;
import com.google.cloud.BaseServiceException;

import java.io.IOException;
import java.util.Set;

/**
 * Logging service exception.
 */
public final class LoggingException extends BaseServiceException {

  private static final long serialVersionUID = 449689219311927047L;

  public LoggingException(IOException ex, boolean idempotent) {
    super(ex, idempotent);
  }

  public LoggingException(ApiException apiException, boolean idempotent) {
    super(apiException, idempotent);
  }

  @Override
  protected Set<Error> getRetryableErrors() {
    return null;
  }
}
