/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.logging.spi;

import com.google.api.gax.grpc.ApiException;
import com.google.api.gax.grpc.ChannelProvider;
import com.google.api.gax.grpc.ExecutorProvider;
import com.google.api.gax.grpc.FixedChannelProvider;
import com.google.api.gax.grpc.FixedExecutorProvider;
import com.google.api.gax.grpc.ProviderManager;
import com.google.api.gax.grpc.UnaryCallSettings;
import com.google.cloud.GrpcServiceOptions;
import com.google.cloud.NoCredentials;
import com.google.cloud.logging.LoggingException;
import com.google.cloud.logging.LoggingOptions;
import com.google.cloud.logging.spi.LoggingRpc;
import com.google.cloud.logging.spi.v2.ConfigServiceV2Client;
import com.google.cloud.logging.spi.v2.ConfigServiceV2Settings;
import com.google.cloud.logging.spi.v2.LoggingServiceV2Client;
import com.google.cloud.logging.spi.v2.LoggingServiceV2Settings;
import com.google.cloud.logging.spi.v2.MetricsServiceV2Client;
import com.google.cloud.logging.spi.v2.MetricsServiceV2Settings;
import com.google.common.base.Function;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.logging.v2.CreateLogMetricRequest;
import com.google.logging.v2.CreateSinkRequest;
import com.google.logging.v2.DeleteLogMetricRequest;
import com.google.logging.v2.DeleteLogRequest;
import com.google.logging.v2.DeleteSinkRequest;
import com.google.logging.v2.GetLogMetricRequest;
import com.google.logging.v2.GetSinkRequest;
import com.google.logging.v2.ListLogEntriesRequest;
import com.google.logging.v2.ListLogEntriesResponse;
import com.google.logging.v2.ListLogMetricsRequest;
import com.google.logging.v2.ListLogMetricsResponse;
import com.google.logging.v2.ListMonitoredResourceDescriptorsRequest;
import com.google.logging.v2.ListMonitoredResourceDescriptorsResponse;
import com.google.logging.v2.ListSinksRequest;
import com.google.logging.v2.ListSinksResponse;
import com.google.logging.v2.LogMetric;
import com.google.logging.v2.LogSink;
import com.google.logging.v2.UpdateLogMetricRequest;
import com.google.logging.v2.UpdateSinkRequest;
import com.google.logging.v2.WriteLogEntriesRequest;
import com.google.logging.v2.WriteLogEntriesResponse;
import com.google.protobuf.Empty;
import io.grpc.ManagedChannel;
import io.grpc.Status;
import io.grpc.internal.ManagedChannelImpl;
import io.grpc.netty.NegotiationType;
import io.grpc.netty.NettyChannelBuilder;
import java.io.IOException;
import java.util.HashSet;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;

public class DefaultLoggingRpc
implements LoggingRpc {
    private final ConfigServiceV2Client configClient;
    private final LoggingServiceV2Client loggingClient;
    private final MetricsServiceV2Client metricsClient;
    private final ScheduledExecutorService executor;
    private final ProviderManager providerManager;
    private final GrpcServiceOptions.ExecutorFactory<ScheduledExecutorService> executorFactory;
    private boolean closed;

    public DefaultLoggingRpc(LoggingOptions options) throws IOException {
        InternalLoggingOptions internalOptions = new InternalLoggingOptions(options);
        this.executorFactory = internalOptions.getExecutorFactory();
        this.executor = (ScheduledExecutorService)this.executorFactory.get();
        try {
            ChannelProvider channelProvider;
            FixedExecutorProvider executorProvider = FixedExecutorProvider.create((ScheduledExecutorService)this.executor);
            if (options.getHost().contains("localhost") || options.getCredentials().equals(NoCredentials.getInstance())) {
                ManagedChannelImpl managedChannel = ((NettyChannelBuilder)NettyChannelBuilder.forTarget((String)options.getHost()).negotiationType(NegotiationType.PLAINTEXT).executor((Executor)this.executor)).build();
                channelProvider = FixedChannelProvider.create((ManagedChannel)managedChannel);
            } else {
                channelProvider = internalOptions.getChannelProvider();
            }
            this.providerManager = ProviderManager.newBuilder().setChannelProvider(channelProvider).setExecutorProvider((ExecutorProvider)executorProvider).build();
            UnaryCallSettings.Builder callSettingsBuilder = internalOptions.getApiCallSettings();
            ConfigServiceV2Settings.Builder confBuilder = ConfigServiceV2Settings.defaultBuilder().setExecutorProvider((ExecutorProvider)this.providerManager).setChannelProvider((ChannelProvider)this.providerManager).applyToAllUnaryMethods(callSettingsBuilder);
            LoggingServiceV2Settings.Builder logBuilder = LoggingServiceV2Settings.defaultBuilder().setExecutorProvider((ExecutorProvider)this.providerManager).setChannelProvider((ChannelProvider)this.providerManager).applyToAllUnaryMethods(callSettingsBuilder);
            MetricsServiceV2Settings.Builder metricsBuilder = MetricsServiceV2Settings.defaultBuilder().setExecutorProvider((ExecutorProvider)this.providerManager).setChannelProvider((ChannelProvider)this.providerManager).applyToAllUnaryMethods(callSettingsBuilder);
            this.configClient = ConfigServiceV2Client.create(confBuilder.build());
            this.loggingClient = LoggingServiceV2Client.create(logBuilder.build());
            this.metricsClient = MetricsServiceV2Client.create(metricsBuilder.build());
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }

    private static <V> Future<V> translate(ListenableFuture<V> from, final boolean idempotent, int ... returnNullOn) {
        final HashSet returnNullOnSet = Sets.newHashSetWithExpectedSize((int)returnNullOn.length);
        for (int value : returnNullOn) {
            returnNullOnSet.add(value);
        }
        return Futures.catching(from, ApiException.class, (Function)new Function<ApiException, V>(){

            public V apply(ApiException exception) {
                if (returnNullOnSet.contains(exception.getStatusCode().value())) {
                    return null;
                }
                throw new LoggingException(exception, idempotent);
            }
        });
    }

    @Override
    public Future<LogSink> create(CreateSinkRequest request) {
        return DefaultLoggingRpc.translate(this.configClient.createSinkCallable().futureCall((Object)request), true, new int[0]);
    }

    @Override
    public Future<LogSink> update(UpdateSinkRequest request) {
        return DefaultLoggingRpc.translate(this.configClient.updateSinkCallable().futureCall((Object)request), true, new int[0]);
    }

    @Override
    public Future<LogSink> get(GetSinkRequest request) {
        return DefaultLoggingRpc.translate(this.configClient.getSinkCallable().futureCall((Object)request), true, Status.Code.NOT_FOUND.value());
    }

    @Override
    public Future<ListSinksResponse> list(ListSinksRequest request) {
        return DefaultLoggingRpc.translate(this.configClient.listSinksCallable().futureCall((Object)request), true, new int[0]);
    }

    @Override
    public Future<Empty> delete(DeleteSinkRequest request) {
        return DefaultLoggingRpc.translate(this.configClient.deleteSinkCallable().futureCall((Object)request), true, Status.Code.NOT_FOUND.value());
    }

    @Override
    public Future<Empty> delete(DeleteLogRequest request) {
        return DefaultLoggingRpc.translate(this.loggingClient.deleteLogCallable().futureCall((Object)request), true, Status.Code.NOT_FOUND.value());
    }

    @Override
    public Future<WriteLogEntriesResponse> write(WriteLogEntriesRequest request) {
        return DefaultLoggingRpc.translate(this.loggingClient.writeLogEntriesCallable().futureCall((Object)request), false, new int[0]);
    }

    @Override
    public Future<ListLogEntriesResponse> list(ListLogEntriesRequest request) {
        return DefaultLoggingRpc.translate(this.loggingClient.listLogEntriesCallable().futureCall((Object)request), true, new int[0]);
    }

    @Override
    public Future<ListMonitoredResourceDescriptorsResponse> list(ListMonitoredResourceDescriptorsRequest request) {
        return DefaultLoggingRpc.translate(this.loggingClient.listMonitoredResourceDescriptorsCallable().futureCall((Object)request), true, new int[0]);
    }

    @Override
    public Future<LogMetric> create(CreateLogMetricRequest request) {
        return DefaultLoggingRpc.translate(this.metricsClient.createLogMetricCallable().futureCall((Object)request), true, new int[0]);
    }

    @Override
    public Future<LogMetric> update(UpdateLogMetricRequest request) {
        return DefaultLoggingRpc.translate(this.metricsClient.updateLogMetricCallable().futureCall((Object)request), true, new int[0]);
    }

    @Override
    public Future<LogMetric> get(GetLogMetricRequest request) {
        return DefaultLoggingRpc.translate(this.metricsClient.getLogMetricCallable().futureCall((Object)request), true, Status.Code.NOT_FOUND.value());
    }

    @Override
    public Future<ListLogMetricsResponse> list(ListLogMetricsRequest request) {
        return DefaultLoggingRpc.translate(this.metricsClient.listLogMetricsCallable().futureCall((Object)request), true, new int[0]);
    }

    @Override
    public Future<Empty> delete(DeleteLogMetricRequest request) {
        return DefaultLoggingRpc.translate(this.metricsClient.deleteLogMetricCallable().futureCall((Object)request), true, Status.Code.NOT_FOUND.value());
    }

    @Override
    public void close() throws Exception {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.configClient.close();
        this.loggingClient.close();
        this.metricsClient.close();
        this.providerManager.getChannel().shutdown();
        this.executorFactory.release((ExecutorService)this.executor);
    }

    private static final class InternalLoggingOptions
    extends LoggingOptions {
        private static final long serialVersionUID = -2107638980310672033L;

        private InternalLoggingOptions(LoggingOptions options) {
            super(options.toBuilder());
        }

        @Override
        protected GrpcServiceOptions.ExecutorFactory<ScheduledExecutorService> getExecutorFactory() {
            return super.getExecutorFactory();
        }

        protected UnaryCallSettings.Builder getApiCallSettings() {
            return super.getApiCallSettings();
        }

        protected ChannelProvider getChannelProvider() {
            return super.getChannelProvider();
        }
    }
}

